/* $Id: server.c,v 1.3 1997/08/22 07:16:09 janssen Exp $ */
/* Last edited by Mike Spreitzer August 1, 1996 3:01 pm PDT */

#include <stdio.h>
#include <math.h>
#include <stdlib.h>	/* for exit() */

#include "Test1.h"

int main (int ac, char **av)
{
  Test1_O1	uc;
  char *	tinfo[] = { "tcp_0_0", NULL };
  ILU_C_Server	s;
  char *	proof;

  Test1__InitializeServer();

  s = ILU_C_InitializeServer("pickleServer", NULL, "iiop", tinfo,
			     NULL, ilu_TRUE);

  if (s == NULL) {
    printf("Error.  Couldn't create server.\n");
    exit(1);
  }
  uc = Test1_O1__CreateTrue("pickleObj", s, NULL);
  if (uc == NULL) {
    printf("Error.  Couldn't create object.\n");
    exit(1);
  }
  if ((proof = ILU_C_PublishObject(uc)) == NULL) {
    fprintf(stderr, "Error.  Couldn't publish Test1-Server object.\n");
    exit(1);
  }
  printf("exported %s\n", ILU_C_SBHOfObject(uc));
  ILU_C_Run();
  return 0;
}

CORBA_any *
  server_Test1_O1_bounce (Test1_O1 handle, CORBA_any *v, CORBA_Environment *env)
{
  CORBA_any *pickle;

  pickle = ILU_C_Any_Duplicate (v, env);
  return pickle;
}
