/* Define all procedures which are external to each other.
   Copyright (C) 1993, 1995 Free Software Foundation, Inc.
   Contributed by Tim Wicinski (wicinski@barn.com).
   Hacked by Brendan Kehoe (brendan@cygnus.com).

This file is part of GNU GNATS.

GNU GNATS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU GNATS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU GNATS; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111, USA.  */

#ifndef _gnats_h_ 
#define _gnats_h_ 

/* Define these for the default settings */
#define PENDING "pending"

#include <ansidecl.h>
#include <libiberty.h>

#include <stdio.h>

/* A generic boolean type.  */
typedef short bool;

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <getopt.h>
#ifndef S_ISREG			/* Doesn't have POSIX.1 stat stuff. */
#define mode_t unsigned short
#endif
#if !defined(S_ISREG) && defined(S_IFREG)
#define	S_ISREG(m) (((m) & S_IFMT) == S_IFREG)
#endif
#ifndef S_ISLNK
#define lstat stat
#endif

#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_SYSLOG_H
#include <syslog.h>
#endif
#if defined(HAVE_STRING_H) || defined(STDC_HEADERS)
#include <string.h>
#ifndef bcopy
#define bcopy(s, d, n)	memcpy ((d), (s), (n))
#endif
#ifndef bzero
#define bzero(s, n)	memset ((s), 0, (n))
#endif
#ifndef index
#define index strchr
#endif
#ifndef rindex
#define rindex strrchr
#endif
#else
#include <strings.h>
#endif

#include <errno.h>
#ifdef STDC_HEADERS
#define getopt system_getopt
#include <stdlib.h>
#undef getopt
#else /* not STDC_HEADERS */
char *getenv ();
extern int errno;
#endif /* STDC_HEADERS */

#if defined(HAVE_FCNTL_H) || defined(_POSIX_VERSION)
#include <fcntl.h>
#else
#include <sys/file.h>
#endif

#ifndef alloca
/* Make alloca work the best possible way.  */
#ifdef __GNUC__
#define alloca __builtin_alloca
#else /* not __GNUC__ */
#if HAVE_ALLOCA_H
#include <alloca.h>
#else /* not __GNUC__ or HAVE_ALLOCA_H */
#ifndef _AIX /* Already did AIX, up at the top.  */
char *alloca ();
#endif /* not _AIX */
#endif /* not HAVE_ALLOCA_H */ 
#endif /* not __GNUC__ */
#endif /* not alloca */

#if defined(__STDC__) || defined(_AIX)
#include <stdarg.h>
#else
#include <varargs.h>
#endif

#include <ctype.h>
#include <signal.h>
#include <pwd.h>

#ifndef SEEK_SET
#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2
#endif

#ifndef RETSIGTYPE
#define RETSIGTYPE void
#endif

/* This used to be 30, but we upped it to 50 to make sure that int'l
   timezones will fit.  */
#define GNATS_TIME_LENGTH	50

/* Prototypes that are generic to many GNATS utilities.  */

#include "headers.h"
#include "pr.h"
#include "files.h"
#include "globals.h"
#include "pathmax.h"
#include "regex.h"

/* Debugging level.  */
extern int debug_level;

/* If 1, we're running the daemon.  */
extern int is_daemon;

/* File to log all messages to.  */
extern FILE *gnats_logfile;

/* The last time the index was modified.  */
extern time_t index_mtime;

/* Top of the GNATS tree.  */
extern char *gnats_root;

/* The definition of GNATS_USER as generated for config.c.  */
extern char *gnats_user;

/* Possible values for the logging mode.  Note "syslog" will only be used
   if the system supports it---otherwise it will relegate to "mail".  */
typedef enum
{
  SYSLOG,
  MAIL,
  STDERR,
  NUM_LOGGING_METHODS
} Logging_Methods;

/* Current logging method.  */
extern Logging_Methods log_method;

/* Used to keep track of each bad value for fields in a PR.  */
struct bad_enum
{
  char *msg;
  struct bad_enum *next;
};

/* Table to tell if a char c is whitespace.  */
extern unsigned char is_space[256];
#define SKIP_WHITE_SPACE(p) \
  do { while (is_space[(unsigned char) *(p)]) ++(p); } while (0)

/* The name this program was run with.  */
extern char *program_name;

/* needed everywhere */
extern void xfree			PARAMS((char *));

/* in client.c */
extern void get_reply			PARAMS((void));
extern void client_init			PARAMS((void));
extern void client_exit			PARAMS((void));
extern void safe_exit			PARAMS((void));

/* in config.c */
extern void configure			PARAMS((void));

/* in edit.c */
extern int check_pr			PARAMS((FILE*));
extern int modify_pr			PARAMS((FILE*));
extern int lock_pr			PARAMS((char*, char*, char*));
extern int unlock_pr			PARAMS((char*));

/* in getdate.c */
extern time_t get_date			PARAMS((char *, ...));

/* in headers.c */
extern char *header_name		PARAMS((Header_Name));
extern char *header_value		PARAMS((Header_Name));
extern char *raw_header_value		PARAMS((Header_Name));
extern void set_header			PARAMS((Header_Name, char *));
extern void init_header			PARAMS((void));
extern void clean_header		PARAMS((void));
extern int read_header			PARAMS((FILE *));
extern void write_header		PARAMS((FILE *, Header_Name));

/* in index.c */
extern FILE *open_index			PARAMS((void));
extern time_t stat_index		PARAMS((char *));
extern int check_index			PARAMS((void));
extern char *find_pr_category		PARAMS((FILE *, char *));
extern void create_index_entry		PARAMS((char *));
extern Index *next_index_entry		PARAMS((FILE *));
extern void close_index			PARAMS((FILE *));
extern Index *get_index			PARAMS((void));
extern void write_index			PARAMS((Index*));
extern void free_index			PARAMS((Index *));
extern void free_index_entry		PARAMS((Index *));

/* in internal.c */
extern void block_signals               PARAMS((void));
extern void unblock_signals             PARAMS((void));
extern void add_to_index                PARAMS((void));
extern int is_gnats_locked               PARAMS((void));
extern int lock_gnats                    PARAMS((void));
extern int unlock_gnats                  PARAMS((void));
extern void punt                        PARAMS((int, ...));
extern int copy_file                    PARAMS((char *, char *));
extern void add_to_index		PARAMS((void));
extern int gnats_locked			PARAMS((void));

/* in lists.c */
extern int get_gnats_file		PARAMS((unsigned int, char*));

/* in misc.c */
extern void init_gnats			PARAMS((void));
extern void log_msg			PARAMS((int, int, ...));
extern char *get_next_field		PARAMS((char *, char *, int));
extern int read_string			PARAMS((char *, FILE *));
extern void append_string		PARAMS((char **, char *));
extern char *get_token			PARAMS((char *, char *));
extern FILE *open_mail_file     	PARAMS((void));
extern void close_mail_file		PARAMS((FILE *));
extern void init_space			PARAMS((void));
extern void init_network		PARAMS((void));
extern Responsible *get_responsible_address	PARAMS((char *));

/* in pr.c */
extern void read_pr			PARAMS((FILE *, int));
extern void write_pr			PARAMS((FILE *, PR_Name));
extern void init_pr			PARAMS((void));
extern void clean_pr			PARAMS((void));
extern char *field_value		PARAMS((PR_Name));
extern int verify_enum			PARAMS((PR_Name, char *, char *));
extern bool set_field			PARAMS((PR_Name, char *));
extern struct bad_enum *check_enum_types	PARAMS((int));

#endif /* !_gnats_h_ */
