------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--                   S Y S T E M . O S _ I N T E R F A C E                  --
--                                                                          --
--                                  S p e c                                 --
--                         (Version for new GNARL)                          --
--                                                                          --
--                             $Revision: 1.6 $                            --
--                                                                          --
--          Copyright (C) 1992-1997, Free Software Foundation, Inc.         --
--                                                                          --
-- GNARL is free software; you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. GNARL is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNARL was developed by the GNARL team at Florida State University. It is --
-- now maintained by Ada Core Technologies Inc. in cooperation with Florida --
-- State University (http://www.gnat.com).                                  --
--                                                                          --
------------------------------------------------------------------------------

--  This is a DOS/DJGPPv2 (FSU THREAD) version of this package.

--  DO NOT EDIT this file.
--  This file was made by editing the SunOS version.
--  It was automatically generated from another file by the m4 macro processor.
--  The name of the file you should edit is the same as this one, but with
--  ".ads" replaced by ".sm4", or
--  ".adb" replaced by ".bm4", or
--  ".c" replaced by ".cm4", or
--  ".dat" replaced by ".tm4"

--  The following options are left over from the SunOS version.
--  Local options selected:
--    __TARGET            = sparc-sun-SunOS
--    __ARCH              = SPARC
--    __OS                = SUNOS41X
--    __HAS_SIGCONTEXT    = 1
--    __HAS_UCONTEXT      = 0
--    __THREADS           = POSIX_THREADS
--    __THREAD_VARIANT    = FSU_THREADS
--    __HAS_TIMESPEC      = 1
--    __HAS_NANOSLEEP     = 1
--    __HAS_CLOCK_GETTIME = 1
--    __HAS_GETTIMEOFDAY  = 1
--    __POSIX_THREAD_PRIO_PROTECT = 1
--    __POSIX_THREAD_PRIO_INHERIT = 0
--    __POSIX_THREAD_ATTR_STACKADDR = 0
--    __POSIX_THREAD_ATTR_STACKSIZE = 0
--    __POSIX_THREAD_PRIORITY_SCHEDULING = 1

--  This package encapsulates all direct interfaces to OS services
--  that are needed by children of System.

--  PLEASE DO NOT add any with-clauses to this package
--  or remove the pragma Elaborate_Body.
--  It is designed to be a bottom-level (leaf) package.

--  This version is for POSIX-like operating systems
--  The original file "s-osinte.sm4" contains conditional
--  macro calls that allow selection of various options.
--  The options selected for this expansion were:

--  When adding new signals to s-osinte.sm4, don't forget to update
--  cconst.dat (m4 macro definition data-file) and the files
--  s-intnam.ads (package Ada.Interrupt_Names) for the various ports.

with Interfaces.C;
package System.OS_Interface is
   pragma Preelaborate;

   --
   --  A short name for libgthreads.a to keep Mike Feldman happy.
   --
   pragma Linker_Options ("-lgthre");

   subtype int            is Interfaces.C.int;
   subtype short          is Interfaces.C.short;
   subtype long           is Interfaces.C.long;
   subtype unsigned       is Interfaces.C.unsigned;
   subtype unsigned_short is Interfaces.C.unsigned_short;
   subtype unsigned_long  is Interfaces.C.unsigned_long;
   subtype unsigned_char  is Interfaces.C.unsigned_char;
   subtype plain_char     is Interfaces.C.plain_char;
   subtype size_t         is Interfaces.C.size_t;

   -----------
   -- Errno --
   -----------

   function errno return int;
   pragma Import (C, errno, "__get_errno");

   --  NAMEs not used are commented-out
   --  NAMEs not supported on this system have __NAME for value

   --  E2BIG    : constant := 3;
   --  EACCES   : constant := 4;
   EAGAIN   : constant := 5;
   --  EBADF    : constant := 6;
   --  EBUSY    : constant := 7;
   --  ECHILD   : constant := 8;
   --  EDEADLK  : constant := 9;
   --  EDOM     : constant := 1;
   --  EEXIST   : constant := 10;
   --  EFAULT   : constant := 11;
   --  EFBIG    : constant := 12;
   EINTR    : constant := 13;
   EINVAL   : constant := 14;
   --  EIO      : constant := 15;
   --  EISDIR   : constant := 16;
   --  EMFILE   : constant := 17;
   --  EMLINK   : constant := 18;
   --  ENAMETOOLONG : constant := 19;
   --  ENFILE   : constant := 20;
   --  ENODEV   : constant := 21;
   --  ENOENT   : constant := 22;
   --  ENOEXEC  : constant := 23;
   --  ENOLCK   : constant := 24;
   ENOMEM   : constant := 25;
   --  ENOSPC   : constant := 26;
   --  ENOSYS   : constant := 27;
   --  ENOTDIR  : constant := 28;
   --  ENOTEMPTY    : constant := 29;
   --  ENOTTY   : constant := 30;
   --  ENXIO    : constant := 31;
   --  EPERM    : constant := 32;
   --  EPIPE    : constant := 33;
   --  ERANGE   : constant := 2;
   --  EROFS    : constant := 34;
   --  ESPIPE   : constant := 35;
   --  ESRCH    : constant := 36;
   --   __ETIMEDOUT    : constant := 0;
   --  EXDEV    : constant := 37;

   -------------
   -- Signals --
   -------------

   NSIG : constant := 320;
   type Signal is new int range 0 .. Interfaces.C."-" (NSIG, 1);

   --  NAMEs not used are commented-out
   --  NAMEs not supported on this system have __NAME for value

   SIGHUP     : constant := 294; --  hangup
   SIGINT     : constant := 295; --  interrupt (rubout)
   SIGQUIT    : constant := 298; --  quit (ASCD FS)
   SIGILL     : constant := 290; --  illegal instruction (not reset)
   --  __SIGTRAP    : constant := 0; --  trace trap (not reset)
   --  __SIGIOT     : constant := 0; --  IOT instruction
   SIGABRT    : constant := 288; --  used by abort
   --  __SIGEMT     : constant := 0; --  EMT instruction
   SIGFPE     : constant := 289; --  floating point exception
   SIGKILL    : constant := 296; --  kill (cannot be caught or ignored)
   --  __SIGBUS     : constant := 0; --  bus error
   SIGSEGV    : constant := 291; --  segmentation violation
   --  __SIGSYS     : constant := 0; --  bad argument to system call
   SIGPIPE    : constant := 297; --  write on a pipe with no one to read it
   SIGALRM    : constant := 293; --  alarm clock
   SIGTERM    : constant := 292; --  software termination signal from kill
   SIGUSR1    : constant := 299; --  user defined signal 1
   SIGUSR2    : constant := 300; --  user defined signal 2
   --  __SIGCLD     : constant := 0; --  alias for SIGCHLD
   --  __SIGCHLD    : constant := 0; --  child status change
   --  __SIGPWR     : constant := 0; --  power-fail restart
   --  __SIGWINCH   : constant := 0; --  window size change
   --  __SIGURG     : constant := 0; --  urgent condition on IO channel
   --  __SIGPOLL    : constant := 0; --  pollable event occurred
   --  __SIGIO      : constant := 0; --  I/O possible (Solaris SIGPOLL alias)
   --  __SIGSTOP    : constant := 0; --  stop (cannot be caught or ignored)
   --  __SIGTSTP    : constant := 0; --  user stop requested from tty
   --  __SIGCONT    : constant := 0; --  stopped process has been continued
   --  __SIGTTIN    : constant := 0; --  background tty read attempted
   --  __SIGTTOU    : constant := 0; --  background tty write attempted
   --  __SIGVTALRM  : constant := 0; --  virtual timer expired
   --  __SIGPROF    : constant := 0; --  profiling timer expired
   --  __SIGXCPU    : constant := 0; --  CPU time limit exceeded
   --  __SIGXFSZ    : constant := 0; --  filesize limit exceeded
   --  __SIGWAITING : constant := 0; --  process's lwps blocked (Solaris)
   --  __SIGFREEZE  : constant := 0; --  used by CPR (Solaris)
   --  __SIGTHAW    : constant := 0; --  used by CPR (Solaris)
   --  __SIG32      : constant := 0; --  reserved for kernel (IRIX)
   --  __SIGUNUSED  : constant := 0; --  unused signal (Linux)
   --  __SIGSTKFLT  : constant := 0; --  coprocessor stack fault (Linux)
   --  __SIGLOST    : constant := 0;   --  SIGIO alias (Linux)

   type sigset_t is private;

   function sigaddset
     (set : access sigset_t;
      sig : Signal)
     return int;
   pragma Import (C, sigaddset, "sigaddset");

   function sigdelset
     (set : access sigset_t;
      sig : Signal)
     return int;
   pragma Import (C, sigdelset, "sigdelset");

   function sigfillset
     (set : access sigset_t)
     return int;
   pragma Import (C, sigfillset, "sigfillset");

   function sigismember
     (set : access sigset_t;
      sig : Signal)
     return int;
   pragma Import (C, sigismember, "sigismember");

   function sigemptyset
     (set : access sigset_t)
     return int;
   pragma Import (C, sigemptyset, "sigemptyset");


   --  The types mcontext_t and gregset_t are part of the ucontext_t
   --  information, which is specific to Solaris2.4 for SPARC
   --  The ucontext_t info seems to be used by the handler
   --  for SIGSEGV to decide whether it is a Storage_Error (stack overflow) or
   --  a Constraint_Error (bad pointer).  The original code that did this
   --  is suspect, so it is not clear whether we really need this part of
   --  the signal context information, or perhaps something else.
   --  More analysis is needed, after which these declarations may need to
   --  be changed.


   --  __FPE_INTOVF_TRAP     : constant := 1;  --  integer overflow
   --  __FPE_STARTSIG_TRAP   : constant := 2;  --  process using fp
   --  __FPE_INTDIV_TRAP     : constant := 20;  --  integer divide by zero
   --  __FPE_FLTINEX_TRAP    : constant := 196;  --  floating inexact result
   --  __FPE_FLTDIV_TRAP     : constant := 200;  --  floating divide by zero
   --  __FPE_FLTUND_TRAP     : constant := 204;  --  floating underflow
   --  __FPE_FLTOPERR_TRAP   : constant := 208;  --  floating operand error
   --  __FPE_FLTOVF_TRAP     : constant := 212;  --  floating overflow

   --  __ILL_STACK           : constant := 0;  --  bad stack
   --  __ILL_ILLINSTR_FAULT  : constant := 2;  --  illegal instruction fault
   --  __ILL_PRIVINSTR_FAULT : constant := 3;  --  privileged instruction fault


   type struct_sigcontext is record
      gs            : unsigned_short;
      fs            : unsigned_short;
      es            : unsigned_short;
      ds            : unsigned_short;
      edi           : unsigned_long;
      esi           : unsigned_long;
      ebp           : unsigned_long;
      esp           : unsigned_long;
      ebx           : unsigned_long;
      edx           : unsigned_long;
      ecx           : unsigned_long;
      eax           : unsigned_long;
      trapno        : unsigned_long;
      err           : unsigned_long;
      eip           : unsigned_long;
      cs            : unsigned_short;
      eflags        : unsigned_long;
      esp_at_signal : unsigned_long;
      ss            : unsigned_short;
      i387          : unsigned_long;
      oldmask       : unsigned_long;
      cr2           : unsigned_long;
   end record;
   pragma Convention (C, struct_sigcontext);

   type struct_sigaction is record
      sa_flags     : int;
      sa_handler   : System.Address;
      sa_mask      : sigset_t;
   end record;
   pragma Convention (C, struct_sigaction);
   type struct_sigaction_ptr is access all struct_sigaction;


   SIG_BLOCK   : constant := 1;
   SIG_UNBLOCK : constant := 3;
   SIG_SETMASK : constant := 2;

   --  SA_NOCLDSTOP : constant := 8;
   --  not used
   --  SA_SIGINFO : constant := 0;
   --  not used

   SIG_DFL : constant := 0;
   SIG_IGN : constant := -1;
   --  SIG_ERR : constatn := 1;
   --  not used

   function sigaction
     (sig  : Signal;
      act  : access struct_sigaction;
      oact : struct_sigaction_ptr)
     return int;
   pragma Import (C, sigaction, "sigaction");

   ----------
   -- Time --
   ----------

   type timespec is private;

   function nanosleep (rqtp, rmtp : access timespec)  return int;
   --  FSU_THREADS has nonstandard nanosleep
   type clockid_t is private;

   CLOCK_REALTIME : constant clockid_t;

   function clock_gettime
     (clock_id : clockid_t;
      tp       : access timespec)
      return int;
   pragma Import (C, clock_gettime, "clock_gettime");

   function To_Duration (TS : timespec) return Duration;
   pragma Inline (To_Duration);

   function To_Timespec (D : Duration) return timespec;
   pragma Inline (To_Timespec);

   type struct_timezone is record
      tz_minuteswest  : int;
      tz_dsttime   : int;
   end record;
   pragma Convention (C, struct_timezone);
   type struct_timeval is private;
   --  This is needed on systems that do not have clock_gettime()
   --  but do have gettimeofday().

   function To_Duration (TV : struct_timeval) return Duration;
   pragma Inline (To_Duration);

   function To_Timeval (D : Duration) return struct_timeval;
   pragma Inline (To_Timeval);

   function gettimeofday
     (tv : access struct_timeval;
      tz : access struct_timezone) return int;
   pragma Import (C, gettimeofday, "gettimeofday");


   --  add a hook to locate the Epoch, for use with Calendar????

   -------------------------
   -- Priority Scheduling --
   -------------------------

   MIN_PRIO : constant := 0;
   MAX_PRIO : constant := 0;

   SCHED_FIFO  : constant := 0;
   SCHED_RR    : constant := 1;
   SCHED_OTHER : constant := 2;

   -------------
   -- Process --
   -------------

   type pid_t is private;

   function kill
     (pid : pid_t;
      sig : Signal)
   return int;
   pragma Import (C, kill, "kill");

   function getpid return pid_t;
   pragma Import (C, getpid, "getpid");

   -------------
   -- Threads --
   -------------

   type Thread_Body is access
     function (arg : System.Address) return System.Address;


   type pthread_t           is private;
   type pthread_mutex_t     is limited private;
   type pthread_cond_t      is limited private;
   type pthread_attr_t      is limited private;
   type pthread_mutexattr_t is limited private;
   type pthread_condattr_t  is limited private;
   type pthread_key_t       is private;

   PTHREAD_CREATE_DETACHED : constant := 1;
   PTHREAD_CREATE_JOINABLE : constant := 0;

   -----------------------------------------
   --  Nonstandard Thread Initialization  --
   -----------------------------------------
   --  FSU_THREADS requires pthread_init, which is nonstandard
   --  and this should be invoked during the elaboration of s-taprop.adb
   procedure pthread_init;
   pragma Import (C, pthread_init, "pthread_init");

   ---------------------------
   --  POSIX.1c  Section 3  --
   ---------------------------

   function sigwait
     (set : access sigset_t;
      sig : access Signal)
     return int;
   --  FSU_THREADS has a nonstandard sigwait

   function pthread_kill
     (thread : pthread_t;
      sig    : Signal)
     return   int;
   pragma Import (C, pthread_kill, "pthread_kill");

   function pthread_sigmask
     (how  : int;
      set  : access sigset_t;
      oset : access sigset_t)
     return int;
   --  FSU_THREADS does not have pthread_sigmask

   --  We declare two wrappers for pthread_sigmask, since null may need
   --  to be passed for either set or oset and this is not allowed
   --  in Ada for access mode parameters (the error was not catched by
   --  GNAT until recently, and a flag, -gnatdj, was added to allow it
   --  to compile).

   function pthread_sigmask_set
     (how  : int;
      set  : access sigset_t)
     return int;
   --  Identical to pthread_sigmask (how, set, null).

   function pthread_sigmask_oset
     (how  : int;
      oset : access sigset_t)
     return int;
   --  Identical to pthread_sigmask (how, null, oset).

   ----------------------------
   --  POSIX.1c  Section 11  --
   ----------------------------

   function pthread_mutexattr_init
     (attr : access pthread_mutexattr_t)
     return int;
   pragma Import (C, pthread_mutexattr_init, "pthread_mutexattr_init");

   function pthread_mutexattr_destroy
     (attr : access pthread_mutexattr_t)
     return int;
   pragma Import (C, pthread_mutexattr_destroy, "pthread_mutexattr_destroy");

   function pthread_mutex_init
     (mutex : access pthread_mutex_t;
      attr  : access pthread_mutexattr_t)
     return int;
   pragma Import (C, pthread_mutex_init, "pthread_mutex_init");

   function pthread_mutex_destroy
     (mutex : access pthread_mutex_t)
     return  int;
   pragma Import (C, pthread_mutex_destroy, "pthread_mutex_destroy");

   function pthread_mutex_lock
     (mutex : access pthread_mutex_t)
     return int;
   --  FSU_THREADS has nonstandard pthread_mutex_lock

   function pthread_mutex_unlock
     (mutex : access pthread_mutex_t)
     return int;
   --  FSU_THREADS has nonstandard pthread_mutex_lock

   function pthread_condattr_init
     (attr : access pthread_condattr_t)
     return int;
   pragma Import (C, pthread_condattr_init, "pthread_condattr_init");

   function pthread_condattr_destroy
     (attr : access pthread_condattr_t)
     return int;
   pragma Import (C, pthread_condattr_destroy, "pthread_condattr_destroy");

   function pthread_cond_init
     (cond : access pthread_cond_t;
      attr : access pthread_condattr_t)
     return int;
   pragma Import (C, pthread_cond_init, "pthread_cond_init");

   function pthread_cond_destroy
     (cond : access pthread_cond_t)
     return int;
   pragma Import (C, pthread_cond_destroy, "pthread_cond_destroy");

   function pthread_cond_signal
     (cond : access pthread_cond_t)
     return int;
   pragma Import (C, pthread_cond_signal, "pthread_cond_signal");

   function pthread_cond_wait
     (cond  : access pthread_cond_t;
      mutex : access pthread_mutex_t)
     return  int;
   --  FSU_THREADS has a nonstandard pthread_cond_wait

   function pthread_cond_timedwait
     (cond    : access pthread_cond_t;
      mutex   : access pthread_mutex_t;
      abstime : access timespec)
     return    int;
   --  FSU_THREADS has a nonstandard pthread_cond_timedwait

   ----------------------------
   --  POSIX.1c  Section 13  --
   ----------------------------



   PTHREAD_PRIO_NONE    : constant := 0;
   PTHREAD_PRIO_PROTECT : constant := 2;
   PTHREAD_PRIO_INHERIT : constant := 1;

   function pthread_mutexattr_setprotocol
     (attr     : access pthread_mutexattr_t;
      protocol : int)
     return int;
   pragma Import
      (C, pthread_mutexattr_setprotocol, "pthread_mutexattr_setprotocol");

   function pthread_mutexattr_getprotocol
     (attr     : access pthread_mutexattr_t;
      protocol : access int)
     return int;
   pragma Import
     (C, pthread_mutexattr_getprotocol, "pthread_mutexattr_getprotocol");

   function pthread_mutexattr_setprioceiling
     (attr     : access pthread_mutexattr_t;
      prioceiling : int)
     return int;
   pragma Import
     (C, pthread_mutexattr_setprioceiling,
      "pthread_mutexattr_setprio_ceiling");

   function pthread_mutexattr_getprioceiling
     (attr     : access pthread_mutexattr_t;
      prioceiling : access int)
     return int;
   pragma Import
     (C, pthread_mutexattr_getprioceiling,
      "pthread_mutexattr_getprioceiling");

   type struct_sched_param is record
      sched_priority : int;  --  scheduling priority
   end record;

   function pthread_getschedparam
     (thread : pthread_t;
      policy : access int;
      param  : access struct_sched_param)
     return int;
   --  FSU_THREADS does not have pthread_getschedparam

   function pthread_setschedparam
     (thread : pthread_t;
      policy : int;
      param  : access struct_sched_param)
     return int;
   --  FSU_THREADS does not have pthread_setschedparam

   function pthread_attr_setscope
     (attr            : access pthread_attr_t;
      contentionscope : int)
     return int;
   pragma Import (C, pthread_attr_setscope, "pthread_attr_setscope");

   function pthread_attr_getscope
     (attr            : access pthread_attr_t;
      contentionscope : access int)
     return int;
   pragma Import (C, pthread_attr_getscope, "pthread_attr_getscope");

   function pthread_attr_setinheritsched
     (attr            : access pthread_attr_t;
      inheritsched : int)
     return int;
   pragma Import
     (C, pthread_attr_setinheritsched, "pthread_attr_setinheritsched");

   function pthread_attr_getinheritsched
     (attr         : access pthread_attr_t;
      inheritsched : access int)
     return int;
   pragma Import
     (C, pthread_attr_getinheritsched, "pthread_attr_getinheritsched");

   function pthread_attr_setschedpolicy
     (attr   : access pthread_attr_t;
      policy : int)
     return int;
   pragma Import
    (C, pthread_attr_setschedpolicy,
     "pthread_attr_setsched");

   function pthread_attr_getschedpolicy
     (attr   : access pthread_attr_t;
      policy : access int)
     return int;
   pragma Import (C, pthread_attr_getschedpolicy,
     "pthread_attr_getsched");

   function pthread_attr_setschedparam
     (attr        : access pthread_attr_t;
      sched_param : int)
     return int;
   pragma Import (C, pthread_attr_setschedparam, "pthread_attr_setschedparam");

   function pthread_attr_getschedparam
     (attr        : access pthread_attr_t;
      sched_param : access int)
     return int;
   pragma Import (C, pthread_attr_getschedparam, "pthread_attr_getschedparam");

   function sched_yield return int;
   --  FSU_THREADS does not have sched_yield;

   -----------------------------
   --  P1003.1c - Section 16  --
   -----------------------------

   function pthread_attr_init
     (attributes : access pthread_attr_t)
     return int;
   pragma Import (C, pthread_attr_init, "pthread_attr_init");

   function pthread_attr_destroy
     (attributes : access pthread_attr_t)
     return int;
   pragma Import (C, pthread_attr_destroy, "pthread_attr_destroy");



   function pthread_attr_setdetachstate
     (attr        : access pthread_attr_t;
      detachstate : int)
     return int;
   --  FSU_THREADS has a nonstandard pthread_attr_setdetachstate

   function pthread_attr_getdetachstate
     (attr        : access pthread_attr_t;
      detachstate : access int)
     return int;
   pragma Import
     (C, pthread_attr_getdetachstate, "pthread_attr_getdetachstate");

   function pthread_attr_getstacksize
     (attr      : access pthread_attr_t;
      stacksize : access size_t)
     return int;
   pragma Import
     (C, pthread_attr_getstacksize, "pthread_attr_getstacksize");

   function pthread_attr_setstacksize
     (attr      : access pthread_attr_t;
      stacksize : size_t)
     return int;
   pragma Import
     (C, pthread_attr_setstacksize, "pthread_attr_setstacksize");

   function pthread_create
     (thread        : access pthread_t;
      attributes    : access pthread_attr_t;
      start_routine : Thread_Body;
      arg           : System.Address)
     return int;
   pragma Import (C, pthread_create, "pthread_create");

   function pthread_detach (thread : pthread_t) return int;
   --  FSU_THREADS has a nonstandard pthread_detach

   procedure pthread_exit (status : System.Address);
   pragma Import (C, pthread_exit, "pthread_exit");

   function pthread_self return pthread_t;
   pragma Import (C, pthread_self, "pthread_self");

   function pthread_equal (t1 : pthread_t; t2 : pthread_t)
      return int;
   --  be careful not to use "=" on thread_t!
   pragma Import (C, pthread_equal, "pthread_equal");

   ----------------------------
   --  POSIX.1c  Section 17  --
   ----------------------------

   function pthread_setspecific
     (key   : pthread_key_t;
      value : System.Address)
     return  int;
   pragma Import (C, pthread_setspecific, "pthread_setspecific");

   function pthread_getspecific (key : pthread_key_t) return System.Address;
   --  FSU_THREADS has a nonstandard pthread_getspecific


   type destructor_pointer is access
      procedure (arg : System.Address);

   function pthread_key_create
     (key        : access pthread_key_t;
      destructor : destructor_pointer)
     return int;
   pragma Import (C, pthread_key_create, "pthread_key_create");


private

   type bits_arr_t is array (Integer range 1 .. 10) of long;
   type sigset_t is record
      bits : bits_arr_t;
   end record;

   --  In Solaris 2.4 the component sa_handler turns out to
   --  be one a union type, and the selector is a macro:
   --  #define sa_handler __funcptr._handler
   --  #define sa_sigaction __funcptr._sigaction

   type pid_t is new int;

   type time_t is new long;

   type timespec is record
      tv_sec       : time_t;
      tv_nsec      : long;
   end record;
   pragma Convention (C, timespec);

   type clockid_t is new int;
   CLOCK_REALTIME : constant clockid_t := 0;


   type struct_timeval is record
      tv_sec       : long;
      tv_usec      : long;
   end record;
   pragma Convention (C, struct_timeval);


   type pthread_attr_t is record
      flags        : int;
      stacksize    : int;
      contentionscope  : int;
      inheritsched  : int;
      detachstate  : int;
      sched        : int;
      prio         : int;
      starttime    : timespec;
      deadline     : timespec;
      period       : timespec;
   end record;
   pragma Convention (C, pthread_attr_t);

   type pthread_condattr_t is record
      flags        : int;
   end record;
   pragma Convention (C, pthread_condattr_t);

   type pthread_mutexattr_t is record
      flags        : int;
      prio_ceiling  : int;
      protocol     : int;
   end record;
   pragma Convention (C, pthread_mutexattr_t);

   type array_type_4 is array (integer range 0 .. 9) of int;
   type array_type_5 is array (integer range 0 .. 9) of int;
   type array_type_6 is array (integer range 0 .. 2) of System.Address;
   type union_type_2 is new int;
   type record_type_4 is record
      si_signo     : int;
      si_code      : int;
      si_value     : union_type_2;
   end record;
   pragma Convention (C, record_type_4);
   type array_type_7 is array (integer range 0 .. 32) of record_type_4;
   type record_type_5 is record
      head         : System.Address;
      tail         : System.Address;
   end record;
   pragma Convention (C, record_type_5);
   type array_type_8 is array (integer range 0 .. 7) of System.Address;
   type record_type_6 is record
      aio_return   : int;
      aio_errno    : int;
   end record;
   pragma Convention (C, record_type_6);
   type array_type_9 is array (integer range 0 .. 7) of long;
   type record_type_7 is record
      fds_bits     : array_type_9;
   end record;
   pragma Convention (C, record_type_7);
   type array_type_10 is array (integer range 0 .. 7) of long;
   type record_type_8 is record
      fds_bits     : array_type_10;
   end record;
   pragma Convention (C, record_type_8);
   type array_type_11 is array (integer range 0 .. 7) of long;
   type record_type_9 is record
      fds_bits     : array_type_11;
   end record;
   pragma Convention (C, record_type_9);
   type record_type_3 is record
      context      : array_type_4;
      pbody        : array_type_5;
      errno        : int;
      ret          : int;
      stack_base   : System.Address;
      state        : int;
      next         : array_type_6;
      num_timers   : int;
      interval     : struct_timeval;
      sig_info     : array_type_7;
      sig          : int;
      code         : int;
      osp          : int;
      opc          : int;
      obp          : int;
      nscp         : System.Address;
      scp          : System.Address;
      joinq        : record_type_5;
      cond         : System.Address;
      queue        : System.Address;
      mask         : sigset_t;
      pending      : sigset_t;
      sigwaitset   : sigset_t;
      func         : System.Address;
      arg          : System.Address;
      result       : System.Address;
      key          : array_type_8;
      cleanup_top  : System.Address;
      attr         : pthread_attr_t;
      base_prio    : int;
      max_ceiling_prio  : int;
      new_prio     : int;
      resultp      : record_type_6;
      wait_on_select  : int;
      width        : int;
      how_many     : int;
      readfds      : record_type_7;
      writefds     : record_type_8;
      exceptfds    : record_type_9;
      tp           : struct_timeval;
   end record;
   pragma Convention (C, record_type_3);
   type pthread_t is access record_type_3;

   type record_type_1 is record
      head         : System.Address;
      tail         : System.Address;
   end record;
   pragma Convention (C, record_type_1);
   type pthread_mutex_t is record
      queue        : record_type_1;
      lock         : plain_char;
      owner        : System.Address;
      flags        : int;
      prio_ceiling  : int;
      protocol     : int;
      prev_max_ceiling_prio  : int;
   end record;
   pragma Convention (C, pthread_mutex_t);

   type record_type_2 is record
      head         : System.Address;
      tail         : System.Address;
   end record;
   pragma Convention (C, record_type_2);
   type pthread_cond_t is record
      queue        : record_type_2;
      flags        : int;
      waiters      : int;
      mutex        : System.Address;
   end record;
   pragma Convention (C, pthread_cond_t);

   type pthread_key_t is new int;

end System.OS_Interface;
