match_find ()
{
	local files="$1"
	local name="$2"

	find "$1" | ( while read line; do
			    case $line in
			    */$2)
				    echo $line
				    ;;
			    esac 
		    done)
}

interactive_shell() {
	cd /
	echo \
"You are running \"ash\", a Bourne-shell clone. The root filesystem is a
RAM disk or floppy. The hard disk filesystems are mounted on \"/target\".
The editor available to you on this floppy is \"ae\". It's very small
and easy to figure out - sorry but \"vi\" and \"emacs\" wouldn't fit. To
get an idea of what Unix utilities are available to you, run \"ls /bin
/sbin /usr/bin /usr/sbin\". Use the \"exit\" command to return to the
installation menu.
"
	/bin/sh
	cd /
}

mounted_partitions () {
	local partitions
	partitions="`< /etc/mtab sed -e 's/[ 	].*$//' -e '/proc$/d' \
	 -e '/ramdisk0$/d' -e '/ram$/d' `"
	if [ $? -ne 0 -o -z "$partitions" ]; then return 1; fi
	# Reverse the partitions from the mount-table order, as this is the order
	# in which they would be un-mounted.
	echo `reverse "$partitions"`
	return 0
}

used_partitions () {
    if [ -n "$Swap" -a "$Swap" != "None" ]; then
	echo -n "$Swap "
    fi
    mounted_partitions
}

# XXX currently unused
# XXX PCMCIA currently  set in network configuration
select_drivers() {
	local choice

	choice="`checklist "Please select the hardware that you have" \
"Select special hardware" \
"SCSI" "SCSI adapters and devices" off \
"PCMCIA" "PCMCIA equipment" off`"
	for i in $choice; do
		case $i in
		\"SCSI\")
			# XXX load SCSI modules
			if [ "$revext" = lowmem ]; then
				mount_and_check_floppy "" lowmemdrivers
				modconf --source floppy \
					--load-before scsi_mod \
					--restrict-section scsi \
					--load-after sd_mod
				umount /floppy 2>/dev/null
			else
				true
			fi
			;;
		\"PCMCIA\")
			
			# XXX load PCMCIA
#			mount_and_check_floppy "" ${revext}drivers
#			modconf --source floppy --restrict-section pcmcia
#			umount /floppy 2>/dev/null
			pcmcia=true
			;;
		*)
			unreachable
		esac
	done
}

# FIXME: delete this whenever the C version works
scan_partitions_to_be_deleted () {
	local types="$*"
	local partitions
	local i
	local j
	local all_partitions
	
	sed -n -e '/^\/dev\//p' </tmp/fdisk >/tmp/fdisk.scan_partitions
	all_partitions="`sed -e 's/[ 	].*$//' </tmp/fdisk.scan_partitions `"
	rm -f /tmp/fdisk.scan_partitions

	if [ -n "${types}" ]; then
		for i in $all_partitions; do
			type=`partition_to_fstype $i`
			for j in ${types}; do
				if [ "$type" = $j ]; then
					partitions="$partitions $i"
				fi
			done
		done
	else
		partitions="$all_partitions"
	fi

	if [ -z "$partitions" ]; then return 1; fi
	echo "$partitions"
	return 0
}

partition_to_fstype () {
	local type

	sed -n -e "s:^$1:$1:p" </tmp/fdisk >/tmp/fdisk.to_fstype
	type="`sed -e 's/.*[ 	][ 	]//g' </tmp/fdisk.to_fstype`"
	rm -f /tmp/fdisk.to_fstype

	case "$type" in
	"Linux native")
		echo ext2
		;;
	"Linux swap")
		echo swap
		;;
	Linux/MINIX)
		echo minix
		;;
	Extended)
		echo extended
		;;
# for Linux/m68k - Atari
	Minix)
		echo minix
		;;
	*DOS*)
		echo msdos
		;;
	*)
		return 1   
	esac
	echo -n . >/dev/tty
	return 0
}
