#include <string.h>
#include <sys/types.h>
#include <sys/swap.h>
#include <sys/mount.h>
#include <stdio.h>
#include <newt.h>
#include "dinstall.h"
#include "../busybox/internal.h"
#include "lang.h"

extern int mount_one( char *blockDevice, char *directory, char *filesystemType,
  unsigned long flags, char *string_flags, int noMtab, int fake);

static struct fdisk_disk *
select_drive(void) {
  struct fdisk_disk *disk;
  newtComponent t1,lb,f1,b1,b2,ans;
  int it=0;

  /* shell version used try_open here. Why ? */
  
  if (NULL == fdisk_disks) {
    problemBox(MSG_NO_HARD_DISK_L,MSG_NO_HARD_DISK);
    return(NULL);
  }
  
  t1 = newtTextbox (1, 0, 70, 4, NEWT_FLAG_WRAP);
  newtTextboxSetText(t1,MSG_SELECT_HD); 
  lb = newtListbox(25,5, 0, NEWT_FLAG_DOBORDER | NEWT_FLAG_RETURNEXIT);
  disk = fdisk_disks;
  while (disk) {
    newtListboxAddEntry(lb,disk->name,disk);
    disk = disk->next;
    it++;
  }
  b1 = newtCompactButton ( 24, it+8, MSG_OK );
  b2 = newtCompactButton ( 36, it+8, MSG_CANCEL );
  
  f1 = newtForm(NULL, NULL, 0);
  newtFormAddComponents (f1 , t1, lb, b1, b2, NULL);

  newtOpenWindow (5, 7-it/2, 71, 9+it, MSG_SELECT_DISK_DRIVE);
  ans=newtRunForm(f1);
  if (ans!=b2)
    disk = newtListboxGetCurrent(lb);
  else
    disk = NULL;

  newtPopWindow();
  newtFormDestroy(f1);

  return(disk);
}

int partition_disk (void) {
  struct fdisk_disk *d;
  struct fdisk_partition *p;
  char *mounts, *swaps, *tmpbuf; 
  int root_on_disk=0, status;
  struct stat statbuf;

  sync();
  mounts = swaps = NULL;

  if (! (d = select_drive())) {
    return(1);
  }

  p = d->partitions;

  while (p) {
    if (p->in_use) {
      if (fdisk_fstype_of(p->type) == FSTYPE_SWAP) {
	if (swaps) {
	  addtolist(&swaps,p->name);
        } else {
	  swaps = strdup(p->name);
        }
      } else {
	if (mounts) {
	  addtolist(&mounts,p->name);
        } else {
          mounts = strdup(p->name);
        }
      }  
    }
    p=p->next_by_disk;
  }
  prtbuf[0]='\0';
  if (mounts)
    sprintf(prtbuf,MSG_REPARTITION_MOUNTED ,mounts,d->name,d->name);
  if (swaps) {
    tmpbuf=(char *)malloc(strlen(swaps)+2*strlen(d->name)+320);
    sprintf(tmpbuf,MSG_REPARTITION_SWAP,swaps,d->name,d->name);
    strcat(prtbuf,tmpbuf);
    free(tmpbuf);
  }
  if ((mounts)||(swaps)){
    strcat(prtbuf,MSG_REPARTITION_HD);
    if (!(yesNoBox(prtbuf,MSG_REPARTITION_HD))) return (1);
  }
  if (mounts) {
    p = mounted_partitions;
    while (p) {
      if (strstr(mounts,p->name)) {
	if (do_umount(p->name,0)) {
/* XXX should check errno ? */
	  sprintf(prtbuf, MSG_UMOUNT_FAILED_L2,p->name, p->name, p->name);
	  problemBox(prtbuf,MSG_UMOUNT_FAILED);
	  root_on_disk=1;
	}
      }
      p=p->next_in_use;
    }
    free (mounts);
  }
  if (swaps) {
    p = swapon_partitions;
    while (p) {
      if (strstr(swaps,p->name)) {
	struct FileInfo finfo;
	finfo.source = p->name;
	swapoff_fn(&finfo);
      }
      p=p->next_in_use;
    }
    free (swaps);
  }
  if ( NAME_ISEXE( T_FILE("/sbin/cfdisk"), &statbuf ) ) {
    sprintf(prtbuf,"cfdisk %s",d->name);
  } else {
    sprintf(prtbuf,"fdisk %s",d->name);
  }
  newtSuspend();
  status=system(prtbuf);
  newtResume();
  if (root_on_disk) reboot_system();
  return 0;
}

static int mount_partition (struct fdisk_partition *partition) {
  char *mount_point,*real_mount_point, *prototype, *mode, *type;
  struct stat statbuf;

  type = fdisk_fstype_name_of(partition->type);
  if (!type) {
    sprintf(prtbuf,MSG_INVALID_FS_L,partition->name,sysname(partition->type));
    problemBox(prtbuf,MSG_INVALID_FS);
    return 1;
  }
  if (! Root) {
    sprintf(prtbuf,MSG_MOUNT_ROOT_L,partition->name); 
    if (! yesNoBox(prtbuf,MSG_MOUNT_ROOT) ) return 1;
    mount_point=strdup("/");
    real_mount_point=strdup("/target");
  } else {
    if ( (! NAME_ISDIR( T_FILE("/target/usr"), &statbuf ) ) ||
         (! strcmp(Root->name,block_device(T_FILE("/target/usr"),NULL))) ){
      prototype="/usr";
    } else if ( (! NAME_ISDIR( T_FILE("/target/var"), &statbuf ) ) ||
                (! strcmp(Root->name,block_device(T_FILE("/target/var"),NULL))) ){ 
      prototype="/var";
    } else if ( (! NAME_ISDIR( T_FILE("/target/home"), &statbuf ) ) ||
                (! strcmp(Root->name,block_device(T_FILE("/target/home"),NULL))) ){
      prototype="/home";
    } else {
      prototype="/";
    }

    sprintf(prtbuf,MSG_SELECT_MOUNT_POINT_L,partition->name);
    mount_point=inputBox(prtbuf,MSG_SELECT_MOUNT_POINT,prototype);
    if (NULL == mount_point) return 1;
    real_mount_point=(char *)malloc(8+strlen(mount_point));
    real_mount_point[0]='\0';
    strcat(real_mount_point,"/target");
    strcat(real_mount_point,mount_point);
  }

  if (! NAME_ISDIR( T_FILE(real_mount_point), &statbuf ) ) {
    struct FileInfo finfo;
    if (! strcmp(real_mount_point,"/target/tmp") ) {
      mode="1777";
    } else {
      mode="755";
    }
    finfo.source = T_FILE(real_mount_point);
    finfo.orWithMode = strtol(mode, 0, 010);
    finfo.makeParentDirectories = 1;
    if (! mkdir_fn(&finfo)) {
      chown(finfo.source, 0, 3); /* root_uid= 0 , sys_gid= 3 */
    }
  }
  if ( mount_one(partition->name,real_mount_point,type,0,"\0",0,0) ) {
    perrorBox(MSG_MOUNT_FAILED);
    free(real_mount_point);
    free(mount_point);
    return 1;
  }
  if (! strcmp(mount_point,"/") ) {
    Root=partition;
  }
  free(mount_point);
  return 0;
}

static int get_cflag (const char *name) {
  struct stat statbuf;

  if (! NAME_ISEXE( T_FILE("/sbin/badblocks"), &statbuf ) ) {
/* 	not_on_lowmem "/sbin/badblocks not on lowmem disk" */
    return 0;
  }
  sprintf(prtbuf,MSG_SCAN_BADBLOCKS_L, name);
  return yesNoBox(prtbuf,MSG_SCAN_BADBLOCKS);
}

int init_linux (void) {
  struct fdisk_partition *p;
  int cflag,status;

  sync();
  p=select_not_mounted(MSG_SELECT_INITIALIZE ,MSG_SELECT_PARTITION,1,FSTYPE_EXT2);
  if (!p) return 1;
  cflag=get_cflag(p->name);
  sprintf(prtbuf,MSG_INITIALIZE_INFO,p->name);
  if(! yesNoBox(prtbuf,MSG_ARE_YOU_SURE) ) return 1;

  sprintf(prtbuf,"mkfs.ext2 %s %s",( cflag ? "-c" : ""),p->name);
  newtSuspend();
  printf(CLEAR MSG_CREATING_FS);
  status=system(prtbuf);
  newtResume();
  if (status) {
/* FIXME	write_it_down "The filesystem was not created." */
    problemBox(MSG_FS_NOT_CREATED,MSG_PROBLEM);
    return 1;
  }
  return mount_partition(p);
}

int init_swap (void) {
  struct fdisk_partition *p;
  struct FileInfo finfo;
  int cflag,status;

  sync();
  p=select_not_mounted(MSG_SELECT_INITIALIZE_SWAP_L,MSG_SELECT_SWAP,1,FSTYPE_SWAP);
  if (!p) return 1;
  cflag=get_cflag(p->name); 
  sprintf(prtbuf,MSG_INITIALIZE_SWAP_INFO,p->name);
  if(! yesNoBox(prtbuf,MSG_ARE_YOU_SURE) ) return 1;

  sprintf(prtbuf,"mkswap %s %s",( cflag ? "-c" : ""),p->name);
  newtSuspend();
  printf(CLEAR MSG_INITIALIZING_SWAP);
  status=system(prtbuf);
  newtResume();
  if (status) {
/* FIXME        write_it_down "The swap partition could not be initialized." */
    problemBox(MSG_SWAP_NOT_CREATED,MSG_PROBLEM);
    return 1;
  }
  finfo.source = p->name;
  if (swapon_fn(&finfo)) {
    sprintf(prtbuf,MSG_SWAP_NOT_ACTIVED,p->name);
    perrorBox(prtbuf);
    return 1;
  }
  return 0;
}

int no_swap (void) {
  struct fdisk_partition *p;

  if ( yesNoBox( MSG_DO_WIHOUT_SWAP_L,MSG_DO_WIHOUT_SWAP )) {
    if (swapon_partitions) {
      p = swapon_partitions;
      while (p) {
        struct FileInfo finfo;
        finfo.source = p->name;
        swapoff_fn(&finfo);
        p=p->next_in_use;
      }
    }
    noSwap=1;
  }
  return 0;
}

int mount_any (void) {
  struct fdisk_partition *p;

  p=select_not_mounted( MSG_SELECT_PARTITION_2MOUNT,
MSG_SELECT_PARTITION,5,FSTYPE_EXT2,FSTYPE_MINIX,FSTYPE_MSDOS,FSTYPE_AFFS,FSTYPE_HFS);
  if (!p) return 1;
  return mount_partition(p);
}

static int unmount_partition (struct fdisk_partition *p) {

  if (do_umount(p->name,0)) {
/* XXX should check errno ? */
    sprintf(prtbuf,MSG_UMOUNT_FAILED_L2, p->name, p->name, p->name);
    problemBox(prtbuf,MSG_UMOUNT_FAILED);
    return 1;
  }
  if ( p == Root ) Root=NULL;
  return 0;
}

int unmount_any (void) {
  struct fdisk_partition *p;
  newtComponent t1,lb,f1,b1,b2,ans;
  int it=0;

  p=mounted_partitions;
  if ((p == NULL) || 
      ((! strcmp(p->name,InstallationRootDevice)) && (p->next_in_use==NULL))) {
    problemBox(MSG_NO_MOUNTED_PARTITION,MSG_PROBLEM);
    return 1;
  }
  t1 = newtTextbox (1, 0, 70, 1, NEWT_FLAG_WRAP);
  newtTextboxSetText(t1, MSG_SELECT_PARTITION_2UMOUNT);
  lb = newtListbox(26, 2, 0, NEWT_FLAG_DOBORDER | NEWT_FLAG_RETURNEXIT);
  p = mounted_partitions;
  while (p) {
    if (strcmp(p->name,InstallationRootDevice))
      newtListboxAddEntry(lb,p->name,p);
    p = p->next_in_use;
    it++;
  }
  b1 = newtCompactButton ( 24, it+4, MSG_OK );
  b2 = newtCompactButton ( 36, it+4, MSG_CANCEL );

  f1 = newtForm(NULL, NULL, 0);
  newtFormAddComponents (f1, t1, lb, b1, b2, NULL);

  newtOpenWindow (5, 9-it/2, 71, 5+it, MSG_SELECT_PARTITION);
  ans = newtRunForm(f1);
  if (ans != b2)
    p = newtListboxGetCurrent(lb);
  else
    p = NULL;

  newtPopWindow();
  newtFormDestroy(f1);

  if (p == NULL) return 1;
  return unmount_partition(p);
}

int activate_swap (void) {
  struct fdisk_partition *p;
  struct FileInfo finfo;

  p=select_not_mounted(MSG_SELECT_ACTIVATE_SWAP_L ,MSG_SELECT_SWAP,1,FSTYPE_SWAP);
  if (!p) return 1;
  sprintf(prtbuf,MSG_ACTIVATE_INFO,p->name);
  if(! yesNoBox(prtbuf,MSG_ARE_YOU_SURE) ) return 1;
  finfo.source = p->name;
  if (swapon_fn(&finfo)) {
    sprintf(prtbuf,MSG_SWAP_NOT_ACTIVED,p->name);
    perrorBox(prtbuf);
    return 1;
  }
  return 0;
}

int view_partitions (void) {
  struct fdisk_disk *d;
  struct fdisk_partition *p;
  newtComponent t1,f1,b1;
  int height=0;

  t1 = newtTextbox (1, 0, 60, 1, NEWT_FLAG_WRAP);
  d = fdisk_disks;
  if (d) {
    newtTextboxSetText(t1,MSG_VIEW_PARTITIONS_TITLE);
    while (d) {
      p = d->partitions;
      if (p) {
        while (p) {
          sprintf(prtbuf,"%-10s  %-3s  %-20s  %-18s",p->name,
            (p->in_use)?MSG_YES:MSG_NO,sysname(p->type),
            (p->mount_point)? p->mount_point : " ");
          newtTextboxAddLine(t1,prtbuf,-1);
          p = p->next_by_disk;
        }
      } else {
        sprintf(prtbuf,MSG_NO_PARTITIONS,d->name);
        newtTextboxAddLine(t1,prtbuf,-1);
      }
      d = d->next;
      newtTextboxAddLine(t1," ",-1);
    }
    height=newtTextboxGetNumLines(t1);
    newtTextboxSetHeight(t1,height);
    newtOpenWindow (10, 11-height/2, 61, height+1, MSG_PARTITIONS_LIST);
    b1 = newtCompactButton ( 23, height, MSG_CONTINUE);
    f1 = newtForm(NULL, NULL, 0);
    newtFormAddComponents (f1, t1, b1, NULL);
    newtRunForm(f1);
    newtPopWindow();
    newtFormDestroy(f1);
    return 0;
  } else {
    problemBox(MSG_NO_HARD_DISK_L, MSG_NO_HARD_DISK);
    return 1;
  }
}
