// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _HttpConn_h_
#define _HttpConn_h_

#include <qstring.h>
#include "Connection.h"

//: The HttpConn class provides a simple means for retrieving data through thr HTTP protocol.
class HttpConn : public Connection {
    Q_OBJECT
    enum { Init, RequestSent, Setup, Data } _state;
    QString _header;
    QString _mediaType;
    QString _mediaSubtype;
    int     _reqStatus;
    QString _reqStatusText;
    QString _location;

    //. Process an HTTP header.  We are interested in headers that specify the
    //. Internet media type, the data size, or the new location of the data.
    void procHeader();
public:
    //. Create a new HttpConn.
    HttpConn( const Url& url );

    //. Open an HTTP connection to a remote host.  Look up the host, create a
    //. create a socket, send the request, and switch to non-blocking mode.
    virtual bool open();
public slots:
    //. The connection has data to be read.  Read it and emit it.
    virtual void readable();

    virtual void writable();
signals:
    //. Emit data as it is received.
    virtual void data( const char* bytes, int length );

    //. Emit notification that the connection has been torn down.
    virtual void endOfData();

    //. Emit the Internet media type and size of the data stream.
    virtual void startOfData( QString mediaType, QString mediaSubtype, int totalSize );

    //. Emit message about connection status and data transfered.
    virtual void status( QString msg );

    //. This signal is emitted when the URL being retrieved changes because
    //. of an HTTP redirect.
    virtual void urlChanged( const Url& url );
};

#endif
