/*
 * $Id: warn.h,v 1.1 1997/05/22 21:46:00 tvr Exp $
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 * Written by
 *   Teemu Rantanen (tvr@cs.hut.fi)
 *
 * $Log: warn.h,v $
 * Revision 1.1  1997/05/22 21:46:00  tvr
 * Initial revision
 *
 */

typedef struct warn_s warn_t;

/*
 * Init warning -pointer. nrwarnings is the maximum warnid used on warn().
 * name is the name of the module, eg "SID".
 */
warn_t *warn_init(char *name, int nrwarnings);

/*
 * Warn every warning with warnid >= 0 only once.
 * Warn other warnings always.
 */
void warn(warn_t *pwarn, int warnid, char *msg, ...);

/*
 * This resets warning-information for one module or all modules
 * (NULL-parameter). After reset warning with warnid >= 0 will be
 * displayed again.
 */
void warn_reset(warn_t *pwarn);
