// pppload - A PPP Load Monitor
// Copyright (C) 1996  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include <qapp.h>
#include "PPPStats.H"
#include "MainWindow.H"
#include "Options.H"

Options* options = 0;

int main(int   argc,
		 char* argv[])
{
	QApplication a( argc, argv );
	options              = new Options( argc, argv );
	MainWindow* mw       = new MainWindow;
	PPPStats*   pppStats = new PPPStats;

	mw->connect( pppStats, SIGNAL(changeStats(unsigned int, unsigned int, unsigned int, unsigned int)), mw, SLOT(updateStats(unsigned int, unsigned int, unsigned int, unsigned int)));
	mw->connect( pppStats, SIGNAL(linkDown())                     , mw, SLOT(linkDown()));

	a.setMainWidget( mw );
	mw->show();
	return a.exec();
}
