// $Id: stringify.C,v 1.2 1997/10/03 10:41:46 zeller Exp $ -*- C++ -*-
// C-encode standard input

// Copyright (C) 1997 Technische Universitaet Braunschweig, Germany.
// Written by Andreas Zeller <zeller@ips.cs.tu-bs.de>.
// 
// This file is part of the DDD Library.
// 
// The DDD Library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// The DDD Library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with the DDD Library -- see the file COPYING.LIB.
// If not, write to the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
// DDD is the data display debugger.
// For details, see the DDD World-Wide-Web page, 
// `http://www.cs.tu-bs.de/softech/ddd/',
// or send a mail to the DDD developers <ddd@ips.cs.tu-bs.de>.

char stringify_rcsid[] = 
    "$Id: stringify.C,v 1.2 1997/10/03 10:41:46 zeller Exp $";

#include <iostream.h>
#include <iomanip.h>
#include <stdlib.h>

#ifndef EXIT_SUCCESS
#define EXIT_SUCCESS 0
#endif

#ifndef EXIT_FAILURE
#define EXIT_FAILURE 1
#endif

int main()
{
    cout << "\"";

    int p = 0;

    char c;

    while (cin.get(c))
    {
	if (p > 0 && p % 16 == 0)
	    cout << "\"\n\"";

	cout << "\\" << oct << setw(3) 
	     << setfill('0') << int((unsigned char)c);

	p++;
    }

    cout << "\"\n";

    return EXIT_SUCCESS;
}
