// -*- C++ -*-
/* This file is part of
* ======================================================
* 
*           LyX, the High Level Word Processor
*	    Copyright (C) 1995 Matthias Ettrich
*
*           This file is Copyright (C) 1996
*           Lars Gullik Bjnnes
*
*======================================================*/

#ifndef _TOOLBAR_H_
#define _TOOLBAR_H_

#include <forms.h>
#include "keybind.h"
#include "config.h"
#include "lyxlex.h"
#include "combox.h"

#define TOOL_SEPERATOR -1
#define TOOL_LAYOUTS -2
#define TOOL_NEWLINE -3

class Toolbar
{
private:
	struct toolbarItem
	{
		toolbarItem *next;
		int action;
		FL_OBJECT *icon;
		bool IsBitmap;
		char **pixmap;
		toolbarItem(){
			next = NULL;
			action = LFUN_NOACTION;
			icon = NULL;
			pixmap = NULL;
			IsBitmap = false;
		}
		~toolbarItem(){
			if (icon){
				fl_delete_object(icon);
				fl_free_object(icon);
			}
		}
			
	};
	toolbarItem *toollist; // a list containing all the buttons
	int xpos, ypos;
	int buttonwidth, height;
	int standardspacing, sepspace;
	bool cleaned;
	char **getPixmap(kb_action, char* arg=NULL);
	int get_toolbar_func(const char*);
	void clean(); // removes all toolbar buttons from the toolbar.
	static void ToolbarCB(FL_OBJECT*, long);
	void reset(){
		toollist = NULL;
		cleaned = false;
		
		lightReset();
	}
	void lightReset(){
				// these positions are hardcoded now, but
		ypos = 44; // that will change in the near future. (I hope)
		buttonwidth = 30; // the standard button width
		height = 30; // the height of all items in the toolbar
		standardspacing = 4; // the usuall space between items
		sepspace = 15; // extra space
		xpos = 10 - standardspacing;
	}
public:
	Toolbar(){
		toolobj = new FL_OBJECT;
		combox = NULL;
		reset();
	}
	FL_OBJECT *toolobj;
	Combox *combox;
	void read(LyXLexClass*);
	void init(); // sets up default toolbar
	void set(); // (re)sets the toolbar.
	void edit(); /* this is to be the entry point to the toolbar
		      * frame, where you can change the toolbar realtime.*/
    	void add(int ,bool doclean=true); // add a new button to the toolbar.
	void add(const char*, bool doclean=true); // name of func instead of kb_action
	void push(int); // invokes the n'th icon in the toolbar
};

extern Toolbar toolbar;
#endif
