/* This software is Copyright 1995 by Karl-Johan Johnsson
 *
 * Permission is hereby granted to copy, reproduce, redistribute or otherwise
 * use this software as long as: there is no monetary profit gained
 * specifically from the use or reproduction of this software, it is not
 * sold, rented, traded or otherwise marketed, and this copyright notice is
 * included prominently in any copy made. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. ANY USE OF THIS
 * SOFTWARE IS AT THE USER'S OWN RISK.
 */
#include "global.h"
#include "kill.h"
#include "pixmaps.h"
#include "widgets.h"

static unsigned char bitmap_data[] = {
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
};

void free_hot_pixmaps(void)
{
    Display		*disp = XtDisplay(main_widgets.shell);
    unsigned long	*pixels;
    int			i, n;

    for (i = 0 ; i < global.n_pixmaps ; i++)
	if (global.hot_pixmaps[i] != None)
	    XFreePixmap(disp, global.hot_pixmaps[i]);

    if (global.kill_list) {
	pixels =
	    (unsigned long *)XtMalloc(global.n_pixmaps *
				      sizeof(unsigned long));
	for (n = 0, i = 0 ; global.kill_list[i] ; i++)
	    if (global.kill_list[i]->alloced_pixel)
		pixels[n++] = global.kill_list[i]->pixel;

	if (n > 0)
	    XFreeColors(disp, global.cmap, pixels, n, 0);
	XtFree((char *)pixels);
    }

    XtFree((char *)global.hot_pixmaps);
    global.hot_pixmaps = NULL;
    global.n_pixmaps = 0;
}

void alloc_hot_pixmaps(void)
{
    if (global.kill_list) {
	Display		*disp = XtDisplay(main_widgets.shell);
	Window		win = XtWindow(main_widgets.shell);
	int		i, n;

	for (n = 1, i = 0 ; global.kill_list[i] ; i++)
	    if (global.kill_list[i]->valid &&
		global.kill_list[i]->action != KillActionKill)
		n++;

	global.hot_pixmaps = (Pixmap *)XtMalloc(n * sizeof(Pixmap));
	global.hot_pixmaps[0] = None;

	for (n = 1, i = 0 ; global.kill_list[i] ; i++) {
	    KILL_NODE	*node = global.kill_list[i];
	    XColor	col;
	    int		ok;

	    if (!node->valid || node->action == KillActionKill)
		continue;

	    ok = XParseColor(disp, global.cmap, node->color, &col);
	    if (ok && XAllocColor(disp, global.cmap, &col)) {
		node->pixel = col.pixel;
		node->alloced_pixel = True;
	    } else {
		if (ok)
		    fprintf(stderr,
			    "Warning: Cannot allocate "
			    "colormap entry for \"%s\"\n",
			    node->color);
		else
		    fprintf(stderr,
			    "Warning: Bogus color in kill"
			    "file: \"%s\"\n",
			    node->color);
		node->pixel = global.default_hot_pixel;
		node->alloced_pixel = False;
	    }

	    global.hot_pixmaps[n] =
		XCreatePixmapFromBitmapData(disp, win, (char *)bitmap_data,
					    HOT_PIXMAP_SIZE, HOT_PIXMAP_SIZE,
					    node->pixel, 0, global.depth);
	    node->hot = n;
	    n++;
	}

	global.n_pixmaps = n;
    } else {
	global.hot_pixmaps = (Pixmap *)XtMalloc(sizeof(Pixmap));
	global.hot_pixmaps[0] = None;
	global.n_pixmaps = 1;
    }
}

void create_hot_pixmap(KILL_NODE *node)
{
    Display	*disp = XtDisplay(main_widgets.shell);
    Window	win = XtWindow(main_widgets.shell);

    if (!node->alloced_pixel)
	node->pixel = global.default_hot_pixel;
    node->hot = global.n_pixmaps++;
    global.hot_pixmaps =
	(Pixmap *)XtRealloc((char *)global.hot_pixmaps,
			    global.n_pixmaps * sizeof(Pixmap));
    global.hot_pixmaps[node->hot] =
	XCreatePixmapFromBitmapData(disp, win, (char *)bitmap_data,
				    HOT_PIXMAP_SIZE, HOT_PIXMAP_SIZE,
				    node->pixel, 0, global.depth);
}
