
/* Maelstrom Sound Mixer class

	-Sam Lantinga			(5/5/95)
*/

#include "sound_cmds.h"
#include "sample.h"

#define _PATH_DEV_AUDIO	"/dev/audio"
#ifdef linux
#define _PATH_DEV_DSP	"/dev/dsp"
#else
#define _PATH_DEV_DSP	_PATH_DEV_AUDIO
#endif /* linux */

/* 0002 = 2 fragments */
/* 000a = 2^9 (512) bytes/fragment (lower this for faster reaction time) */
#define FRAG_SPEC	0x00020009

#ifndef ASYNCHRONOUS_IO
#define IO_CHECK	128
#endif

/* Woah!  The CLASS! :) */
class Mixer {

public:
	Mixer(char *device, unsigned short initvolume);
	~Mixer();

	int  SetVolume(unsigned short Volume);
	int  SoundID(unsigned short channel);
	int  Play_Sample(unsigned short channel, Sample *sample);
	void Play(void);
	void Halt(unsigned short channel);
	void HaltAll(void);
	void Handle_IO(int fd, void (*handler)(int));

private:
	void PlaySleep(void);		// Sleep instead of play sound
	int  DSPopen(int complain);	// Open the sound device
	void DSPclose(void);		// Close the sound device

	char *dsp_device;		// The pathname of the sound device
	int   dsp_fd;			// The sound device file descriptor
	int   speed;			// The recording speed of the samples
	int   frag_size;		// The fragment size

	float volume;			// Current volume of playing samples

	/* Some channels and the sound data to play */
	struct Channel {
		int   position;		// Offset into current sample
		int   in_use;		// Is this channel in use?
		Sample *sample;		// Current sample on this channel
		} channels[NUM_CHANNELS];

	unsigned char *clipped;		// Sound data to play
	unsigned char *silence;		// Just plain silence

	int unclipped;			// Unclipped raw data 
#ifdef PLAY_DEV_AUDIO
	int increment;			// Frequency relation constant
#endif

	/* See if there is pending I/O */
	void (*io_handler)(int);	// I/O handler
	int   io_fd;			// I/O fd
	void Handle_IO(int nuthin) {
		struct timeval tv;
		fd_set fdset;

		if ( ! io_handler )
			return;

		FD_ZERO(&fdset);
		FD_SET(io_fd, &fdset);
		memset(&tv, 0, sizeof(tv));
#ifdef _INCLUDE_HPUX_SOURCE
		if ( select(io_fd+1,(int *)&fdset,NULL,NULL,&tv) == 1 )
#else
		if ( select(io_fd+1,&fdset,NULL,NULL,&tv) == 1 )
#endif
			(*io_handler)(0);
	}

};
