/* d_switch.h		-*- C++ -*-
 *$Header: /al/acs/src/RCS/d_switch.h,v 9.21 95/10/21 18:10:45 al Exp $
 * data structures for voltage (and current) controlled switch
 */
#ifndef D_SWITCH_H
#define D_SWITCH_H
#include "e_model.h"
#include "e_elemnt.h"
/*--------------------------------------------------------------------------*/
class MODEL_SWITCH : public MODEL_BASE {
friend class SWITCH_BASE;
public:
	MODEL_SWITCH(const char *name = "");
	MODEL_SWITCH(const MODEL_SWITCH& p){assert(!"copy-model??");}
	CARD*	clone()const{return new MODEL_SWITCH(*this);}
	void	parse(CS&);
	void	print(int,int)const;
private:
  double	vt;		/* threshold voltage */
  double	vh;		/* hysteresis voltage */
  double	ron;		/* on resistance */
  double	roff;		/* off resistance */
  enum control_t {VOLTAGE, CURRENT};
  control_t	type;		/* current or voltage controlled */
};
/*--------------------------------------------------------------------------*/
class SWITCH_COMMON : private COMPONENT_COMMON {
friend class SWITCH_BASE;
	SWITCH_COMMON();
	SWITCH_COMMON(const SWITCH_COMMON& p):COMPONENT_COMMON(p){*this = p;}
  char		modelname[LABELEN+1];
};
/*--------------------------------------------------------------------------*/
class SWITCH_BASE : public ELEMENT {
protected:
	SWITCH_BASE();
	SWITCH_BASE(const SWITCH_BASE& p);
	void	parse_sb(CS&,int);
	void	expand_sb();
public:
	void	print(int,int)const;
	int	dotr();
	void	trload(){trload_passive();}
	void	trunload(){trunload_passive();}
	void	doac();
protected:
  char		inputlabel[LABELEN+1];/* this is here instead of in Cswitch */
  CARD*		input;		      /* due to bad design and lazyness */
  enum	{IPRINTNODES = 2, VPRINTNODES = 4, NUMNODES = 4};
private:
  enum state_t {UNKNOWN, ON, OFF};
  state_t	ic;		/* initial state */
  state_t	current_state;	/* state 1 iter ago (may be bad) */
  state_t	previous_state;	/* state 1 time or step ago (known good) */
};
/*--------------------------------------------------------------------------*/
class DEV_VSWITCH : public SWITCH_BASE {
public:
	DEV_VSWITCH(){}
	DEV_VSWITCH(const DEV_VSWITCH& p):SWITCH_BASE(p){}
	CARD*	clone()const{return new DEV_VSWITCH(*this);}
	void	parse(CS& cmd){parse_sb(cmd,4);}
	void	expand(){expand_sb();}
};
/*--------------------------------------------------------------------------*/
class DEV_CSWITCH : public SWITCH_BASE {
public:
	DEV_CSWITCH(){}
	DEV_CSWITCH(const DEV_CSWITCH& p):SWITCH_BASE(p){}
	CARD*	clone()const{return new DEV_CSWITCH(*this);}
	void	parse(CS& cmd){parse_sb(cmd,2);}
	void	expand();
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
