/*############################################################################*/
/*      LaTeX - LEXICAL ANALIZER                                              */
/*############################################################################*/


%%

\\documentstyle	{ return L_documentstyle;}
\\documentclass	{ return L_documentstyle;}
\{document\}	{ yylval.spec = DOCUMENT; 	return L_document;	}
\\begin		{ return L_begin; 	}
\\end		{ return L_end;   	}

\\appendix	{ return L_appendix;	}
\\box           { return L_box;         }
\\clearpage	{ return L_clearpage;	}
\\maketitle	{ return L_maketitle;	}
\\newpage	{ return L_newpage;	}
\\samepage	{ return L_samepage;	}
\\sloppy	{ return L_sloppy;	}
\\textwidth     { return L_textwidth;   }
\\today		{ return L_today;	}
\\centering     { return L_centering;   }
\\noindent	{ return L_noindent;	}
\\hfill		{ return L_hfill;	}
\\vfill		{ return L_vfill;	}

\\bibliography[ \t]*  	{ return L_bibliography;}
\\bibliographystyle[ \t]* { return L_bibliographystyle;}
\\input[ \t]*		{ return L_input;	}
\\fbox[ \t]*		{ return L_fbox;	}
\\footnote[ \t]*	{ return L_footnote;	}
\\label[ \t]*		{ return L_label;	}
\\linespacing[ \t]*   	{ return L_linespacing; }
\\mbox[ \t]*		{ return L_mbox;	}
\\newsavebox[ \t]*	{ return L_newsavebox;	}
\\pagenumbering[ \t]*	{ return L_pagenumbering;}
\\pagestyle[ \t]*	{ return L_pagestyle;	}
\\ref[ \t]*		{ return L_ref;		}
\\marginpar[ \t]*       { return L_marginpar;   }
\\pageref[ \t]*         { return L_pageref;     }
\\sqrt[ \t]*		{ return L_sqrt;	}
\_			{ return L_subscript;	}
\^			{ return L_superscript;	}
\\usebox[ \t]*		{ return L_usebox;	}
\\hspace[ \t]*		{ return L_hspace;	}
\\hspace\*[ \t]*	{ return L_hspace;	}
\\vspace[ \t]*		{ return L_vspace;	}
\\vspace\*[ \t]*	{ return L_vspace;	}

\\frac[ \t]*		{ return L_frac;	}

\\kill		{ return L_kill;	}
\\hline		{ return L_hline;	}
\\\/		{ return L_smallspace;	}
\\\,		{ return L_thinspace;	}
\\\!		{ return L_negspace;	}
\\\:		{ return L_mediumspace;	}
\\\;		{ return L_thickspace;	}
\\\x20		{ return L_mathspace;	}
\\\=		{ return L_tabset;	}
\\\>		{ return L_tabskip;	}
\\thinlines	{ return L_thinlines;	}
\\thicklines	{ return L_thicklines;	}
\\tableofcontents { return L_tableofcontents;}

\\item[ \t]*		{ return L_item;	}
\\linebreak[ \t]*	{ return L_linebreak;	}
\\nolinebreak[ \t]*	{ return L_nolinebreak;	}
\\pagebreak[ \t]*	{ return L_pagebreak;	}
\\nopagebreak[ \t]*	{ return L_nopagebreak;	}

\\bibitem[ \t]*		{ return L_bibitem;	}
\\cite[ \t]*		{ return L_cite;	}
\\shortstack[ \t]*	{ return L_shortstack;	}
\\caption[ \t]*		{ return L_caption;	}

\\cline[ \t]*		{ return L_cline;	}
\\include[ \t]*		{ return L_include;	}
\\includeonly[ \t]*	{ return L_includeonly;	}
\\circle[ \t]*		{ return L_circle;	}
\\frame[ \t]*		{ return L_frame;	}
\\centerline[ \t]*	{ return L_centerline;	}
\\pmod[ \t]*		{ return L_pmod;	}
\\overline[ \t]*	{ return L_overline;	}
\\vec[ \t]*		{ return L_vec;		}

\\sbox[ \t]*		{ return L_sbox;	}
\\stackrel[ \t]* 	{ return L_stackrel;	}
\\rule[ \t]*            { return L_rule;        }

\\multicolumn[ \t]*	{ return L_multicolumn;	}

\\makebox[ \t]*		{ return L_makebox;	}
\\framebox[ \t]*	{ return L_framebox;	}

\\oval[ \t]*		{ return L_oval;	}

\\line[ \t]*		{ return L_line;	}
\\vector[ \t]*		{ return L_vector;	}
\\put[ \t]*		{ return L_put;		}

\\dashbox[ \t]*		{ return L_dashbox;	}
\\savebox[ \t]*		{ return L_savebox;	}

\\multiput[ \t]*	{ return L_multiput;	}
\\bezier[ \t]*          { return L_bezier;      }

\\alpha[ \t]*		{ yylval.spec = ALPHA;		return L_MathGreek;	}
\\beta[ \t]*		{ yylval.spec = BETA;		return L_MathGreek;	}
\\gamma[ \t]*		{ yylval.spec = GAMMA;		return L_MathGreek;	}
\\delta[ \t]*		{ yylval.spec = DELTA;		return L_MathGreek;	}
\\epsilon[ \t]*	        { yylval.spec = EPSILON;	return L_MathGreek;	}
\\varepsilon[ \t]*	{ yylval.spec = VAREPSILON;	return L_MathGreek;	}
\\zeta[ \t]*		{ yylval.spec = ZETA;		return L_MathGreek;	}
\\eta[ \t]*		{ yylval.spec = ETA;		return L_MathGreek;	}
\\theta[ \t]*		{ yylval.spec = THETA;		return L_MathGreek;	}
\\vartheta[ \t]*	{ yylval.spec = VARTHETA;	return L_MathGreek;	}
\\iota[ \t]*		{ yylval.spec = IOTA;		return L_MathGreek;	}
\\kappa[ \t]*		{ yylval.spec = KAPPA;		return L_MathGreek;	}
\\lambda[ \t]*	        { yylval.spec = LAMBDA;		return L_MathGreek;	}
\\mu[ \t]*		{ yylval.spec = MU;		return L_MathGreek;	}
\\nu[ \t]*		{ yylval.spec = NU;		return L_MathGreek;	}
\\xi[ \t]*		{ yylval.spec = XI;		return L_MathGreek;	}
\\pi[ \t]*		{ yylval.spec = PI;		return L_MathGreek;	}
\\varpi[ \t]*		{ yylval.spec = VARPI;		return L_MathGreek;	}
\\rho[ \t]*		{ yylval.spec = RHO;		return L_MathGreek;	}
\\varrho[ \t]*		{ yylval.spec = VARRHO;		return L_MathGreek;	}
\\sigma[ \t]*		{ yylval.spec = SIGMA;		return L_MathGreek;	}
\\varsigma[ \t]*	{ yylval.spec = VARSIGMA;	return L_MathGreek;	}
\\tau[ \t]*		{ yylval.spec = TAU;		return L_MathGreek;	}
\\upsilon[ \t]*		{ yylval.spec = UPSILON;	return L_MathGreek;	}
\\phi[ \t]*		{ yylval.spec = PHI;		return L_MathGreek;	}
\\varphi[ \t]*		{ yylval.spec = VARPHI;		return L_MathGreek;	}
\\chi[ \t]*		{ yylval.spec = CHI;		return L_MathGreek;	}
\\psi[ \t]*		{ yylval.spec = PSI;		return L_MathGreek;	}
\\omega[ \t]*		{ yylval.spec = OMEGA;		return L_MathGreek;	}
\\Gamma[ \t]*		{ yylval.spec = uGAMMA;		return L_MathGreek;	}
\\Delta[ \t]*		{ yylval.spec = uDELTA;		return L_MathGreek;	}
\\Theta[ \t]*		{ yylval.spec = uTHETA;		return L_MathGreek;	}
\\Lambda[ \t]*		{ yylval.spec = uLAMBDA;	return L_MathGreek;	}
\\Xi[ \t]*		{ yylval.spec = uXI;		return L_MathGreek;	}
\\Pi[ \t]*		{ yylval.spec = uPI;		return L_MathGreek;	}
\\Sigma[ \t]*		{ yylval.spec = uSIGMA;		return L_MathGreek;	}
\\Upsilon[ \t]*		{ yylval.spec = uUPSILON;	return L_MathGreek;	}
\\Phi[ \t]*		{ yylval.spec = uPHI;		return L_MathGreek;	}
\\Psi[ \t]*		{ yylval.spec = uPSI;		return L_MathGreek;	}
\\Omega[ \t]*		{ yylval.spec = uOMEGA;		return L_MathGreek;	}

\\ldots[ \t]*		{ yylval.spec = LDOTS;		return L_MathSymbol;	}
\\vdots[ \t]*		{ yylval.spec = VDOTS;		return L_MathSymbol;	}
\\cdots[ \t]*		{ yylval.spec = CDOTS;		return L_MathSymbol;	}
\\ddots[ \t]*		{ yylval.spec = DDOTS;		return L_MathSymbol;	}

\\pm[ \t]*		{ yylval.spec = PM;		return L_MathSymbol;	}
\\mp[ \t]*		{ yylval.spec = MP;		return L_MathSymbol;	}
\\times[ \t]*		{ yylval.spec = TIMES;		return L_MathSymbol;	}
\\div[ \t]*		{ yylval.spec = DIV;		return L_MathSymbol;	}
\\ast[ \t]*		{ yylval.spec = AST;		return L_MathSymbol;	}
\\star[ \t]*		{ yylval.spec = STAR;		return L_MathSymbol;	}
\\circ[ \t]*		{ yylval.spec = CIRC;		return L_MathSymbol;	}
\\bullet[ \t]*		{ yylval.spec = BULLET;		return L_MathSymbol;	}
\\cdot[ \t]*		{ yylval.spec = CDOT;		return L_MathSymbol;	}
\\cap[ \t]*		{ yylval.spec = CAP;		return L_MathSymbol;	}
\\cup[ \t]*		{ yylval.spec = CUP;		return L_MathSymbol;	}
\\uplus[ \t]*		{ yylval.spec = UPLUS;		return L_MathSymbol;	}
\\sqcap[ \t]*		{ yylval.spec = SQCAP;		return L_MathSymbol;	}
\\sqcup[ \t]*		{ yylval.spec = SQCUP;		return L_MathSymbol;	}
\\vee[ \t]*		{ yylval.spec = VEE;		return L_MathSymbol;	}
\\wedge[ \t]*		{ yylval.spec = WEDGE;		return L_MathSymbol;	}
\\setminus[ \t]*	{ yylval.spec = SETMINUS;	return L_MathSymbol;	}
\\wr[ \t]*		{ yylval.spec = WR;		return L_MathSymbol;	}
\\diamond[ \t]*		{ yylval.spec = DIAMOND;	return L_MathSymbol;	}
\\bigtriangleup[ \t]*	{ yylval.spec = BIGTRIANGLEUP;	return L_MathSymbol;	}
\\bigtriangledown[ \t]* { yylval.spec = BIGTRIANGLEDOWN;return L_MathSymbol;	}
\\triangleleft[ \t]*	{ yylval.spec = TRIANGLELEFT;	return L_MathSymbol;	}
\\triangleright[ \t]*	{ yylval.spec = TRIANGLERIGHT;	return L_MathSymbol;	}
\\lhd[ \t]*		{ yylval.spec = LHD;		return L_MathSymbol;	}
\\rhd[ \t]*		{ yylval.spec = RHD;		return L_MathSymbol;	}
\\unlhd[ \t]*		{ yylval.spec = UNLHD;		return L_MathSymbol;	}
\\unrhd[ \t]*		{ yylval.spec = UNRHD;		return L_MathSymbol;	}
\\oplus[ \t]*		{ yylval.spec = OPLUS;		return L_MathSymbol;	}
\\ominus[ \t]*		{ yylval.spec = OMINUS;		return L_MathSymbol;	}
\\otimes[ \t]*		{ yylval.spec = OTIMES;		return L_MathSymbol;	}
\\oslash[ \t]*		{ yylval.spec = OSLASH;		return L_MathSymbol;	}
\\odot[ \t]*		{ yylval.spec = ODOT;		return L_MathSymbol;	}
\\bigcirc[ \t]*		{ yylval.spec = BIGCIRC;	return L_MathSymbol;	}
\\dagger[ \t]*		{ yylval.spec = DAGGER;		return L_MathSymbol;	}
\\ddagger[ \t]*		{ yylval.spec = DDAGGER;	return L_MathSymbol;	}
\\amalg[ \t]*		{ yylval.spec = AMALG;		return L_MathSymbol;	}

\\leq[ \t]*		{ yylval.spec = LEQ;		return L_MathSymbol;	}
\\preq[ \t]*		{ yylval.spec = PREQ;		return L_MathSymbol;	}
\\preceq[ \t]*		{ yylval.spec = PRECEQ;		return L_MathSymbol;	}
\\ll[ \t]*		{ yylval.spec = LL;		return L_MathSymbol;	}
\\subset[ \t]*		{ yylval.spec = SUBSET;		return L_MathSymbol;	}
\\subseteq[ \t]*	{ yylval.spec = SUBSETEQ;	return L_MathSymbol;	}
\\sqsubset[ \t]*	{ yylval.spec = SQSUBSET;	return L_MathSymbol;	}
\\sqsubseteq[ \t]*	{ yylval.spec = SQSUBSETEQ;	return L_MathSymbol;	}
\\in[ \t]*		{ yylval.spec = IN;		return L_MathSymbol;	}
\\vdash[ \t]*		{ yylval.spec = VDASH;		return L_MathSymbol;	}
\\geq[ \t]*		{ yylval.spec = GEQ;		return L_MathSymbol;	}
\\succ[ \t]*		{ yylval.spec = SUCC;		return L_MathSymbol;	}
\\suceq[ \t]*		{ yylval.spec = SUCEQ;		return L_MathSymbol;	}
\\gg[ \t]*		{ yylval.spec = GG;		return L_MathSymbol;	}
\\supset[ \t]*		{ yylval.spec = SUPSET;		return L_MathSymbol;	}
\\supseteq[ \t]*	{ yylval.spec = SUPSETEQ;	return L_MathSymbol;	}
\\sqsupset[ \t]*	{ yylval.spec = SQSUPSET;	return L_MathSymbol;	}
\\sqsupseteq[ \t]*	{ yylval.spec = SQSUPSETEQ;	return L_MathSymbol;	}
\\ni[ \t]*		{ yylval.spec = NI;		return L_MathSymbol;	}
\\dashv[ \t]*		{ yylval.spec = DASHV;		return L_MathSymbol;	}
\\equiv[ \t]*		{ yylval.spec = EQUIV;		return L_MathSymbol;	}
\\sim[ \t]*		{ yylval.spec = SIM;		return L_MathSymbol;	}
\\simeq[ \t]*		{ yylval.spec = SIMEQ;		return L_MathSymbol;	}
\\asymp[ \t]*		{ yylval.spec = ASYMP;		return L_MathSymbol;	}
\\approx[ \t]*		{ yylval.spec = APPROX;		return L_MathSymbol;	}
\\cong[ \t]*		{ yylval.spec = CONG;		return L_MathSymbol;	}
\\neq[ \t]*		{ yylval.spec = NEQ;		return L_MathSymbol;	}
\\doteq[ \t]*		{ yylval.spec = DOTEQ;		return L_MathSymbol;	}
\\propto[ \t]*		{ yylval.spec = PROPTO;		return L_MathSymbol;	}
\\models[ \t]*		{ yylval.spec = MODELS;		return L_MathSymbol;	}
\\perp[ \t]*		{ yylval.spec = PERP;		return L_MathSymbol;	}
\\mid[ \t]*		{ yylval.spec = MID;		return L_MathSymbol;	}
\\parallel[ \t]*	{ yylval.spec = PARALLEL;	return L_MathSymbol;	}
\\bowtie[ \t]*		{ yylval.spec = BOWTIE;		return L_MathSymbol;	}
\\Join[ \t]*		{ yylval.spec = uJOIN;		return L_MathSymbol;	}
\\smile[ \t]*		{ yylval.spec = SMILE;		return L_MathSymbol;	}
\\frown[ \t]*		{ yylval.spec = FROWN;		return L_MathSymbol;	}

\\leftarrow[ \t]*	{ yylval.spec = LEFTARROW;	return L_MathSymbol;	}
\\Leftarrow[ \t]*	{ yylval.spec = uLEFTARROW;	return L_MathSymbol;	}
\\rightarrow[ \t]*	{ yylval.spec = RIGHTARROW;	return L_MathSymbol;	}
\\Rightarrow[ \t]*	{ yylval.spec = uRIGHTARROW;	return L_MathSymbol;	}
\\lefrighttarrow[ \t]* 	{ yylval.spec = LEFRIGHTTARROW; return L_MathSymbol;	}
\\Lefrighttarrow[ \t]* 	{ yylval.spec = uLEFRIGHTTARROW;return L_MathSymbol;	}
\\longleftarrow[ \t]*	{ yylval.spec = LONGLEFTARROW;	return L_MathSymbol;	}
\\Longleftarrow[ \t]*	{ yylval.spec = uLONGLEFTARROW;	return L_MathSymbol;	}
\\longrightarrow[ \t]* 	{ yylval.spec = LONGRIGHTARROW; return L_MathSymbol;	}
\\Longrightarrow[ \t]* 	{ yylval.spec = uLONGRIGHTARROW;return L_MathSymbol;	}
\\longlefrighttarrow[ \t]* { yylval.spec = LONGLEFRIGHTTARROW;return L_MathSymbol;}
\\Longlefrighttarrow[ \t]* { yylval.spec = uLONGLEFRIGHTTARROW;return L_MathSymbol;}
\\uparrow[ \t]*		{ yylval.spec = UPARROW;	return L_MathSymbol;	}
\\Uparrow[ \t]*		{ yylval.spec = uUPARROW;	return L_MathSymbol;	}
\\downarrow[ \t]*	{ yylval.spec = DOWNARROW;	return L_MathSymbol;	}
\\Downarrow[ \t]*	{ yylval.spec = uDOWNARROW;	return L_MathSymbol;	}
\\updownarrow[ \t]*	{ yylval.spec = UPDOWNARROW;	return L_MathSymbol;	}
\\Updownarrow[ \t]*	{ yylval.spec = uUPDOWNARROW;	return L_MathSymbol;	}
\\nearrow[ \t]*		{ yylval.spec = NEARROW;	return L_MathSymbol;	}
\\searrow[ \t]*		{ yylval.spec = SEARROW;	return L_MathSymbol;	}
\\swarrow[ \t]*		{ yylval.spec = SWARROW;	return L_MathSymbol;	}
\\nwarrow[ \t]*		{ yylval.spec = NWARROW;	return L_MathSymbol;	}

\\mapsto[ \t]*		{ yylval.spec = MAPSTO;		return L_MathSymbol;	}
\\longmapsto[ \t]*	{ yylval.spec = LONGMAPSTO;	return L_MathSymbol;	}
\\leadsto[ \t]*		{ yylval.spec = LEADSTO;	return L_MathSymbol;	}
\\hookleftarrow[ \t]*	{ yylval.spec = HOOKLEFTARROW;	return L_MathSymbol;	}
\\leftharpoonup[ \t]*	{ yylval.spec = LEFTHARPOONUP;	return L_MathSymbol;	}
\\rightharpoonup[ \t]* 	{ yylval.spec = RIGHTHARPOONUP; return L_MathSymbol;	}
\\leftharpoondown[ \t]* { yylval.spec = LEFTHARPOONDOWN;return L_MathSymbol;	}
\\rightharpoondown[ \t]* { yylval.spec = RIGHTHARPOONDOWN;return L_MathSymbol;	}
\\rightleftharpoons[ \t]* { yylval.spec = RIGHTLEFTHARPOONS;return L_MathSymbol;}

\\aleph[ \t]*		{ yylval.spec = ALEPH;		return L_MathSymbol;	}
\\hbar[ \t]*		{ yylval.spec = HBAR;		return L_MathSymbol;	}
\\imath[ \t]*		{ yylval.spec = IMATH;		return L_MathSymbol;	}
\\jmath[ \t]*		{ yylval.spec = JMATH;		return L_MathSymbol;	}
\\ell[ \t]*		{ yylval.spec = ELL;		return L_MathSymbol;	}
\\wp[ \t]*		{ yylval.spec = WP;		return L_MathSymbol;	}
\\Re[ \t]*		{ yylval.spec = uRE;		return L_MathSymbol;	}
\\Im[ \t]*		{ yylval.spec = uIM;		return L_MathSymbol;	}
\\mho[ \t]*		{ yylval.spec = MHO;		return L_MathSymbol;	}
\\prime[ \t]*		{ yylval.spec = PRIME;		return L_MathSymbol;	}
\\emptyset[ \t]*	{ yylval.spec = EMPTYSET;	return L_MathSymbol;	}
\\nabla[ \t]*		{ yylval.spec = NABLA;		return L_MathSymbol;	}
\\surd[ \t]*		{ yylval.spec = SURD;		return L_MathSymbol;	}
\\top[ \t]*		{ yylval.spec = TOP;		return L_MathSymbol;	}
\\bot[ \t]*		{ yylval.spec = BOT;		return L_MathSymbol;	}
\\\|[ \t]*		{ yylval.spec = lOR;		return L_MathSymbol;	}
\\angle[ \t]*		{ yylval.spec = ANGLE;		return L_MathSymbol;	}
\\forall[ \t]*		{ yylval.spec = FORALL;		return L_MathSymbol;	}
\\exists[ \t]*		{ yylval.spec = EXISTS;		return L_MathSymbol;	}
\\neg[ \t]*		{ yylval.spec = NEG;		return L_MathSymbol;	}
\\flat[ \t]*		{ yylval.spec = FLAT;		return L_MathSymbol;	}
\\natural[ \t]*		{ yylval.spec = NATURAL;	return L_MathSymbol;	}
\\sharp[ \t]*		{ yylval.spec = SHARP;		return L_MathSymbol;	}
\\backslash[ \t]*	{ yylval.spec = BACKSLASH;	return L_MathSymbol;	}
\\partial[ \t]*		{ yylval.spec = PARTIAL;	return L_MathSymbol;	}
\\infty[ \t]*		{ yylval.spec = INFTY;		return L_MathSymbol;	}
\\Box[ \t]*		{ yylval.spec = uBOX;		return L_MathSymbol;	}
\\Diamond[ \t]*		{ yylval.spec = uDIAMOND;	return L_MathSymbol;	}
\\triangle[ \t]*	{ yylval.spec = TRIANGLE;	return L_MathSymbol;	}
\\clubsuit[ \t]*	{ yylval.spec = CLUBSUIT;	return L_MathSymbol;	}
\\diamondsuit[ \t]*	{ yylval.spec = DIAMONDSUIT;	return L_MathSymbol;	}
\\heartsuit[ \t]*	{ yylval.spec = HEARTSUIT;	return L_MathSymbol;	}
\\spadesuit[ \t]*	{ yylval.spec = SPADESUIT;	return L_MathSymbol;	}

\\sum[ \t]*		{ yylval.spec = SUM;		return L_MathSymbol;	}
\\prod[ \t]*		{ yylval.spec = PROD;		return L_MathSymbol;	}
\\coprod[ \t]*		{ yylval.spec = COPROD;		return L_MathSymbol;	}
\\int[ \t]*		{ yylval.spec = INT;		return L_MathSymbol;	}
\\oint[ \t]*		{ yylval.spec = OINT;		return L_MathSymbol;	}
\\bigcap[ \t]*		{ yylval.spec = BIGCAP;		return L_MathSymbol;	}
\\bigcup[ \t]*		{ yylval.spec = BIGCUP;		return L_MathSymbol;	}
\\bigsqcup[ \t]*	{ yylval.spec = BIGSQCUP;	return L_MathSymbol;	}
\\bigvee[ \t]*		{ yylval.spec = BIGVEE;		return L_MathSymbol;	}
\\bigwedge[ \t]*	{ yylval.spec = BIGWEDGE;	return L_MathSymbol;	}
\\bigdot[ \t]*		{ yylval.spec = BIGDOT;		return L_MathSymbol;	}
\\bigotimes[ \t]*	{ yylval.spec = BIGOTIMES;	return L_MathSymbol;	}
\\bigoplus[ \t]*	{ yylval.spec = BIGOPLUS;	return L_MathSymbol;	}
\\biguplus[ \t]*	{ yylval.spec = BIGUPLUS;	return L_MathSymbol;	}
\\bmod[ \t]*		{ yylval.spec = BMOD;		return L_MathSymbol;	}
\\arccos[ \t]*		{ yylval.spec = ARCCOS;		return L_MathSymbol;	}
\\arcsin[ \t]*		{ yylval.spec = ARCSIN;		return L_MathSymbol;	}
\\arctan[ \t]*		{ yylval.spec = ARCTAN;		return L_MathSymbol;	}
\\arg[ \t]*		{ yylval.spec = ARG;		return L_MathSymbol;	}
\\cos[ \t]*		{ yylval.spec = COS;		return L_MathSymbol;	}
\\cosh[ \t]*		{ yylval.spec = COSH;		return L_MathSymbol;	}
\\cot[ \t]*		{ yylval.spec = COT;		return L_MathSymbol;	}
\\coth[ \t]*		{ yylval.spec = COTH;		return L_MathSymbol;	}
\\csc[ \t]*		{ yylval.spec = CSC;		return L_MathSymbol;	}
\\deg[ \t]*		{ yylval.spec = DEG;		return L_MathSymbol;	}
\\det[ \t]*		{ yylval.spec = DET;		return L_MathSymbol;	}
\\dim[ \t]*		{ yylval.spec = DIM;		return L_MathSymbol;	}
\\exp[ \t]*		{ yylval.spec = EXP;		return L_MathSymbol;	}
\\gcd[ \t]*		{ yylval.spec = GCD;		return L_MathSymbol;	}
\\hom[ \t]*		{ yylval.spec = HOM;		return L_MathSymbol;	}
\\inf[ \t]*		{ yylval.spec = INF;		return L_MathSymbol;	}
\\ker[ \t]*		{ yylval.spec = KER;		return L_MathSymbol;	}
\\lg[ \t]*		{ yylval.spec = LG;		return L_MathSymbol;	}
\\lim[ \t]*		{ yylval.spec = LIM;		return L_MathSymbol;	}
\\liminf[ \t]*		{ yylval.spec = LIMINF;		return L_MathSymbol;	}
\\limsup[ \t]*		{ yylval.spec = LIMSUP;		return L_MathSymbol;	}
\\ln[ \t]*		{ yylval.spec = LN;		return L_MathSymbol;	}
\\log[ \t]*		{ yylval.spec = LOG;		return L_MathSymbol;	}
\\max[ \t]*		{ yylval.spec = MAX;		return L_MathSymbol;	}
\\min[ \t]*		{ yylval.spec = MIN;		return L_MathSymbol;	}
\\Pr[ \t]*		{ yylval.spec = uPR;		return L_MathSymbol;	}
\\sec[ \t]*		{ yylval.spec = SEC;		return L_MathSymbol;	}
\\sin[ \t]*		{ yylval.spec = SIN;		return L_MathSymbol;	}
\\sinh[ \t]*		{ yylval.spec = SINH;		return L_MathSymbol;	}
\\tan[ \t]*		{ yylval.spec = TAN;		return L_MathSymbol;	}
\\tanh[ \t]*		{ yylval.spec = TANH;		return L_MathSymbol;	}

\\lfloor[ \t]*		{ yylval.spec = LFLOOR;		return L_MathDelim;	}
\\rfloor[ \t]*		{ yylval.spec = RFLOOR;		return L_MathDelim;	}
\\lceil[ \t]*		{ yylval.spec = LCEIL;		return L_MathDelim;	}
\\rceli[ \t]*		{ yylval.spec = RCELI;		return L_MathDelim;	}
\\langle[ \t]*		{ yylval.spec = LANGLE;		return L_MathDelim;	}
\\rangle[ \t]*		{ yylval.spec = RANGLE;		return L_MathDelim;	}
\\\{[ \t]*		{ yylval.spec = LCURLY;		return L_MathDelim;	}
\\\}[ \t]*		{ yylval.spec = RCURLY;		return L_MathDelim;	}

\\part[ \t]*		{ yylval.spec = PART; 		return L_Heading;	}
\\chapter[ \t]*		{ yylval.spec = CHAPTER; 	return L_Heading;	}
\\section[ \t]*		{ yylval.spec = SECTION; 	return L_Heading;	}
\\subsection[ \t]*	{ yylval.spec = SUBSEC; 	return L_Heading;	}
\\subsubsection[ \t]* 	{ yylval.spec = SUBSUB; 	return L_Heading;	}
\\paragraph[ \t]*	{ yylval.spec = PARAGRAPH; 	return L_Heading;	}
\\subparagraph[ \t]*	{ yylval.spec = SUBPARA; 	return L_Heading;	}
\\part\*[ \t]*		{ yylval.spec = PART; 		return L_Heading_star;	}
\\chapter\*[ \t]*	{ yylval.spec = CHAPTER; 	return L_Heading_star;	}
\\section\*[ \t]*	{ yylval.spec = SECTION; 	return L_Heading_star;	}
\\subsection\*[ \t]*	{ yylval.spec = SUBSEC; 	return L_Heading_star;	}
\\subsubsection\*[ \t]* { yylval.spec = SUBSUB; 	return L_Heading_star;	}
\\paragraph\*[ \t]*	{ yylval.spec = PARAGRAPH; 	return L_Heading_star;	}
\\subparagraph\*[ \t]*	{ yylval.spec = SUBPARA; 	return L_Heading_star;	}

\\em[ \t]*		{ yylval.spec = EM; 		return L_FontShape;	}
\\tt[ \t]*		{ yylval.spec = TT; 		return L_FontShape;	}
\\ttfamily[ \t]*       	{ yylval.spec = TT; 		return L_FontShape;	}
\\sc[ \t]*		{ yylval.spec = SC; 		return L_FontShape;	}
\\scshape[ \t]*		{ yylval.spec = SC; 		return L_FontShape;	}
\\sl[ \t]*		{ yylval.spec = SL; 		return L_FontShape;	}
\\slshape[ \t]*		{ yylval.spec = SL; 		return L_FontShape;	}
\\sf[ \t]*		{ yylval.spec = SF; 		return L_FontShape;	}
\\sffamily[ \t]*	{ yylval.spec = SF; 		return L_FontShape;	}
\\bf[ \t]*		{ yylval.spec = BF; 		return L_FontShape;	}
\\bfseries[ \t]*	{ yylval.spec = BF; 		return L_FontShape;	}
\\rm[ \t]*		{ yylval.spec = RM; 		return L_FontShape;	}
\\rmfamily[ \t]*	{ yylval.spec = RM; 		return L_FontShape;	}
\\it[ \t]*		{ yylval.spec = IT; 		return L_FontShape;	}
\\itshape[ \t]*		{ yylval.spec = IT; 		return L_FontShape;	}
\\upshape[ \t]*		{ yylval.spec = UP; 		return L_FontShape;	}
\\mdseries[ \t]*	{ yylval.spec = MD; 		return L_FontShape;	}
\\cal[ \t]*	        { yylval.spec = CAL; 		return L_FontShape;	}

\\tiny[ \t]*		{ yylval.spec = TINY; 		return L_FontSize;	}
\\scriptsize[ \t]*	{ yylval.spec = SCRIPTSIZE; 	return L_FontSize;	}
\\footnotesize[ \t]*	{ yylval.spec = FOOTNOTESIZE; 	return L_FontSize;	}
\\small[ \t]*		{ yylval.spec = SMALL; 		return L_FontSize;	}
\\normalsize[ \t]*	{ yylval.spec = NORMALSIZE; 	return L_FontSize;	}
\\large[ \t]*		{ yylval.spec = LARGE; 		return L_FontSize;	}
\\Large[ \t]*		{ yylval.spec = LARGER; 	return L_FontSize;	}
\\LARGE[ \t]*		{ yylval.spec = LARGEST; 	return L_FontSize;	}
\\huge[ \t]*		{ yylval.spec = HUGE; 		return L_FontSize;	}
\\Huge[ \t]*		{ yylval.spec = HUGER; 		return L_FontSize;	}

\{abstract\}[ \t]*	{ yylval.spec = ABSTRACT; 	return L_Environment;	}
\{array\}[ \t]*	        { yylval.spec = ARRAY; 		return L_Environment;	}
\{center\}[ \t]*	{ yylval.spec = CENTER; 	return L_Environment;	}
\{description\}[ \t]*	{ yylval.spec = DESCRIPTION; 	return L_Environment;	}
\{displaymath\}[ \t]*	{ yylval.spec = DISPLAYMATH; 	return L_Environment;	}
\{enumerate\}[ \t]*	{ yylval.spec = ENUMERATE;	return L_Environment;	}
\{eqnarray\}[ \t]*	{ yylval.spec = EQNARRAY; 	return L_Environment;	}
\{eqnarray\*\}[ \t]*	{ yylval.spec = EQNARRAYs; 	return L_Environment;	}
\{equation\}[ \t]*	{ yylval.spec = EQUATION; 	return L_Environment;	}
\{figure\}[ \t]*	{ yylval.spec = FIGURE; 	return L_Environment;	}
\{flushleft\}[ \t]*	{ yylval.spec = FLUSHLEFT; 	return L_Environment;	}
\{flushright\}[ \t]*	{ yylval.spec = FLUSHRIGHT; 	return L_Environment;	}
\{itemize\}[ \t]*	{ yylval.spec = ITEMIZE; 	return L_Environment;	}
\{list\}[ \t]*	        { yylval.spec = LIST; 		return L_Environment;	}
\{math\}[ \t]*	        { yylval.spec = MATH; 		return L_Environment;	}
\{minipage\}[ \t]*	{ yylval.spec = MINIPAGE; 	return L_Environment;	}
\{picture\}[ \t]*	{ yylval.spec = PICTURE; 	return L_Environment;	}
\{quotation\}[ \t]*	{ yylval.spec = QUOTATION; 	return L_Environment;	}
\{quote\}[ \t]*	        { yylval.spec = QUOTE; 		return L_Environment;	}
\{sloppypar\}[ \t]*	{ yylval.spec = SLOPPYPAR; 	return L_Environment;	}
\{tabbing\}[ \t]*	{ yylval.spec = TABBING; 	return L_Environment;	}
\{table\}[ \t]*	        { yylval.spec = TABLE; 		return L_Environment;	}
\{tabular\}[ \t]*	{ yylval.spec = TABULAR; 	return L_Environment;	}
\{thebibliography\}[ \t]* { yylval.spec = THEBIBLIOGRAPHY; return L_Environment;}
\{theindex\}[ \t]*	{ yylval.spec = THEINDEX; 	return L_Environment;	}
\{titlepage\}[ \t]*	{ yylval.spec = TITLEPAGE; 	return L_Environment;	}
\{trivlist\}[ \t]*	{ yylval.spec = TRIVLIST; 	return L_Environment;	}
\{verbatin\}[ \t]*	{ yylval.spec = VERBATIN; 	return L_Environment;	}
\{verse\}[ \t]*	        { yylval.spec = VERSE; 		return L_Environment;	}

\{article\}	{ yylval.spec = ARTICLE;	return L_DocStyle;	}
\{book\}	{ yylval.spec = BOOK; 		return L_DocStyle;	}
\{report\}	{ yylval.spec = REPORT; 	return L_DocStyle;	}
\{letter\}	{ yylval.spec = LETTER; 	return L_DocStyle;	}

\\\[		{ yylval.spec = (int)yytext[1];	return L_mathbegin;	}
\\\]		{ yylval.spec = (int)yytext[1];	return L_mathend;	}
\\\(		{ yylval.spec = (int)yytext[1];	return L_mathbegin;	}
\\\)		{ yylval.spec = (int)yytext[1];	return L_mathend;	}

\\\'		{ yylval.spec = (int)yytext[1];	return L_accent;	}
\\\`		{ yylval.spec = (int)yytext[1];	return L_accent;	}
\\\^		{ yylval.spec = (int)yytext[1];	return L_accent;	}
\\\~		{ yylval.spec = (int)yytext[1];	return L_accent;	}
\\\"		{ yylval.spec = (int)yytext[1];	return L_accent;	}
\\\.		{ yylval.spec = (int)yytext[1];	return L_accent;	}
\\c		{ yylval.spec = (int)yytext[1];	return L_accent;	}
\\d		{ yylval.spec = (int)yytext[1];	return L_accent;	}
\\b		{ yylval.spec = (int)yytext[1];	return L_accent;	}
\\v		{ yylval.spec = (int)yytext[1];	return L_accent;	}
\\H		{ yylval.spec = (int)yytext[1];	return L_accent;	}
\\t		{ yylval.spec = (int)yytext[1];	return L_accent;	}
\\u		{ yylval.spec = (int)yytext[1];	return L_accent;	}

\\S		{ yylval.spec = (int)yytext[1];	return L_LatexMisc;	}
\\P		{ yylval.spec = (int)yytext[1];	return L_LatexMisc;	}
\\copyright	{ yylval.spec = (int)yytext[1];	return L_LatexMisc;	}
\\pounds	{ yylval.spec = (int)yytext[1];	return L_LatexMisc;	}
\\\-		{ yylval.spec = (int)yytext[1];	return L_LatexMisc;	}
\\\%		{ yylval.spec = (int)yytext[1];	return L_LatexMisc;	}
\\\#		{ yylval.spec = (int)yytext[1];	return L_LatexMisc;	}
\\\$		{ yylval.spec = (int)yytext[1];	return L_LatexMisc;	}
\\\&		{ yylval.spec = (int)yytext[1];	return L_LatexMisc;	}

\(		{ return L_lparen;	}
\)		{ return L_rparen;	}
\[		{ return L_lbracket;	}
\]		{ return L_rbracket;	}
\{		{ return L_lcurly;	}
\}		{ return L_rcurly;	}
\+		{ return L_plus;	}
\/		{ return L_div;		}
\=		{ return L_equal;	}
\<		{ return L_less;	}
\>		{ return L_more;	}
\~		{ return L_tilde;	}
\$		{ return L_dollar;	}
\&		{ return L_amper;	}
\\\\		{ return L_newline;	}
\\		{ return L_backslash;	}
[ \t]+		{ yylval.spec = (int)yytext[0];	return L_space;		}

\%.*\n	        { /* skip comments */ linecounter++;	}
[a-zA-Z0-9\@\|\,\.\-\;\:\`\'\"\?]+    { StoreString(); return L_word;}
\n[ \t]*	{ linecounter++; return L_linefeed;	}
.               { fprintf(stderr, "Scanner: Symbols '%s' on line %d was deleted.\n", yytext, linecounter);
		  errorcounter ++; 	}

%%


/*===========================================================================*/
/*      Storage area for constants and identifier names                       */
/*===========================================================================*/

#define         SIZE_OF_BUFFER    256000
char            ConstantBuffer [SIZE_OF_BUFFER];
char            *BufferPtr = ConstantBuffer;
char            *BufferEnd = ConstantBuffer + SIZE_OF_BUFFER;

/*===========================================================================*/
/*      StoreString - Saves string read by scanner                           */
/*===========================================================================*/

int             StoreString (void)
{
    char   *s = yytext;

    yylval.ptr = BufferPtr;
    while (*BufferPtr++ = *s++)
        ;
    *BufferPtr++ = '\0';
    if (BufferPtr > BufferEnd)
    {
        fprintf (stderr, "LaTeX lexical analyzer: CONSTANT BUFFER OVERFLOW\n\n");
        exit (1);
    }
}

/*===========================================================================*/
/*      Source input routines                                                */
/*===========================================================================*/

int             yywrap ()
{
    return 1;
}
