	{ Ce schema decrit la structure d'une reference bibliographique,
	selon la structure BibTeX.

	V. Quint	Janvier 1987	}

STRUCTURE RefBib;

DEFPRES RefBibP;

STRUCT

  RefBib = CASE OF  

	Article = BEGIN		{ un article d'un journal ou d'un magazine }
		Ident = TEXT;
		Note = TEXT;
		Auteurs = LIST OF (Auteur = TEXT);
		Titre_Article = LIST OF (Unit\351);
		Titre_Journal = TEXT;
		Volume = TEXT;
		Num\351ro = TEXT;
		Pages = TEXT;
		Mois = TEXT;
		Ann\351e = TEXT;
		END;

	Livre = BEGIN		{ un livre publie' par un editeur }
		Ident;
		Note;
		Auteurs;
		Titre_Livre = LIST OF (Unit\351);
		Volume;
		Publi\351_par = TEXT;
		Adresse = TEXT;
		Mois;
		Ann\351e;
		END;

	Conf\351rence = BEGIN {Un article paru dans les actes d'une conference}
		Ident;
		Note;
		Auteurs;
		Titre_Article;
		Titre_Livre;
		Edit\351_par = TEXT;
		Pages;
		Publi\351_par;
		Adresse;
		Mois;
		Ann\351e;
		END;

	Manuel = BEGIN	{ Une documentation technique }
		Ident;
		Note;
		Auteurs;
		Titre = LIST OF (Unit\351);
		Organisation = TEXT;
		Adresse;
		Mois;
		Ann\351e;
		END;

	Rapport = BEGIN	{ Un rapport publie' par un laboratoire }
		Ident;
		Note;
		Auteurs;
		Titre;
		Num\351ro;
		Institution = TEXT;
		Adresse;
		Mois;
		Ann\351e;
		END;

	Th\350se = BEGIN	{ Une these }
		Ident;
		Note;
		Auteurs;
		Titre;
		Type_th\350se = TEXT;
		Universit\351 = TEXT;
		Mois;
		Ann\351e;
		END;

	END;

	Unit\351 = UNIT;

	Tout_titre = CASE OF
		Titre;
		Titre_Article;
		Titre_Livre;
		END;
UNITS
   Indice = TEXT;
   Exposant = TEXT;

EXPORT
   RefBib;

EXCEPT

   RefBib:		MoveResize;
   Article:		MoveResize;
   Ident:		MoveResize;
   Note:		MoveResize;
   Auteurs:		MoveResize;
   Auteur:		MoveResize;
   Titre_Article:	MoveResize;
   Titre_Journal:	MoveResize;
   Volume:		MoveResize;
   Num\351ro:		MoveResize;
   Pages:		MoveResize;
   Mois:		MoveResize;
   Ann\351e:		MoveResize;
   Livre:		MoveResize;
   Titre_Livre:		MoveResize;
   Publi\351_par:	MoveResize;
   Adresse:		MoveResize;
   Conf\351rence:	MoveResize;
   Edit\351_par:	MoveResize;
   Manuel:		MoveResize;
   Titre:		MoveResize;
   Organisation:	MoveResize;
   Rapport:		MoveResize;
   Institution:		MoveResize;
   Th\350se:		MoveResize;
   Type_th\350se:	MoveResize;
   Universit\351:	MoveResize;
   Unit\351:		MoveResize;
   Tout_titre:		MoveResize;


END
