	{ Ce schema donne les regles pour la traduction d'un Rapport Thot 
          en LaTeX2.09

	  V. Quint	Juillet 1995
          revision 	J. Andre janvier 1996	}

TRANSLATION Rapport;

LINELENGTH 78;

BUFFERS
   NomImage(Picture);

COUNTERS
   CptAnnexe: Set 1 on Rapport Add 1 on Annexe;
   CptAuteur: Set 1 on Rapport  Add 1 on Affiliation;
   CptBiblio: Rank of Citation_biblio;
   CptFigure: Set 0 on Rapport  Add 1 on Figure;
   CptFormule: Set 0 on Rapport  Add 1 on Formule_num\351rot\351e;
   CptSect1: Rank of Section 1;
   CptSect2: Rank of Section 2;
   CptSect3: Rank of Section 3;
   CptSect4: Rank of Section 4;
   CptAnnx1: Rank of Section 1;

CONST
   CFermeNL = '}\12';
   Clabel   = '\label{';
   Cref     = '\ref{';

VAR
   VarAnnexe :  Value(CptAnnexe,Uppercase);
   VarAnx    : 'anx' Value(CptAnnexe,Uppercase);
   VarAuteur : Value(CptAuteur, lowercase);
   VarSect1 : 'secta' Value(CptSect1) ;
   VarSect2 : 'sectb' Value(CptSect1) Value(CptSect2) ;
   VarSect3 : 'sectc' Value(CptSect1) Value(CptSect2)
	      Value(CptSect3) ;
   VarSect4 : 'sectd' Value(CptSect1) Value(CptSect2) Value(CptSect3)
		Value(CptSect4) ;
   VarFormule : 'math' Value(CptFormule) ;
   VarBiblio : '{bib' Value(CptBiblio) '}';
   VarFigure : 'fig' Value(CptFigure)'' ;

RULES

   Rapport :
	BEGIN
	Use ParagraphT for Paragraphe;
	Use RefBibT for RefBib;
	Use DrawT1 for Draw;
	Use Draw2T for Draw2;
	Use TableT for Table;
	Use ArbreT for Arbre;
	Use Arbre2T for Arbre2;
        Create '%Rapport-Thot to LaTeX2.09/7bits - 9 janvier 1996 - version beta-test';
        Create '\12% En cas d anomalie, envoyer un mail a jandre@irisa.fr\12';
	Create '\documentstyle[times,twoside,11pt]{article}\12';
	Create '\ifx\defined\maketitle\maketitle\else\fi\12';
	Create '\newlength{\thotwidth}\12';	{ pour ParagraphT.SCH }
        Create '\input{psfig}\12'; { pour l'input de PostScript }
	Create '%\renewcommand{\psfig}[1]{\mbox{#1}}\12'; {sans appel a fig}
	Create '\title{}\author{}\date{\empty}\12';
        Create '\begin{document}\12';
	Create '\12%\newpage\12%\tableofcontents\12\end{document}\12' After;
	END;

   Entete:
	BEGIN
	Create '\12\maketitle\12' After;
	END;

   Auteurs_courants:
        BEGIN
	Create '\12\markboth{' Before;
        Create '}' After;
        END;

   Titre_courant:
	BEGIN
        Get Auteurs_courants Before;
        Create '{' Before;
        Create '}\pagestyle{myheadings}\12\thispagestyle{empty}\12' After;
	END;

   R\351f\351rence:
        BEGIN
        Create '\12\def\thefootnote{\fnsymbol{footnote}}\12';
        Create '\12\footnotetext[7]{' Before;              
        Create '}\12\def\thefootnote{\arabic{footnote}}\12' After ; 
        END;

   Statut:
        BEGIN
        Create '\12\def\thefootnote{\fnsymbol{footnote}}\12';
        Create '\12\footnotetext[7]{' Before;
        Create '}\12\def\thefootnote{\arabic{footnote}}\12' After ;
        END;
 
   Date_de_mise_a_jour :
	BEGIN
	Create '\12\date{' Before;
	Create '}\12' After;
	END;

   Titre :
	BEGIN
	Create '\12\title{' Before;
	Create '}\12' After;
	END;

   Auteurs:
	BEGIN
	END;

   Auteur :
	BEGIN
	IF First Create '\author{';
	IF NOT First Create ' \and ';
	IF Last Create '}\12\maketitle\12' After;
	END;

   Affiliations :
        IF Not Empty
	BEGIN
	Create '\begin{center}\begin{tabular}{rl}\12';
	Create '\end{tabular}\end{center}\12' After;
	END;

   Affiliation :
	BEGIN
        IF Referred AND Not Empty
       	   BEGIN
		Create VarAuteur;
		Create ' ';
	   END;
	IF Not Empty Create '&';
	IF Not Empty Create '\\\\\12' After;
	END;

   Ref_affiliation:
	BEGIN
	Create '$^{';
	Create Referred VarAuteur;
	Create '}$';
	END;

   R\351sum\351 :
        BEGIN
	Create '\maketitle\12';
        IF Not Empty
        BEGIN
        Create '%\begin{resume}\12\begin{abstract}\12';
        Create '\end{abstract}\12%\end{resume}\12' After;
        END;
        END;

   Mots_cl\351s :
	BEGIN
        Create '\maketitle\12';
	IF Not Empty
	BEGIN
	Create '\12%\begin{motsclef}\12{\bf Keywords:}\12 ';
	Create '%\end{motsclef}\12' After;
	END;
	END;

   Heading:
	BEGIN
	END;

   Title:
	BEGIN
	{*******}
	END;

   Abstract : 
	BEGIN
        Create '\maketitle\12';
        IF Not Empty
	BEGIN
	Create '\begin{abstract}\12';
	Create '\end{abstract}\12' After;
	END;
	END;

   Keywords :
        BEGIN
        Create '\maketitle\12';
	IF Not Empty
	BEGIN
	Create '\12%\begin{keywords}\12{\bf Keywords:}\12 ';
        Create '%\end{keywords}\12' After;
	END;
	END;

   Corps:
	BEGIN
        Create '\maketitle\12';
        Create '\bigskip\12';   
	END;

   Pr\351ambule:
	BEGIN
	END;

   Suite_sections:
	BEGIN
	END;

   Partie_finale:
	BEGIN
	Create '\maketitle\12';
	END;

   Sections_finales:
	BEGIN
	END;

   Section:
	BEGIN
	END;

   Titre_section :
	BEGIN
	IF NOT WITHIN Annexe
	 and within Partie_finale 
	   Create '\12\section*{';
	IF  NOT WITHIN Annexe and NOT within Sections_finales and within 1 Section
	   Create '\12\section{';
	IF  NOT WITHIN Annexe and within 2 Section
	   Create '\12\subsection{';
	IF  NOT WITHIN Annexe and within 3 Section
	   Create '\12\subsubsection{';
	IF  NOT WITHIN Annexe and within >3 Section
	   Create '\12\paragraph{';
        IF within Annexe and within 1 Section
           Create '\12\subsection{'; {A.1=subsection}
        IF within Annexe and within 2 Section
           Create '\12\subsubsection{';
        IF within Annexe and within >2 Section
           Create '\12\paragraph{';
        Create CFermeNL After;
	IF Referred
	   Create Clabel After;
	IF Referred and within 1 Section
	   Create VarSect1 After;
	IF Referred and within 2 Section
	   Create VarSect2 After;
	IF Referred and within 3 Section
	   Create VarSect3 After;
	IF Referred and within 4 Section
	   Create VarSect4 After;
        IF Referred
           Create CFermeNL After; {a cause absence numeros qd >4 Section }
	END;

   Ref_section :
	BEGIN
	Create Cref;
	If target within 0 Section create referred VarSect1;
	If target within 1 Section create referred VarSect2;
	If target within 2 Section create referred VarSect3;
	If target within >2 Section create referred VarSect4;
	Create '}';
	END;

   Suite_paragraphes:
	BEGIN
	END;

   Groupe_titr\351:
	BEGIN
	END;

   Titre_groupe:
	BEGIN
	Create '\12\paragraph{';
	Create '}\12' after;
	END;

   Ref_groupe_titr\351:
	BEGIN
	{********}
	END;

   Groupe:
	BEGIN
	END;

   Image :
	BEGIN
	END;

   Formule_num\351rot\351e :
	BEGIN
	Create '\12\begin{equation}\12';
	IF Referred 
	   BEGIN
	   Create '\12' After;
	   Create Clabel After;
	   Create VarFormule After;
	   Create '}' After;
	   END;
	Create '\12\end{equation}\12' After;
	END;

   Ref_formule :
	BEGIN
	Create Cref;
	Create Referred VarFormule;
        Create '}';       
	END;

   Math :
	BEGIN
	Use MathT;
	IF NOT Within Formule_num\351rot\351e AND NOT Within Math
	   AND NOT Within Pr\351ambule AND NOT Within Suite_paragraphes
	   BEGIN
	   Create '$' Before;
	   Create '$' After;
	   END;
	IF immediately within Pr\351ambule AND NOT within Suite_paragraphes
	   BEGIN
           Create '\begin{displaymath}\12' Before;
           Create '\12\end{displaymath}\12' After;
	   END;
	IF immediately within Suite_paragraphes
	   BEGIN
           Create '\begin{displaymath}\12' Before;
           Create '\12\end{displaymath}\12' After;
	   END;
	END;

   Figure :
	BEGIN
	Create '\12\begin{figure}\12' before;
	Create '\12\end{figure}\12' after;
	END;

   Illustration :
	BEGIN
	END;

   Image\240:
	BEGIN
	END;

   L\351gende_figure :
	BEGIN
	Create '\12\caption{';
	Create CFermeNL after;
	IF Referred 
	   BEGIN
	   Create Clabel After;
	   Create VarFigure After;
	   Create '}' After;
	   END;
	END;

   Ref_figure :
	BEGIN
	Create 'Fig.~\ref{';
	Create Referred VarFigure;
	Create '}';
	END;

   Note :
	BEGIN
	END;

   Ref_note :
	BEGIN
	Create '}' After;
	If not within Auteurs
	   BEGIN
	Create '\footnote{';
	   Get Referred Note;
	   END;
	If within Auteurs
	   BEGIN
	   Create '\thanks{';
	   Get Referred Note;
	   END;
	END;

   Indice :
	BEGIN
	Create '$_{';
	Create '}$' After;
	END;

   Exposant :
	BEGIN
	Create '$^{';
	Create '}$' After;
	END;

   Annexes:
	BEGIN
        Create '\appendix\12'; 
	END;

   Annexe :
	BEGIN
	END;

   Ref_annexe:
	BEGIN
         Create 'ANNEXE~';
	Create Cref;
        Create referred VarAnx;
        Create '}';
        END;

   Titre_annexe:
	BEGIN
	Create '\12\section{';
	 Create CFermeNL After;
        IF Referred
	   BEGIN
           Create Clabel After;
	   Create VarAnx After;
	   Create '}' After;
	   END;
	END;

   Titre_courant_annexe:
	BEGIN
	Create '\12\markright{';
	Create '}\12' After;
	END;

   Bibliographie :
	BEGIN
	Create '\12\begin{thebibliography}{99}\12';
	Create '\end{thebibliography}\12' After;
	END;

   Citation_biblio :
	BEGIN
	Create '\12\bibitem';
	Create VarBiblio;
	Create '\12' after;
	END;

   Ref_biblio :
	BEGIN
	Create '\cite';
	Create Referred VarBiblio;
	END;

   GRAPHICS_UNIT :
	BEGIN
	Create '\begin{picture}(50,50)\12\put(0,0){\framebox(50,50){ }}\12\end{picture}';
	Remove;
	END;

   PICTURE_UNIT :
	BEGIN
	Create '\centerline{\psfig{figure=';
	Create NomImage After;
	Create '}}' After;
	END;

ATTRIBUTES

   Importance = D\351finition :
	BEGIN
	Create '{\it ';
	Create '}' After;	
	END;

   Importance = Important :
	BEGIN
	Create '{\bf ';
	Create '}' After;	
	END;

   Num\351ro_prem_page:
        BEGIN
        Create '\setcounter{page}{';
        Create Num\351ro_prem_page;
        Create '}\12';
        END;

   Num\351ro_prem_section:
	BEGIN
        Create '\setcounter{section}{';
        Create Num\351ro_prem_section;   
	END;

   Type_auteur = Auteur_principal:
	BEGIN
	{******}
	END;

   Type_auteur = Auteur_secondaire:
	BEGIN
	{******}
	END;

PRESENTATION

   Style = Bold:
	BEGIN
	Create '{\bf ';
	Create '}' After;	
	END;

   Style = Italics:
	BEGIN
	Create '{\it ';
	Create '}' After;	
	END;

   Font = Helvetica:
	BEGIN
	Create '{\sf ';
	Create '}' After;	
	END;

   Font = Courier:
	BEGIN
	Create '{\tt ';
	Create '}' After;	
	END;

 Adjust = Left :
        BEGIN
        Create '\begin{flushleft}\12';
        Create '\end{flushleft}\12' after;
        END;
 
   UnderLine = UnderLine :
        BEGIN
        Create '\underline{ ';
        create '}' after;
        END;

  UnderLine = OverLine :
        BEGIN
        Create '$\overline{\rm ';
        create '}$' after;
        END;

{ UnderLine = StrikeOut :
        BEGIN
        Create xxx
        create  xxx after;
        END; }
 
   Background :
        BEGIN
         {******}
        END;
 
   Foreground :
        BEGIN
          {******}
        END;


TextTRANSLATE	Latin
	BEGIN
        '\133' -> '{[}'; { a cause possibilite de \\[ }
	'\212' -> '\mbox{}\\\\\12';
	'\230' -> '$\div$';
	'\231' -> '$\times$';
	'\240' -> '~';
	'\241' -> '!`';
	'\242' -> 'c';
	'\243' -> '\pounds';
	'\244' -> 'o';            
	'\245' -> 'Y';         
	'\246' -> '$|$';
	'\247' -> '\S';
        '\250' -> '"';                 
	'\251' -> '\copyright';
	'\252' -> '$^a$';             
	'\253' -> '\symbol{171}';
	'\254' -> '$\neg$';
	'\255' -> '-';
	'\256' -> '$^R$';
	'\257' -> '$^-$';
     '\260' -> '$^o$'  ; 
	'\261' -> '$\pm$';
	'\262' -> '$^2$';
	'\263' -> '$^3$';
	'\264' -> '''';
	'\265' -> '$\mu$';
	'\266' -> '$\P$';
	'\267' -> '$\cdot$';
	'\271' -> '$^1$';
	'\273' -> '\symbol{187}';
	'\274' -> '$1/4$';
	'\275' -> '$1/2$';
	'\276' -> '$3/4$';
	'\277' -> '?`';
	'\300' -> '\`{A}';     
	'\301' -> '\''{A}'; 
	'\302' -> '\^{A}'; 
	'\303' -> '\~{A}'; 
	'\304' -> '\"{A}'; 
	'\305' -> '\AA'; 
	'\306' -> '\AE'; 
	'\307' -> '\c{C}'; 
	'\310' -> '\`{E}'; 
	'\311' -> '\''{E}'; 
	'\312' -> '\^{E}'; 
	'\313' -> '\"{E}'; 
	'\314' -> '\`{I}'; 
	'\315' -> '\''{I}'; 
	'\316' -> '\^{I}'; 
	'\317' -> '\"{I}'; 
	'\320' -> 'D'; 
	'\321' -> '\~{N}'; 
	'\322' -> '\`{O}'; 
	'\323' -> '\''{O}'; 
	'\324' -> '\^{O}'; 
	'\325' -> '\~{O}'; 
	'\326' -> '\"{O}'; 
	'\327' -> '\OE'; 
	'\330' -> '\O'; 
	'\331' -> '\`{U}'; 
	'\332' -> '\''{U}'; 
	'\333' -> '\^{U}'; 
	'\334' -> '\"{U}'; 
	'\335' -> '\''{Y}'; 
	'\336' -> 'p'; 
	'\337' -> '\ss'; 
	'\340' -> '\`{a}'; 
	'\341' -> '\''{a}'; 
	'\342' -> '\^{a}'; 
	'\343' -> '\~{a}'; 
	'\344' -> '\"{a}'; 
	'\345' -> '\aa'; 
	'\346' -> '\ae '; 
	'\347' -> '\c{c}'; 
	'\350' -> '\`{e}'; 
	'\351' -> '\''{e}'; 
	'\352' -> '\^{e}'; 
	'\353' -> '\"{e}'; 
	'\354' -> '\`{\i}'; 
	'\355' -> '\''{\i}'; 
	'\356' -> '\^{\i}'; 
	'\357' -> '\"{\i}'; 
	'\360' -> '$\partial$'; 
	'\361' -> '\~{n}'; 
	'\362' -> '\`{o}'; 
	'\363' -> '\''{o}'; 
	'\364' -> '\^{o}'; 
	'\365' -> '\~{o}'; 
	'\366' -> '\"{o}'; 
	'\367' -> '\oe ';
	'\370' -> '\o'; 
	'\371' -> '\`{u}'; 
	'\372' -> '\''{u}'; 
	'\373' -> '\^{u}'; 
	'\374' - > '\"{u}'; 
	'\375' - > '\''{y}'; 
	'\376' - > 'P'; 
	'\377' - > '\"{y}'; 
	' ;'  -> '~;';
	' :'  -> '~:';
	'#'   -> '\#';
	'$'   -> '\$';
	'%'   -> '\%';
	'&'   -> '\&';
	'<'   -> '$<$';
	'>'   -> '$>$';
	'@'   -> '\symbol{''100}';
	'\'   -> '\symbol{''134}';
	'^'   -> '\symbol{''136}';
	'_'   -> '\_';
	'{'   -> '\{';
	'|'   -> '$|$';
	'}'   -> '\}';
	'~'   -> '\symbol{''176}';
	'TeX' -> '\TeX ';
	'TeX ' -> '\TeX\ ';
	'LaTeX' -> '\LaTeX ';
	'LaTeX ' -> '\LaTeX\ ';
	'LaTeX2e' -> '\LaTeXe ';
        'LaTeX2e ' -> '\LaTeXe\ ';
END;

TextTRANSLATE	Grec
	BEGIN
	'"' -> '$\forall$';
	'#' -> '\#';
	'$' -> '$\exists$';
	'%' -> '\%';
	'&' -> '\&';
	'''' -> '$\ni$';
	'-' -> '$-$';
	'<' -> '$<$';
	'>' -> '$>$';
	'@' -> '$\cong$';
	'C' -> 'X';
	'D' -> '$\Delta$';
	'F' -> '$\Phi$';
	'G' -> '$\Gamma$';
	'J' -> '$\vartheta$';
	'L' -> '$\Lambda$';
	'P' -> '$\Pi$';
	'Q' -> '$\Theta$';
	'R' -> 'P';
	'S' -> '$\Sigma$';
	'U' -> 'Y';
	'V' -> '$\varsigma$';
	'W' -> '$\Omega$';
	'X' -> '$\Xi$';
	'Y' -> '$\Psi$';
	'\' -> '$\bigtriangleup$';
	'^' -> '$\bot$';
	'_' -> '\_';
	'`' -> '';
	'a' -> '$\alpha$';
	'b' -> '$\beta$';
	'c' -> '$\chi$';
	'd' -> '$\delta$';
	'e' -> '$\varepsilon$';
	'f' -> '$\phi$';
	'g' -> '$\gamma$';
	'h' -> '$\eta$';
	'i' -> '$\iota$';
	'j' -> '$\varphi$';
	'k' -> '$\kappa$';
	'l' -> '$\lambda$';
	'm' -> '$\mu$';
	'n' -> '$\nu$';
	'p' -> '$\pi$';
	'q' -> '$\theta$';
	'r' -> '$\rho$';
	's' -> '$\sigma$';
	't' -> '$\tau$';
	'u' -> '$\upsilon$';
	'v' -> '$\varpi$';
	'w' -> '$\omega$';
	'x' -> '$\xi$';
	'y' -> '$\psi$';
	'z' -> '$\zeta$';
	'{'   -> '\{';
	'|'   -> '$|$';
	'}'   -> '\}';
	'~'   -> '\symbol{''176}';
	'\241' -> '$\Upsilon$';
	'\242' -> '$\prime$';
	'\243' -> '$\leq$';
	'\244' -> '/';
	'\245' -> '$\infty$';
	'\246' -> '$\int$';
	'\247' -> '$\clubsuit$';
	'\250' -> '$\diamondsuit$';
	'\251' -> '$\heartsuit$';
	'\252' -> '$\spadesuit$';
	'\253' -> '$\leftrightarrow$';
	'\254' -> '$\leftarrow$';
	'\255' -> '$\uparrow$';
	'\256' -> '$\rightarrow$';
	'\257' -> '$\downarrow$';
	'\260' -> '$^o$';
	'\261' -> '$\pm$';
	'\262' -> '$\prime\prime$';
	'\263' -> '$\geq$';
	'\264' -> '$\times$';
	'\265' -> '$\propto$';
	'\266' -> '$\partial$';
	'\267' -> '$\bullet$';
	'\270' -> '$\div$';
	'\271' -> '$\neq$';
	'\272' -> '$\equiv$';
	'\273' -> '$\approx$';
	'\274' -> '...';
	'\275' -> '$\mid$';
	'\276' -> '$-$';
	'\277' -> '$\hookleftarrow$';
	'\300' -> '$\aleph$';
	'\301' -> '$\Im$';
	'\302' -> '$\Re$';
	'\303' -> '$\wp$';
	'\304' -> '$\otimes$';
	'\305' -> '$\oplus$';
	'\306' -> '$\emptyset$';
	'\307' -> '$\cap$';
	'\310' -> '$\cup$';
	'\311' -> '$\supset$';
	'\312' -> '$\supseteq$';
	'\313' -> '$\not\subset$';
	'\314' -> '$\subset$';
	'\315' -> '$\subseteq$';
	'\316' -> '$\in$';
	'\317' -> '$\not\in$';
	'\320' -> '$\angle$';
	'\321' -> '$\nabla$';
	'\322' -> '$^R$';
	'\323' -> '$\copyright$';
	'\324' -> '$^{TM}$';
	'\325' -> '$\prod$';
	'\326' -> '$\surd$';
	'\327' -> '$\cdot$';
	'\330' -> '$\neg$';
	'\331' -> '$\vee$';
	'\332' -> '$\wedge$';
	'\333' -> '$\Leftrightarrow$';
	'\334' -> '$\Leftarrow$';
	'\335' -> '$\Uparrow$';
	'\336' -> '$\Rightarrow$';
	'\337' -> '$\Downarrow$';
	'\340' -> '$\Diamond$';
	'\341' -> '$<$';
	'\342' -> '$^R$';
	'\343' -> '$\copyright$';
	'\344' -> '$^{TM}$';
	'\345' -> '$\sum$';
	'\361' -> '$>$';
	'\362' -> '$\int$';
	END;

SYMBTRANSLATE
	begin
	'i' -> '$\int$';
	'd' -> '$\int\int$';
	'c' -> '$\oint$';
	'r' -> '$\surd$';
	'S' -> '$\sum$';
	'P' -> '$\prod$';
	'U' -> '$\bigcup$';
	'I' -> '$\bigcap$';
	'>' -> '$\rightarrow$';
	'<' -> '$\leftarrow$';
	'^' -> '$\uparrow$';
	'V' -> '$\downarrow$';
	'h' -> '-';
	'v' -> '|';
	'{' -> '\{';
	'}' -> '\}';
	END;

GRAPHTRANSLATE
	BEGIN
	'R' -> '$\Box$';
	'C' -> '$\Box$';
	'c' -> '$\bigcirc$';
	'L' -> '$\Diamond$';
	'h' -> '-';
	't' -> '-';
	'b' -> '-';
	'l' -> '|';
	'r' -> '|';
	'v' -> '|';
	'/' -> '/';
	'\' -> '$\backslash$';
	'>' -> '$\rightarrow$';
	'<' -> '$\leftarrow$';
	'^' -> '$\uparrow$';
	'V' -> '$\downarrow$';
	'O' -> '$\nwarrow$';
	'e' -> '$\searrow$';
	'E' -> '$\nearrow$';
	'o' -> '$\swarrow$';
	END;
END
