#define ONESTEP 1 pt
#define TWOSTEP 2 pt
#define THREESTEP 3 pt
#define SIXSTEP 6 pt
#define SEVENSTEP 7 pt
#define TableSimpleHSpace 0.5
#define TableDoubleHSpace 1
#define TableSimpleVSpace 0.4

PRESENTATION Math;

VIEWS
	Main_view;

CONST
   Blanc = TEXT '';

DEFAULT

   BEGIN
	Visibility: Enclosing = ;
	VertRef: * . Left ;
	HorizRef: Enclosed . HRef ;
	Height: Enclosed . Height;
	Width: Enclosed  . Width;
	VertPos: HRef = Previous . Href;
	HorizPos: Left = Previous . Right;
	LineBreak: No;
	Font: Enclosing =;
	Style: Italics;
	Size: Enclosing = ;
	Indent: 0;
	Justify: No;
	Adjust: Left;
	LineSpacing: 1;
	Depth : 0;
	UnderLine: Enclosing =;
	Thickness: Enclosing =;
	LineStyle: Enclosing =;
	LineWeight: Enclosing =;
	Background: Enclosing =;
	Foreground: Enclosing =;
	FillPattern: Enclosing =;
   END;

BOXES

   Fractionbar:
       BEGIN
        Height: 0.2; 
        Width: Enclosing . Width ;
        HorizPos: Left = Enclosing.Left;
	{HorizRef: Enclosed . HMiddle;}
        VertPos: Nil;
        
	Size: Enclosing - TWOSTEP ;
        Style: Roman;
        Content: Graphics 'h'; 
       END;

   SymbRadical:
        BEGIN
        Height:  Root_obj . Height;
        Width:  Root_obj . Width + 0.8;
{       VertPos: Top = Enclosing . Top;
        HorizPos: Left = Enclosing . Left;}
        VertPos: Nil;
        HorizPos: Nil;
        Content: Symbol 'r'; 
        END;   
{*********** Boxes for Integration constructs ***************************}

     Intsymbol: 
       BEGIN 
        Height: Enclosing.Height; 
        HorizPos: Left = Enclosing.Left; 
        VertPos:  Nil; 
        HorizRef: *.HMiddle + 0.25; 
        Content: Symbol 'i'; 
       END; 
     DIntsymbol: 
       BEGIN 
        Height: Enclosing.Height; 
        HorizPos: Left = Enclosing.Left; 
        VertPos:  Nil; 
        HorizRef: *.HMiddle + 0.25; 
        Content: Symbol 'd'; 
       END; 
     CIntsymbol: 
       BEGIN 
        Height: Enclosing.Height; 
        HorizPos: Left = Enclosing.Left; 
        VertPos:  Nil; 
        HorizRef: *.HMiddle + 0.25; 
        Content: Symbol 'c'; 
       END; 

{*********** Boxes for Limits ***************************}

 Infbox:        
        BEGIN
          HorizPos: Nil;
          VertPos: Nil;
          Content: TEXT 'inf';
          Style: Roman;
        END;
 Limbox:        
        BEGIN
          HorizPos: Nil;
          VertPos: Nil;
          Content: TEXT 'lim';
          Style: Roman;
        END;
 Liminfbox:     
        BEGIN
          HorizPos: Nil;
          VertPos: Nil;
          Content: TEXT 'lim inf';
          Style: Roman;
        END;
 Limsupbox:     
        BEGIN
          HorizPos: Nil;
          VertPos: Nil;
          Content: TEXT 'lim sup';
          Style: Roman;
        END;
 Maxbox:        
        BEGIN
          HorizPos: Nil;
          VertPos: Nil;
          Content: TEXT 'max';
          Style: Roman;
        END;
 Minbox:        
        BEGIN
          HorizPos: Nil;
          VertPos: Nil;
          Content: TEXT 'min';
          Style: Roman;
        END;
 Supbox:        
        BEGIN
          HorizPos: Nil;
          VertPos: Nil;
          Content: TEXT 'sup';
          Style: Roman;
        END;


{*********** Boxes for Accents ***************************}

  Shavebox:	
       BEGIN
         HorizPos: VMiddle = Previous.VMiddle;
         VertPos: Top = Previous.Top +0.3;
         Depth: 3;
         Content: TEXT ' '; Height: 0.1;
       END;
                  

  Slashbox:     
       BEGIN
         HorizPos: VMiddle = Previous.VMiddle;
         VertPos: Top = Previous.Top ;
         Depth: 3;
         Content: TEXT '/'; 
       END;

  Hatbox:
       BEGIN
         HorizPos: VMiddle = Previous.VMiddle;
         VertPos: Top = Previous.Top - 0.25;
         Depth: 3;
         Content: TEXT '\136'; Size: Enclosing =;

       END;
  HatboxL:
       BEGIN
{
         HorizPos: VMiddle = Previous.VMiddle;
         VertPos: Top = Previous.Top - 0.4;
         Depth: 3;
         Content: TEXT '\136'; Size: Enclosing =;

}
        Height: 0.6; 
        Width: Enclosing . Width * 50 %;
        HorizPos: Left = Enclosing.Left;
        Depth: 3;
        VertPos:Bottom = Enclosing.Top - 0.2;
        
	Size: Enclosing - TWOSTEP ;
        Style: Roman;
        Content: Graphics '/';

       END;
  HatboxR:
       BEGIN
        Height: 0.6; 
        Width: Previous . Width ;
        HorizPos: Right = Enclosing.Right;
        Depth: 3;
        VertPos:Bottom = Enclosing.Top - 0.2;
        
	Size: Enclosing - TWOSTEP ;
        Style: Roman;
        Content: Graphics '\\';

       END;
  Acutebox:     
       BEGIN
         HorizPos: VMiddle = Previous.VMiddle;
         VertPos: Top = Previous.Top -0.15;
         Depth: 3;
         Content: TEXT '\264'; Size: Enclosing =;

       END;
  Gravebox:     
       BEGIN
         HorizPos: VMiddle = Previous.VMiddle;
         VertPos: Top = Previous.Top -0.15;
         Depth: 3;
         Content: TEXT '\140'; Size: Enclosing =;

       END;
  Tildebox:	
       BEGIN
         HorizPos: VMiddle = Previous.VMiddle;
         VertPos: Top = Previous.Top - 0.5;
         Depth: 3;
         Content: TEXT '\176'; Size: Enclosing = {- TWOSTEP min 6};

       END;
  Barbox:	
       BEGIN
        Height: 0.2; 
        Width: Enclosing . Width ;
        HorizPos: Left = Enclosing.Left;
        Depth: 3;
        VertPos:Top = Enclosing.Top - 0.15;
        
	Size: Enclosing - TWOSTEP ;
        Style: Roman;
        Content: Graphics 't'; 

       END;
  BarboxH:	
       BEGIN
        Height: 0.2; 
        Width: Enclosing . Width ;
        HorizPos: Left = Enclosing.Left;
        Depth: 3;
        VertPos:Top = Enclosing.Top - 0.2;
        
	Size: Enclosing - TWOSTEP ;
        Style: Roman;
        Content: Graphics 't'; 

       END;
  BarboxB:	
       BEGIN
        Height: 0.2; 
        Width: Enclosing . Width ;
        HorizPos: Left = Enclosing.Left;
        Depth: 3;
        VertPos:Bottom = Enclosing.Bottom;
        
	Size: Enclosing - TWOSTEP ;
        Style: Roman;
        Content: Graphics 't'; 

       END;
  Vecbox:	
       BEGIN
         HorizPos: VMiddle = Previous.VMiddle;
         VertPos: Top = Previous.Top - 0.3;
         Depth: 3;
         Content: TEXT G '\256'; Size: Enclosing - SIXSTEP min 6;

       END;
  Dotaccbox:	
       BEGIN
         HorizPos: VMiddle = Previous.VMiddle;
         VertPos: Top = Previous.Top - 0.15;
         Depth: 3;
         Content: TEXT G '\327'; 

       END;
  Ddotbox:	
       BEGIN
         HorizPos: VMiddle = Previous.VMiddle;
         VertPos: Top = Previous.Top - 0.15;
         Depth: 3;
         Content: TEXT '\250'; 

       END;

  SPrimebox:	
        BEGIN
          VertPos: HRef = Previous.HRef ;
          Content: TEXT G '\242';
        HorizPos: Left = Previous.Right;

        END;
  DPrimebox:    
        BEGIN
          VertPos: HRef = Previous.HRef ;
          Content: TEXT G '\262';
        HorizPos: Left = Previous.Right;

        END;

{*********** Boxes for Spacing ***************************}

     SpaceChar:
        BEGIN
	  Height: Previous . Height ;
          VertPos: HRef = Previous.HRef ;
	  HorizPos: Left = Previous.Right;
          Content: TEXT ' ';
	  Style: Roman;
	  Size : Previous =;

        END;

     Spacebox:
        BEGIN
	  Height: Previous . Height ;
          VertPos: HRef = Previous.HRef ;
          Content: TEXT '\267' {Graphics '\260'};
	  Size : 4;


        END;

     TSpacebox:
        BEGIN
	  Width: 0.1;
	  Height: 1.25 ;
          {VertPos: Bottom = Previous.HRef - 2 ;}
	  {VertPos: HRef = Previous.HRef - 0.4;}
          Content: Graphics '\260';


        END;

     Cdotsbox:
        BEGIN
	  Height: 1 ;
          VertPos: HRef = Previous.HRef ;
          Content: TEXT G ' \327 \327 \327 ';  


        END;

     Ldotsbox:
        BEGIN
	  Height: 1 ;
          VertPos: HRef = Previous.HRef ;
          Content: TEXT  ' . . . ';


        END;

     BDDOTbox:
        BEGIN
	  Height: 0.5;
          VertPos: HRef = Previous.HRef - 0.9 ;
          HorizPos: Left = Previous.Right + 0.2;
          Content: TEXT  '.';  

        END;

     MDDOTbox:
        BEGIN
	  Height: 0.5;
          VertPos: HRef = Previous.HRef + 0.4;
          HorizPos: Left = Previous.Left + 0.4;
          Content: TEXT '.';  

        END;


     EDDOTbox:
        BEGIN
	  Height: 0.5;
          VertPos: HRef = Previous.HRef + 0.4 ;
          HorizPos: Left = Previous.Left + 0.4;
          Content: TEXT '.';  

        END;

     BVDOTbox:
        BEGIN
	  Height: 0.5;
          VertPos: HRef = Previous.HRef - 0.85 ;
          HorizPos: Left = Previous.Right + 0.1;
          Content: TEXT  '.';  

        END;

     MVDOTbox:
        BEGIN
	  Height: 0.5;
          VertPos: HRef = Previous.HRef + 0.4;
          HorizPos: Left = Previous.Left;
          Content: TEXT  '.';  

        END;


     EVDOTbox:
        BEGIN
	  Height: 0.5;
          VertPos: HRef = Previous.HRef + 0.4 ;
          HorizPos: Left = Previous.Left;
          Content: TEXT  '.';  
        END;

EmbTeX_box:
        BEGIN
        Content: Text 'TeX: ';
        Style: BoldItalics;
	Size: Enclosing - TWOSTEP min 3;
        {IN SGML Visibility: 0;}
        END;

 CellFooter:
	BEGIN
	Content: Graphics ' ';
	Height: TableSimpleVSpace;
	Width: TableSimpleHSpace;
	VertPos: Top = Creator . Bottom;
	HorizPos: Left = Creator . Left;
	END;

 CellHeader:
	BEGIN
	Content: Graphics ' ';
	Height: TableSimpleVSpace;
	Width: TableSimpleHSpace;
	VertPos: Bottom = Creator . Top;
	HorizPos: Left = Creator . Left;
	END;

 BModBox:
	BEGIN
	Content: TEXT ' mod ';
	VertPos : HRef = Previous . HRef;
	HorizPos: Left = Previous . Left;
	Style: Roman;
	END;

 PModBox:
	BEGIN
	Content: TEXT '(mod ';
	VertPos : HRef = Previous . HRef;
	HorizPos: Left = Previous . Left;
	Style: Roman;
	END;

 PModParentBox:
	BEGIN
	Content: TEXT ')';
	VertPos : HRef = Previous . HRef;
	HorizPos: Left = Previous . Right;
	Style: Roman;
	END;


RULES

   Math:
        BEGIN
	PageBreak: No;
	LineBreak: Yes;
	VertPos: Top = Previous . Bottom;
	HorizPos: VMiddle = Previous . VMiddle;
        END;

   Choice_math:
        BEGIN
          VertPos: HRef = Previous . Href;
          HorizPos: Left = Previous.Right;
          PageBreak: No;
        END;

   EmptyContents:
         BEGIN
           Height: 0;
           Width: 0;
           Visibility: 0;
         END;

   Emb_tex :
        BEGIN
	  CreateFirst (EmbTeX_box);
          VertPos: HRef = Previous.HRef;
          HorizPos: Left = Previous.Right;
          PageBreak: No;
{          VertRef: Enclosed . VRef;}
          Font : Helvetica;
          Size: Enclosing - TWOSTEP;
          Style: BoldItalics;
          Line;
          Indent: 0;
        END;

   Textual:
        BEGIN
          VertPos: HRef = Previous . HRef;
          HorizPos: Left = Previous.Right;
          PageBreak: No;
          {Style: Enclosing =;}
        END;

    TEXT_UNIT:
	BEGIN
          VertPos: HRef = Previous . Href;
          HorizPos: Left = Previous.Right;
	  Style: Enclosing =;
	END;

{************* ROOT ******************}
    Root_cst:
        BEGIN
        VertPos: HRef = Previous . Href;
        HorizPos: Left = Previous.Right + 0.2;
        HorizRef: Enclosed Root_obj . HRef ;
        Gather: Yes;
        END;

   Root_ord:
        BEGIN
        HorizRef: * . Top;
{        HorizPos: Left = Enclosing.Left;}
        HorizPos: Right = SymbRadical.Left + 0.6;
        VertPos: Bottom = SymbRadical.Bottom - 0.3;
        Size: Enclosing - THREESTEP min 3;
        END;

  Root_obj:
        BEGIN
        CreateBefore (SymbRadical);
        HorizPos: Left = SymbRadical . Left + 1;
        VertPos: Top = SymbRadical . Top + 0.1;
         END;

{************ SUPERLINE ******************}

  Superline:
        BEGIN
          VertPos: HRef = Previous . Href;
          HorizPos: Left = Previous.Right;
          PageBreak: No;
        END;


{************ FRACTION *******************}

   Fraction:
        BEGIN
          HorizPos: Left = Previous.Right+0.2;
          PageBreak: No;
          CreateFirst(Fractionbar);
          VertPos: HRef = Previous . Href;
          HorizRef: Enclosed Fractionbar.HRef;
        END;
   Numera_r: 
        BEGIN 
        HorizPos: VMiddle = Fractionbar.VMiddle; 
        VertPos: Bottom = Fractionbar . Top ;  
        END;
   Denomi_r: 
        BEGIN
        HorizPos: VMiddle = Fractionbar.VMiddle;
        VertPos: Top = Fractionbar . Bottom ; 
        END;

{********* SUBSCRIPTED ************}
   Subscr_d:
       BEGIN
          VertPos: HRef = Previous . Href;
          HorizPos: Left = Previous.Right+0.2;
          PageBreak: No;
       END;
  Main:
       BEGIN
          HorizPos: Nil;
          VertPos: Nil;
       END;
  Subscr: 
        BEGIN
          Size: Enclosing - TWOSTEP min 3;
          HorizPos: Left = Main . Right + 0.2;
          Vertpos: HRef = Main.Bottom + 0.1;
        END;
  Supscr: 
        BEGIN
          Size: Enclosing - TWOSTEP min 3;
          HorizPos: Left = Main . Right + 0.2;
          Vertpos: HRef = Main.Top + 0.3;
        END;
  Presub: 
        BEGIN
          Size: Enclosing - TWOSTEP min 6;
          HorizPos: Right = Main . Left ;
          Vertpos: HRef = Main.Bottom + 0.1;
        END;
  Presup: 
        BEGIN
          Size: Enclosing - TWOSTEP min 6;
          HorizPos: Right = Main . Left ;
          Vertpos: HRef = Main.Top + 0.5;
        END;

{******** INTEGRATION **************}
   Int_cst: 
       BEGIN
          VertPos: HRef = Previous . Href;
          HorizPos: Left = Previous.Right+0.2;
          PageBreak: No;
          HorizRef: Enclosed Integrnd . HRef;
       END;
   L_part_a:
        BEGIN
        HorizRef: Enclosed Intsym.HRef;
        HorizPos: Left = Enclosing.Left;
        VertPos: Nil;
        END;
   Intsym: 
        BEGIN
        HorizPos: Left = Enclosing.Left;
        VertPos: Nil;
        Width: Enclosed.Width;
        Height: 2.0;
        END;
   Lower_bd:
        BEGIN
        Size: Enclosing - TWOSTEP min 6;
        HorizPos: Left = Intsym . Right - 0.2;
        VertPos:  HRef = Intsym.Bottom;
        END;

  Upper_bd:
        BEGIN
        Size: Enclosing - TWOSTEP min 6;
        HorizPos: Left = Intsym . Right + 0.2;
        VertPos: HRef = Intsym.Top + 0.25;
        END;

   Integrnd:
        BEGIN
          HorizPos: Left = L_part_a . Right + 0.2;
          VertPos: HRef = Previous . Href;
        END;


{*********** SUM UNION ********************}

   Sum_cst: 
       BEGIN
          VertPos: HRef = Previous . Href;
          HorizPos: Left = Previous.Right+0.2;
          PageBreak: No;
          HorizRef: Enclosed Operand . HRef;
       END;
   L_part_b:
        BEGIN
{        Size: Enclosing + 3 max 17;}
        {Size: Enclosing - 1;}
        {Size: Enclosing + THREESTEP max 72;}
        HorizRef: Enclosed Sumsym.HMiddle + 0.2;
        HorizPos: Left = Enclosing.Left;
        END;


  Lower_ex: 
        BEGIN
        HorizPos: VMiddle = Sumsym.VMiddle;
        VertPos: Top = Sumsym . HRef + 0.1 ; 
        Size: Enclosing - TWOSTEP min 3;
        END;
   Upper_ex: 
        BEGIN 
        HorizPos: VMiddle = Sumsym.VMiddle; 
        VertPos: HRef = Sumsym . Top - 0.15;
        Size: Enclosing - TWOSTEP min 3;
        END;

  Sumsym:
        BEGIN
        HorizPos: nil;
        VertPos: nil;
        {Size: Enclosing + TWOSTEP max 72;}
        Size: Enclosing + ONESTEP max 72;
	Height: 1.1;
	Width: Enclosed . Width ;
        END;

   Operand: 
        BEGIN
          HorizPos: Left = L_part_b . Right + 0.2;
          VertPos: HRef = Previous . Href;
        END;

{************ STACKREL ******************}

   Stackrel:
       BEGIN
          VertPos: HMiddle = Previous . HMiddle;
          HorizRef: Enclosed Lower_a . HRef;
          HorizPos: Left = Previous . Right+0.2;
          PageBreak: No;
       END;

   Upper_a: 
        BEGIN
	VertPos: Nil;
        HorizPos: Nil;
	Size: Enclosing - TWOSTEP min 3;
        END;

   Lower_a: 
        BEGIN 
        HorizPos: VMiddle = Previous.VMiddle;
        VertPos: Top = Upper_a . HRef - 0.1;
        END;

{************ LIMITS ********************}
   Lim_like:
       BEGIN
          VertPos: HRef = Previous.Href;
          HorizPos: Left = Previous.Right+0.2;
          PageBreak: No;
       END;

   Range: 
        BEGIN
        HorizPos: VMiddle = Previous.VMiddle;
        VertPos: Top = Previous. HRef + 0.1 ; 
        Size: Enclosing - TWOSTEP min 3;
        END;

   L_part_c:
       BEGIN
          VertPos: HRef = Previous.Href;
          HorizPos: Left = Previous.Right + 0.2;
          PageBreak: No;
       END;

   R_part_c:
       BEGIN
          VertPos: HRef = Previous.Href;
          HorizPos: Left = Previous.Right + 0.2;
          PageBreak: No;
       END;

{************ PARENTHESIS ***************}

  Delimiters:
       BEGIN
         HorizRef: Enclosed Included_1.HRef;
         VertPos: HRef = Previous . Href;
         HorizPos: Left = Previous.Right+0.2;
         PageBreak: No;
       END;

Left_del:
      BEGIN
        HorizRef: * . Top;
        Height: Included_1 . Height;
        HorizPos: Left = Enclosing . Left + 0.1;
        VertPos: Top =  Included_1 . Top;
	Size: Enclosing + ONESTEP max 72; {Try to make | more visible in print}
      END;

Included_1:
      BEGIN
        HorizPos: Left = Previous . Right + 0.1;
        VertPos: Nil;
      END;

Right_del:
      BEGIN
        HorizRef: * . Top;
        Height: Included_1 . Height;
        HorizPos: Left = Previous . Right + 0.1;
        VertPos: Top = Included_1 . Top;
	Size: Enclosing + ONESTEP max 72; {Try to make | more visible in print}
      END;

  Thin_space:
    BEGIN
     Width: 0.3;
     VertPos: HRef = Previous . Href;
     HorizPos: Left = Previous.Right;
     PageBreak: No;
     CreateFirst(Spacebox);
    END;

  Medium_space: 
    BEGIN
     Width: 0.5;
     VertPos: HRef = Previous . Href;
     HorizPos: Left = Previous.Right;
     PageBreak: No;
     CreateFirst(Spacebox);
    END;

 Thick_space:
    BEGIN
     Width: 0.7;
     VertPos: HRef = Previous . Href;
     HorizPos: Left = Previous.Right;
     PageBreak: No;
     CreateFirst(Spacebox);
    END;

 Cdots:
    BEGIN
     VertPos: HRef = Previous . Href;
     HorizPos: Left = Previous.Right;
     PageBreak: No;
     CreateFirst(Cdotsbox);
    END;

 Ldots:
    BEGIN
     VertPos: HRef = Previous . Href;
     HorizPos: Left = Previous.Right;
     PageBreak: No;
     CreateFirst(Ldotsbox);
    END;

 Ddots:
    BEGIN
     Height: 1.5 ;
     VertPos: HRef = Previous . Href ;
     HorizPos: Left = Previous.Right;
     PageBreak: No;
     CreateFirst(TSpacebox);
     CreateFirst(BDDOTbox);
     CreateFirst(MDDOTbox);
     CreateFirst(EDDOTbox);
    END;

 Vdots:
    BEGIN
     Height: 1.5 ;
     VertPos: HRef = Previous . Href ;
     HorizPos: Left = Previous.Right;
     PageBreak: No;
     CreateFirst(TSpacebox);
     CreateFirst(BVDOTbox);
     CreateFirst(MVDOTbox);
     CreateFirst(EVDOTbox);
    END;

{***************** Trigo Functions ****************}
 Invoc_Fct:
     BEGIN
      VertPos: HRef = Previous . Href ;
      HorizPos: Left = Previous.Right;
      Width: Enclosed . Width;
     END;

 Function_name:
     BEGIN
      VertPos: HRef = Previous . Href ;
      HorizPos: Left = Previous.Right;
      Width: Enclosed . Width;
      Style: Roman;
      PageBreak: No;
      CreateLast (SpaceChar);
     END;

 Parameter:
     BEGIN
      VertPos: HRef = Previous . Href ;
      HorizPos: Left = Previous.Right;
      Width: Enclosed . Width;
      PageBreak: No;
     END;

{***********************************************}
 SYMBOL_UNIT:
	BEGIN
	Height: Enclosing . Height;
        Width: Enclosing . Width;
        VertPos: HMiddle = Enclosing.HMiddle;
        HorizPos: VMiddle = Enclosing.VMiddle;
        HorizRef: *.HMiddle + 0.2;
        END;

{************ MATRIX ********************}

Array:
	BEGIN
        Gather: Yes;
        PageBreak: Yes;
        Justify: No;
        HorizPos: VMiddle = Enclosing . VMiddle;
        VertPos: Top = Previous . Bottom + 0.5;
        Adjust: Left;
	END;

 Array_head:
	BEGIN
        PageBreak: Yes;
	HorizPos: Left = Enclosing . Left + TableSimpleHSpace;
	VertPos: nil;
	Height: 1 pt;
	END;

 EmptyHead:
	BEGIN
        PageBreak: Yes;
	HorizPos: Left = Enclosing . Left + TableSimpleHSpace;
	VertPos: nil;
	Height: 1 pt;
	END;

 Column_head:
	BEGIN
        PageBreak: Yes;
	HorizPos: Left = Previous . Right + TableDoubleHSpace;
	VertPos: Top = Enclosing . Top;
	Height: 1 pt;
	END;

 Array_body:
	BEGIN
	VertPos : Top = Previous . Bottom;
	END;

 Array_row:
	BEGIN
        PageBreak: Yes;
	VertPos: Top = Previous Array_row . Bottom;
	HorizPos: Left = Enclosing . Left;
	END;

 Array_cell:
	BEGIN
	VertPos : Top = Enclosing . Top + TableSimpleVSpace;
	HorizPos: Left = Previous Array_cell . Right + TableDoubleHSpace;
	CreateAfter (CellFooter);
	END;

{************ MODULOS ******************}

 B_Modulo :
	BEGIN
	VertPos : HRef = Previous . HRef;
	HorizPos: Left = Previous . Right;
	Style: Roman;
	END;

 ModuloConstant :
	BEGIN
	VertPos : HRef = Enclosing . HRef;
	HorizPos: Left = Enclosing . Right;
	CreateBefore (BModBox);
	Style: Roman;
	END;

 P_Modulo :
	BEGIN
	VertPos : HRef = Previous . HRef;
	HorizPos: Left = Previous . Right;
	CreateBefore (PModBox);
	CreateAfter (PModParentBox);
	Style: Roman;
	END;

ATTRIBUTES

{************ LIMITS ********************}

  LIMITOP = Inf:        CreateFirst(Infbox);
  LIMITOP = Limm:       CreateFirst(Limbox);
  LIMITOP = Liminf:    CreateFirst(Liminfbox);
  LIMITOP = Limsup:    CreateFirst(Limsupbox);
  LIMITOP = Maxx:       CreateFirst(Maxbox);
  LIMITOP = Minn:       CreateFirst(Minbox);
  LIMITOP = Sup:        CreateFirst(Supbox);
  
  
{******** INTEGRATION **************}

  INTTYPE = Single:        CreateFirst(Intsymbol);
  INTTYPE = Double:        CreateFirst(DIntsymbol);
  INTTYPE = Contour:       CreateFirst(CIntsymbol);

{************* TEXTUAL *************************}

  NEGATED: 			CreateLast(Slashbox);

  CALLIGRAPHIC:		         
      BEGIN
      Font: Times;
      Style: Roman;
      END;

  ACCENT = Hat:	  BEGIN Height : Previous. Height; CreateLast(Hatbox); END;
  ACCENT = Acute: BEGIN Height : Previous. Height; CreateLast(Acutebox); END;
  ACCENT = Tilde: BEGIN Height : Previous. Height; CreateLast(Tildebox); END;
  ACCENT = Bar:   BEGIN Height : Previous. Height; CreateLast(Barbox); END;
  ACCENT = Vec:   BEGIN Height : Previous. Height; CreateLast(Vecbox); END;
  ACCENT = Dot:   BEGIN Height : Previous. Height; CreateLast(Dotaccbox); END;
  ACCENT = Ddot:  BEGIN Height : Previous. Height; CreateLast(Ddotbox); END;
  ACCENT = Sprime:BEGIN Height : Previous. Height; CreateLast(SPrimebox); END;
  ACCENT = Dprime:BEGIN Height : Previous. Height; CreateLast(DPrimebox); END;
  ACCENT = Grave: BEGIN Height : Previous. Height; CreateLast(Gravebox); END;

  SHAVE : CreateLast(Shavebox);

{Inline presentation rules}
   INLSTYLE(Emb_tex) :
        BEGIN
          VertPos: HRef = Previous . Href;
          HorizPos: Left = Previous.Right+0.2;
        END;

{*********** SUPERLINE ****************}

  LINE_TYPE = UnderBar:		CreateLast(BarboxB);
  LINE_TYPE = UnderBrace:	CreateLast(BarboxB);
  LINE_TYPE = OverBar: 	   	CreateLast(BarboxH);
  LINE_TYPE = OverBrace:
	BEGIN
	  CreateLast(HatboxL);
	  CreateLast(HatboxR);
	END;
  LINE_TYPE = WideHat:
	BEGIN
	  CreateLast(HatboxL);
	  CreateLast(HatboxR);
	END;
  LINE_TYPE = WideTilde:	
	BEGIN
	  CreateLast(HatboxL);
	  CreateLast(HatboxR);
	END;

{*********** FRACTION *****************}

   INLSTYLE(Numera_r): 
        BEGIN 
        HorizPos: VMiddle = Fractionbar.VMiddle; 
        VertPos: Bottom = Fractionbar . Top ; 
        Size: Enclosing - TWOSTEP min 6; 
        END;
   INLSTYLE(Denomi_r): 
        BEGIN
        HorizPos: VMiddle = Fractionbar.VMiddle;
        VertPos: Top = Fractionbar . Bottom ; 
        Size: Enclosing - TWOSTEP min 6; 
        END;
{********* SUBSCRIPTED ************}

   INLSTYLE(Subscr_d):
       BEGIN
          VertPos: HRef = Previous . Href;
          HorizPos: Left = Previous.Right+0.2;
          PageBreak: No;
       END;
    INLSTYLE(Subscr): 
        BEGIN
          Size: Enclosing - THREESTEP min 6;
          HorizPos: Left = Main . Right ;
          Vertpos: HRef = Main.Bottom + 0.0;
        END;
  INLSTYLE(Supscr): 
        BEGIN
          Size: Enclosing - THREESTEP min 6;
          HorizPos: Left = Main . Right ;
          Vertpos: HRef = Main.Top + 0.3;
        END;
  INLSTYLE(Presub): 
        BEGIN
          Size: Enclosing - THREESTEP min 6;
          HorizPos: Right = Main . Left ;
          Vertpos: HRef = Main.Bottom + 0.0;
        END;
  INLSTYLE(Presup): 
        BEGIN
          Size: Enclosing - THREESTEP min 6;
          HorizPos: Right = Main . Left ;
          Vertpos: HRef = Main.Top + 0.6;
        END;

{************INTEGRATION*********************}

   INLSTYLE(Intsym): 
        BEGIN
        HorizPos: Left = Enclosing.Left;
        VertPos: Nil;
        Width: Enclosed.Width;
        Height: 1.3;
        END;
   INLSTYLE(Lower_bd):
        BEGIN
        Size: Enclosing - THREESTEP min 6;
        HorizPos: Left = Intsym . Right - 0.2;
        VertPos: Top = Intsym . Bottom - 0.6;
        END;

  INLSTYLE(Upper_bd):
        BEGIN
        Size: Enclosing - THREESTEP min 6;
        HorizPos: Left = Intsym . Right + 0.1;
        VertPos: Bottom = Intsym . Top + 0.5;
        END;


{*********** SUM UNION ********************}


   INLSTYLE(L_part_b):
        BEGIN
{        Size: Enclosing + 1 max 17;}
        {Size: Enclosing - FOURSTEP min 6;}
        {Size: Enclosing + ONESTEP max 72;}
        HorizRef: Enclosed Sumsym . HMiddle + 0.2;
        HorizPos: Left = Enclosing.Left;
        END;


  INLSTYLE(Lower_ex): 
        BEGIN
        HorizPos: Left = Sumsym . Right;
        VertPos: HRef = Sumsym . Bottom ; 
{        Size: Enclosing - 3 min 1;}
        {Size: Enclosing + 1;}
        {Size: Enclosing - THREESTEP min 6;} {Relative to size of L.PART.B}
        Size: Enclosing - TWOSTEP min 6;
        END;
   INLSTYLE(Upper_ex): 
        BEGIN 
        HorizPos: Left = Sumsym . Right; 
        VertPos: HRef = Sumsym . Top + 0.3 ;  
{        Size: Enclosing - 3 min 1;}
        {Size: Enclosing + 1;}
        {Size: Enclosing - THREESTEP min 6;} {Relative to size of L.PART.B}
        Size: Enclosing - TWOSTEP min 6;
        END;
   INLSTYLE(Sumsym): 
        BEGIN
        HorizPos: nil;
        VertPos: nil;
	Height: 0.9;
	Width: Enclosed . Width ;
        Size: Enclosing = ;
        END;

{***************** STACKREL *****************}
{
   INLSTYLE(Upper_a): 
        BEGIN 
        HorizPos: VMiddle = Lower_a . VMiddle; 
        VertPos: Bottom = Lower_a . Top + 0.4;
	Size: Enclosing - THREESTEP min 6;
        END;
}
{****************  LIMITS ******************}

   INLSTYLE(Range): 
        BEGIN
        HorizPos: Left = Previous.Right;
        VertPos: HRef = Previous . Bottom + 0.15 ; 
        END;

 COLUMN_WIDTH:
	BEGIN
	Width: COLUMN_WIDTH pt;
	END;

 REF_COLUMN:
	BEGIN
	Width: Referred . Width;
	HorizPos: Left = Referred . Left;
	END;


 ROW_ALIGN (Column_head) = Row_left :
	Adjust: Left;

 ROW_ALIGN (Column_head) = Row_center :
	Adjust: VMiddle;

 ROW_ALIGN (Column_head) = Row_right :
	Adjust: Right;


 ROW_VALIGN (Array) = Row_top :
{	VertPos : Top = Enclosing . Top + TableSimpleVSpace;}
	VertPos : Top = Previous NOT Delimiters . Top;

 ROW_VALIGN (Array) = Row_bottom :
	BEGIN
{	VertPos : Bottom = Enclosing . Bottom - TableSimpleVSpace;}
	VertPos : Bottom =  Previous NOT Delimiters . Bottom;
	CreateBefore (CellHeader);
	END;
END
