	{ Ce schema decrit la presentation utilisee pour les extensions des INDEX
        les tables d index
        les options
        les descripteurs de marques
        ls descripteurs de references croisees
	
        H. Richy Octobre 1991

       + descripteurs partages 
         H. Richy Janvier 1996 }

{ Variables utilisees : ENGLISH, NOREF, US_PAPER }

PRESENTATION ExtIndex;

VIEWS
#ifdef ENGLISH
	Full_text;
#else
	VuePrincipale;
#endif

PRINT
#ifdef ENGLISH
	Full_text, Index_tables;
#else
	VuePrincipale, Index_tables;
#endif

COUNTERS
   CptIndex: Rank of Elem_Index;
   CptTerme: Rank of Terme;
#ifdef ENGLISH
   CptPageIndex: Set 0 on Index_tables Set 0 on Index_table Add 1 on Page(Full_text);
#else
   CptPageIndex: Set 0 on Index_tables Set 0 on Index_table Add 1 on Page(VuePrincipale);
#endif
   CptNiveau: Rank of Cl\351;
   CCptNiveau: Rank of CCl\351;
   CptDesc: Rank of Descripteur;
   CptCrois\351e: Rank of Renvoi;
   CptOption: Rank of Option;
   CptTable: Rank of Index_table;

VAR
   VarCptTable: Text ' (index ' Value (CptTable, Arabic) Text ') ';
   VarPageIndex: Text ' I' Value (CptTable, Arabic) Text '-'
                   Value (CptPageIndex, Arabic);
   VarNiveauCle: Text ' (' Value (CptNiveau, Arabic) Text ') ';
   VarNiveauCCle: Text ' (' Value (CCptNiveau, Arabic) Text ') ';

DEFAULT

   BEGIN
   HorizRef: Enclosed . HRef ;
   VertRef : Enclosed . VRef ;
   Width: Enclosed . Width;
   Height: Enclosed . Height;
   VertPos : Top = Previous . Bottom;
   HorizPos : Left = Enclosing . Left;
   Justify : Enclosing =;
   Visibility: Enclosing =;
   Font: Enclosing =;
   Style: Enclosing =;
   Size: Enclosing =;
   Adjust : Enclosing =;
   Indent : Enclosing =;
   LineSpacing: Enclosing =;
   Depth: 0;
   UnderLine: Enclosing =;
   Thickness: Enclosing =;
   Foreground: Enclosing =;
   Background: Enclosing =;
   FillPattern: Enclosing =;
   END;

BOXES
   BoiteDescripteur:
        BEGIN
	VertPos: Top = Enclosing . Top + 1;
#ifdef ENGLISH
        Content: text 'Descriptors of references';
#else
        Content: text 'Descripteurs des r\351f\351rences';
#endif
        Style: Bold;
	Font : Helvetica;
	Size : Creator + 2;
	Foreground: Creator =;
	Background: Creator =;
        END;

   BoiteCrois\351e:
        BEGIN
	VertPos: Top = Enclosing . Top + 1;
#ifdef ENGLISH
        Content: text 'Descriptors of cross-references';
#else
        Content: text 'R\351f\351rences crois\351es';
#endif
        Style: Bold;
	Font : Helvetica;
	Size : Creator + 2;
	Foreground: Creator =;
	Background: Creator =;
        END;

   BoiteOption:
        BEGIN
	VertPos: Top = Enclosing . Top + 1;
#ifdef ENGLISH
        Content: text 'Building options for the index tables';
#else
        Content: text 'Options pour la construction des tables d''index';
#endif
        Style: Bold;
 	Font : Helvetica;
	Size : Creator + 2;
	Foreground: Creator =;
	Background: Creator =;
        END;

   NumeroDesc:
        BEGIN
	VertPos: Top = Previous . Bottom + 2;
        Content: (text '['  VALUE (CptDesc, Arabic) text ']');
	Style: Roman;
 	Font : Creator =;
	Size : Creator =;
	Foreground: Creator =;
	Background: Creator =;
       END;

   BlueNumeroDesc:
        BEGIN
	VertPos: Top = Previous . Bottom + 2;
        Content: (text '['  VALUE (CptDesc, Arabic) text ']');
	Style: Roman;
 	Font : Creator =;
	Size : Creator =;
	Foreground: SkyBlue;
	Background: Creator =;
       END;

   NumeroCrois\351:
	BEGIN
	VertPos: Top = Previous . Bottom + 2;
{	VertPos: Top = Enclosing . Top + 1; }
	Content: (text '[Cr:' VALUE (CptCrois\351e, Arabic) text ']');
	Style: Roman;
 	Font : Creator =;
	Size : Creator =;
	Foreground: Creator =;
	Background: Creator =;
	END;

   NumeroOption:
        BEGIN
        VertPos: Top = Previous . Bottom + 3;
        Content: (text '['  VALUE (CptOption, Arabic) text ']');
	Style: Roman;
 	Font : Creator =;
	Size : Creator =;
	Foreground: Creator =;
	Background: Creator =;
        END;

   BoiteNumNote:
        BEGIN
        VertPos: HRef = Previous . HRef;
        HorizPos: Left = Previous . Right + 0.5;
	Content: (text '(note ');
        Size: Enclosing -2 min 6;
	Font : Creator =;
	Style: Italics;
	Foreground: Creator =;
	Background: Creator =;
       END;

   BoiteParNote:
        BEGIN
        VertPos: HRef = Previous . HRef;
        HorizPos: Left = Previous . Right + 0.5;
	Content: (text ') ');
	Style: Italics;
	Font : Creator =;
	Size: Enclosing -2 min 6;
	Foreground: Creator =;
	Background: Creator =;
       END;

   NumSectUnique:
        BEGIN
         VertPos: HRef = Previous . HRef;
         HorizPos: Left = Previous . Right + 0.5;
	 Content: (text 's. ');
        END;

   NumSectIntervalle:
        BEGIN
        VertPos: HRef = Previous . HRef;
        HorizPos: Left = Previous . Right + 0.5;
	Content: (text 'ss. ');
	Font : Creator =;
	Size : Creator =;
	Style: Creator =;
	Foreground: Creator =;
	Background: Creator =;
        END;

  VirguleBlanc:
        BEGIN
        Content: Text ', ';
	Font : Creator =;
	Size : Creator =;
	Style: Creator =;
	Foreground: Creator =;
	Background: Creator =;
        END;

#ifndef NOREF
   DeuxPointsBlanc:
        BEGIN
#ifdef ENGLISH
        Content: Text ': ';
#else
        Content: Text ' : ';
#endif
	Font : Creator =;
	Size : Creator =;
	Style: Creator =;
	Foreground: Creator =;
	Background: Creator =;
        END;
#endif

   Tiret:
        BEGIN
        HorizPos: Left = Previous . Right;
        VertPos: HRef = Previous . HRef;
        Content: Text '-';
	Font : Creator =;
	Size : Creator =;
	Style: Creator =;
	Foreground: Creator =;
	Background: Creator =;
        END;

   TiretCar:
        BEGIN
        Content: Text '-';
  	Font : Creator =;
	Size : Creator =;
	Style: Creator =;
	Foreground: Creator =;
	Background: Creator =;
        END;

#ifndef NOREF
   See:
        BEGIN
#ifdef ENGLISH
        Content: Text 'see ';
#else
        Content: Text 'voir ';
#endif
   	Font : Creator =;
        Size: Creator =;
        Style: Italics;
	Foreground: Creator =;
	Background: Creator =;
       END;

  SeeAlso:
        BEGIN
#ifdef ENGLISH
        Content: Text ', see also ';
#else
        Content: Text ', voir aussi ';
#endif
	Font : Creator =;
        Size: Creator =;
        Style: Italics;
	Foreground: Creator =;
	Background: Creator =;
        END;
#endif

   NumeroIndex:
        BEGIN
        HorizPos: VMiddle = Enclosing . VMiddle;
        VertPos: Top = Previous . Bottom;
        Content: (text 'INDEX ' VALUE (CptTable, Arabic));
	Font : Creator =;
        Size : Enclosing + 2;
	Style: Creator =;
	Foreground: Creator =;
	Background: Creator =;
	END;

   HautTitreIndex:
        BEGIN
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
        Copy (Titre_Index);
        Justify: No;
        HorizPos: Left = Previous PAGE_BREAK . Left;
        VertPos: Top = Previous PAGE_BREAK . Bottom + 0.4 cm;
	Font : Creator =;
	Size : 11 pt;
        Style: Italics;
       END;

   BasPage:
        BEGIN
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
        Height: 0.5 cm;
        VertPos: Bottom = Next PAGE_BREAK . Top;
        HorizPos: VMiddle = Next PAGE_BREAK . VMiddle;
	Content: (Text ' ');
	Font : Creator =;
        Size : 11 pt;
	Style: Creator =;
        END;

   EspaceBasPage:
        BEGIN
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
        Height: 1.4 cm;
        Width: 1 pt;
        VertPos: Bottom = Next PAGE_BREAK . Top;
        HorizPos: Left = Next PAGE_BREAK . Left;
        Content: (Graphics ' ');
        END;

   NumPageIndex:
        BEGIN
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
        Content: VarPageIndex;
        VertPos: Top = Previous PAGE_BREAK . Bottom + 0.4 cm;
        HorizPos: Right = Previous PAGE_BREAK . Right;
        Height:   1.6 cm;
        Size : 11 pt;
        Font: times;
        Style: Roman;
        END;

   PageTables:
        BEGIN
#ifdef US_PAPER
        Width: 14.6 cm;
        Height: 23.3 cm;
        HorizPos: Left = Enclosing . Left + 3.2 cm;
#else
        Width: 14 cm;
        Height: 25 cm;
        HorizPos: Left = Enclosing . Left + 3.5 cm;
#endif
        VertPos: Top = Enclosing . Top + 2 cm;
	END; 

   PageIndex:
        BEGIN
#ifdef US_PAPER
        Width: 14.6 cm;
        Height: 23.3 cm;
        HorizPos: Left = Enclosing . Left + 3.2 cm;
#else
        Width: 14 cm;
        Height: 25 cm;
        HorizPos: Left = Enclosing . Left + 3.5 cm;
#endif
        VertPos: Top = Enclosing . Top + 2 cm;
        IF (CptPageIndex > 0)  CreateAfter (NumPageIndex);
	IF (CptPageIndex > 1)  CreateAfter (HautTitreIndex);
	IF (CptTable > 0) CreateBefore (BasPage);
	CreateBefore (EspaceBasPage);
        END;

   BoiteVirgule:
        BEGIN
        Content: Text ', ';
	Font : Creator =;
	Size : Creator =;
	Style: Creator =;
	Foreground: Creator =;
	Background: Creator =;
        END;

   BoiteSujet:
        BEGIN
#ifdef ENGLISH
        Content: Text 'subject: ';
#else
        Content: Text 'sujet : ';
#endif
        VertPos: Top = Previous . Bottom + 0.2;
        HorizPos: Left = Enclosing . Left + 2.3;
        Visibility: 6;
        Font: Helvetica;
        Size : Creator =;
	Style: Bold;
	Foreground: Creator =;
	Background: Creator =;
       END;

   BoiteSemantique:
        BEGIN
#ifdef ENGLISH
        Content: Text 'semantics: ';
#else
        Content: Text 's\351mantique : ';
#endif
        VertPos: Top = Previous . Bottom + 0.2;
        HorizPos: Left = Enclosing . Left + 2.3;
        Visibility: 6;
        Font: Helvetica;
        Size : Creator=;
	Style: Bold;
	Foreground: Creator =;
	Background: Creator =;
        END;

   BoiteGlose:
        BEGIN
#ifdef ENGLISH
        Content: Text 'gloss:';
#else
        Content: Text 'glose :';
#endif
        VertPos: Top = Previous . Bottom + 0.2;
        HorizPos: Left = Enclosing . Left + 2.3;
        Visibility: 6;
        Font: Helvetica;
        Size : Creator=;
	Style: Bold;
	Foreground: Creator =;
	Background: Creator =;
        END;

   BoiteCles:
        BEGIN
#ifdef ENGLISH
        Content: Text 'key:';
#else
        Content: Text 'cl\351 (s) de tri :';
#endif
        HorizPos: Left = Enclosing . Left + 2.3;
        VertPos: Top = Previous . Top;
	Visibility: 6;
        Font: Helvetica;
        Size : Creator =;
	Style: Bold;
	Foreground: Creator =;
	Background: Creator =;
        END;

   NiveauCle:
        BEGIN
        Content : VarNiveauCle;
        VertPos: Bottom = Previous . Bottom;
        Visibility: 6;
 	Font : Creator =;
	Size : Creator =;
	Style: Italics;
	Foreground: Creator =;
	Background: Creator =;
       END;

  NumeroMarque:
        BEGIN
        VertPos: Bottom = Previous . Bottom;
	HorizPos: Left = Enclosing . Left + 0.5;  
        Content: Text '\253-';
	Visibility: 6;
	Font : Creator =;
	Size : Creator =;
        Style: Bold;
        Foreground: SkyBlue;
	Background: Creator =;
        END;

   BoiteRenvoi:
        BEGIN
#ifdef ENGLISH
        Content: Text 'see: ';
#else
        Content: Text 'voir : ';
#endif
        VertPos: Top = Previous . Bottom + 0.2;
        HorizPos: Left = Enclosing . Left + 2.3;
        Visibility: 6;
        Font: Helvetica;
        Size : Creator =;
	Style: Bold;
	Foreground: Creator =;
	Background: Creator =;
	END;

   NiveauCCle:
        BEGIN
        Content : VarNiveauCCle;
        VertPos: Bottom = Previous . Bottom;
        Visibility: 6;
	Font : Creator =;
        Size : Enclosing - 2;
	Style: Italics;
	Foreground: Creator =;
	Background: Creator =;
        END;

   BoiteTri:
        BEGIN
#ifdef ENGLISH
        Content: Text '\212Sorting:\240';
#else
        Content: Text '\212Tri\240:\240';
#endif
        Visibility: 6;
        Font: Helvetica;
        Size : Creator =;
	Style: Bold;
	Foreground: Creator =;
	Background: Creator =;
        END;

   BoiteTriAlpha:
        BEGIN
#ifdef ENGLISH
        Content: Text 'alphabetic order (mixing upper and lower cases)';
#else
        Content: Text 'alphab\351tique en groupant MAJ et min';
#endif
        Visibility: 6;
	Font : Creator =;
        Size : Creator =;
        Style: Italics;
	Foreground: Creator =;
	Background: Creator =;
        END;

   BoiteTriNum:
        BEGIN
#ifdef ENGLISH
        Content: Text 'numbers, then alphabetic order';
#else
        Content: Text 'chiffres, puis caract\350res alphab\351tiques';
#endif
        Visibility: 6;
	Font : Creator =;
        Size : Creator =;
        Style: Italics;
	Foreground: Creator =;
	Background: Creator =;
        END;

   BoiteTriTypo:
        BEGIN
#ifdef ENGLISH
        Content: Text 'alphabetic order (upper and lower cases separated)';
#else
        Content: Text 'alphab\351tique s\351parant MAJ et min';
#endif
        Visibility: 6;
	Font : Creator =;
        Size : Creator =;
        Style: Italics;
	Foreground: Creator =;
	Background: Creator =;
        END;

   BoiteTriPerso:
        BEGIN
#ifdef ENGLISH
        Content: Text 'order is defined in the file Fcode.tri';
#else
        Content: Text 'd\351fini dans Fcode.tri';
#endif
        Visibility: 6;
	Font : Creator =;
        Size : Creator =;
        Style: Italics;
	Foreground: Creator =;
	Background: Creator =;
        END;

   BoitePresRenvoi:
        BEGIN
#ifdef ENGLISH
        Content: Text '\212References:\240';
#else
        Content: Text '\212Pr\351sentation de renvois\240:\240';
#endif
        Visibility: 6;
        Font: Helvetica;
        Size : Creator =;
	Style: Bold;
	Foreground: Creator =;
	Background: Creator =;
        END;

   BoitePresPage:
        BEGIN
#ifdef ENGLISH
        Content: Text 'to page number';
#else
        Content: Text 'au num\351ro de la page';
#endif
        Visibility: 6;
	Font : Creator =;
        Size : Creator =;
        Style: Italics;
	Foreground: Creator =;
	Background: Creator =;
        END;

   BoitePresSect:
        BEGIN
#ifdef ENGLISH
        Content: Text 'to section number';
#else
        Content: Text 'au num\351ro de la section';
#endif
        Visibility: 6;
	Font : Creator =;
        Size : Creator =;
        Style: Italics;
	Foreground: Creator =;
	Background: Creator =;
        END;

   BoitePresTerme:   
        BEGIN
#ifdef ENGLISH
        Content: Text '\212Terms:\240'; 
#else
        Content: Text '\212Pr\351sentation des termes\240:\240'; 
#endif
        Visibility: 6;
        Size : Creator =;
        Font: Helvetica;
	Style: Bold;
	Foreground: Creator =;
	Background: Creator =;
        END;

   BoiteTermeMaj:
        BEGIN
#ifdef ENGLISH
        Content: Text 'in upper cases';
#else
        Content: Text 'tout en majuscules';
#endif
        Visibility: 6;
 	Font : Creator =;
        Size : Creator =;
        Style: Italics;
	Foreground: Creator =;
	Background: Creator =;
       END;

   BoiteTermeMin:      
        BEGIN
#ifdef ENGLISH
        Content: Text 'in lower cases';
#else
        Content: Text 'tout en minuscules';
#endif
        Visibility: 6;
 	Font : Creator =;
        Size : Creator =;
        Style: Italics; 
	Foreground: Creator =;
	Background: Creator =;
       END;

   BoiteTermeCap1:      
        BEGIN
#ifdef ENGLISH
        Content: Text 'capital at level 1';
#else
        Content: Text 'avec une capitale au niveau 1';
#endif
        Visibility: 6;
 	Font : Creator =;
        Size : Creator =;
        Style: Italics; 
	Foreground: Creator =;
	Background: Creator =;
       END;

   BoiteTermeCap:      
        BEGIN
#ifdef ENGLISH
        Content: Text 'capital at any level';
#else
        Content: Text 'avec une capitale initiale';
#endif
        Visibility: 6;
	Font : Creator =;
        Size : Creator =;
        Style: Italics; 
	Foreground: Creator =;
	Background: Creator =;
        END;

   BoiteTermeTQ:
        BEGIN
#ifdef ENGLISH
        Content: Text 'unchanged';
#else
        Content: Text 'tel quel';
#endif
        Visibility: 6;
 	Font : Creator =;
        Size : Creator =;
        Style: Italics;
	Foreground: Creator =;
	Background: Creator =;
         END;

   BoitePresGroupe:
        BEGIN
#ifdef ENGLISH
        Content: Text '\212Group titles:\240';
#else
        Content: Text '\212Pr\351sentation des titres de groupe\240:\240';
#endif
        Visibility: 6;
        Font: Helvetica;
        Size : Creator =;
	Style: Bold;
	Foreground: Creator =;
	Background: Creator =;
        END;

   BoitePresVisible:
        BEGIN
#ifdef ENGLISH
        Content: Text 'visible';
#else
        Content: Text 'visibles';
#endif
        Visibility: 6;
  	Font : Creator =;
        Size : Creator =;
        Style: Italics;
	Foreground: Creator =;
	Background: Creator =;
        END;

   BoitePresNonVisible:
        BEGIN
#ifdef ENGLISH
        Content: Text 'unvisible';
#else
        Content: Text 'non visibles';
#endif
        Visibility: 6;
  	Font : Creator =;
        Size : Creator =;
        Style: Italics;
	Foreground: Creator =;
	Background: Creator =;
        END;

   BoiteIdxGroupe:
        BEGIN
#ifdef ENGLISH
        Content: Text 'Groups of letters\240:\240';
#else
        Content: Text 'Entr\351es \340 grouper\240:\240';
#endif
	Indent: - 1.5 cm;
        VertPos: Top = Previous . Bottom + 0.2;
        HorizPos: Left = Enclosing . Left;
	Visibility: 6;
        Font: Helvetica;
        Size : Creator =;
	Style: Bold;
	Foreground: Creator =;
	Background: Creator =;
        END;
 
   BoiteIdxTitre:
        BEGIN
	Visibility: 6;
#ifdef ENGLISH
        Content: Text 'Index\240title:\240';
#else
        Content: Text 'Titre de cet index\240:\240';
#endif
        Font: Helvetica;
	Style: Bold;
        Size : Creator =;
	Foreground: Creator =;
	Background: Creator =;
        END;

   BoiteIdxSujet:
        BEGIN
	Visibility: 6;
#ifdef ENGLISH
        Content: Text 'Relevant subjects:\240';
#else
        Content: Text 'Sujets \340 retenir (par d\351faut = tous)\240:\240';
#endif
        Font: Helvetica;
        Size : Creator =;
	Style: Bold;
	Foreground: Creator =;
	Background: Creator =;
        END;
 
  BoitePresSujet:   
        BEGIN
        Visibility: 6;
#ifdef ENGLISH
        Content: Text '\212Presentation of the terms:\240'; 
#else
        Content: Text '\212Pr\351sentation des termes de ce sujet\240:\240'; 
#endif
        Font: Helvetica;
        Size : Creator =;
	Style: Bold;
	Foreground: Creator =;
	Background: Creator =;
        END;

   BoiteSujetGras:
        BEGIN
        Visibility: 6;
#ifdef ENGLISH
        Content: Text 'bold';
#else
        Content: Text 'en gras';
#endif
  	Font : Creator =;
        Size : Creator =;
        Style: Italics;
	Foreground: Creator =;
	Background: Creator =;
        END;

   BoiteSujetItalique:
        BEGIN
        Visibility: 6;
#ifdef ENGLISH
        Content: Text 'italics';
#else
        Content: Text 'en italique';
#endif
  	Font : Creator =;
        Size : Creator =;
        Style: Italics;
	Foreground: Creator =;
	Background: Creator =;
        END;

   BoiteSujetItalGras:
        BEGIN
        Visibility: 6;
#ifdef ENGLISH
        Content: Text 'italics and bold';
#else
        Content: Text 'en italique gras';
#endif
  	Font : Creator =;
        Size : Creator =;
        Style: Italics;
	Foreground: Creator =;
	Background: Creator =;
        END;

   BoiteSujetRomain:
        BEGIN
        Visibility: 6;
#ifdef ENGLISH
        Content: Text 'roman';
#else
        Content: Text 'en romain';
#endif
  	Font : Creator =;
        Size : Creator =;
        Style: Italics;
	Foreground: Creator =;
	Background: Creator =;
        END;

   BoiteIdxIntro:
        BEGIN
#ifdef ENGLISH
        Content: Text 'Introduction:\240';
#else
        Content: Text 'Commentaire \340 introduire en d\351but de table\240:\240';
#endif
        VertPos: Top = Previous . Bottom + 0.3;
	HorizPos: Left = Enclosing . Left;
	Visibility: 6;
        Font: Helvetica;
        Size : Creator =;
	Style: Bold;
	Foreground: Creator =;
	Background: Creator =;
        END;
 
RULES

  First Marque_Index:
	BEGIN
	Content: Text '\253';
        Foreground: SkyBlue;
	Visibility: 4;
{**428*}VertPos : Top = Previous NOT First Marque_Index . Bottom;
{**428*}HorizPos : Left = Previous NOT Second Marque_Index . Left + 0.8;
   	END;

  Second Marque_Index:
        BEGIN
	Content: Text '\273';
        Foreground: SkyBlue;
        Visibility: 4;
{**428*}VertPos : Top = Previous NOT Second Marque_Index . Bottom;
{**428*}HorizPos : Left = Previous NOT First Marque_Index . Left + 0.8;
  	END;

   Index_tables:
	BEGIN
	Page(PageTables);
	Font: times;
	Size : 11 pt;
	Width: Enclosing . Width - 1.2;
	HorizPos: Left = Enclosing . Left + 0.6;
	Visibility: 10;
	Indent: 0;
	Justify: Yes;
	LineSpacing: 1.2;
	END;

  Index_table:
        BEGIN
	Page(PageIndex);
	Indent: 1;
        Width: Enclosing . Width;
   	HorizPos: Left = Enclosing . Left;
   	VertPos: Top = Previous Index_table. Bottom;
        CreateFirst(NumeroIndex);
        END;

  Titre_Index:
        BEGIN
        Width: Enclosing . Width * 80%;
        Size : Enclosing + 6;
        Style: Roman;
        VertPos: Top = NumeroIndex . Bottom + 0.5;
        HorizPos: VMiddle = Enclosing . VMiddle;
        PageBreak: No;
        Line;
        Adjust: VMiddle;
        Justify: No;
        Indent: 0;
        END;

  Intro_Index:
        BEGIN
        Width: Enclosing . Width * 80%;
        Style: Italics;
        HorizPos : VMiddle = Enclosing . VMiddle;
        VertPos : Top = Previous . Bottom + 2;
        Indent: 0;
        END;

   Contenu_Index:
        BEGIN
        VertPos: Top = Previous . Bottom + 30 pt;
        Width: Enclosing . Width - 2.5;
        HorizPos: Left = Enclosing . Left + 2.5;
	NoBreak1:2;
        Indent: 0;
        END;

   Car_Index:
        BEGIN
	NoBreak1 : 2 cm;
        VertPos: Top = Previous . Bottom;
        Width: Enclosing . Width;
        HorizPos: Left = Enclosing . Left;
        END;

   Titre_Car:
        BEGIN
        Font: helvetica;
        Size: Enclosing + 1;
        Style: Bold;
        VertPos: Top = Enclosing . Top + 1.5;
        HorizPos: Left = Enclosing . Left;
        Width: Enclosing . Width;
        Line;
        END;

   Car:
        BEGIN
        IF NOT First CreateBefore (TiretCar);
        END;

   Contenu_Car:
        BEGIN
        Font: times;
        VertPos: Top = Previous . Bottom + 0.2;
        HorizPos: Left = Enclosing . Left;
        Width: Enclosing . Width;
        END;

   Elem_Index:
        BEGIN
        Width: Enclosing . Width;
        HorizPos: Left = Enclosing . Left;
        VertPos: Top = Previous . Bottom + 0.1;
        PageBreak: No;
        Justify : No;
        END;

   Entr\351e:
        BEGIN
	Width: Enclosing . Width;
        VertPos: Top = Previous Entr\351e1 . Bottom + 0.2;
	LineSpacing : 0.7; 
	Indent : - 1;	
        Line;
        END;

   Suite_entr\351e:
        BEGIN
        HorizPos: Left = Enclosing . Left + 1;
        VertPos: Top = Previous . Bottom;
        Width : Enclosing . Width - 1;
        END;

   Entr\351e1:
        BEGIN
        HorizPos: Left = Enclosing Suite_entr\351e . Left;
        VertPos: Top = Previous Entr\351e1 . Bottom + 0.1;
        Width: Enclosing . Width;
        END;

   Suite_entr\351e1:
        BEGIN
        HorizPos: Left = Enclosing . Left + 1;
        VertPos: Top = Previous . Bottom;
        Width : Enclosing . Width - 1;
        END;

   Entr\351e2:
        BEGIN
        HorizPos: Left = Enclosing Suite_entr\351e1 . Left;
        VertPos: Top = Previous Entr\351e2 . Bottom + 0.1;
        Width: Enclosing . Width;
        END;

   Suite_entr\351e2:
        BEGIN
	HorizPos: Left = Enclosing. Left + 1;
        VertPos: Top = Previous . Bottom;
        Width: Enclosing . Width - 1;
        END;

   Entr\351e3:
        BEGIN
	HorizPos: Left = Enclosing Suite_entr\351e2 . Left;
        VertPos: Top = Previous Entr\351e3 . Bottom + 0.1;
        Width: Enclosing . Width;
        END;

   Terme:
        BEGIN
        END;

   Commentaire:
        BEGIN
        CreateBefore (VirguleBlanc);
        Style: Italics;
        END;

   Liste_des_Ref:
        BEGIN
#ifdef NOREF
	Visibility: 0;
#else
        CreateBefore (DeuxPointsBlanc);
        VertPos: Top = Previous . Top;
        Width: Enclosing . Width - 7;
#endif
        END;

   Liste_crois\351e:
        BEGIN
#ifdef NOREF
	Visibility: 0;
#else
        IF First CreateBefore (See);
        IF NOT First CreateBefore (SeeAlso);
#endif
        END;

   RefDirecte:
        BEGIN
#ifdef NOREF
	Visibility: 0;
#else
        IF NOT First CreateBefore (VirguleBlanc);
#endif
        END;

   RefCrois\351e:
        BEGIN
#ifdef NOREF
	Visibility: 0;
#else
        IF NOT First CreateBefore (VirguleBlanc);
#endif
        END;

   RefCr:
        BEGIN
#ifdef NOREF
	Visibility: 0;
#else
        Copy(Terme);
#endif
        END;

   NoteNum:
        BEGIN
#ifdef NOREF
	Visibility: 0;
#else
        Size: Enclosing -2 min 6;
	Style: Italics;
	CreateBefore(BoiteNumNote);
	CreateAfter(BoiteParNote);
        LineBreak: No;
#endif
        END;

   PageUnique:
        BEGIN
#ifdef NOREF
	Visibility: 0;
#else
 	Foreground : Red;
        LineBreak: No;
#endif
        END;

   PageDebut:
        BEGIN
#ifdef NOREF
	Visibility: 0;
#else
 	Foreground : Red;
        LineBreak: No;
#endif
        END;

   PageFin:
        BEGIN
#ifdef NOREF
	Visibility: 0;
#else
        VertPos: Top = Enclosing . Top;
        HorizPos: Left = Previous . Right;
	Foreground : Red;
        CreateBefore (Tiret);
        LineBreak: No;
#endif
        END;

   Vers_crois\351e :
      BEGIN
#ifdef NOREF
	Visibility: 0;
#else
        Content : TEXT '--x->';
        HorizPos: Left = Previous . Right;
        VertPos: Top = Previous . Top;
        Visibility: 4;
#endif
      END;

   Vers_descripteur:
        BEGIN
#ifdef NOREF
	Visibility: 0;
#else
	Visibility: 4;
        Content : TEXT '-->';
        HorizPos: Left = Previous . Right;
#endif
        VertPos: Top = Previous . Top;
        END;

   PAGE_BREAK:
        BEGIN
	Background : White;
	HorizOverflow: Yes;
	Foreground : Black;
	Fillpattern : nopattern;
        END;

   TEXT_UNIT:
	BEGIN
	HorizRef: Enclosed . HRef;
	END;

   Descripteurs:
	BEGIN
	Font: Helvetica;
	CreateFirst(BoiteDescripteur);
	Size : 11 pt;
	Width: Enclosing . Width - 1.2;
	HorizPos: Left = Enclosing . Left + 0.6;
 	Visibility: 10;
	Indent: 0;
	Justify: Yes;
	LineSpacing: 1.2;
	END;

   Descripteur:
	BEGIN
	IF Referred
		CreateBefore(BlueNumeroDesc);
	IF NOT Referred
		CreateBefore (NumeroDesc);
	Width: Enclosing . Width;
	HorizPos: Left = Enclosing . Left;
        VertPos: HRef = Previous  . HRef;
	LineBreak: No;
	END;

   Cl\351s:
        BEGIN
        CreateBefore (BoiteCles);
        HorizPos: Left = Enclosing . Left + 9;
        VertPos: Top = Enclosing . Top;
        Width: Enclosing . Width - 9;
        Line;
        END;
 
   Cl\351:
        BEGIN
        VertPos: Top = Previous . Top;
        CreateBefore (NiveauCle);
	CreateAfter (BoiteVirgule);
        END;

   Sujet:
        BEGIN
        CreateBefore(BoiteSujet);
        HorizPos: Left = Enclosing . Left + 9;
        VertPos: Top = Previous . Top;
        Width: Enclosing . Width - 9;
        Line;
        END;

  S\351mantique:
        BEGIN
        CreateBefore(BoiteSemantique);
        HorizPos: Left = Enclosing . Left + 9;
        VertPos: Top = Previous . Top;
        Width: Enclosing . Width - 9;
        Line;
        END;

  Glose:
        BEGIN
        CreateBefore(BoiteGlose);
        HorizPos: Left = Enclosing . Left + 9;
        VertPos: Top = Previous . Top;
        Width: Enclosing . Width - 9;
        Line;
        END;

   Renvois:
	BEGIN
	Font: Helvetica;
	CreateFirst(BoiteCrois\351e);
	Size : 11 pt;
	Width: Enclosing . Width - 1.2;
	HorizPos: Left = Enclosing . Left + 0.6;
	Visibility: 10;
	Indent: 0;
	Justify: Yes;
	LineSpacing: 1.2;
	END;

   Renvoi:
	BEGIN
	CreateBefore (NumeroCrois\351);
	Width: Enclosing . Width - 2.3;
	HorizPos: Left = Enclosing . Left + 2.3;
        VertPos: HRef = Previous  . HRef;
{        VertPos: Top = Previous NumeroCrois\351 . Top; }
	LineBreak: No;
	END;

   CCl\351s:
        BEGIN
        CreateBefore (BoiteCles);
        HorizPos: Left = Enclosing . Left + 9;
        VertPos: Top = Previous . Top;
        Width: Enclosing . Width - 9;
        Line;
        END;
 
   CCl\351:
        BEGIN
        VertPos: Top = Previous . Top;
        CreateBefore (NiveauCCle);
        CreateAfter (BoiteVirgule);
        END;

   RenvoiCl\351s:
        BEGIN
        CreateBefore (BoiteRenvoi);
        Copy(Cl\351s);
        HorizPos: Left = Enclosing . Left + 9;
        VertPos: Top = Previous . Top;
        Width: Enclosing . Width - 9;
        Line;
        END;

   Options:
	BEGIN
 	Visibility: 10;
	Font: Helvetica;
	CreateFirst(BoiteOption);
	Size : 11 pt;
	Width: Enclosing . Width - 1.2;
	HorizPos: Left = Enclosing . Left + 0.6;
	Indent: 0;
	Justify: Yes;
	LineSpacing: 1.2;
	END;

   Option:
	BEGIN
        CreateBefore (NumeroOption);
	Width: Enclosing . Width - 1.6;
        VertPos: HRef = Previous  . HRef;
        HorizPos: Left = Enclosing . Left + 1.6;
	LineBreak: No;
	END;

   Idx_Titre:
        BEGIN
	CreateFirst(BoiteIdxTitre);
	Indent: - 1 cm;
        VertPos: Top = Enclosing . Top;
	Width: Enclosing . Width;
	HorizPos: Left = Enclosing . Left;
        Line;
        END;

   Idx_Sujets:
        BEGIN
        CreateFirst(BoiteIdxSujet);
	Indent: - 1 cm;
 	Width: Enclosing . Width;
	HorizPos: Left = Enclosing . Left;
	VertPos: Top = Previous . Bottom + 0.3;
        END;

   Idx_Sujet:
        BEGIN
        HorizPos: Left = Enclosing . Left + 1.5;
        VertPos: Top = Previous . Bottom + 0.2;
	Width: Enclosing . Width - 1.5;
        Line;
        END;

   Idx_Groupes:
        BEGIN
        CreateFirst(BoiteIdxGroupe);
	Width: Enclosing . Width;
	HorizPos: Left = Enclosing . Left;
        VertPos: Top = Previous . Bottom + 0.3;
        END;

   Idx_Groupe:
        BEGIN
	HorizPos: Left = Enclosing . Left + 1;
        VertPos: Top = Previous . Bottom + 0.2;
	Width: Enclosing . Width;
        Line;
        END;

   Idx_CarGroupe:
        BEGIN
        HorizPos: Left = Enclosing . Left + 1 cm;
        VertPos: Top = Previous . Bottom + 0.2;
        Width: Enclosing . Width - 1 cm;
        Line;
        END;

    Idx_CarElem:
        BEGIN
	CreateAfter (BoiteVirgule);
	Width: 1.2;
        END;

   Idx_Intro:
        BEGIN
        Width : Enclosing . Width - 1.5;
	CreateBefore(BoiteIdxIntro);
        HorizPos : Left = Enclosing . Left + 1.5;
        VertPos: Top = Previous . Bottom + 0.2;
        END;

ATTRIBUTES

   A_Vers_descripteur:
        BEGIN
        UnderLine: Underlined;
	Size: Enclosing + 4;
        Style: Bold;
	END;
			   
   Niveau = Gras:
        BEGIN
        Font: Times;
        Style: Bold;
        END;

   Niveau = Italique:
        BEGIN
        Font: Times;
        Style: Italics;
        END;

   Niveau = ItalGras:
        BEGIN
        Font: Times;
        Style: BoldItalics;
        END;

   Niveau = Romain:
        BEGIN
        Font: Times;
        Style: Roman;
        END;

   Force = Fort :
        BEGIN
        Font: Times;
        Style: Bold;
        END;

   Force = Normal:
        BEGIN
        Font: Times;
        Style: Roman;
        END;

   Force = Faible:
        BEGIN
        Font: Times;
        Style: Italics;
        END;

   Pres_Ref(PageUnique) = Par_section:
	CreateBefore(NumSectUnique);

   Pres_Ref(PageIntervalle) = Par_section:
	CreateBefore (NumSectIntervalle);

   Pres_Car(Titre_Car) = Visible:
	BEGIN
	Visibility: 5; 
	END;

   Pres_Car(Titre_Car) = NonVisible:
	BEGIN
	Visibility: 0; 
	END;

   Valeur = faible:
        BEGIN
	Style: Italics;
        END;

   Valeur = moyenne:
        BEGIN
	Style: Roman;
        END;

   Valeur = forte:
        BEGIN
	Style: Bold;
        END;

   Vers_marque1:
        BEGIN
	CreateFirst(NumeroMarque);
        HorizPos: Left = Enclosing . Left + 2;
        END;

   Tri = Alpha :
	BEGIN
        CreateLast(BoiteTri);
	CreateLast(BoiteTriAlpha);
	END;
   Tri = Num :
	BEGIN
        CreateLast (BoiteTri);
        CreateLast(BoiteTriNum);
	END;
   Tri = Typo :
        BEGIN
        CreateLast (BoiteTri);
        CreateLast(BoiteTriTypo);
        END;
   Tri = Personnel :
        BEGIN
        CreateLast (BoiteTri);
        CreateLast(BoiteTriPerso);
        END;

  Pres_Renvoi = Par_page :
	BEGIN
        CreateLast(BoitePresRenvoi);
        CreateLast(BoitePresPage);
	END;
  Pres_Renvoi = Par_section :
	BEGIN
        CreateLast (BoitePresRenvoi);
        CreateLast(BoitePresSect);
	END;

  Pres_Terme = MAJUSCULES :
        BEGIN
        CreateLast(BoitePresTerme);
        CreateLast(BoiteTermeMaj);
        END;
  Pres_Terme = Minuscules :      
        BEGIN
        CreateLast(BoitePresTerme); 
        CreateLast(BoiteTermeMin);    
        END;
  Pres_Terme = Une_capitale:      
        BEGIN
        CreateLast(BoitePresTerme); 
        CreateLast(BoiteTermeCap1);    
        END;
  Pres_Terme = Des_capitales :      
        BEGIN
        CreateLast(BoitePresTerme); 
        CreateLast(BoiteTermeCap);    
        END;
  Pres_Terme = Tel_quel :      
        BEGIN
        CreateLast(BoitePresTerme); 
        CreateLast(BoiteTermeTQ);    
        END;

  Pres_Groupe = Visible :
	BEGIN
        CreateLast(BoitePresGroupe);
        CreateLast(BoitePresVisible);
	END;
 Pres_Groupe = NonVisible :
	BEGIN
        CreateLast(BoitePresGroupe);
        CreateLast(BoitePresNonVisible);
	END;

  Pres_Sujet = Gras :      
        BEGIN
        CreateLast(BoitePresSujet); 
        CreateLast(BoiteSujetGras);    
        END;
  Pres_Sujet = Italique :      
        BEGIN
        CreateLast(BoitePresSujet); 
        CreateLast(BoiteSujetItalique);    
        END;
  Pres_Sujet = ItalGras :      
        BEGIN
        CreateLast(BoitePresSujet); 
        CreateLast(BoiteSujetItalGras);    
       END;
  Pres_Sujet = Romain :      
        BEGIN
        CreateLast(BoitePresSujet); 
        CreateLast(BoiteSujetRomain);    
        END;

END
