/****************************************************************************
** $Id: qfontdta.h,v 2.5 1997/03/26 22:21:54 hanord Exp $
**
**		      ***   INTERNAL HEADER FILE   ***
**
**		This file is NOT a part of the Qt interface!
**
*** Definition of QFontData struct
**
** Created : 941229
**
** Copyright (C) 1992-1997 Troll Tech AS.  All rights reserved.
**
** This file is part of the non-commercial distribution of Qt 1.2.
**
** See the file LICENSE included in the distribution for the usage
** and distribution terms, or http://www.troll.no/qt/license.html.
**
** (This file differs from the one in the commercial distribution of
** Qt only by this comment.)
**
*****************************************************************************/

#ifndef QFONTDTA_H
#define QFONTDTA_H


struct QFontDef {				// font definition
    QString	family;
    short	pointSize;
    uint	styleHint	: 8;
    uint	charSet		: 8;
    uint	weight		: 8;
    uint	italic		: 1;
    uint	underline	: 1;
    uint	strikeOut	: 1;
    uint	fixedPitch	: 1;
    uint	hintSetByUser	: 1;
    uint	rawMode		: 1;
    uint	dirty		: 1;
};


class QFontInternal;

struct QFontData : public QShared {
    QFontData()
	: exactMatch(FALSE), fin(0)
	{}
    QFontData( const QFontData &d )
	: req(d.req), exactMatch(d.exactMatch), fin(d.fin)
	{}
   ~QFontData()
	{}
    QFontData &operator=( const QFontData &d )
	{
	    req = d.req;
	    exactMatch = d.exactMatch;
	    fin = d.fin;
	    return *this;
	}
    QFontDef	    req;			// requested font
    bool	    exactMatch;
    QFontInternal  *fin;
};


#endif // QFONTDTA_H
