/****************************************************************************
** $Id: qconnect.cpp,v 2.1 1996/11/25 15:25:51 hanord Exp $
**
** Implementation of QConnection class
**
** Created : 930417
**
** Copyright (C) 1992-1997 Troll Tech AS.  All rights reserved.
**
** This file is part of the non-commercial distribution of Qt 1.2.
**
** See the file LICENSE included in the distribution for the usage
** and distribution terms, or http://www.troll.no/qt/license.html.
**
** (This file differs from the one in the commercial distribution of
** Qt only by this comment.)
**
*****************************************************************************/

#include "qconnect.h"

RCSTAG("$Id: qconnect.cpp,v 2.1 1996/11/25 15:25:51 hanord Exp $");


/*!
  \class QConnection qconnect.h

  \brief The QConnection class is an internal class, used in the
  signal/slot mechanism.

  Do not use this class directly in application programs.

  \internal
  QObject has a list of QConnection for each signal that is connected to the
  outside world.
*/


QConnection::QConnection( const QObject *object, QMember member,
			  const char *memberName )
{
    obj = (QObject *)object;
    mbr = member;
    mbr_name = memberName;
    nargs = 0;
    if ( strstr(memberName,"()") == 0 ) {
        const char *p = memberName;
	nargs++;
	while ( *p ) {
	    if ( *p++ == ',' )
		nargs++;
	}
    }
}
