/****************************************************************************
** $Id: qstrlist.h,v 2.1 1996/10/06 19:13:51 agulbra Exp $
**
** Definition of QStrList, QStrIList and QStrListIterator classes
**
** Created : 920730
**
** Copyright (C) 1992-1997 Troll Tech AS.  All rights reserved.
**
** This file is part of the non-commercial distribution of Qt 1.2.
**
** See the file LICENSE included in the distribution for the usage
** and distribution terms, or http://www.troll.no/qt/license.html.
**
** (This file differs from the one in the commercial distribution of
** Qt only by this comment.)
**
*****************************************************************************/

#ifndef QSTRLIST_H
#define QSTRLIST_H

#include "qstring.h"
#include "qlist.h"
#include "qdstream.h"


#if defined(DEFAULT_TEMPLATECLASS)
typedef QListT<char>			QStrListBase;
typedef QListIteratorT<char>		QStrListIterator;
#else
typedef Q_DECLARE(QListM,char)		QStrListBase;
typedef Q_DECLARE(QListIteratorM,char)	QStrListIterator;
#endif


class QStrList : public QStrListBase
{
public:
    QStrList( bool deepCopies=TRUE ) { dc = deepCopies; }
   ~QStrList()	{ clear(); }
private:
    GCI	  newItem( GCI d )	{ return dc ? qstrdup( (const char*)d ) : d; }
    void  deleteItem( GCI d )	{ if ( dc ) delete[] (char*)d; }
    int	  compareItems( GCI s1, GCI s2 )
				{ return strcmp((const char*)s1,
						(const char*)s2); }
    QDataStream &read( QDataStream &s, GCI &d )
				{ s >> (char *&)d; return s; }
    QDataStream &write( QDataStream &s, GCI d ) const
				{ return s << (const char *)d; }
    bool  dc;
};


class QStrIList : public QStrList		// case insensitive string list
{
public:
    QStrIList( bool deepCopies=TRUE ) : QStrList( deepCopies ) {}
   ~QStrIList() { clear(); }
private:
    int	  compareItems( GCI s1, GCI s2 )
				{ return stricmp((const char*)s1,
						 (const char*)s2); }
};


#endif // QSTRLIST_H
