/**********************************************************************
** $Id: qlabel.h,v 2.1 1997/03/13 20:01:21 agulbra Exp $
**
** Definition of QLabel widget class
**
** Created : 941215
**
** Copyright (C) 1992-1997 Troll Tech AS.  All rights reserved.
**
** This file is part of the non-commercial distribution of Qt 1.2.
**
** See the file LICENSE included in the distribution for the usage
** and distribution terms, or http://www.troll.no/qt/license.html.
**
** (This file differs from the one in the commercial distribution of
** Qt only by this comment.)
**
*****************************************************************************/

#ifndef QLABEL_H
#define QLABEL_H

#include "qframe.h"


class QLabel : public QFrame
{
    Q_OBJECT
public:
    QLabel( QWidget *parent=0, const char *name=0, WFlags f=0 );
    QLabel( const char *text, QWidget *parent=0, const char *name=0,
	    WFlags f=0 );
    QLabel( QWidget * buddy, const char * text,
	    QWidget * parent, const char * name=0, WFlags f=0 );
   ~QLabel();

    const char *text()		const	{ return ltext; }
    QPixmap    *pixmap()	const	{ return lpixmap; }

    int		alignment()	const	{ return align; }
    void	setAlignment( int );
    int		margin()	const	{ return extraMargin; }
    void	setMargin( int );

    bool	autoResize()	const	{ return autoresize; }
    void	setAutoResize( bool );
    QSize	sizeHint() const;

    void	setBuddy( QWidget * );
    QWidget *   buddy() const;

public slots:
    void	setText( const char * );
    void	setPixmap( const QPixmap & );
    void	setNum( int );
    void	setNum( double );

protected:
    void	drawContents( QPainter * );

private slots:
    void	acceleratorSlot();
    void	buddyDied();

private:
    void	updateLabel();
    QString	ltext;
    QPixmap    *lpixmap;
    int		extraMargin;
    int		align;
    bool	autoresize;

private:	// Disabled copy constructor and operator=
    QLabel( const QLabel & ) {}
    QLabel &operator=( const QLabel & ) { return *this; }
};


#endif // QLABEL_H
