(***********************************************************************)
(*                                                                     *)
(*                           Objective Caml                            *)
(*                                                                     *)
(*            Xavier Leroy, projet Cristal, INRIA Rocquencourt         *)
(*                                                                     *)
(*  Copyright 1996 Institut National de Recherche en Informatique et   *)
(*  Automatique.  Distributed only by permission.                      *)
(*                                                                     *)
(***********************************************************************)

(* $Id: typedecl.mli,v 1.9 1996/09/23 11:33:21 xleroy Exp $ *)

(* Typing of type definitions and primitive definitions *)

open Types

val transl_type_decl:
        Env.t -> (string * Parsetree.type_declaration) list ->
                                  (Ident.t * type_declaration) list * Env.t
val transl_exception:
        Env.t -> Parsetree.exception_declaration -> exception_declaration

val transl_value_decl:
        Env.t -> Parsetree.value_description -> value_description

val transl_with_constraint:
        Env.t -> Parsetree.type_declaration -> type_declaration
    
type error =
    Repeated_parameter
  | Duplicate_constructor of string
  | Too_many_constructors
  | Duplicate_label of string
  | Recursive_abbrev of string
  | Definition_mismatch of type_expr
  | Illdefined_abbrev of string

exception Error of Location.t * error

val report_error: error -> unit
