#!/bin/sh
# This script runs MMM after merging user options with default options

### BEGINNING OF CONFIGURATION
# CHECK: INSTALLDIR should be the same as in Makefile.config
INSTALLDIR=/usr/local/lib/mmm

# CHECK: the MMM_MAIL variable
# for use with the internal mailto: interface. This command *must* be
# compatible with /usr/ucb/mail, that is, accept
# $ $MMM_MAIL -s subject address < msg_body
# If left undefined, MMM will use the first "mail" command in the user's PATH
# We suggest the following:
if [ -f /bin/mail ]; then
  MMM_MAIL=/bin/mail
  export MMM_MAIL
fi

# CHECK: bin points to the binary, copied as $(INSTALLDIR)/mmm.bin
# during installation.
bin=$INSTALLDIR/mmm.bin

# CHECK: default proxy host. Can be overidden by users.
proxy=www-proxy.domain
port=80

# CHECK: the I18N message file
msgfile=$INSTALLDIR/msgs.txt

# CHECK: Set your language. It is used with the I18N message file.
# Note for Japanese users: 
#   You must specify "jpn" for -lang, even if you set $LANG="ja" or whatever.
lang=$LANG

# CHECK: Url for default location of doc
# Set this to where you installed the doc. It can be a local url,
# an url on your server. Please do *not* point directly to our doc page.
helpurl=http://pauillac.inria.fr/~rouaix/mmm/doc.html


### END OF CONFIGURATION

# Below this line, there should be nothing to change

# This switch shound contain all possible options of mmm.bin
# For options with values in this file, do not add to opts.
while : ; do
  case $1 in
    "") break;;
   -proxy) proxy=$2; shift;;
   -port) port=$2; shift;;
   -d) display=$2; shift;;
   -display) display=$2; shift;;
   -suffixes) suffixes=$2; shift;;
   -external) opts="$opts -external";;
   -lang) lang=$2; shift;;
   -msgfile) msgfile=$2; shift;;
   -prefs) prefs=$2; shift;;
   -helpurl) helpurl=$2; shift;;
    *) opts="$opts $1";;
   esac
   shift
done

# Rebuild command line
args=
[ "$proxy" ] && args="$args -proxy $proxy"
[ "$port" ] && args="$args -port $port"
[ "$display" ] && args="$args -display $display"
[ "$suffixes" ] && args="$args -suffixes $suffixes"
# external is in opts
[ "$lang" ] && args="$args -lang $lang"
[ "$msgfile" ] && args="$args -msgfile $msgfile"
[ "$prefs" ] && args="$args -prefs $prefs"
[ "$helpurl" ] && args="$args -helpurl $helpurl"
[ "$opts" ] && args="$args $opts"

exec $bin $args


