/*
** filelocList.h (from slist_templace.h)
*/

# ifndef filelocLIST_H
# define filelocLIST_H

abst_typedef /*@null@*/ struct _filelocList
{
  int nelements;
  int free;
  /*@reldef@*/ /*@relnull@*/ o_fileloc *elements;
} *filelocList ;

extern /*@unused@*/ /*@truenull@*/ bool
  filelocList_isUndefined (filelocList f) /*@*/ ;
extern /*@falsenull@*/ bool filelocList_isDefined (filelocList f);

/*@constant null filelocList filelocList_undefined; @*/
# define filelocList_undefined (NULL)
# define filelocList_isDefined(f)   ((f) != filelocList_undefined)
# define filelocList_isUndefined(f) ((f) == filelocList_undefined)

/*@iter filelocList_elements (sef filelocList x, yield exposed fileloc el); @*/
# define filelocList_elements(x, m_el) \
   { if (filelocList_isDefined (x)) { \
      int m_ind; fileloc *m_elements = &((x)->elements[0]); \
      for (m_ind = 0 ; m_ind < (x)->nelements; m_ind++) \
         { fileloc m_el = *(m_elements++); 

# define end_filelocList_elements }}}

extern int filelocList_realSize (filelocList s) /*@*/ ;

extern int filelocList_size (/*@sef@*/ filelocList s) /*@*/ ;
# define filelocList_size(s)    (filelocList_isDefined (s) ? (s)->nelements : 0)

extern bool filelocList_isEmpty (/*@sef@*/ filelocList s);
# define filelocList_isEmpty(s) (filelocList_size(s) == 0)

extern filelocList 
  filelocList_append (/*@returned@*/ filelocList s, /*@only@*/ filelocList t);
extern /*@only@*/ filelocList filelocList_new (void) /*@*/ ;
extern filelocList 
  filelocList_add (/*@returned@*/ filelocList s, /*@only@*/ fileloc el)
   /*@modifies s@*/ ;

extern filelocList 
  filelocList_addDifferentFile (/*@returned@*/ filelocList s, 
				fileloc where, fileloc loc)
   /*@modifies s@*/ ;

extern filelocList filelocList_addUndefined (/*@returned@*/ filelocList s)
   /*@modifies s@*/ ;

extern /*@only@*/ cstring filelocList_unparseUses (filelocList s);
extern /*@unused@*/ /*@only@*/ cstring filelocList_unparse (filelocList s) ;
extern void filelocList_free (/*@only@*/ filelocList s) ;

/*@constant int filelocListBASESIZE;@*/
# define filelocListBASESIZE MIDBASESIZE

# endif




