/*
 * defines for the system specific memory routines
 *
 * Copyright 1995 by Gray Watson
 *
 * This file is part of the dmalloc package.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * NON-COMMERCIAL purpose and without fee is hereby granted, provided
 * that the above copyright notice and this permission notice appear
 * in all copies, and that the name of Gray Watson not be used in
 * advertising or publicity pertaining to distribution of the document
 * or software without specific, written prior permission.
 *
 * Please see the PERMISSIONS file or contact the author for information
 * about commercial licenses.
 *
 * Gray Watson makes no representations about the suitability of the
 * software described herein for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * The author may be contacted at gray.watson@letters.com
 *
 * $Id: heap.h,v 1.29 1995/09/06 17:37:02 gray Exp $
 */

#ifndef __HEAP_H__
#define __HEAP_H__

#include "dmalloc_loc.h"			/* for LOCAL and BLOCK_SIZE */

/*
 * error code returned by heap allocation routine
 */
#define HEAP_ALLOC_ERROR	0L

/*
 * probably machine specific defines used for certain calculations
 */
#if HEAP_GROWS_UP

/* test whether pointer PNT is in the heap space */
#define IS_IN_HEAP(pnt)		\
  ((char *)(pnt) >= (char *)_heap_base && (char *)(pnt) < (char *)_heap_last)

/* turn pointer PNT into a block index */
#define WHICH_BLOCK(pnt)	\
  (((char *)(pnt) - (char *)_heap_base) / BLOCK_SIZE)

/* get a pointer to the memory block number BLOCKN */
#define BLOCK_POINTER(blockn)	((char *)_heap_base + (blockn) * BLOCK_SIZE)

/* test whether pointer PNT is on a block boundary */
#define ON_BLOCK(pnt)		\
  (((char *)(pnt) - (char *)_heap_base) % BLOCK_SIZE == 0)

/* calculate the size of heap */
#define HEAP_SIZE	((char *)_heap_last - (char *)_heap_base)

/* is the heap growing?  is the NEW pointer ahead of the OLD */
#define IS_GROWTH(new, old)	((char *)(new) > (char *)(old))

/* increment the heap point PNT by SIZE */
#define HEAP_INCR(pnt, size)	((char *)(pnt) + (size))

#else /* ! HEAP_GROWS_UP */

/* test whether pointer PNT is in the heap space */
#define IS_IN_HEAP(pnt)		\
  ((char *)(pnt) <= (char *)_heap_base && (char *)(pnt) > (char *)_heap_last)

/* turn pointer PNT into a block index */
#define WHICH_BLOCK(pnt)		\
  (((char *)(_heap_base) - (char *)pnt) / BLOCK_SIZE)

/* get a pointer to the memory block number BLOCKN */
#define BLOCK_POINTER(blockn)	((char *)_heap_base - (blockn) * BLOCK_SIZE)

/* test whether pointer P is on a block boundary */
#define ON_BLOCK(pnt)		\
  (((char *)(_heap_base) - (char *)(pnt)) % BLOCK_SIZE == 0)

/* is the heap growing?  is the NEW pointer ahead of the OLD */
#define HEAP_SIZE	((char *)_heap_base - (char *)_heap_last)

/* is the heap growing? */
#define IS_GROWTH(new, old)	((char *)(new) < (char *)(old))

/* increment the heap point PNT by SIZE */
#define HEAP_INCR(pnt, size)	((char *)(pnt) - (size))

#endif /* ! HEAP_GROWS_UP */

/*<<<<<<<<<<  The below prototypes are auto-generated by fillproto */

IMPORT	void		*_heap_base;  /* base of our heap */

IMPORT	void		*_heap_last;  /* end of our heap */

/*
 * initialize heap pointers.  returns [NO]ERROR
 */
IMPORT	int	_heap_startup(void);

/*
 * function to get SIZE memory bytes from the end of the heap.  it
 * returns a pointer to any external blocks in EXTERNP and the number
 * of blocks in EXTERNCP.
 */
IMPORT	void	*_heap_alloc(const unsigned int size, void ** externp,
			     int * externcp);

/*<<<<<<<<<<   This is end of the auto-generated output from fillproto. */

#endif /* ! __HEAP_H__ */
