#include "cthugha.h"
#include "translate.h"
#include "display.h"

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

int use_translations = 1;			/* allow translations */
opt_data translations[MAX_TRANS] = {
    { NULL, 1, "none", "No Translation" }	/* trans. 0 is identiy */
};
int nr_translations=1;				/* nr. of maps */
char translate_first[256];			/* first translation */
trans_map * active_translation = NULL;		/* translation used */
char lib_size[512];
char * translation_path[] = {
    "./",
    "./tab/",
    lib_size,
    "/usr/local/lib/cthugha/tab/",
    ""
};
int trans_stretch = 1;				/* allow stretching */

int done_translation=0;				/* trans. already done for
						   this iteration */

int read_trans(FILE * file, char * name);

/*
 * Initialize the translation-tables.
 */
int init_translate() {

    if (!use_translations) 
	return 0;

    printf("Loading translations...\n");
    
    sprintf(lib_size, "/usr/local/lib/cthugha/tab/%dx%d/", 
            BUFF_WIDTH,BUFF_HEIGHT);
	
    /* Read translations-tables from disk */
    load( translation_path, "/tab/", ".tab", read_trans);

    printfv("Number of loaded translations: %d\n\n", nr_translations);

    return 0;
}

/*
 * Read a translation file
 * 
 * The file should contain BUFF_WIDTH * BUFF_HEIGHT utint-values.
 * These values specifiy the translation as described in the doc-file.
 */
#define TRANS	translations[nr_translations].data
int read_trans(FILE * file, char * name) {
    int i,j;
    union data {
	unsigned long * l;
	unsigned short * s;
    } D;
    tab_header header;

    int size = ( BUFF_SIZE > 65535) ? sizeof(long) : sizeof(short);
    int BSize = BUFF_SIZE;
    int * dst = TRANS;
    int * tmpBuffer = NULL;
    int stretch = 0;
    
    if ( opt_defined(name, translations, nr_translations) && !double_load) {
	printfv("   ... already loaded\n");
	return 1;
    }
    if ( nr_translations >= MAX_TRANS )	{	/* no more room */
	printfe("Maximum number of translations reached.\n");
	return 1;
    }
    if ( (TRANS = malloc(BUFF_SIZE * sizeof(int))) == NULL) {
	printfe("Can't allocate memory for translation.\n");
	return 1;
    }
	
    /* read header */
    if ( fread( &header, sizeof(tab_header), 1, file) != 1) {
	printfe("  Can't read header in file %s.\n", name);
	return 1;
    }
    
    /* check header ID */
    if ( header.id != *((long*)"HDKB")) {
	printfv("\n    Header ID-mismatch. Trying without header.");

	/* go back to start of file */
	rewind(file);
	/* no description in old style */
	translations[nr_translations].desc[0] = '\0'; 

	/* fill in header */
	header.size_x = BUFF_WIDTH;
	header.size_y = BUFF_HEIGHT;
    } else {
	/* ID OK - now test size */
	if( (header.size_x != BUFF_WIDTH) || (header.size_y != BUFF_HEIGHT)) {
	    printfv("  Size mismatch (%dx%d instead of %dx%d)",
		    header.size_x, header.size_y,
		    BUFF_WIDTH, BUFF_HEIGHT);
	    if ( trans_stretch) {		/* allow stretching */
		printfv(" - stretching\n");
		stretch = 1;
	    } else {
		free(TRANS);
		return 1;
	    }
	}
	   
	/* translation table may use a different size */
	BSize = header.size_x * header.size_y;
	size = (BSize > 65535) ? sizeof(long) : sizeof(short);
	/* for stretching we need a temp buffer */
	if ( stretch ) {
	    if ( (tmpBuffer = malloc(BSize * sizeof(int))) == NULL) {
		printfe("Can't allocate memory for temporary translation.\n");
		return 1;
	    }
	}
	    
	/* now copy description */
	strncpy(translations[nr_translations].desc, header.description, 40);
    }

    /* allocate memory for read buffer */
    D.l = (unsigned long*)malloc(size*header.size_x);
    if ((void*)D.l != (void*)D.s) {
        printfe("Wackiness afoot at %d in %s\n",__LINE__,__FILE__);
        exit(1);
    }

	   
    /* read data */
    dst = stretch ? tmpBuffer : TRANS;
    for(i=0; i < header.size_y; i++) {
	if ( (j=fread( D.l, size, header.size_x, file)) < header.size_x ) {
	    printfe("  Can't read at line: %d, read: %d (%s)\n", i,j, name);
	    free( TRANS );
	    if( tmpBuffer) free( tmpBuffer );
	    free( D.l );
	    return 1;
	}	
	for(j=0; j < header.size_x; j++) {
	    if( BSize > 65535) {
		if ( D.l[j] >= BSize) {
		    printfe("  High-translation (value: %ld) in %s.\n", 
			    D.l[j], name);
		    free( TRANS );
		    if ( tmpBuffer) free(tmpBuffer);
		    return 1;
		}
		*dst++ = (int)D.l[j];
	    } else {
		if ( D.s[j] >= BSize) {
		    printfe("  High-translation (value: %d) in %s.\n", 
			    D.s[j], name);
		    free( TRANS );
		    if ( tmpBuffer) free(tmpBuffer);
		    return 1;
		}
		*dst++ = (int)D.s[j];
	    }
	}
    }
    /* readbuffer no longer needed */
    free(D.l);


    /* do the stretching if necessary (from: Rus Maxham) */
    if ( stretch ) {
	double xs,ys;
	int x,y,tp,ox,oy,dx,dy;
	int * tabin = tmpBuffer;
	dst = TRANS;
	
	xs = (double)header.size_x / BUFF_WIDTH;
	ys = (double)header.size_y / BUFF_HEIGHT;

	for (j=0;j<BUFF_HEIGHT;j++) {

	    y = (double)j*ys;
	    if (y >= header.size_y)
		y = header.size_y - 1;

	    for (i=0;i<BUFF_WIDTH;i++) {
		
		x = (double)i*xs;
		if (x >= header.size_x)
		    x = header.size_x - 1;
		
		tp = tabin[x + y*header.size_x];
		ox = tp % header.size_x;
		oy = tp / header.size_x;
		dx = (double)(ox - x)/xs;
		dy = (double)(oy - y)/ys;
		dst[i+j*BUFF_WIDTH] = abs(i + dx + (j + dy)
					  * BUFF_WIDTH)%BUFF_SIZE;
		
	    }
	}
	free(tmpBuffer);	/* no longer needed */
    }


    /* Check for too much data */
    if ( fread( &D, size, 1, file) ) {
	printfe("  Extra data at end of file %s\n", name);
	free( TRANS );
	return 1;
    }

    /* fill name and usage for translation */
    strncpy(translations[nr_translations].name, name, MAX_NAME_LEN);
    translations[nr_translations].use = 1;
    
    nr_translations ++;		
    return 0;
}			

/*
 * No special exit-code needed (memory is freed at exit so not needed here)
 */
int exit_translate() {
    return 0;
}

/*
 * Change to a new translation-table
 */
int change_translate(int to) {
    active_translation = opt_change(to, translations, nr_translations, 
				    active_translation)->data;
    return 0;
}
int select_translate() {
    int i;
    i=display_selection(translations, nr_translations, active_translation,
			"Select Translation\n");
    if ( i >= 0)
	change_translate(i);
    return i;
}

/*
 * Do the translation.
 *
 * if active_translation is 0 then nothing is done.
 */			
void translate() {
    int * trans;
    int i;
    unsigned char * dst;
    unsigned char * src;

    if( done_translation)
	return;

    if( active_translation == 0)		/* 0 is identity */
	return;
		
    dst = passive_buffer;			/* destination */
    src = active_buffer;
    active_buffer = passive_buffer; passive_buffer = src;
			
    trans = (int*)(active_translation);		/* transl.-map */
    src[0] = 0;

    for(i=BUFF_SIZE; i != 0; i--)  		/* do the translation */
	*dst++ = src[*trans++];   
}






