#include "cthugha.h"
#include "sound.h"
#include "options.h"
#include "cd_player.h"
#include "net_sound.h"
#include "keys.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <sys/soundcard.h>
#include <math.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#undef COLORS
#include <ncurses.h>

int cthugha_verbose = 0;
int cthugha_pause = 0;
int BUFF_WIDTH = 320;
int BUFF_HEIGHT = 200;

int REQ_PORT = 5555;

/* 
   First initialization
*/
int init_ncurses() {
    if( !initscr() )
	return 1;

    timeout(0);					/* no timeout on getch(); */
    keypad(stdscr, TRUE);			/* allow function keys */
    meta(stdscr, TRUE);				/* 8-bit clean */
    noecho();					/* don't print out keys */
    cbreak();

    erase();
    refresh();
	
    return 0;
}

int exit_ncurses() {
    endwin();
    return 0;
}

/*
 * Get a "line" of sound from the soundcard 
 */
int read_sound() {

    if( nr_clients == 0) {
	free_sound();
	return 0;
    }

    alloc_sound();

    if ( sound_source == SNDSRC_DEBUG)
	sound_random();
    else 
	sound_read();

    return 0;
}



int main(int argc, char * argv[]) {
    int key = Z_SPACE;

    if ( get_params(argc, argv))
	return 1;

    if ( init_sound() ) {
	return 1;
    }
    if ( init_server() ) {
	exit_sound();
	return 1;
    }
    if( init_ncurses() ) {
	exit_server();
	exit_sound();
	return 1;
    }

    free_sound();	

    do {
	( key == Z_SPACE) ? clear() : erase(); 

	read_sound();
	broadcast_sound();

	server_accept();

	key=cd_player();

	print_clients();

	refresh();

	if(srv_wait_time)		/* wait for a short while */
	    usleep(srv_wait_time*1000);	/* to give clients a chance */
					/* to display everything */
    } while( key != Z_ESC );

    exit_sound();
    exit_server();
    exit_ncurses();
    return 0;
}
