;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime1.8/Rgc/automata.scm          */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed May  5 08:48:02 1993                          */
;*    Last change :  Mon Jul 10 14:44:08 1995 (serrano)                */
;*                                                                     */
;*    La compilation des automates                                     */
;*    -------------------------------------------------------------    */
;*    Parvenu a ce stade de la compilation, on a deja calcule le       */
;*    `dfa', maintenant on le compile, i.e. on calcule une `lambda'    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __rgc_automata
   
   (import  (__error                   "Llib/error.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__r4_numbers_6_5          "Ieee/number.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_input_6_10_2         "Ieee/input.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_output_6_10_3        "Ieee/output.scm")
	    
	    (__rgc                     "Rgc/runtime.scm")
	    (__rgc_accept              "Rgc/accept.scm")
	    (__rgc_ustate              "Rgc/ustate.scm")
	    (__rgc_cstate              "Rgc/cstate.scm")
	    (__rgc_optimize            "Rgc/optimize.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__evenv                   "Eval/evenv.scm"))

   (export  (build-automata nb-states states t-trap)
	    (state->symbol  num)))

;*---------------------------------------------------------------------*/
;*     Les variables statistiques ...                                  */
;*---------------------------------------------------------------------*/
(define *cost*            0)
(define *cost-max*        0)
(define *state-max-cost*  "")
(define *uncompact-state* 0)
(define *uncoded-state*   0)
(define *states*         '())
(define *nb-looping*      0)

;*---------------------------------------------------------------------*/
;*     build-automata ...                                              */
;*     int x states x vector --> lambda                                */
;*---------------------------------------------------------------------*/
(define (build-automata nb-states states t-trap)
   (set! *states*          states)
   (set! *cost*            0)
   (set! *uncompact-state* 0)
   (set! *uncoded-state*   0)
   (set! *cost-max*        0)
   (set! *cost*            0)
   (set! *state-max-cost*  "")
   (set! *nb-looping*      0)
;*---------------------------------------------------------------------*/
   (let ((accept? (make-accept-function nb-states states)))
      (prepare-optimisation nb-states states)
      (cons
       'labels
       (list
	(let loop ((state-num 0))
	   (if (=fx state-num nb-states)
	       '()
	       (let ((new-dfa-state (decl-auto-state nb-states
						     state-num
						     states
						     accept?)))
		  (if new-dfa-state
		      (cons new-dfa-state
			    (loop (+fx 1 state-num)))
		      (loop (+fx 1 state-num))))))
	`(,(state->symbol 0) rule)))))

;*---------------------------------------------------------------------*/
;*     decl-auto-state ...                                             */
;*---------------------------------------------------------------------*/
(define (decl-auto-state nb-states state-num states accept?)
   (let* ((state-name (state->symbol state-num))
	  (kind (kind-of-code nb-states state-num states))
	  (code (case (car kind)
		   ((no-code)
		    (set! *uncoded-state* (+fx 1 *uncoded-state*))
		    #f)
		   ((compact)
		    (set! *nb-looping*
			  (+fx *nb-looping*
			     (if (compute-looping state-num
						  (cadddr kind)
						  accept?
						  nb-states)
				 1
				 0)))
		    (let ((cost (cadr kind)))
		       (set! *cost* (+fx *cost* cost))
		       (if (>fx cost *cost-max*)
			   (begin
			      (set! *cost-max* cost)
			      (set! *state-max-cost* (string-append
						      "max cost (state."
						      (integer->string
						       state-num) ") "))))
		       (decl-cstate state-name
				    accept?
				    state-num
				    (caddr kind)
				    (cadddr kind))))
		   ((uncompact)
		    (set! *nb-looping*
			  (+fx *nb-looping*
			     (if (compute-looping state-num
						  (cadr kind)
						  accept?
						  nb-states)
				 1
				 0)) )
		    (set! *uncompact-state* (+fx 1 *uncompact-state*))
		    (decl-ustate state-name
				 (cadr kind)
				 accept?
				 nb-states
				 state-num)))))
      code))

;*---------------------------------------------------------------------*/
;*     kind-of-code ...                                                */
;*---------------------------------------------------------------------*/
(define (kind-of-code nb-states state-num states)
;*---- On lis toutes les transitions et on range dans tmp -------------*/
;*   En meme temps, on regarde toutes les lettres qui seront dans le   */
;*   else du cond.                                                     */
;*---------------------------------------------------------------------*/
   (let ((alpha-else (make-vector (+fx 1 *rgc-last-char*) #t))
	 (tmp        (make-vector nb-states '()))
	 (else-c&t   'dummy)) 
       (if (not (let ((abort #f))
		   (let loop ((fleche* (vector-ref states state-num)))
		       (if (null? fleche*)
			   abort
			   (let ((pr (car fleche*)))
			      (let ((lettre    (car pr))
				    (new-state (cdr pr)))
				 (if (not (char? lettre))
				     ;; ici on ne fait rien pour
				     ;; les matchs car ils
				     ;; sont traites lors de la
				     ;; transition vers cet
				     ;; etat.
				     (loop (cdr fleche*))
				     ;; pr n'est pas une acceptation...
				     ;; on a donc une transition:
				     ;;      state-num x lettre -> new-state
				     (begin
					(set! abort #t)
					(vector-set! alpha-else
						     (char->integer lettre)
						     #f)
					(vector-set! tmp
						     new-state
						     (cons
						      (char->integer lettre)
						      (vector-ref tmp
								  new-state)))
					(loop (cdr fleche*))))))))))
	;; On n'a rien lu du tout
	'(no-code)
	(begin
;*---- On calcule le cout du else -------------------------------------*/
;*  Ce calcul a un interet car dans certain cas il peut etre judicieux */
;*  d'inverser le dernier test du cond et le else.                     */
;*---------------------------------------------------------------------*/
	   (let ((else-alpha (let loop ((i *rgc-first-char*) ;; les chars speciaux
					(l '()))         ;; doivent etre exclus
				(if (=fx i *rgc-last-char*)    ;; du else...
				    l
				    (if (vector-ref alpha-else i)
					(loop (+fx i 1)
					      (cons i l))
					(loop (+fx i 1)
					      l))))))
	      (set! else-c&t (cost&test else-alpha 'abort)))
;*---- On calcule les tests a faire (et leur cout) --------------------*/
	   (let loop ((i 0)
		      (l '()))
	      ;; Dans l on a la liste triee des tests a faire.
	      ;; On calcule le cout totale pour savoir
	      ;; si on 'cond' ou si on 'case'
	      (if (=fx i nb-states)
		  (let ((c (+fx 1 (let loop ((l l))
				   ;; on fait un ++ car il faut
				   (if (null? l) ;; ajouter le cout du 
				       0         ;; (<fx c *rgc-first-char*)
				       (if (null? (cdr l))
					   (if (>fx (car (car l))
						  (car else-c&t))
					       (car else-c&t)
					       (car (car l)))
					   (+fx (car (car l))
					      (loop (cdr l)))))))))
		     (if (>fx c *rgc-compact*)
			 ;; le cond est trop cher, il faut un case
			 (list 'uncompact tmp)
			 ;; C'est bon le cond est possible
			 (list 'compact c l else-c&t tmp)))
		  (let ((ref (vector-ref tmp i)))
		     (if (not (null? ref))
			 (loop (+fx 1 i)
			       (smart-insort-cost! (cost&test ref i) l))
			 (loop (+fx 1 i)
			       l)))))))))

;*---------------------------------------------------------------------*/
;*     smart-insort-cost! ...                                          */
;*---------------------------------------------------------------------*/
(define (smart-insort-cost! cost-cell l)
   (cond
      ((null? l)
       (cons cost-cell '()))
      ((>fx (car cost-cell) (car (car l)))
       (set-cdr! l (smart-insort-cost! cost-cell (cdr l)))
       l)
      (else
       (set-cdr! l (cons (car l) (cdr l)))
       (set-car! l cost-cell)
       l)))

;*---------------------------------------------------------------------*/
;*     cost&test ...                                                   */
;*     cost&test: ( lettre* x state ) --> ( cost x test x state )      */
;*---------------------------------------------------------------------*/
(define (cost&test lettre* new-state)
;*---- une petites variables qui va nous servir partout ---------------*/
   (let ((new-alpha (make-vector (+Fx *rgc-last-char* 1) #f)))
;*---- prepare-lettre* ------------------------------------------------*/
      (labels ((prepare-lettre* (lettre*)
				(let loop ((l lettre*))
				   (if (null? l)
				       'done
				       (begin
					  (vector-set! new-alpha (car l) #t)
					  (loop (cdr l))))))
;*---- not-lettre* (calcul complementaire d'un interval) --------------*/
	       (not-lettre* (lettre*)
			    ;; on a lu dans prepare-lettre*, on ecrit
			    (let loop ((i *rgc-first-char*)   
				       (l '()))
			       (if (=fx i *rgc-last-char*)
				   (let liip ((j 0))
				      (if (=fx j *rgc-first-char*)
					  l
					  (begin
					     (vector-set! new-alpha j #t)
					     (set! l (cons j l))
					     (liip (+fx j 1)))))
				   (if (vector-ref new-alpha i)
				       (begin
					  (vector-set! new-alpha i #f)
					  (loop (+fx i 1) l))
				       (begin
					  (vector-set! new-alpha i #t)
					  (loop (+fx i 1) (cons i l)))))))
;*---- Les cellules qu'on va retourner --------------------------------*/
	       (make-cost-cell (cost test state)
			       (list cost test state))
;*---- get-intervals --------------------------------------------------*/
;*   get-intervals:  --> intervals*                                    */
;*   cette fonction se sert de new-alpha qui est initialise par        */
;*   prepare-lettre*.                                                  */
;*---------------------------------------------------------------------*/
	       (get-intervals (not?)
		   (let ((l     '())
			 (start  #f)
			 (end    (+fx 1 *rgc-last-char*)))
		      (let for ((i (if not? 0 *rgc-first-char*)))
			 (if (=fx i *rgc-last-char*)
			     (begin
				;; on a fini la boucle. Toute fois il faut 
				;; terminer l'interval courant.
				(if (and start (not (=fx i (+fx 1 end))))
				    (set! l (cons (cons start end) l)))
				l)
			     (begin
				(if (vector-ref new-alpha i)
				    (begin
				       (vector-set! new-alpha i #f)
				       (if start
					   ;; on a deja commence un
					   ;; nouvel interval
					   (if (=fx i (+fx 1 end))
					       ;; on est toujours dans le
					       ;; meme interval
					       (set! end i)
					       ;; on a fini l'interval courant
					       (begin
						  (set! l (cons (cons start
								      end)
								l))
						  (set! end i)
						  (set! start i)))
					   (begin
					      (set! start i)
					      (set! end i))))
				    (if start
					;; on avait commence un interval,
					;; on le fini
					(begin
					   (set! l (cons (cons start end) l))
					   (set! end (+fx 1 *rgc-last-char*))
					   (set! start #f))))
				(for (+fx i 1))))))))
;*---- le main --------------------------------------------------------*/
	 (if (null? lettre*)
	     (make-cost-cell 0 'no-test 'no-state)
	     (begin
		(prepare-lettre* lettre*)
		(let* ((not-test (>fx (length lettre*) (/fx (-fx *rgc-last-char* 1)
							    2)))
		       (alpha    (if not-test
				     (not-lettre* lettre*)
				     lettre*))
		       (len      (length alpha)))
		   (let ((cell
			  (cond
			     ((=fx len 1)
			      (make-cost-cell 1
					      `(rgc-=? c ,(car alpha))
					      new-state))
			     ((=fx len 2)
			      (make-cost-cell
			       3
			       `(or (rgc-=? c ,(car alpha))
				    (rgc-=? c ,(cadr alpha)))
			       new-state))
			     (else
			      (let* ((intervals* (get-intervals not-test))
				     (res '())
				     (cost 0))
				 (let loop ((i* intervals*))
				    (if (null? i*)
					'()
					(begin
					   (let* ((pr  (car i*))
						  (len (-fx (cdr pr)
							    (car pr))))
					      (cond
						 ((eq? len 0)
						  (set! res
							(cons
							 `(rgc-=? c ,(car pr))
							 res))
						  (set! cost (+fx 1 cost)))
						 ((eq? len 1)
						  (set! res (append
							     (list
							      `(rgc-=? c ,(car pr))
							      `(rgc-=? c ,(cdr pr)))
							     res))
						  (set! cost (+fx cost 2)))
						 ((=fx (car pr) 0)
						  (set! res
							(cons
							 `(rgc-<=? c ,(cdr pr))
							 res))
						  (set! cost (+fx 1 cost)))
						 ((=fx (cdr pr) *rgc-last-char*)
						  (set! res
							(cons `(rgc->=? c ,(car pr))
							      res))
						  (set! cost (+fx 1 cost)))
						 (else
						  (set! res
					 		(cons
							 `(and (rgc->=? c ,(car pr))
							       (rgc-<=? c ,(cdr pr)))
							 res))
						  (set! cost (+fx cost 3)))))
					(loop (cdr i*)))))
				    (if (cdr res)
					(make-cost-cell (+fx cost (-fx (length res) 1))
							`(or ,@res)
							new-state)
					(make-cost-cell cost
							(car res)
							new-state)))))))
		      (if not-test
			  ;; on fait le not du test puisque c'est rentable
			  (make-cost-cell (+fx 1 (car cell))
					  `(not ,(cadr cell))
					  (caddr cell))
			  cell))))))))

;*---------------------------------------------------------------------*/
;*    state->symbol                                                    */
;*    int --> symbol                                                   */
;*---------------------------------------------------------------------*/
(define (state->symbol num)
   (string->symbol (string-append "STATE_" (integer->string num))))

