;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime1.8/Ieee/char.scm             */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jul 21 10:09:50 1992                          */
;*    Last change :  Thu Jul 13 15:03:12 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    6.6 Characters (page 24, r4)                                     */
;*=====================================================================*/
 
;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_characters_6_6
   
   (import  (__error                   "Llib/error.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")

	    (__evenv                   "Eval/evenv.scm"))

   (foreign (macro bool  c-char?                (obj)         "CHARP")
	    (macro       uchar  c-char-upcase   (uchar)       "toupper")
	    (macro       uchar  c-char-downcase (uchar)       "tolower")
	    (infix macro bool  c-char=?         (uchar uchar) "==")
	    (infix macro bool  c-char<?         (uchar uchar) "<")
	    (infix macro bool  c-char>?         (uchar uchar) ">")
	    (infix macro bool  c-char<=?        (uchar uchar) "<=")
	    (infix macro bool  c-char>=?        (uchar uchar) ">=")
	    (macro long  c-char->integer        (uchar)       "")
	    (macro uchar  c-integer->char       (long)        "")
	    (infix macro uchar  c-char-or       (uchar uchar) "|"))
   
   (export  (inline char?::bool             ::obj)
	    (inline char=?::bool            ::uchar ::uchar)
	    (inline char<?::bool            ::uchar ::uchar)
	    (inline char>?::bool            ::uchar ::uchar)
	    (inline char<=?::bool           ::uchar ::uchar)
	    (inline char>=?::bool           ::uchar ::uchar) 
	    (inline char-ci=?::bool         ::uchar ::uchar)
	    (inline char-ci<?::bool         ::uchar ::uchar)
	    (inline char-ci>?::bool         ::uchar ::uchar)
	    (inline char-ci<=?::bool        ::uchar ::uchar)
	    (inline char-ci>=?::bool        ::uchar ::uchar)
	    (inline char-alphabetic?::bool  ::uchar)
	    (inline char-numeric?::bool     ::uchar)
	    (inline char-whitespace?::bool  ::uchar)
	    (inline char-upper-case?::bool  ::uchar)
	    (inline char-lower-case?::bool  ::uchar)
	    (inline char->integer::long     ::uchar)
	    (integer->char::uchar           ::long)
	    (inline integer->char-ur::uchar ::long)
	    (inline char-upcase::uchar      ::uchar)
	    (inline char-downcase::uchar    ::uchar)
	    (inline char-or::uchar          ::uchar ::uchar))
   
   (pragma  (c-char? (_type-checker_ bchar))))
 
;*---------------------------------------------------------------------*/
;*    char? ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (char? obj)
   (c-char? obj))

;*---------------------------------------------------------------------*/
;*    char=? ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (char=? char1 char2)
   (c-char=? char1 char2))

;*---------------------------------------------------------------------*/
;*    char<? ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (char<? char1 char2)
   (c-char<? char1 char2))

;*---------------------------------------------------------------------*/
;*    char>? ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline  (char>? char1 char2)
   (c-char>? char1 char2))

;*---------------------------------------------------------------------*/
;*    char<=? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (char<=? char1 char2)
   (c-char<=? char1 char2))

;*---------------------------------------------------------------------*/
;*    char>=? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (char>=? char1 char2)
   (c-char>=? char1 char2))

;*---------------------------------------------------------------------*/
;*    char-ci=? ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (char-ci=? char1 char2)
   (char=? (char-upcase char1) (char-upcase char2)))

;*---------------------------------------------------------------------*/
;*    char-ci<? ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (char-ci<? char1 char2)
   (c-char<? (char-upcase char1) (char-upcase char2))) 

;*---------------------------------------------------------------------*/
;*    char-ci>? ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline  (char-ci>? char1 char2)
   (c-char>? (char-upcase char1) (char-upcase char2)))

;*---------------------------------------------------------------------*/
;*    char-ci<=? ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (char-ci<=? char1 char2)
   (c-char<=? (char-upcase char1) (char-upcase char2)))

;*---------------------------------------------------------------------*/
;*    char-ci>=? ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (char-ci>=? char1 char2)
   (c-char>=? (char-upcase char1) (char-upcase char2)))

;*---------------------------------------------------------------------*/
;*    char-alphabetic? ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (char-alphabetic? char)
   (let ((c (char-upcase char)))
      (if (char>=? c #\A)
	  (char<=? c #\Z)
	  #f)))

;*---------------------------------------------------------------------*/
;*    char-numeric? ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (char-numeric? char)
   (if (char>=? char #\0)
       (char<=? char #\9)
       #f))

;*---------------------------------------------------------------------*/
;*    char-withespace? ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (char-whitespace? char)
   (char=? char #\space))

;*---------------------------------------------------------------------*/
;*    char-upper-case? ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (char-upper-case? char)
   (if (char>=? char #\A)
       (char<=? char #\Z)
       #f))

;*---------------------------------------------------------------------*/
;*    char-lower-case? ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (char-lower-case? char)
   (if (char>=? char #\a)
       (char<=? char #\z)
       #f))

;*---------------------------------------------------------------------*/
;*    char->integer ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (char->integer char)
   (c-char->integer char))

;*---------------------------------------------------------------------*/
;*    integer->char ...                                                */
;*---------------------------------------------------------------------*/
(define (integer->char int)
   (if (and (>=fx int 0) (<=fx int 255))
       (c-integer->char int)
       (error "integer->char" "integer out of range" int)))

;*---------------------------------------------------------------------*/
;*    integer->char-ur ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (integer->char-ur int)
   (c-integer->char int))

;*---------------------------------------------------------------------*/
;*    char-upcase ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline  (char-upcase char)
   (c-char-upcase char))

;*---------------------------------------------------------------------*/
;*    char-downcase ...                                                */
;*---------------------------------------------------------------------*/
(define-inline  (char-downcase char)
   (c-char-downcase char))
		     
;*---------------------------------------------------------------------*/
;*    char-or ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (char-or char1 char2)
   (c-char-or char1 char2))
