;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Read/inline.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Dec 29 10:30:51 1994                          */
;*    Last change :  Tue Mar 21 12:01:36 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We scan files in order to find `inline' definitions.             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module read_inline
   (include "Ast/ast.sch"
	    "Tools/trace.sch")
   (import  tools_error
	    tools_speek
	    parse_definition
	    ast_env)
   (export  (look-for-inline inline port module)
	    (get-readed-inlines)))

;*---------------------------------------------------------------------*/
;*    *readed-inline* ...                                              */
;*---------------------------------------------------------------------*/
(define *readed-inlines* '())

;*---------------------------------------------------------------------*/
;*    get-readed-inlines ...                                           */
;*    -------------------------------------------------------------    */
;*    This function is used to add to the ast all the imported         */
;*    inlines. These inported inlines are added to the ast after       */
;*    the user and expand pass. So imported inline functions are       */
;*    just added when the compilation start. This means that inline    */
;*    functions should not use macros.                                 */
;*---------------------------------------------------------------------*/
(define (get-readed-inlines)
   *readed-inlines*)

;*---------------------------------------------------------------------*/
;*    look-for-inline ...                                              */
;*    inlines x port x symbol --> 'done @ error                        */
;*    -------------------------------------------------------------    */
;*    We read until we have found all inline definitions or EOF.       */
;*---------------------------------------------------------------------*/
(define (look-for-inline inlines port module)
   (trace read
	  "Je recherche dans: " module #\Newline
	  "                 : " inlines #\Newline)
   (if (null? inlines)
       'done
       (let loop ((exp     (read port #t))
		  (inlines inlines))
	  (cond
	     ((null? inlines)
	      'done)
	     ((eof-object? exp)
	      (let loop ((inlines inlines))
		 (if (null? (cdr inlines))
		     (user-error "look-for-inline"
				 "Can't find such inline definition"
				 (string-append
				  (string-append (symbol->string (car inlines))
						 "@")
				  (symbol->string module)))
		     (begin
			(warning
			 "module-declaration"
			 "Can't find such inline definition -- "
			 (string-append
			  (string-append (symbol->string (car inlines))
					 "@")
			  (symbol->string module)))
			(loop (cdr inlines))))))
	     (else
	      (match-case exp
		 ((define-inline (?name . ?args) . ?body)
		  ;; This is really a hack but in order to avoid
		  ;; confusion between several inline named in the
		  ;; same way, we replace the name of the inline
		  ;; by its global structure. The end of this
		  ;; hack is in the module ast_check.
		  (let ((name (car (parse-formal-ident name))))
		     (if (not (memq name inlines))
			 (loop (read port #t) inlines)
			 (let* ((global   (find-global name module))
				(function (global-value global)))
			    ;; _the_ hack
			    (set-car! (cadr exp) global)
			    (function-body-set! function body)
			    (function-body-set! function args)
			    (set! *readed-inlines* (cons exp *readed-inlines*))
			    (loop (read port #t) (remq! name inlines))))))
		 (else
		  (loop (read port #t) inlines))))))))
				      
   

				      
   
