;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Parse/with.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Dec 27 18:06:19 1994                          */
;*    Last change :  Mon Feb 12 17:57:19 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The parsing of `with' clauses                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module parse_with
   (include "Ast/ast.sch")
   (import  engine_param
	    read_access
	    parse_import
	    ast_env
	    tools_module
	    tools_file
	    tools_error)
   (export  (parse-with with)))

;*---------------------------------------------------------------------*/
;*    parse-with ...                                                   */
;*---------------------------------------------------------------------*/
(define (parse-with with)
   (define (o-name file)
      (string-append (prefix file) ".o"))
   (define (bound-initialization-function! name)
      (set! *init-functions*
	    (cons `((@ ,(module-init-name name) ,name))
		  *init-functions*))
      (parse-imported (list (module-init-name name)) name)
      (let ((global (find-global (module-init-name name) name)))
	 (global-eval?-set! global #f)))
   (let loop ((with with))
      (if (null? with)
	  'done
	  (match-case (car with)
	     ((?name ?file)
	      (add-access! (car (car with)) (cadr (car with)))
	      (set! *with-files* (cons (o-name file) *with-files*))
	      (if (not (memq name *init-functions*))
		  (bound-initialization-function! name))
	      (loop (cdr with)))
	     (else
	      (let* ((name (car with))
		     (b    (assq name *access-table*)))
		 (if (not b)
		     (user-error "parse-with" "can't access module" name)
		     (begin
			(set! *with-files* (cons (o-name (cdr b))
						 *with-files*))
			(if (not (memq name *init-functions*))
			    (bound-initialization-function! name))
			(loop (cdr with))))))))))
   
	     
	
