;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Parse/cforeign.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Dec 27 18:13:55 1994                          */
;*    Last change :  Thu Apr 11 10:42:34 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We parse foreign clauses                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module parse_cforeign
   (include "Type/type.sch")
   (import  engine_param
	    tools_error
	    tools_location
	    tools_args
	    ast_global
	    type_env
	    parse_type
	    cforeign_export
	    cforeign_type)
   (export  (parse-c-foreign foreigns import/export)))

;*---------------------------------------------------------------------*/
;*    parse-c-foreign ...                                              */
;*---------------------------------------------------------------------*/
(define (parse-c-foreign foreigns import/export)
   (let loop ((foreigns foreigns))
      (if (null? foreigns)
	  'done
	  (begin
	     (c-foreign-parser (car foreigns))
	     (loop (cdr foreigns))))))
   
;*---------------------------------------------------------------------*/
;*    c-foreign-parser ...                                             */
;*---------------------------------------------------------------------*/
(define (c-foreign-parser foreign)
   (match-case foreign
      ((include ?string)
       (if (not (string? string))
	   (user-error/location (find-location foreign)
				"c-foreign-parser"
				"Illegal `#include' form"
				foreign)
	   (if (not (member string *include-foreign*))
	       (set! *include-foreign* (cons string *include-foreign*)))))
      ((type . ?-)
       (parse-c-type foreign))
      ((export (and (? symbol?) ?b-name) (and (? string?) ?c-name))
       (remember-foreign-exported-bigloo-variable! b-name c-name))
      ((or (macro ?type ?l-name ?proto ?c-name)
	   (infix macro ?type ?l-name ?proto ?c-name))
       (if (not (and (string? c-name)
		     (symbol? type)
		     (symbol? l-name)
		     (let loop ((proto proto))
			(cond
			   ((null? proto)
			    #t)
			   ((symbol? proto)
			    #t)
			   ((not (pair? proto))
			    #f)
			   ((not (symbol? (car proto)))
			    #f)
			   (else
			    (loop (cdr proto)))))))
	   (user-error/location (find-location foreign)
				"c-foreign-parser"
				"Illegal `macro' form"
				foreign)
	   (declare-foreign-function! l-name
				      c-name
				      type
				      proto
				      (eq? (car foreign) 'infix)
				      'c-macro-function)))
      ((macro ?type ?l-name ?c-name)
       (if (not (and (string? c-name)
		     (symbol? type)
		     (symbol? l-name)))
	   (user-error/location (find-location foreign)
				"c-foreign-parser"
				"Illegal `macro-variable' form"
				foreign)
	   (declare-foreign-variable! l-name
				      c-name
				      type
				      'c-macro-variable)))
      ((?type ?l-name ?proto ?c-name)
       (if (not (and (string? c-name)
		     (symbol? type)
		     (symbol? l-name)
		     (let loop ((proto proto))
			(cond
			   ((null? proto)
			    #t)
			   ((symbol? proto)
			    #t)
			   ((not (pair? proto))
			    #f)
			   ((not (symbol? (car proto)))
			    #f)
			   (else
			    (loop (cdr proto)))))))
	   (user-error/location (find-location foreign)
				"c-foreign-parser"
				"Illegal `function' form"
				foreign)
	   (declare-foreign-function! l-name
				      c-name
				      type
				      proto
				      #f
			  	      'c-function)))
      ((?type ?l-name ?c-name)
       (if (not (and (string? c-name)
		     (symbol? type)
		     (symbol? l-name)))
	   (user-error/location (find-location foreign)
				"c-foreign-parser"
				"Illegal `variable' form"
				foreign)
	   (declare-foreign-variable! l-name
				      c-name
				      type
				      'c-variable)))
      (else
       (user-error/location (find-location foreign)
			    "c-foreign-parser"
			    "Illegal foreign form"
			    foreign))))

;*---------------------------------------------------------------------*/
;*    parse-c-type ...                                                 */
;*---------------------------------------------------------------------*/
(define (parse-c-type type)
   (match-case type
      ((type (and (? symbol?) ?id) (and (? string?) ?name))
       (declare-type! id name 'c-type '()))
      ((type (and (? symbol?) ?id) ?t-exp (and (? string?) ?name))
       (if (check-c-type-exp? t-exp)
	   (declare-c-type type id t-exp name)
	   (user-error "parse-c-type" "Illegal `C foreign type'" type)))
      (else
       (user-error "parse-c-type" "Illegal `C foreign type'" type))))
 
;*---------------------------------------------------------------------*/
;*    check-c-type-exp? ...                                            */
;*---------------------------------------------------------------------*/
(define (check-c-type-exp? t-exp)   
   (match-case t-exp
      ((? symbol?)
       #t)
      (((or union struct) . ?slots)
       (let loop ((slots slots))
	  (if (null? slots)
	      #t
	      (match-case (car slots)
		 (((? symbol?) (? symbol?) (? string?))
		  (loop (cdr slots)))
		 (else
		  #f)))))
      ((pointer (? symbol?))
       #t)
      ((array (? symbol?))
       #t)
      ((function (? symbol?) (and (or () (? pair?)) ?t-exp))
       (let loop ((t-exp t-exp))
	  (cond
	     ((null? t-exp)
	      #t)
	     ((symbol? t-exp)
	      #t)
	     ((symbol? (car t-exp))
	      (loop (cdr t-exp)))
	     (else
	      #f))))
      ((enum . ?slots)
       (let loop ((slots slots))
	  (if (null? slots)
	      #t
	      (match-case (car slots)
		 (((? symbol?) (? string?))
		  (loop (cdr slots)))
		 (else
		  #f)))))
      (else
       #f)))

   
   
	  
       
