;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Integrate/u.scm ...      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 15 10:30:52 1995                          */
;*    Last change :  Wed Mar 15 15:12:25 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `U' property                                                 */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module integrate_u
   (include "Tools/trace.sch"
	    "Ast/ast.sch"
	    "Integrate/integrate.sch")
   (import  tools_shape
	    integrate_a)
   (export  (U!)))

;*---------------------------------------------------------------------*/
;*    U! ...                                                           */
;*---------------------------------------------------------------------*/
(define (U!)
   (let loop ((Phi *phi*))
      (if (null? Phi)
	  (trace-U)
	  (let* ((p    (car Phi))
		 (ifun (variable-info p)))
	     (ifun-U-set! ifun (=fx (length (ifun-K* ifun)) 1))
	     (loop (cdr Phi))))))

;*---------------------------------------------------------------------*/
;*    trace-U ...                                                      */
;*---------------------------------------------------------------------*/
(define (trace-U)
   (when-trace '(integrate loop)
	       (lambda ()
		  (fprint *trace-port* "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~")
		  (fprint *trace-port* "U: " #\Newline)
		  (for-each (lambda (p)
			       (let ((ifun (variable-info p)))
				  (fprint *trace-port*
					  " --> " (shape p) #\:
					  (ifun-U ifun))))
			    *phi*)
		  (fprint *trace-port* "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"))))
