;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Integrate/cto.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Apr 25 15:52:39 1995                          */
;*    Last change :  Wed Oct 11 11:38:21 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The computation of the `cto' property.                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module integrate_cto
   (include "Tools/trace.sch"
	    "Ast/node.sch"
	    "Integrate/integrate.sch")
   (import  tools_shape
	    ast_dump)
   (export  (set-cto! <ast> <local>)))

;*---------------------------------------------------------------------*/
;*    set-cto! ...                                                     */
;*    -------------------------------------------------------------    */
;*    We just walk across the body to find all calls.                  */
;*---------------------------------------------------------------------*/
(define (set-cto! ast local)
   (let loop ((ast ast))
      (ast-case ast
	 ((atom)
	  #unspecified)
	 ((kwote)
	  #unspecified)
	 ((var)
	  #unspecified)
	 ((make-box)
	  (loop (make-box-value ast)))
	 ((box-ref)
	  (loop (box-ref-var ast)))
	 ((box-set!)
	  (loop (box-set!-var ast))
	  (loop (box-set!-value ast)))
	 ((fun)
	  (internal-error "a-graph"
			  "Illegal node (see Globalize)"
			  (ast->sexp ast)))
	 ((prag-ma)
	  (for-each loop (prag-ma-values ast))
	  #unspecified)
	 ((fail)
	  (loop (fail-proc ast))
	  (loop (fail-msg ast))
	  (loop (fail-obj ast)))
	 ((sequence)
	  (for-each loop (sequence-exp ast))
	  #unspecified)
	 ((conditional)
	  (loop (conditional-test ast))
	  (loop (conditional-then ast))
	  (loop (conditional-else ast)))
	 ((setq)
	  (loop (setq-val ast))
	  (loop (setq-var ast)))
	 ((let-var)
	  (let liip ((bindings  (let-var-bindings ast)))
	     (if (null? bindings)
		 (loop (let-var-body ast))
		 (begin
		    (loop (cdr (car bindings)))
		    (liip (cdr bindings))))))
	 ((let-fun)
	  (let liip ((locals (let-fun-locals ast)))
	     (if (null? locals)
		 (loop (let-fun-body ast))
		 (let* ((local (car locals))
			(fun   (local-value local))
			(info  (local-info local)))
		    (begin
		       (loop (function-body fun))
		       (liip (cdr locals)))))))
	 ((set-ex-it)
	  (loop (set-ex-it-body ast)))
	 ((jump-ex-it)
	  (loop (jump-ex-it-exit ast))
	  (loop (jump-ex-it-value ast)))
	 ((funcall)
	  (let liip ((asts (funcall-actuals ast)))
	     (if (null? asts)
		 (loop (funcall-fun ast))
		 (begin
		    (loop (car asts))
		    (liip (cdr asts))))))
	 ((app-ly)
	  (loop (app-ly-fun ast))
	  (loop (app-ly-value ast)))
	 ((app)
	  ;; is the called function is a globalized local one, and
	  ;; is not local, we add it to the cto list.
	  (let ((fun (var-variable (app-fun ast))))
	     (if (and (local? fun)
		      (ifun-G? (local-info fun))
		      (not (eq? local fun))
		      (not (memq fun (ifun-cto (local-info local)))))
		 (ifun-cto-set! (local-info local)
				(cons fun
				      (ifun-cto (local-info local))))))
	  (let liip ((asts (app-actuals ast)))
	     (if (null? asts)
		 #unspecified
		 (begin
		    (loop (car asts))
		    (liip (cdr asts))))))
	 ((switch)
	  (let liip ((clauses (switch-clauses ast)))
	     (if (null? clauses)
		 (loop (switch-test ast))
		 (begin
		    (loop (cdr (car clauses)))
		    (liip (cdr clauses)))))))))
