;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    .../prgm/project/bigloo/comptime1.8/Globalize/loc2glo.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jan 27 11:39:39 1995                          */
;*    Last change :  Fri Mar 22 15:43:59 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `local' -> `global' transformation.                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module globalize_local->global
   (include "Tools/trace.sch"
	    "Ast/node.sch"
	    "Globalize/globalize.sch")
   (import  tools_shape
	    engine_param
	    globalize_ast
	    globalize_free
	    tools_args
	    type_cache
	    ast_sexp
	    ast_dump
	    ast_global
	    ast_local)
   (export  (local->global <local>)
	    (the-global    <local>)))

;*---------------------------------------------------------------------*/
;*    default-type ...                                                 */
;*---------------------------------------------------------------------*/
(define (default-type)
   (if (<fx *optim* 2)
       *obj*
       '()))

;*---------------------------------------------------------------------*/
;*    local->global ...                                                */
;*---------------------------------------------------------------------*/
(define (local->global local)
   (trace (loop globalize) (local-shape local) #\: #\Newline)
   (let* ((global    (the-global local))
	  (args      (function-args (local-value local)))
	  (info      (local-info local))
	  (new-body  (fun-Ginfo-new-body info))
	  (kaptured  (fun-Ginfo-kaptured info)))
      (if (function-escape? (local-value local))
	  (fix-escaping-definition global local args kaptured new-body)
	  (fix-non-escaping-definition global local args kaptured new-body))
      (trace (loop globalize) #\Newline)
      global))

;*---------------------------------------------------------------------*/
;*    fix-escaping-definition ...                                      */
;*---------------------------------------------------------------------*/
(define (fix-escaping-definition global local args kaptured body)
   (let ((env      (make-local-variable 'env *procedure*))
	 (new-free (map (lambda (old)
			   (let ((new (make-local-variable (local-name old)
							   (default-type))))
			      (local-info-set! new (default-var-Ginfo))
			      (var-Ginfo-kaptured?-set! (local-info new) #t)
			      (local-access-set! new (local-access old))
			      new))
			kaptured))
	 (new-args (map (lambda (old)
			   (let ((new (make-local-variable (local-name old)
							   (default-type))))
			      (local-info-set! new (default-var-Ginfo))
			      (var-Ginfo-kaptured?-set! (local-info new)
							(var-Ginfo-kaptured?
							 (local-info old)))
			      (local-access-set! new (local-access old))
			      new))
			args))
	 (old-fun  (local-value local))
	 (new-fun  (make-function)))
      ;; we must set now the info slot of env
      (local-info-set! env (default-var-Ginfo))
      (var-Ginfo-kaptured?-set! (local-info env) #f)
      ;; we ajust de function definition
      (function-inline?-set! new-fun #f)
      (function-arity-set! new-fun (+-arity (function-arity old-fun) 1))
      (function-args-set! new-fun (cons env new-args))
      (function-escape?-set! new-fun #t)
      ;; we set function types (an escaping function is _always_ of
      ;; type obj x obj x .. x obj -> obj because type check cannot be
      ;; perform on the call site).
      (function-type-res-set! new-fun *obj*)
      (for-each (lambda (l) (local-type-set! l *obj*)) (function-args new-fun))
      (global-value-set! global new-fun)
      (function-body-set!
       new-fun
       (make-escaping-body local
			   global
			   new-args
			   new-free
			   env
			   (ast-globalize! body
					   local
					   (cons (cons (the-closure local #f)
						       env)
						 (map cons
						      kaptured
						      new-free)))))
      global))

;*---------------------------------------------------------------------*/
;*    make-escaping-body ...                                           */
;*---------------------------------------------------------------------*/
(define (make-escaping-body local global args kaptured env body)
   (let ((stack (list env))
	 (loc   (ast-location body)))
      (function-body-set! (local-value local) body)
      (ast-let-var loc
		   #f
		   #f
		   (let loop ((kaptured kaptured)
			      (num  0)
			      (res  '()))
		      (if (null? kaptured)
			  (reverse! res)
			  (loop (cdr kaptured)
				(+fx num 1)
				(cons (cons (car kaptured)
					    (sexp->ast `(procedure-ref env
								       ,num)
						       stack
						       global
						       loc
						       'read))
				      res))))
		   (ast-let-fun loc
				#f
				#f
				(list local)
				(ast-app loc
					 #f
					 #f
					 (ast-var loc #f #f local)
					 (map (lambda (v)
						 (ast-var loc #f #f v))
					      args)
					 #f
					 #f
					 #f
					 #f))
		   #t)))
					    
;*---------------------------------------------------------------------*/
;*    fix-non-escaping-definition ...                                  */
;*---------------------------------------------------------------------*/
(define (fix-non-escaping-definition global local args kaptured body)
   (let ((add-args (map (lambda (old)
			   (let ((new (make-local-variable (local-name old)
							   (default-type))))
			      (local-info-set! new (default-var-Ginfo))
			      (var-Ginfo-kaptured?-set! (local-info new) #t)
			      (local-access-set! new (local-access old))
			      new))
			kaptured))
	 (old-fun  (local-value local))
	 (new-fun  (make-function)))
      (function-inline?-set! new-fun #f)
      (function-arity-set! new-fun (+-arity (function-arity old-fun)
					    (length kaptured)))
      (function-args-set! new-fun (append (reverse add-args) args))
      (function-escape?-set! new-fun #t)
      (function-escape?-set! old-fun #f)
      (if (<fx *optim* 2)
	  (function-type-res-set! new-fun *obj*)
	  (function-type-res-set! new-fun '()))
      (function-body-set! new-fun
			  (ast-globalize! (fun-Ginfo-new-body
					   (local-info local))
					  local
					  (map cons kaptured add-args)))
      (global-value-set! global new-fun)
      global))

;*---------------------------------------------------------------------*/
;*    the-global ...                                                   */
;*---------------------------------------------------------------------*/
(define (the-global local)
   (let ((info (local-info local)))
      (if (global? (fun-Ginfo-the-global info))
	  (fun-Ginfo-the-global info)
	  (let ((global (declare-global-procedure!
			 'static
			 ;; we create an unused dummy module
			 (gensym 'local)
			 'procedure
			 (list (list (local-name local))))))
	     (fun-Ginfo-the-global-set! info global)
	     (global-type-set! global *procedure*)
	     (global-occurrence-set! global 1)
	     global))))
