;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Eval/init.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Apr 26 15:01:38 1995                          */
;*    Last change :  Thu May 18 16:44:12 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `eval-initialize!' function's body.                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module eval_init
   (include "Ast/node.sch")
   (import  eval_parse
	    ast_global
	    ast_sexp
	    ast_env
	    tools_error
	    engine_param)
   (export  (make-eval-init!)))

;*---------------------------------------------------------------------*/
;*    cache                                                            */
;*---------------------------------------------------------------------*/
(define *define-primop-ref* #f)
(define *define-primop*     #f)
(define *location*          #f)

;*---------------------------------------------------------------------*/
;*    init-eval-cache! ...                                             */
;*---------------------------------------------------------------------*/
(define (init-eval-cache!)
   (set! *define-primop-ref* (require-global 'define-primop-ref!
					     '__evenv
					     #f))
   (set! *define-primop*     (require-global 'define-primop!
					     '__evenv
					     #f))
   (set! *location*          (require-global 'location
					     'foreign
					     #f)))

;*---------------------------------------------------------------------*/
;*    stop-eval-cache! ...                                             */
;*---------------------------------------------------------------------*/
(define (stop-eval-cache!)
   (set! *define-primop-ref* #f)
   (set! *define-primop*     #f)
   (set! *location*          #f))

;*---------------------------------------------------------------------*/
;*    make-eval-init ...                                               */
;*---------------------------------------------------------------------*/
(define (make-eval-init!)
   (init-eval-cache!)
   (let ((initf (find-global 'initialize-eval-primop! *module-name*)))
      (if (not (global? initf))
	  (internal-error "make-eval-init"
			  "Unbound variable"
			  'initialize-eval!)
	  (let ((body (make-eval-init-ast (get-eval-global-exported))))
	     (function-body-set! (global-value initf) body)
	     (stop-eval-cache!)
	     #unspecified))))

;*---------------------------------------------------------------------*/
;*    make-eval-init-ast ...                                           */
;*---------------------------------------------------------------------*/
(define (make-eval-init-ast l)
   (if (null? l)
       (sexp->ast #unspecified '() '() #f 'read)
       (ast-sequence #f
		     #f
		     #f
		     (list (ast-sequence #f
					 #f
					 #f
					 (map make-one-init l))
			   (sexp->ast #unspecified
				      '()
				      '()
				      #f
				      'read)))))

;*---------------------------------------------------------------------*/
;*    make-one-init ...                                                */
;*    -------------------------------------------------------------    */
;*    For variables, we produce the expression:                        */
;*       `(define-primop-ref ',(global-name var) (localtion ,var))     */
;*                                                                     */
;*    For functions:                                                   */
;*       `(define-primop ',(global-name var) ,var)                     */
;*---------------------------------------------------------------------*/
(define (make-one-init var)
   (global-occurrence-set! var (+fx 1 (global-occurrence var)))
   (if (eq? (global-class var) 'variable)
       (let ((loc (ast-app #f
			   #f
			   #f
			   (ast-var #f #f #f *location*)
			   (list (ast-var #f #f #f var))
			   #f
			   #f
			   #f
			   #f)))
	  (use-variable! *location* #f 'read)
	  (use-variable! *define-primop-ref* #f 'read)
	  (ast-app #f
		   #f
		   #f
		   (ast-var #f #f #f *define-primop-ref*)
		   (list (ast-kwote #f #f #f (global-name var) #f)
			 loc)
		   #f
		   #f
		   #f
		   #f))
       (begin
	  (use-variable! *define-primop* #f 'read)
	  (ast-app #f
		   #f
		   #f
		   (ast-var #f #f #f *define-primop*)
		   (list (ast-kwote #f #f #f (global-name var) #f)
			 (ast-var #f #f #f var))
		   #f
		   #f
		   #f
		   #f))))

	   
