;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cnst/initialize.scm      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Feb 20 15:50:19 1995                          */
;*    Last change :  Fri Mar 22 15:52:29 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The initialize function definition.                              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cnst_initialize
   (include "Tools/trace.sch"
	    "Ast/node.sch")
   (import  tools_shape
	    tools_speek
	    engine_param
	    cnst_alloc
	    cnst_ast
	    ast_sexp
	    ast_env)
   (export  (initialize-init!)
	    (initialize-stop!)))

;*---------------------------------------------------------------------*/
;*    *init-constant-function* ...                                     */
;*---------------------------------------------------------------------*/
(define *init-constant-function* #f)

;*---------------------------------------------------------------------*/
;*    initialize-init! ...                                             */
;*---------------------------------------------------------------------*/
(define (initialize-init!)
   (set! *init-constant-function*
	 (find-global 'initialize-constants! *module-name*))
      (if (not (global? *init-constant-function*))
	  (begin
	     (internal-error "cnst-walk!"
			     "Can't find static function"
			     "initialize-constants!")
	     #f)
	  #t))

;*---------------------------------------------------------------------*/
;*    initialize-stop! ...                                             */
;*    -------------------------------------------------------------    */
;*    Now, we have finished the ast walk, we can set the               */
;*    initialization function definition.                              */
;*---------------------------------------------------------------------*/
(define (initialize-stop!)
   (case *init-mode*
      ((lib)
       (lib-initialize!))
      ((read)
       (read-initialize!))
      ((intern)
       (intern-initialize!))
      (else
       (internal-error "intialize-stop!" "Illegal init-mode" *init-mode*))))

;*---------------------------------------------------------------------*/
;*    lib-initialize! ...                                              */
;*---------------------------------------------------------------------*/
(define (lib-initialize!)
   (global-occurrence-set! (get-cnst-table) 0)
   (global-target-name-set! (get-cnst-table) "*__cnst")
   (function-body-set! (global-value *init-constant-function*)
		       (ast-sequence #f
				     #f
				     #f
				     (append (get-cnst-ast)
					     (list (sexp->ast
						    '#unspecified
						    '()
						    *init-constant-function*
						    #f
						    'read)))))
   #t)

;*---------------------------------------------------------------------*/
;*    read-initialize! ...                                             */
;*---------------------------------------------------------------------*/
(define (read-initialize!)
   (if (=fx (get-cnst-offset) 0)
       (read-empty-cnst-initialize!)
       (read-full-cnst-initialize!)))

;*---------------------------------------------------------------------*/
;*    read-empty-cnst-initialize! ...                                  */
;*---------------------------------------------------------------------*/
(define (read-empty-cnst-initialize!)
   (global-occurrence-set! (get-cnst-table) 0)
   (global-target-name-set! (get-cnst-table) "*__cnst")
   (let* ((cnst-string (cnst-set->cnst-string (get-cnst-set))) 
	  (ast      (ast-sequence #f
				  #f
				  #f
				  (append (get-cnst-ast)
					  (list (sexp->ast
						 '#unspecified
						 '()
						 *init-constant-function*
						 #f
						 'read))))))
      (function-body-set! (global-value *init-constant-function*) ast)
      #t))

;*---------------------------------------------------------------------*/
;*    read-full-cnst-initialize! ...                                   */
;*---------------------------------------------------------------------*/
(define (read-full-cnst-initialize!)
   (global-target-name-set! (get-cnst-table)
			    (string-append "__cnst[ "
					   (number->string (get-cnst-offset))
					   " ] "))
   (define (read-full-cnst-initialize/small-string cnst-string)
      (let* ((var-string  (cnst-alloc-string cnst-string #f))
	     (sexp `(let (((:: cnst-port input-port)
			   (c-open-input-string ,(global-name
						  (var-variable
						   var-string)))))
		       (labels ((loop ((:: i int))
				      (if (c-=fx i -1)
					  #unspecified
					  (begin
					     (cnst-table-set! i
							      (read (c-cons
								     cnst-port
								     '())))
					     (let (((:: aux int) (c--fx i 1)))
						(loop aux))))))
			  (loop ,(-fx (get-cnst-offset) 1)))))
	     (ast-read (sexp->ast sexp
				  '()
				  *init-constant-function*
				  #f
				  'read))
	     (ast      (ast-sequence #f
				     #f
				     #f
				     (cons ast-read
					   (get-cnst-ast)))))
	 (function-body-set! (global-value *init-constant-function*) ast)
	 #t))
   (let* ((cnst-string (cnst-set->cnst-string (get-cnst-set))))
      (read-full-cnst-initialize/small-string cnst-string)))

;*---------------------------------------------------------------------*/
;*    cnst-set->cnst-string ...                                        */
;*    -------------------------------------------------------------    */
;*    What we call an `set' is just a list of all the constant.        */
;*    To build the string, we just print it !                          */
;*---------------------------------------------------------------------*/
(define (cnst-set->cnst-string set)
   (let ((port (open-output-string)))
      (if (not (output-port? port))
	  (internal-error "cnst-set->cnst-string"
			  "Can't open output string port"
			  port)
	  (begin
	     (for-each (lambda (cnst)
			  (write cnst port)
			  (write-char #\space port))
		       set)
	     (close-output-port port)))))
  
;*---------------------------------------------------------------------*/
;*    intern-initialize! ...                                           */
;*---------------------------------------------------------------------*/
(define (intern-initialize!)
   (if (=fx (get-cnst-offset) 0)
       (intern-empty-cnst-initialize!)
       (intern-full-cnst-initialize!)))

;*---------------------------------------------------------------------*/
;*    intern-empty-cnst-initialize! ...                                */
;*---------------------------------------------------------------------*/
(define (intern-empty-cnst-initialize!)
   (global-occurrence-set! (get-cnst-table) 0)
   (global-target-name-set! (get-cnst-table) "*__cnst")
   (let* ((ast (ast-sequence #f
			     #f
			     #f
			     (append (get-cnst-ast)
				     (list (sexp->ast
					    '#unspecified
					    '()
					    *init-constant-function*
					    #f
					    'read))))))
      (function-body-set! (global-value *init-constant-function*) ast)
      #t))

;*---------------------------------------------------------------------*/
;*    intern-full-cnst-initialize! ...                                 */
;*---------------------------------------------------------------------*/
(define (intern-full-cnst-initialize!)
   (global-target-name-set! (get-cnst-table)
			    (string-append "__cnst[ "
					   (number->string (get-cnst-offset))
					   " ] "))
   (define (intern-full-cnst-initialize/small-string cnst-string)
      (let* ((var-string  (cnst-alloc-string cnst-string #f))
	     (sexp `(let (((:: cnst-tmp vector) (string->obj ,(global-name
							       (var-variable
								var-string)))))
		       (labels ((loop ((:: i int))
				      (if (c-=fx i -1)
					  #unspecified
					  (begin
					     (cnst-table-set! i
							      (c-vector-ref
							       cnst-tmp
							       i))
					     (let (((:: aux int) (c--fx i 1)))
						(loop aux))))))
			  (loop ,(-fx (get-cnst-offset) 1)))))
	     (ast-intern (sexp->ast sexp
				    '()
				    *init-constant-function*
				    #f
				    'read))
	     (ast      (ast-sequence #f
				     #f
				     #f
				     (cons ast-intern
					   (get-cnst-ast)))))
	 (function-body-set! (global-value *init-constant-function*) ast)
	 #t))
   (let* ((cnst-string (obj->string (list->vector (reverse! (get-cnst-set))))))
      (intern-full-cnst-initialize/small-string cnst-string)))

 
