;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cfa/walk.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Feb 21 08:37:48 1995                          */
;*    Last change :  Thu Aug 24 13:43:47 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `control flow analysis'                                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_walk
   (include "Tools/pass.sch"
	    "Tools/trace.sch"
	    "Ast/ast.sch")
   (import  tools_shape
	    engine_param
	    ast_global
	    cfa_approx
	    cfa_cache
	    cfa_cfa
	    cfa_collect
	    cfa_closure
	    cfa_dead
	    cfa_tvector
	    cfa_special
	    cfa_initial
	    cfa_warning
	    cfa_type
	    cfa_show
	    cfa_stack)
   (export  (cfa-walk! <global>*)))

;*---------------------------------------------------------------------*/
;*    cfa-walk! ...                                                    */
;*    -------------------------------------------------------------    */
;*    This function is the engine of all the cfa based optimizations.  */
;*    First, this function invokes the cfa, then the following         */
;*    optimizations are performed:                                     */
;*       1. dead code remove                                           */
;*       2. closure optimization (mapping to X and T)                  */
;*       3. type setting (a kind of reverse type inference)            */
;*       4. allocation class mapping (stackability)                    */
;*---------------------------------------------------------------------*/
(define (cfa-walk! globals)
   (pass-prelude "Cfa" start-cfa-cache! start-cfa-special!)
   ;; first of all, we scan the global definitions in order
   ;; to collect all used types and allocations.
   (collect-all-approx!)
   ;; we have collected all the approximation, we can now declare
   ;; the approximations sets.
   (declare-approx-sets!)
   ;; we have collect all the possible approximation, we now
   ;; prepare the ast to the iteration process.
   (set-initial-approx!)
   ;; ok, we can start now the control flow analysis
   (cfa!)
   ;; the number of iterations
   (show-cfa-nb-iterations)
   ;; warnings
   (if (and (integer? *warning*) (>fx *warning* 1))
       (cfa-warning))
   ;; dead code removal
   (let ((globals    (dead-code-removal! globals))
	 (additional '()))
      ;; we show the result of the approximation (after dead-code-removal!)
      (show-cfa-results)
      ;; allocation class mapping
      (if (and *heap->stack?* (eq? *stack-alloc* 'alloca))
	  (heap->stack!))
      ;; tvector optimization
      (if (>=fx *optim* 1)
	  (set! additional (append (tvector-optimization! globals)
				   additional)))
      ;; type settings
      (type-settings! globals)
      ;; we optimize closure allocations
      (if (>=fx *optim* 2)
	  (closure-optimization!))
      (pass-postlude (append additional globals)
		     stop-cfa-special!
		     stop-cfa-cache!)))

