;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cfa/initial.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Apr  5 09:56:57 1995                          */
;*    Last change :  Wed Oct 11 11:16:30 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We set the initial approximations in the Ast.                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_initial
   (include "Tools/trace.sch"
	    "Ast/node.sch"
	    "Type/type.sch"
	    "Cfa/approx.sch")
   (import  tools_shape
	    type_cache
	    ast_dump
	    ast_env
	    ast_typeof
	    cfa_tvector
	    cfa_special
	    cfa_top
	    cfa_approx
	    cfa_cfa)
   (export  (set-initial-approx!)))

;*---------------------------------------------------------------------*/
;*    set-initial-approx! ...                                          */
;*---------------------------------------------------------------------*/
(define (set-initial-approx!)
   (trace (cfa loop init) "set-initial-approx!:" #\Newline)
   (for-each-global!
    (lambda (global)
       (trace (cfa loop init) "      " (shape global) ": ")
       (cond
;*--- unused ----------------------------------------------------------*/
	  ((and (not (eq? (global-import global) 'export))
		(=fx (global-occurrence global) 0))
	   (trace (cfa loop init) "[unused]" #\Newline)
	   #unspecified)
;*--- variable --------------------------------------------------------*/
	  ((or (eq? (global-class global) 'variable)
	       (eq? (global-class global) 'c-variable)
	       (eq? (global-class global) 'c-macro-variable))
	   (trace (cfa loop init) "[variable]" #\Newline)
	   ;; we create a typed approximation.
	   (let ((type (global-type global)))
	      (if (type? type)
		  (begin
		     (set-approx! global (create-approx (list type) '()))
		     (type-lock-approx! (get-approx global)))
		  (set-approx! global (create-approx '() '()))))
	   ;; and if the variable is exported we add top to its
	   ;; approximations
	   (if (not (eq? (global-import global) 'static))
	       (begin
		  (add-obj! (get-approx global))
		  (add-top! (get-approx global)))))
;*--- sprocedure ------------------------------------------------------*/
	  ((eq? (global-class global) 'sprocedure)
	   (trace (cfa loop init) "[sprocedure]" #\Newline)
	   (set-approx! global (create-approx (list (typeof global))
					      (list (global-value global))))
	   (ast-set-iapprox! (global-value global))
	   (top-lock-approx! (get-approx global))
	   (type-lock-approx! (get-approx global)))
;*--- special ---------------------------------------------------------*/
	  ((or (and (function? (global-value global))
		    (ispecial? (function-cfa-info (global-value global))))
	       (and (ffunction? (global-value global))
		    (ispecial? (ffunction-cfa-info (global-value global)))))
	   #unspecified)
;*--- ffunction -------------------------------------------------------*/
	  ((or (eq? (global-class global) 'c-function)
	       (eq? (global-class global) 'c-macro-function))
	   (trace (cfa loop init) "[ffunction]" #\Newline)
	   (let ((type (ffunction-type-res (global-value global))))
	      (set-approx! global (create-approx (list type) '()))
	      (type-lock-approx! (get-approx global))
	      (add-top! (get-approx global))))
;*--- function --------------------------------------------------------*/
	  ((or (eq? (global-class global) 'procedure)
	       (eq? (global-class global) 'inline))
	   (trace (cfa loop init) "[function]" #\Newline)
	   (case (global-import global)
	      ((export static)
	       (function-set-initial-approx! global))
	      ((import)
	       (let ((type (function-type-res (global-value global))))
		  (set-approx! global (create-approx (list type) '()))
		  (type-lock-approx! (get-approx global))
		  (add-top! (get-approx global))))))
;*--- error -----------------------------------------------------------*/
	  (else
	   (internal-error "set-initial-approx!"
			   "Don't know what to do with"
			   (shape global))))))
   #unspecified)

;*---------------------------------------------------------------------*/
;*    function-set-initial-approx! ...                                 */
;*---------------------------------------------------------------------*/
(define (function-set-initial-approx! var)
   (let* ((fun  (variable-value var))
	  (args (function-args fun))
	  (body (function-body fun))
	  (top? (and (global? var) (eq? (global-import var) 'export)))
	  (tres (function-type-res fun)))
      ;; we create the ifun structure
      (if (type? tres)
	  (begin
	     (variable-cfa-info-set! var (ifun #f
					       *cfa-stamp*
					       (create-approx (list tres)
							      '())))
	     ;; we type lock the result only if the function is exported
	     (if top?
		 (type-lock-approx! (get-approx var))))
	  (variable-cfa-info-set! var
				  (ifun #f
					*cfa-stamp*
					(create-approx '() '()))))
      ;; we prepare the formal approximations
      (for-each (lambda (l)
		   (let ((type (local-type l)))
		      (if (type? type)
			  (set-approx! l (create-approx (list type) '()))
			  (set-approx! l (create-approx '() '()))))
		   (if top?
		       (begin
			  ;; as for the result, formal are type locked
			  ;; only if the function is exported
			  (type-lock-approx! (get-approx l))
			  (add-top! (get-approx l)))))
		args)
      (ast-set-iapprox! body)))

;*---------------------------------------------------------------------*/
;*    ast-set-iapprox! ...                                             */
;*---------------------------------------------------------------------*/
(define (ast-set-iapprox! ast)
   (trace (cfa loop init) "ast-set-iapprox: " (ast->sexp ast) #\Newline)
   (ast-case ast
      ((atom)
       (set-approx! ast (create-approx (list (typeof ast)) '())))
      ((kwote)
       (if (ast? (kwote-cfa-info ast))
	   (let ((value (kwote-value ast)))
	      (ast-set-iapprox! (kwote-cfa-info ast)))
	   (set-approx! ast (create-approx (list (typeof ast)) '()))))
      ((var)
       ;; nothing to do because the approximation is in the variable,
       ;; not in the ast node itself
       #unspecified)
      ((prag-ma)
       (for-each ast-set-iapprox! (prag-ma-values ast))
       (set-approx! ast (create-approx (list (typeof ast)) '()))
       (add-top! (get-approx ast)))
      ((fail)
       (ast-set-iapprox! (fail-proc ast))
       (ast-set-iapprox! (fail-msg ast)) 
       (ast-set-iapprox! (fail-obj ast))
       (set-approx! ast (create-approx '() '())))
      ((sequence)
       (for-each ast-set-iapprox! (sequence-exp ast)))
      ((conditional)
       (ast-set-iapprox! (conditional-test ast))
       (ast-set-iapprox! (conditional-then ast))
       (ast-set-iapprox! (conditional-else ast))
       (set-approx! ast (create-approx '() '())))
      ((switch)
       (ast-set-iapprox! (switch-test ast))
       (for-each (lambda (clause)
		    (ast-set-iapprox! (cdr clause)))
		 (switch-clauses ast))
       (set-approx! ast (create-approx '() '())))
      ((setq)
       (ast-set-iapprox! (setq-var ast))
       (ast-set-iapprox! (setq-val ast))
       (set-approx! ast (create-approx (list (typeof ast)) '()))
       (add-top! (get-approx ast)))
      ((let-var)
       (for-each (lambda (binding)
		    ;; we set the variable approximation
		    (let* ((var  (car binding))
			   (type (local-type var)))
		       (if (type? type)
			   ;; there is no need to type local variable.
			   ;; at least, they can change of type
			   (set-approx! var (create-approx (list type) '()))
			   (set-approx! var (create-approx '() '()))))
		    ;; and the value approximation
		    (ast-set-iapprox! (cdr binding)))
		 (let-var-bindings ast))
       ;; then, we type the body
       (ast-set-iapprox! (let-var-body ast)))
      ((let-fun)
       (for-each function-set-initial-approx! (let-fun-locals ast))
       (ast-set-iapprox! (let-fun-body ast)))
      ((jump-ex-it)
       (ast-set-iapprox! (jump-ex-it-exit ast))
       (ast-set-iapprox! (jump-ex-it-value ast))
       (set-approx! ast (create-approx '() '()))
       (add-top! (get-approx ast))
       (add-obj! (get-approx ast)))
      ((set-ex-it)
       (let ((exit (var-variable (set-ex-it-exit ast))))
	  (set-approx! exit (create-approx (list (typeof exit)) '()))
	  (type-lock-approx! (get-approx exit)))
       (ast-set-iapprox! (set-ex-it-body ast))
       (set-approx! ast (create-approx '() '()))
       (add-top! (get-approx ast))
       (add-obj! (get-approx ast)))
      ((app-ly)
       (ast-set-iapprox! (app-ly-fun ast))
       (ast-set-iapprox! (app-ly-value ast))
       (let ((approx (create-approx (list *obj*) '())))
	  (add-top! approx)
	  (set-approx! ast approx)))
      ((funcall)
       (ast-set-iapprox! (funcall-fun ast))
       (for-each ast-set-iapprox! (funcall-actuals ast))
       (set-approx! ast (create-approx '() '())))
      ((make-box)
       (ast-set-iapprox! (make-box-value ast))
       (set-approx! ast (create-approx (list (typeof ast)) '()))
       (type-lock-approx! (get-approx ast)))
      ((box-ref)
       (ast-set-iapprox! (box-ref-var ast)))
      ((box-set!)
       (ast-set-iapprox! (box-set!-var ast))
       (ast-set-iapprox! (box-set!-value ast))
       (set-approx! ast (create-approx (list (typeof ast)) '())))
      ((app)
       (for-each ast-set-iapprox! (app-actuals ast))
       ;; there is two cases:
       ;;   1- it is a call to a special function (like an allocation)
       ;;      or a getter, then there is a duplication of this function
       ;;   2- we call a `regular' function and then all calls are merged.
       (if (is-special-call? ast)
	   (set-approx! ast (create-special-approx ast))
	   (set-approx! ast (create-approx '() '()))))))
