;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cfa/cache.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Feb 19 10:35:59 1995                          */
;*    Last change :  Thu Aug 24 13:23:08 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    A cache to be able to recognize function call very fast.         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_cache
   (import  ast_global
	    engine_param
	    type_env)
   (export  (start-cfa-cache!)
	    (stop-cfa-cache!)
	    *initialization*
	    *procedure-ref*
	    *procedure-set!*
	    *procedure-l-ref*
	    *procedure-l-set!*
	    *procedure-el-ref*
	    *procedure-el-set!*
	    *procedure-1-el-ref*
	    *procedure-1-el-set!*
	    *nop*
	    *location*
	    *cons*
	    *car*
	    *cdr*
	    *set-car!*
	    *set-cdr!*
	    *create-vector*
	    *make-vector*
	    *create-s-vector*
	    *make-s-vector*
	    *vector-ref*
	    *vector-set!*
	    *vector-length*
	    *tvector-length*
	    *make-fx-procedure*
	    *make-va-procedure*
	    *make-s-fx-procedure*
	    *make-s-va-procedure*
	    *make-s-el-procedure*
	    *make-el-procedure*
	    *make-el-procedure-1*
	    *make-l-procedure*
	    *make-s-l-procedure*))

;*---------------------------------------------------------------------*/
;*    The cache registers definition                                   */
;*---------------------------------------------------------------------*/
(define *initialization*      #f)
(define *nop*                 #f)
(define *location*            #f)
(define *cons*                #f)
(define *car*                 #f)
(define *cdr*                 #f)
(define *set-car!*            #f)
(define *set-cdr!*            #f)
(define *procedure-ref*       #f)
(define *procedure-set!*      #f)
(define *procedure-l-ref*     #f)
(define *procedure-l-set!*    #f)
(define *procedure-el-ref*    #f)
(define *procedure-el-set!*   #f)
(define *procedure-1-el-ref*  #f)
(define *procedure-1-el-set!* #f)
(define *struct-ref*          #f)
(define *struct-set!*         #f)
(define *create-vector*       #f)
(define *make-vector*         #f)
(define *create-s-vector*     #f)
(define *make-s-vector*       #f)
(define *vector-ref*          #f)
(define *vector-set!*         #f)
(define *vector-length*       #f)
(define *tvector-length*      #f)
(define *make-fx-procedure*   #f)
(define *make-va-procedure*   #f)
(define *make-s-fx-procedure* #f)
(define *make-s-va-procedure* #f)
(define *make-el-procedure*   #f)
(define *make-s-el-procedure* #f)
(define *make-el-procedure-1* #f)
(define *make-l-procedure*    #f)
(define *make-s-l-procedure*  #f)

;*---------------------------------------------------------------------*/
;*    start-cfa-cache! ...                                             */
;*---------------------------------------------------------------------*/
(define (start-cfa-cache!)
   (set! *initialization*
	 (require-global 'initialization *module-name* #f))
   (set! *nop*
	 (require-global 'nop 'foreign #f))
   (set! *location*
	 (require-global 'location 'foreign #f))
   (set! *cons*
	 (require-global 'c-cons 'foreign #f))
   (set! *car*
	 (require-global 'c-car 'foreign #f))
   (set! *cdr*
	 (require-global 'c-cdr 'foreign #f))
   (set! *set-car!*
	 (require-global 'c-set-car! 'foreign #f))
   (set! *set-cdr!*
	 (require-global 'c-set-cdr! 'foreign #f))
   (set! *procedure-ref*
	 (require-global 'procedure-ref 'foreign #f))
   (set! *procedure-set!*
	 (require-global 'procedure-set! 'foreign #f))
   (set! *procedure-l-ref*
	 (require-global 'procedure-l-ref 'foreign #f))
   (set! *procedure-l-set!*
	 (require-global 'procedure-l-set! 'foreign #f))
   (set! *procedure-el-ref*
	 (require-global 'procedure-el-ref 'foreign #f))
   (set! *procedure-el-set!*
	 (require-global 'procedure-el-set! 'foreign #f))
   (set! *procedure-1-el-ref*
	 (require-global 'procedure-1-el-ref 'foreign #f))
   (set! *procedure-1-el-set!*
	 (require-global 'procedure-1-el-set! 'foreign #f))
;*    (set! *struct-ref*                                               */
;* 	 (require-global 'c-struct-ref 'foreign #f))             */
;*    (set! *struct-set!*                                              */
;* 	 (require-global 'c-struct-set! 'foreign #f))            */
   (set! *create-vector*
	 (require-global 'c-create-vector 'foreign #f))
   (set! *make-vector*
	 (require-global 'c-make-vector 'foreign #f))
   (set! *create-s-vector*
	 (require-global 'c-create-s-vector 'foreign #f))
   (set! *make-s-vector*
	 (require-global 'c-make-s-vector 'foreign #f))
   (set! *vector-ref*
	 (require-global 'c-vector-ref 'foreign #f))
   (set! *vector-set!*
	 (require-global 'c-vector-set! 'foreign #f))
   (set! *vector-length*
	 (require-global 'c-vector-length 'foreign #f))
   (set! *tvector-length*
	 (require-global 'c-tvector-length 'foreign #f))
   (set! *make-fx-procedure*
	 (require-global 'make-fx-procedure #f #f))
   (set! *make-va-procedure*
	 (require-global 'make-va-procedure #f #f))
   (set! *make-s-fx-procedure*
	 (require-global 'make-s-fx-procedure #f #f))
   (set! *make-s-va-procedure*
	 (require-global 'make-s-va-procedure #f #f))
   (set! *make-el-procedure*
	 (require-global 'make-el-procedure #f #f))
   (set! *make-s-el-procedure*
	 (require-global 'make-s-el-procedure #f #f))
   (set! *make-el-procedure-1*
	 (require-global 'make-el-procedure-1 #f #f))
   (set! *make-l-procedure*
	 (require-global 'make-l-procedure #f #f))
   (set! *make-s-l-procedure*
	 (require-global 'make-s-l-procedure #f #f))
   #t)


;*---------------------------------------------------------------------*/
;*    stop-cfa-cache! ...                                              */
;*---------------------------------------------------------------------*/
(define (stop-cfa-cache!)
   (set! *make-el-procedure*   #f)
   (set! *make-s-el-procedure* #f)
   (set! *make-el-procedure-1* #f)
   (set! *make-l-procedure*    #f)
   (set! *make-s-l-procedure*  #f)
   (set! *make-fx-procedure*   #f)
   (set! *make-va-procedure*   #f)
   (set! *make-s-fx-procedure* #f)
   (set! *make-s-va-procedure* #f)
   (set! *procedure-ref*       #f)
   (set! *procedure-set!*      #f)
   (set! *procedure-el-ref*    #f)
   (set! *procedure-1-el-set!* #f)
   (set! *procedure-1-el-ref*  #f)
   (set! *procedure-el-set!*   #f)
   (set! *procedure-l-ref*     #f)
   (set! *procedure-l-set!*    #f)
   (set! *struct-ref*          #f)
   (set! *struct-set!*         #f)
   (set! *create-vector*       #f)
   (set! *make-vector*         #f)
   (set! *create-s-vector*     #f)
   (set! *make-s-vector*       #f)
   (set! *vector-ref*          #f)
   (set! *vector-set!*         #f)
   (set! *vector-length*       #f)
   (set! *tvector-length*      #f)
   (set! *nop*                 #f)
   (set! *location*            #f)
   (set! *cons*                #f)
   (set! *car*                 #f)
   (set! *cdr*                 #f)
   (set! *set-car!*            #f)
   (set! *set-cdr!*            #f)
   (set! *initialization*      #f)
   #t)


