;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cfa/ast.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Feb 23 14:21:20 1995                          */
;*    Last change :  Fri Oct 27 14:46:00 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `control flow analysis': the walk down the ast               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_ast
   (include "Tools/trace.sch"
	    "Type/type.sch"
	    "Ast/node.sch"
	    "Cfa/approx.sch")
   (import  cfa_app
	    cfa_funcall
	    cfa_apply
	    cfa_cfa
	    cfa_approx
	    cfa_top
	    cfa_vector
	    ast_dump
	    tools_set
	    tools_shape)
   (export  (cfa-ast! ast)))

;*---------------------------------------------------------------------*/
;*    cfa-ast! ...                                                     */
;*    -------------------------------------------------------------    */
;*    ast -> approx                                                    */
;*---------------------------------------------------------------------*/
(define (cfa-ast! ast)
   (trace (cfa loop) "> " (ast->sexp ast) #\Newline)
   (ast-case ast
      ((atom)
       (get-approx ast))
      ((kwote)
       (if (ast? (kwote-cfa-info ast))
	   (cfa-ast! (kwote-cfa-info ast))
	   (get-approx ast)))
      ((var)
       (get-approx ast))
      ((prag-ma)
       (for-each spread-top! (map cfa-ast! (prag-ma-values ast)))
       (get-approx ast))
      ((fail)
       (spread-top! (cfa-ast! (fail-proc ast)))
       (spread-top! (cfa-ast! (fail-msg ast)))
       (spread-top! (cfa-ast! (fail-obj ast)))
       (get-approx ast))
      ((sequence)
       (let loop ((asts (sequence-exp ast))
		  (last #unspecified))
	  (if (null? asts)
	      last
	      (loop (cdr asts) (cfa-ast! (car asts))))))
      ((conditional)
       (cfa-ast! (conditional-test ast))
       (let ((approx      (get-approx ast))
	     (then-approx (cfa-ast! (conditional-then ast)))
	     (else-approx (cfa-ast! (conditional-else ast))))
	  (union-approx! approx then-approx else-approx)
	  (set-approx! ast approx)
	  approx))
      ((switch)
       (cfa-ast! (switch-test ast))
       (let ((approx (get-approx ast)))
	  (let loop ((clauses (switch-clauses ast)))
	     (if (null? clauses)
		 approx
		 (let ((new-approx (cfa-ast! (cdr (car clauses)))))
		    (union-approx! approx new-approx)
		    (loop (cdr clauses)))))))
      ((setq)
       (let* ((approx     (get-approx (setq-var ast)))
	      (val-approx (cfa-ast! (setq-val ast))))
	  (union-approx! approx val-approx)
	  (let ((var (var-variable (setq-var ast))))
	     (if (and (global? var) (eq? (global-import var) 'import))
		 (spread-top! (get-approx (setq-var ast))))
	     (if (approx-type-locked? approx)
		 (lock-vectors! val-approx)))
	  (get-approx ast)))
      ((let-var)
       (for-each
	(lambda (binding)
	   (let* ((var        (car binding))
		  (var-approx (get-approx var))
		  (val-approx (cfa-ast! (cdr binding))))
	      (if (approx-type-locked? var-approx)
		  (lock-vectors! val-approx))
	      (union-approx! var-approx val-approx)))
	(let-var-bindings ast))
       (cfa-ast! (let-var-body ast)))
      ((let-fun)
       (cfa-ast! (let-fun-body ast)))
      ((set-ex-it)
       (spread-top! (cfa-ast! (set-ex-it-body ast)))
       (get-approx ast))
      ((jump-ex-it)
       (cfa-ast! (jump-ex-it-exit ast))
       (let ((approx (cfa-ast! (jump-ex-it-value ast))))
	  (add-obj! approx)
	  (add-top! approx)
	  (spread-top! approx)
	  (get-approx ast)))
      ((app-ly)
       (cfa-apply! ast))
      ((funcall)
       (cfa-funcall! ast))
      ((make-box)
       (let ((val-approx (cfa-ast! (make-box-value ast))))
	  (union-approx! (get-approx ast) val-approx)
	  (get-approx ast)))
      ((box-set!)
       ;; box-set! is a setq.
       (let* ((approx     (get-approx (box-set!-var ast)))
	      (val-approx (cfa-ast! (box-set!-value ast))))
	  (add-obj! approx)
	  (union-approx! approx val-approx)
	  (get-approx ast)))
       ((box-ref)
	;; box-ref is a variable references.
	(add-obj! (get-approx (box-ref-var ast)))
	(cfa-ast! (box-ref-var ast)))
       ((app)
	(let ((fun            (var-variable (app-fun ast)))
	      (actuals-approx (map cfa-ast! (app-actuals ast))))
	   (cfa-app! ast fun actuals-approx)))))
   

