;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Bivalue/apply.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Jan 21 12:45:11 1995                          */
;*    Last change :  Thu Mar 28 16:15:31 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `apply' construction bivaluation                             */
;*=====================================================================*/
 
;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module bivalue_apply
   (include "Ast/node.sch")
   (import  tools_shape
	    tools_speek
	    bivalue_walk
	    bivalue_cache
	    type_env
	    ast_dump
	    ast_env
	    ast_global
	    ast_local)
   (export (bivalue-apply! <ast>)))

;*---------------------------------------------------------------------*/
;*    bivalue-apply! ...                                               */
;*---------------------------------------------------------------------*/
(define (bivalue-apply! ast)
   ;; we look for the applied function
   (let ((fun (app-ly-fun ast)))
      (if (var? fun)
	  (cond
	     ((function? (variable-value (var-variable fun)))
	      (bivalue-known-bigloo-apply! (var-variable fun) ast))
	     ((ffunction? (variable-value (var-variable fun)))
	      (bivalue-known-foreign-apply! (var-variable fun) ast))
	     (else
	      (bivalue-unknown-apply! ast)))
	  (bivalue-unknown-apply! ast))))

;*---------------------------------------------------------------------*/
;*    bivalue-known-bigloo-apply! ...                                  */
;*---------------------------------------------------------------------*/
(define (bivalue-known-bigloo-apply! callee ast)
   ;; we bivaluate value slot
   (app-ly-value-set! ast (bivalue! (app-ly-value ast)))
   (let* ((fun   (variable-value callee))
	  (arity (function-arity fun))
	  (frame (let loop ((formals (function-args (variable-value callee)))
			   (locals  '()))
		   (cond
		      ((null? formals)
		       (reverse! locals))
		      ((and (null? (cdr formals))
			    (<fx arity 0))
		       (reverse! locals))
		      (else
		       (loop (cdr formals)
			     (cons (make-local-variable
				    (gensym 'aux)
				    (local-type (car formals)))
				   locals))))))
	 (loc    (ast-location ast))
	 (type   (ast-type ast)))
      (if (>=fx arity 0)
	  (nested-fx-let loc type ast frame)
	  (nested-va-let loc type ast frame))))

;*---------------------------------------------------------------------*/
;*    bivalue-known-foreign-apply! ...                                 */
;*---------------------------------------------------------------------*/
(define (bivalue-known-foreign-apply! callee ast)
   ;; we bivaluate value slot
   (app-ly-value-set! ast (bivalue! (app-ly-value ast)))
   (let* ((fun   (variable-value callee))
	  (arity (function-arity fun))
	  (frame (let loop ((types   (ffunction-type-args
				     (variable-value callee)))
			   (locals  '()))
		   (if (null? types)
		       (reverse! locals)
		       (loop (cdr types)
			     (cons (make-local-variable (gensym 'aux)
							(car types))
				   locals)))))
	 (loc    (ast-location ast))
	 (type   (ast-type ast)))
      (if (>=fx arity 0)
	  (nested-fx-let loc type ast frame)
	  (nested-va-let loc type ast frame))))
  
;*---------------------------------------------------------------------*/
;*    nested-fx-let ...                                                */
;*    -------------------------------------------------------------    */
;*    We perform the following transformation (f is a known n fix      */
;*    arity function).                                                 */
;*                                                                     */
;*    (apply f exp)                                                    */
;*       -->                                                           */
;*    (let ((runner exp))                                              */
;*       (let ((a0 (car runner)))                                      */
;*          (set! runner (cdr runner))                                 */
;*          (let ((a1 (car runner)))                                   */
;*             (set! runner (cdr runner))                              */
;*             ...                                                     */
;*    	       (let ((an (car runner)))                                */
;*    	          (f a0 ... an)))))                                    */
;*---------------------------------------------------------------------*/
(define (nested-fx-let loc type ast frame)
   (let* ((runner (make-local-variable (gensym 'runner) (find-type 'obj)))
	  (carv   *car*)
	  (cdrv   *cdr*)
	  (a-car  (lambda ()
		     (global-occurrence-set! carv
					     (+fx 1 (global-occurrence carv)))
		     (ast-var loc type #f carv)))
	  (a-cdr  (lambda ()
		     (global-occurrence-set! cdrv
					     (+fx 1 (global-occurrence cdrv)))
		     (ast-var loc type #f cdrv))))
      ;; we build the `runner' binding
      (ast-let-var
       loc
       type
       #f
       (list (cons runner (app-ly-value ast)))
       (let loop ((locals frame))
	  (if (null? locals)
	      (ast-app loc
		       type
		       #f
		       (app-ly-fun ast)
		       (map (lambda (local)
			       (ast-var loc #f #f local))
			    frame)
		       #f
		       #f
		       #f
		       #f)
	      ;; we build the `an' binding
	      (ast-let-var
	       loc
	       type
	       #f
	       (list (cons (car locals)
			   (ast-app loc
				    type
				    #f
				    (a-car)
				    (list (ast-var loc #f #f runner))
				    #f
				    #f
				    #f
				    #f)))
	       (if (null? (cdr locals))
		   (loop (cdr locals))
		   (begin
		      (local-access-set! runner 'write)
		      (ast-sequence loc
				    type
				    #f
				    (list
				     ;; we build the (set! runner (cdr runner))
				     (ast-setq loc
					       #f
					       #f
					       (ast-var loc #f #f runner)
					       (ast-app loc
							type
							#f
							(a-cdr)
							(list (ast-var loc
								       #f
								       #f
								       runner))
							#f
							#f
							#f
							#f))
				     (loop (cdr locals))))))
	       #t)))
       #t)))

;*---------------------------------------------------------------------*/
;*    nested-va-let ...                                                */
;*    -------------------------------------------------------------    */
;*    We perform the following transformation (f is a known n fix      */
;*    arity function).                                                 */
;*                                                                     */
;*    (apply f exp)                                                    */
;*       -->                                                           */
;*    (let ((runner exp))                                              */
;*       (let ((a0 (car runner)))                                      */
;*          (set! runner (cdr runner))                                 */
;*          (let ((a1 (car runner)))                                   */
;*             (set! runner (cdr runner))                              */
;*             ...                                                     */
;*             (f a0 ... runner))))                                    */
;*---------------------------------------------------------------------*/
(define (nested-va-let loc type ast frame)
   (let* ((runner (make-local-variable (gensym 'runner) (find-type 'obj)))
	  (carv   *car*)
	  (cdrv   *cdr*)
	  (a-car  (lambda ()
		     (global-occurrence-set! carv
					     (+fx 1 (global-occurrence carv)))
		     (ast-var loc type #f carv)))
	  (a-cdr  (lambda ()
		     (global-occurrence-set! cdrv
					     (+fx 1 (global-occurrence cdrv)))
		     (ast-var loc type #f cdrv))))
      ;; we build the `runner' binding
      (ast-let-var
       loc
       type
       #f
       (list (cons runner (app-ly-value ast)))
       (let loop ((locals frame)
		  (old    '()))
	  (if (null? locals)
	      (begin
		 (if (null? old)
		     (set! frame (list runner))
		     (set-cdr! old (cons runner '())))
		 (ast-app loc
			  type
			  #f
			  (app-ly-fun ast)
			  (map (lambda (local)
				  (ast-var loc #f #f local))
			       frame)
			  #f
			  #f
			  #f
			  #f))
	      (begin
		 (local-access-set! runner 'write)
		 ;; we build the `an' binding
		 (ast-let-var
		  loc
		  type
		  #f
		  (list (cons (car locals)
			      (ast-app loc
				       type
				       #f
				       (a-car)
				       (list (ast-var loc #f #f runner))
				       #f
				       #f
				       #f
				       #f)))
		  (ast-sequence loc
				type
				#f
				(list
				 ;; we build the (set! runner (cdr runner))
				 (ast-setq loc
					   #f
					   #f
					   (ast-var loc #f #f runner)
					   (ast-app loc
						    type
						    #f
						    (a-cdr)
						    (list (ast-var loc
								   #f
								   #f
								   runner))
						    #f
						    #f
						    #f
						    #f))
				 (loop (cdr locals)
				       locals)))
		  #t))))
       #t)))

;*---------------------------------------------------------------------*/
;*    bivalue-unknown-apply! ...                                       */
;*---------------------------------------------------------------------*/
(define (bivalue-unknown-apply! ast)
   ;; we bivaluate value slot
   (app-ly-value-set! ast (bivalue! (app-ly-value ast)))
   ;; we bivaluate value slot
   (app-ly-fun-set! ast (bivalue! (app-ly-fun ast)))
   ;; and we return
   ast)

