;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Ast/global.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Dec 27 16:59:11 1994                          */
;*    Last change :  Fri Mar 22 17:02:15 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The declaration of global variables                              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_global
   (include "Ast/ast.sch"
	    "Tools/trace.sch"
	    "Type/type.sch")
   (import  ast_env
	    ast_local
	    type_env
	    engine_param
	    tools_args
	    tools_shape)
   (export  (declare-global-procedure!   <import> <symbol> <class> <proto>)
	    (declare-global-variable!    <import> <symbol> <class> <proto>)
	    (declare-foreign-function!   <sym> <st> <type>  <type>* <bool> <c>)
	    (declare-foreign-variable!   <symbol> <string> <type>  <c>)
	    (check-procedure-definition? <global> <import> <class> <proto>)
	    (check-variable-definition?  <global> <import> <class> <proto>)
	    (set-global-procedure-slot!  <global> <import> <class> <proto>)
	    (set-global-variable-slot!   <global> <import> <class> <proto>)
	    (global-shape                <global>)
	    (require-global              <sym> <sym> <bool>)
	    (use-global!                 <global>)))

;*---------------------------------------------------------------------*/
;*    *import* & *foreign* ...                                         */
;*---------------------------------------------------------------------*/
(define *import*  '())
(define *foreign* '())

;*---------------------------------------------------------------------*/
;*    declare-global-procedure! ...                                    */
;*---------------------------------------------------------------------*/
(define (declare-global-procedure! import module class proto)
   [assert check (import module class proto)
	   (and (memq import '(static export import))
			 (symbol? module)
                         (memq class '(variable procedure inline foreign)))]
   (let ((global (bind-global! (car (car proto)) module)))
      (if (eq? import 'import)
	  (set! *import* (cons global *import*)))
      (global-occurrence-set! global 0)
      (set-global-procedure-slot! global import class proto)))

;*---------------------------------------------------------------------*/
;*    declare-global-variable! ...                                     */
;*---------------------------------------------------------------------*/
(define (declare-global-variable! import module class proto)
   [assert check (import module class proto)
	   (and (memq import '(static export import eval))
			 (symbol? module)
                         (memq class '(sstring
				       sreal
				       sprocedure
				       stvector
				       eval
				       variable
				       procedure
				       foreign)))]
   (let ((global (bind-global! (car proto) module)))
      (if (eq? import 'import)
	  (set! *import* (cons global *import*)))
      (global-occurrence-set! global 0)
      (set-global-variable-slot! global import class proto)))

;*---------------------------------------------------------------------*/
;*    declare-foreign-variable! ...                                    */
;*---------------------------------------------------------------------*/
(define (declare-foreign-variable! name c-name type class)
   (assert check (name c-name type class)
	   (and (symbol? name)
		(string? c-name)
		(symbol? type)
		(memq class '(c-macro-variable c-variable))))
   (let ((old   (find-global name))
	 (fill! (lambda (global)
		   (global-pragma-set!      global '())
		   (global-target-name-set! global c-name)
		   (global-import-set!      global 'foreign)
		   (global-module-set!      global 'foreign)
		   (global-occurrence-set!  global 0)
		   (global-class-set!       global class)
		   (global-fast-alpha-set!  global #f)
		   (global-type-set!        global (use-type! type))
		   global)))
      (if (global? old)
	  (begin
	     (warning "top-level" "Redefinition of variable -- " name)
	     (fill! old))
	  (let ((global (bind-global! name 'foreign)))
	     (set! *foreign* (cons global *foreign*))
	     (fill! global)))))
	
;*---------------------------------------------------------------------*/
;*    declare-foreign-function! ...                                    */
;*---------------------------------------------------------------------*/
(define (declare-foreign-function! name c-name type args-type infix class)
   (assert check (name c-name type args-type infix class)
	   (and (symbol? name)
		(string? c-name)
		(symbol? type)
		(memq class '(c-function c-macro-function))))
   [assert check (infix class) (or (not infix) (eq? class 'c-macro-function))]
   (let* ((arity (lambda (exp)
		    (cond
		       ((null? exp)
			0)
		       ((not (pair? exp))
			-1)
		       (else
			(let loop ((i    0)
				   (args exp))
			   (cond
			      ((null? args)
			       i)
			      ((pair? args)
			       (loop (+fx i 1) (cdr args)))
			      (else
			       (negfx (+fx i 1)))))))))
	  (fill! (lambda (global)
		    (global-pragma-set!      global '())
		    (global-target-name-set! global c-name)
		    (global-import-set!      global 'foreign)
		    (global-module-set!      global 'foreign)
		    (global-occurrence-set!  global 0)
		    (global-class-set!       global class)
		    (global-fast-alpha-set!  global #f)
		    (global-type-set!        global (find-type 'function))
		    (let ((ffun (make-ffunction)))
		       (global-value-set! global ffun)
		       (ffunction-arity-set! ffun (arity args-type))
		       (ffunction-infix-set! ffun infix)
		       (if (and infix (not (=fx (ffunction-arity ffun) 2)))
			   (user-error "declare-foreign-function!"
				       "Illegal infix declaration"
				       name))
		       (ffunction-type-res-set! ffun (use-type! type))
		       (let loop ((args args-type)
				  (res  '()))
			  (cond
			     ((null? args)
			      (ffunction-type-args-set! ffun (reverse! res)))
			     ((not (pair? args))
			      (let ((targs (use-type! args)))
				 (ffunction-type-args-set!
				  ffun
				  (reverse! (cons targs res)))))
			     (else
			      (let ((targs (use-type! (car args))))
				 (loop (cdr args)
				       (cons targs res)))))))
		    global)))
      (let ((old (find-global name)))
	 (if (global? old)
	     (begin
		(warning "top-level"
			 "Redefinition of variable -- " name)
		(fill! old))
	     (let ((global (bind-global! name 'foreign)))
		(set! *foreign* (cons global *foreign*))
		(fill! global))))))
	  
;*---------------------------------------------------------------------*/
;*    set-global-procedure-slot! ...                                   */
;*    -------------------------------------------------------------    */
;*    All function creations use this function. So this function       */
;*    defines default values for functions.                            */
;*---------------------------------------------------------------------*/
(define (set-global-procedure-slot! global import class proto)
   [assert check (global import class proto)
	   (and (global? global)
		(memq import '(import export static))
		(memq class '(variable procedure foreign inline)))]
   (global-pragma-set!     global '())
   (global-import-set!     global import)
   (global-eval?-set!      global #t)
   (global-library?-set!   global *lib-mode*)
   (global-access-set!     global 'read)
   (global-class-set!      global class)
   (global-type-set!       global (find-type 'procedure))
   (global-fast-alpha-set! global #f)
   (let* ((value (make-function))
	  (fun   (car proto))
	  (args  (cdr proto))
	  (arity (arity args)))
      (function-inline?-set! value (if (eq? class 'inline)
				       #t
				       '()))
      (function-arity-set! value arity)
      ;; we create formals
      (function-args-set! value
			  (let loop ((args args)
				     (res  '()))
			     (cond
				((null? args)
				 (reverse! res))
				((not (pair? (car args)))
				 ;; it is the last formal of an n-ary
				 ;; function
				 (reverse! (cons (make-local-variable
						  (car args)
						  (use-type! (cdr args)))
						 res)))
				(else
				 (let ((arg (car args)))
				    (loop (cdr args)
					  (cons
					   (make-local-variable
					    (car arg)
					    (if (and (eq? import 'export)
						     (null? (cdr arg)))
						;; exported functions
						;; without type specifi-
						;; -cation are supposed
						;; to take obj type as
						;; type argument.
						(find-type 'obj)
						(use-type! (cdr arg))))
					   res)))))))
      ;; we set the escaping slot
      (function-escape?-set! value (not (eq? import 'static)))
      ;; we set the result type
      (cond
	 ((null? (cdr fun))
	  (if (not (eq? import 'static))
	      (function-type-res-set! value (find-type 'obj))))
	 (else
	  (function-type-res-set! value (use-type! (cdr fun)))))
      (global-value-set! global value)
      ;; we check (and set) the last formal of n-ary function
      (if (<fx arity 0)
	  (let ((formal (car (last-pair (function-args value)))))
	     (cond
		((null? (local-type formal))
		 (local-type-set! formal (find-type 'obj)))
		((or (and (symbol? (local-type formal))
			  (eq? (local-type formal) 'obj))
		     (and (type? (local-type formal))
			  (eq? (local-type formal) (find-type 'obj))))
		 'done)
		(else
		 (user-error (global-name global)
			     "Illegal n-ary argument type specification"
			     (shape formal))))))
      global))
   
;*---------------------------------------------------------------------*/
;*    set-global-variable-slot! ...                                    */
;*    -------------------------------------------------------------    */
;*    To solve the pbm of module initialization, we forbid global      */
;*    exported variable of non Bigloo's type (because, we are          */
;*    unable to ensure that they are initialized before their          */
;*    first use).                                                      */
;*---------------------------------------------------------------------*/
(define (set-global-variable-slot! global import class proto)
   (global-pragma-set!     global '())
   (global-import-set!     global import)
   (global-eval?-set!      global #t) 
   (global-library?-set!   global *lib-mode*)
   (global-access-set!     global (if (eq? import 'static)
				      'read
				      'write))
   (global-class-set!      global class)
   (global-fast-alpha-set! global #f)
   (cond
      ((null? (cdr proto))
       (if (not (eq? import 'static))
	   (global-type-set! global (find-type 'obj))))
      (else
       (let ((type (use-type! (cdr proto))))
	  (if (and (or (eq? import 'import) (eq? import 'export))
		   (not (obj-type? type)))
	      (user-error "set-global-variable-slot!"
			  "Illegal type for global variable"
			  (global-shape global)))
	  (global-type-set! global type))))
   global)

;*---------------------------------------------------------------------*/
;*    check-procedure-definition? ...                                  */
;*---------------------------------------------------------------------*/
(define (check-procedure-definition? global import class proto)
   (trace init "check-procedure-definition?: " (shape global)
	  " import:" import " class:" class
	  "  proto:" (shape proto) #\Newline)
   (cond
      ((and (not (null? import)) (not (eq? (global-import global) import)))
       (trace init "import mismatch" #\Newline)
       #f)
      ((not (eq? (global-class global) class))
       (trace init "class mismatch: old:" (global-class global) " new: " class
	      #\Newline)
       #f)
      ((not (function? (global-value global)))
       (trace init "not function" #\Newline)
       #f)
      (else
       ;; we check if argument are compatible
       (let loop ((args    (cdr proto))
		  (formals (function-args (global-value global))))
	  (trace (init loop)
		 "   args   : " (shape args) #\Newline
		 "   formals: " (shape formals) #\Newline)
	  (cond
	     ((null? args)
	      (if (and (>=fx (function-arity (global-value global)) 0)
		       (null? formals))
		  ;; we still have to check result types
		  (let ((old-type (function-type-res (global-value global)))
			(new-type (cdr (car proto))))
		     (cond
			((null? old-type)
			 (if (not (null? new-type))
			     (trace init "type-res mismatch " #\Newline))
			 (null? new-type))
			((null? new-type)
			 #t)
			((and (type? new-type) (eq? old-type new-type))
			 #t)
			((and (symbol? new-type)
			      (eq? old-type (find-type new-type)))
			 #t)
			(else
			 (trace init "type-res mismatch" #\Newline)
			 #f)))
		  (begin
		     (trace init "number mismatch" #\Newline)
		     (trace init "old-formals: "
			    (shape (function-args (global-value global)))
			    #\newline)
		     (trace init "new-formals: "
			    (shape (cdr proto))
			    #\Newline)
		     #f)))
	     ((null? formals)
	      (trace init "formals mismatch " #\Newline)
	      #f)
	     ((not (pair? (car args)))
	      (and (null? (cdr formals))
		   (<fx (function-arity (global-value global)) 0)
		   (or (null? (cdr args))
		       (eq? (local-type (car formals)) (cdr args)))))
	     ((null? (local-type (car formals)))
	      (if (null? (cdr (car args)))
		  (loop (cdr args)
			(cdr formals))
		  (begin
		     (trace init "type formal mismatch "
			    (shape (car formals))
			    #\Newline)
		     #f)))
	     ((null? (cdr (car args)))
	      (loop (cdr args)
		    (cdr formals)))
	     ((and (type? (cdr (car args)))
		   (eq? (cdr (car args)) (local-type (car formals))))
	      (loop (cdr args)
		    (cdr formals)))
	     ((and (symbol? (cdr (car args)))
		   (eq? (find-type (cdr (car args)))
			(local-type (car formals))))
	      (loop (cdr args)
		    (cdr formals)))
	     (else
	      (trace init "Type formal mismatch " (shape (car formals))
		     #\Newline)
	      #f))))))

;*---------------------------------------------------------------------*/
;*    check-variable-definition? ...                                   */
;*---------------------------------------------------------------------*/
(define (check-variable-definition? global import class proto)
   (cond
      ((not (eq? (global-class global) class))
       #f)
      ((and (not (null? import))
	    (not (eq? (global-import global) import)))
       #f)
      (else
       (let ((type (cdr proto)))
	  (cond
	     ((null? type)
	      #t)
	     ((null? (global-type global))
	      #t)
	     ((and (type? type) (eq? (global-type global) type))
	      #t)
	     ((and (symbol? type) (eq? (global-type global) (find-type type)))
	      #t)
	     (else
	      #f))))))

;*---------------------------------------------------------------------*/
;*    global-shape ...                                                 */
;*---------------------------------------------------------------------*/
(define (global-shape global)
   (let* ((name   (string-downcase! (symbol->string (global-name global))))
	  (module (string-downcase! (symbol->string (global-module global))))
	  (type   (cond
		     ((function? (global-value global))
		      (function-type-res (global-value global)))
		     ((ffunction? (global-value global))
		      (ffunction-type-res (global-value global)))
		     (else
		      (global-type global))))
	  (ts     (cond
		     ((not *type-shape?*)
		      "")
		     ((type? type)
		      (string-append "::" (symbol->string (type-id type))))
		     (else
		      "::_"))))
      (cond
	 (*module-shape?*
	  (string->symbol
	   (string-append name "@" module ts)))
	 (else
	  (case (global-bucket-position (global-name global)
					(global-module global))
	     ((-1)
	      (internal-error "global-shape"
			      "Can't find global any more"
			      (list name module)))
	     ((0)
	      (let ((sym (string->symbol name)))
		 (symbol-append sym (string->symbol ts))))
	     (else
	      (let ((sym (let ((sym (string->symbol name)))
			    (symbol-append sym (string->symbol ts)))))
		 `(@ ,sym ,(string->symbol module)))))))))

;*---------------------------------------------------------------------*/
;*    require-global ...                                               */
;*---------------------------------------------------------------------*/
(define (require-global name module only-if-used?)
   (let ((global (if (symbol? module)
		     (find-global name module)
		     (find-global name))))
      (cond
	 (only-if-used?
	  (if (and (global? global) (>fx (global-occurrence global) 0))
	      global
	      #f))
	 ((global? global)
	  global)
	 (else
	  (internal-error "require-global"
			  "Can't find global variable" 
			       (if (symbol? module)
				   (symbol-append name '@ module)
				   name))))))

;*---------------------------------------------------------------------*/
;*    use-global! ...                                                  */
;*---------------------------------------------------------------------*/
(define (use-global! global)
   (global-occurrence-set! global (+fx 1 (global-occurrence global))))
