;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/cigloo0.2/Engine/engine.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jul 12 15:53:47 1995                          */
;*    Last change :  Fri Apr 12 15:00:45 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We have read the argument line. We start the real compilation    */
;*    process.                                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module engine_engine
   (export (cyloo)
	   (translate-file <string> <bool> <symbol>))
   (import tools_speek
	   tools_file
	   engine_param
	   engine_translate))
	   
;*---------------------------------------------------------------------*/
;*    cyloo ...                                                        */
;*---------------------------------------------------------------------*/
(define (cyloo)
   (if (string? *dest*)
       (begin
	  (set! *oport* (open-output-file *dest*))
	  (if (not (output-port? *oport*))
	      (error "cyloo" "Can't open file for output" *dest*)
	      (unwind-protect (engine) (close-output-port *oport*))))
       (begin
	  ;; when emiting on stdout we switch to a silent mode
	  (set! *verbose* -1)
	  (engine))))

;*---------------------------------------------------------------------*/
;*    *file-processed* ...                                             */
;*---------------------------------------------------------------------*/
(define *file-processed* '())

;*---------------------------------------------------------------------*/
;*    engine ...                                                       */
;*---------------------------------------------------------------------*/
(define (engine)
   ;; first of all, we emit the include Bigloo clauses.
   (if *directives*
       (fprint *oport* "(directives"))
   (fprint *oport* " (foreign")
   (if (null? *src*)
       (translate-stdin 'emit)
       (for-each (lambda (fname) (translate-file fname 'file 'open))
		 (reverse! *src*)))
   ;; and we close include clauses
   (if *directives*
       (fprint *oport* "   ))")
       (fprint *oport* "   )")))

;*---------------------------------------------------------------------*/
;*    translate-stdin ...                                              */
;*---------------------------------------------------------------------*/
(define (translate-stdin mode)
   (translate (current-input-port) "stdin" mode))
 
;*---------------------------------------------------------------------*/
;*    translate-file ...                                               */
;*---------------------------------------------------------------------*/
(define (translate-file fname path mode)
   [assert check (mode) (or (eq? mode 'open) (eq? mode 'scan))]
   (let ((fname (cond
		   ((eq? path '<include>)
		    (find-file/path (if *src-dirname*
					(string-append *src-dirname* "/" fname)
					fname)
				    *include-path*))
		   ((eq? path 'include)
		    (if *src-dirname*
			(string-append *src-dirname* "/" fname)
			fname))
		   (else
		    (set! *src-dirname* (dirname fname))
		    (if (string=? *src-dirname* ".")
			(set! *src-dirname* #f))
		    fname))))
      (cond
	 ((or (not (string? fname)) (not (file-exists? fname)))
	  (error "cyloo" "Can't find file " fname))
	 ((member fname *file-processed*)
	  'done)
	 (else
	  (set! *file-processed* (cons fname *file-processed*))
	  (let ((port (open-input-file fname)))
	     (if (not (input-port? port))
		 (error "cyloo" "Can't open file for input" fname)
		 (unwind-protect (translate port fname mode)
				 (close-input-port port))))))))
   


