
/*
    xskat - a card game for 1 to 3 players.
    Copyright (C) 1996  Gunter Gerhardt

    This program is free software; you can redistribute it freely.
    Use it at your own risk; there is NO WARRANTY.
*/

#undef EXTERN
#ifdef XDIAL_C
#define EXTERN
#else
#define EXTERN extern
#endif

#define OB_NONE       0
#define OB_BUTTON     (1<<0)
#define OB_EXIT       (1<<1)
#define OB_SELECTED   (1<<2)
#define OB_CENTERED   (1<<3)
#define OB_HIDDEN     (1<<4)
#define OB_BOLD       (1<<5)
#define OB_UNDERLINED (1<<6)

#define TOB(t) ((char *)((t)+OB_NONE+1))

typedef struct {
  int spec;
  int x,y,w,h;
  char *str;
  int next;
  Window win;
} OBJECT;

EXTERN OBJECT *actdial[3];
EXTERN OBJECT *resdial[3];

EXTERN OBJECT dihand[]
#ifdef XDIAL_C
=
{
  {4,0,0,19,6,OB_NONE,OB_NONE},
  {OB_CENTERED|OB_UNDERLINED,1,1,17,1,TOB(TX_HAND_F),OB_NONE},
  {OB_EXIT,2,4,6,1,TOB(TX_JA),OB_NONE},
  {OB_EXIT,11,4,6,1,TOB(TX_NEIN),OB_NONE}
}
#endif
;

EXTERN OBJECT diende[3][4]
#ifdef XDIAL_C
=
{{
  {4,0,0,19,6,OB_NONE,OB_NONE},
  {OB_CENTERED|OB_UNDERLINED,1,1,17,1,TOB(TX_SPIEL_BEENDEN),OB_NONE},
  {OB_EXIT,2,4,6,1,TOB(TX_JA),OB_NONE},
  {OB_EXIT,11,4,6,1,TOB(TX_NEIN),OB_NONE}
}}
#endif
;

EXTERN OBJECT diterm[3][5]
#ifdef XDIAL_C
=
{{
  {5,0,0,23,8,OB_NONE,OB_NONE},
  {OB_CENTERED|OB_UNDERLINED,1,1,21,1,TOB(TX_SPIELENDE),OB_NONE},
  {OB_CENTERED,2,3,19,1,OB_NONE,OB_NONE},
  {OB_CENTERED,2,4,19,1,TOB(TX_BEENDET_DAS_SPIEL),OB_NONE},
  {OB_EXIT,8,6,7,1,TOB(TX_AHA),OB_NONE}
}}
#endif
;

EXTERN OBJECT diloesch[]
#ifdef XDIAL_C
=
{
  {4,0,0,19,6,OB_NONE,OB_NONE},
  {OB_CENTERED|OB_UNDERLINED,1,1,17,1,TOB(TX_LOESCHEN_F),OB_NONE},
  {OB_EXIT,2,4,6,1,TOB(TX_JA),OB_NONE},
  {OB_EXIT,11,4,6,1,TOB(TX_NEIN),OB_NONE}
}
#endif
;

EXTERN OBJECT dispiel[]
#ifdef XDIAL_C
=
{
  {13,0,0,43,13,OB_NONE,OB_NONE},
  {OB_CENTERED|OB_UNDERLINED,1,1,41,1,TOB(TX_SPIEL),OB_NONE},
  {OB_BUTTON,2,3,9,1,TOB(TX_KARO),1},
  {OB_BUTTON,12,3,9,1,TOB(TX_HERZ),1},
  {OB_BUTTON,22,3,9,1,TOB(TX_PIK),1},
  {OB_BUTTON,32,3,9,1,TOB(TX_KREUZ),1},
  {OB_BUTTON,2,5,19,1,TOB(TX_NULL),1},
  {OB_BUTTON,22,5,19,1,TOB(TX_GRAND),-5},
  {OB_BUTTON,2,7,12,1,TOB(TX_SCHNEIDER),OB_NONE},
  {OB_BUTTON,15,7,13,1,TOB(TX_SCHWARZ),OB_NONE},
  {OB_BUTTON,29,7,12,1,TOB(TX_OUVERT),OB_NONE},
  {OB_EXIT,15,9,13,1,TOB(TX_ANSAGEN),OB_NONE},
  {OB_CENTERED,1,11,41,1,OB_NONE,OB_NONE}
}
#endif
;

EXTERN OBJECT difehler[]
#ifdef XDIAL_C
=
{
  {7,0,0,43,11,OB_NONE,OB_NONE},
  {OB_CENTERED|OB_UNDERLINED,1,1,41,1,TOB(TX_HINWEIS),OB_NONE},
  {OB_CENTERED,1,3,41,1,TOB(TX_F1),OB_NONE},
  {OB_CENTERED,1,4,41,1,TOB(TX_F2),OB_NONE},
  {OB_CENTERED,1,6,41,1,TOB(TX_F3),OB_NONE},
  {OB_CENTERED,1,7,41,1,TOB(TX_F4),OB_NONE},
  {OB_EXIT,17,9,9,1,TOB(TX_AHA),OB_NONE}
}
#endif
;

EXTERN OBJECT diueberr[]
#ifdef XDIAL_C
=
{
  {7,0,0,43,11,OB_NONE,OB_NONE},
  {OB_CENTERED|OB_UNDERLINED,1,1,41,1,TOB(TX_HINWEIS),OB_NONE},
  {OB_CENTERED,1,3,41,1,TOB(TX_U1),OB_NONE},
  {OB_CENTERED,1,4,41,1,TOB(TX_U2),OB_NONE},
  {OB_CENTERED,1,6,41,1,TOB(TX_U3),OB_NONE},
  {OB_CENTERED,1,7,41,1,TOB(TX_U4),OB_NONE},
  {OB_EXIT,17,9,9,1,TOB(TX_AHA),OB_NONE}
}
#endif
;

EXTERN OBJECT diansage[]
#ifdef XDIAL_C
=
{
  {3,0,0,17,6,OB_NONE,OB_NONE},
  {OB_CENTERED|OB_UNDERLINED,1,1,15,1,TOB(TX_ANGESAGT_IST),OB_NONE},
  {OB_EXIT,3,4,11,1,OB_NONE,OB_NONE}
}
#endif
;

EXTERN OBJECT diresult[]
#ifdef XDIAL_C
=
{
  {18,0,0,37,15,OB_NONE,OB_NONE},
  {OB_CENTERED|OB_UNDERLINED,1,1,35,1,TOB(TX_RESULTAT),OB_NONE},
  {OB_CENTERED,1,2,35,1,OB_NONE,OB_NONE},
  {OB_NONE,2,3,34,1,OB_NONE,OB_NONE},
  {OB_NONE,2,5,34,1,OB_NONE,OB_NONE},
  {OB_NONE,2,7,34,1,TOB(TX_DER_SPIELWERT_IST),OB_NONE},
  {OB_CENTERED,4,9,10,1,OB_NONE,OB_NONE},
  {OB_CENTERED,14,9,10,1,OB_NONE,OB_NONE},
  {OB_CENTERED,24,9,10,1,OB_NONE,OB_NONE},
  {OB_CENTERED,4,10,10,1,OB_NONE,OB_NONE},
  {OB_CENTERED,14,10,10,1,OB_NONE,OB_NONE},
  {OB_CENTERED,24,10,10,1,OB_NONE,OB_NONE},
  {OB_CENTERED,5,11,8,1,OB_NONE,OB_NONE},
  {OB_CENTERED,15,11,8,1,OB_NONE,OB_NONE},
  {OB_CENTERED,25,11,8,1,OB_NONE,OB_NONE},
  {OB_EXIT,2,13,7,1,TOB(TX_ENDE),OB_NONE},
  {OB_EXIT,11,13,11,1,TOB(TX_PROTOKOLL),OB_NONE},
  {OB_EXIT,24,13,11,1,TOB(TX_WEITER),OB_NONE}
}
#endif
;

EXTERN OBJECT dismlres[3][14]
#ifdef XDIAL_C
=
{{
  {14,0,0,33,8,OB_NONE,OB_NONE},
  {OB_CENTERED,1,0,31,1,OB_NONE,OB_NONE},
  {OB_NONE,2,1,30,1,OB_NONE,OB_NONE},
  {OB_NONE,2,2,30,1,OB_NONE,OB_NONE},
  {OB_NONE,2,3,30,1,TOB(TX_DER_SPIELWERT_IST),OB_NONE},
  {OB_CENTERED,2,4,10,1,OB_NONE,OB_NONE},
  {OB_CENTERED,12,4,10,1,OB_NONE,OB_NONE},
  {OB_CENTERED,22,4,10,1,OB_NONE,OB_NONE},
  {OB_CENTERED,2,5,10,1,OB_NONE,OB_NONE},
  {OB_CENTERED,12,5,10,1,OB_NONE,OB_NONE},
  {OB_CENTERED,22,5,10,1,OB_NONE,OB_NONE},
  {OB_CENTERED,3,6,8,1,OB_NONE,OB_NONE},
  {OB_CENTERED,13,6,8,1,OB_NONE,OB_NONE},
  {OB_CENTERED,23,6,8,1,OB_NONE,OB_NONE}
}}
#endif
;

EXTERN OBJECT diproto[3][49]
#ifdef XDIAL_C
=
{{
  {49,0,0,40,23,OB_NONE,OB_NONE},
  {OB_CENTERED|OB_UNDERLINED,1,1,38,1,TOB(TX_PROTOKOLL_T),OB_NONE},
  {OB_CENTERED,2,3,12,1,OB_NONE,OB_NONE},
  {OB_CENTERED,14,3,12,1,OB_NONE,OB_NONE},
  {OB_CENTERED,26,3,12,1,OB_NONE,OB_NONE},
  {OB_CENTERED,2,4,12,1,OB_NONE,OB_NONE},
  {OB_CENTERED,14,4,12,1,OB_NONE,OB_NONE},
  {OB_CENTERED,26,4,12,1,OB_NONE,OB_NONE},
  {OB_NONE,4,5,11,1,OB_NONE,OB_NONE},
  {OB_NONE,16,5,11,1,OB_NONE,OB_NONE},
  {OB_NONE,28,5,11,1,OB_NONE,OB_NONE},
  {OB_NONE,4,6,11,1,OB_NONE,OB_NONE},
  {OB_NONE,16,6,11,1,OB_NONE,OB_NONE},
  {OB_NONE,28,6,11,1,OB_NONE,OB_NONE},
  {OB_NONE,4,7,11,1,OB_NONE,OB_NONE},
  {OB_NONE,16,7,11,1,OB_NONE,OB_NONE},
  {OB_NONE,28,7,11,1,OB_NONE,OB_NONE},
  {OB_NONE,4,8,11,1,OB_NONE,OB_NONE},
  {OB_NONE,16,8,11,1,OB_NONE,OB_NONE},
  {OB_NONE,28,8,11,1,OB_NONE,OB_NONE},
  {OB_NONE,4,9,11,1,OB_NONE,OB_NONE},
  {OB_NONE,16,9,11,1,OB_NONE,OB_NONE},
  {OB_NONE,28,9,11,1,OB_NONE,OB_NONE},
  {OB_NONE,4,10,11,1,OB_NONE,OB_NONE},
  {OB_NONE,16,10,11,1,OB_NONE,OB_NONE},
  {OB_NONE,28,10,11,1,OB_NONE,OB_NONE},
  {OB_NONE,4,11,11,1,OB_NONE,OB_NONE},
  {OB_NONE,16,11,11,1,OB_NONE,OB_NONE},
  {OB_NONE,28,11,11,1,OB_NONE,OB_NONE},
  {OB_NONE,4,12,11,1,OB_NONE,OB_NONE},
  {OB_NONE,16,12,11,1,OB_NONE,OB_NONE},
  {OB_NONE,28,12,11,1,OB_NONE,OB_NONE},
  {OB_NONE,4,13,11,1,OB_NONE,OB_NONE},
  {OB_NONE,16,13,11,1,OB_NONE,OB_NONE},
  {OB_NONE,28,13,11,1,OB_NONE,OB_NONE},
  {OB_NONE,4,14,11,1,OB_NONE,OB_NONE},
  {OB_NONE,16,14,11,1,OB_NONE,OB_NONE},
  {OB_NONE,28,14,11,1,OB_NONE,OB_NONE},
  {OB_NONE,2,15,13,1,TOB(TX_IM_SKAT_IST),OB_NONE},
  {OB_NONE,16,15,22,1,OB_NONE,OB_NONE},
  {OB_NONE,2,16,37,1,OB_NONE,OB_NONE},
  {OB_NONE,2,17,13,1,TOB(TX_GEREIZT_BIS),OB_NONE},
  {OB_NONE,16,17,22,1,OB_NONE,OB_NONE},
  {OB_NONE,2,18,37,1,OB_NONE,OB_NONE},
  {OB_NONE,2,19,13,1,OB_NONE,OB_NONE},
  {OB_NONE,16,19,23,1,OB_NONE,OB_NONE},
  {OB_EXIT,2,21,12,1,TOB(TX_SPIELLISTE),OB_NONE},
  {OB_EXIT,17,21,12,1,TOB(TX_WEITER),OB_NONE},
  {OB_EXIT,32,21,6,1,OB_NONE,OB_NONE}
}}
#endif
;

EXTERN OBJECT diliste[3][24]
#ifdef XDIAL_C
=
{{
  {24,0,0,38,21,OB_NONE,OB_NONE},
  {OB_CENTERED|OB_UNDERLINED,1,1,36,1,TOB(TX_SPIELLISTE_T),OB_NONE},
  {OB_CENTERED,2,3,10,1,OB_NONE,OB_NONE},
  {OB_CENTERED,12,3,10,1,OB_NONE,OB_NONE},
  {OB_CENTERED,22,3,10,1,OB_NONE,OB_NONE},
  {OB_CENTERED,2,4,10,1,OB_NONE,OB_NONE},
  {OB_CENTERED,12,4,10,1,OB_NONE,OB_NONE},
  {OB_CENTERED,22,4,10,1,OB_NONE,OB_NONE},
  {OB_NONE,1,5,36,1,OB_NONE,OB_NONE},
  {OB_NONE,1,6,36,1,OB_NONE,OB_NONE},
  {OB_NONE,1,7,36,1,OB_NONE,OB_NONE},
  {OB_NONE,1,8,36,1,OB_NONE,OB_NONE},
  {OB_NONE,1,9,36,1,OB_NONE,OB_NONE},
  {OB_NONE,1,10,36,1,OB_NONE,OB_NONE},
  {OB_NONE,1,11,36,1,OB_NONE,OB_NONE},
  {OB_NONE,1,12,36,1,OB_NONE,OB_NONE},
  {OB_NONE,1,13,36,1,OB_NONE,OB_NONE},
  {OB_NONE,1,14,36,1,OB_NONE,OB_NONE},
  {OB_NONE,1,15,36,1,OB_NONE,OB_NONE},
  {OB_NONE,1,16,36,1,OB_NONE,OB_NONE},
  {OB_NONE,1,17,36,1,OB_NONE,OB_NONE},
  {OB_EXIT,2,19,8,1,OB_NONE,OB_NONE},
  {OB_EXIT,13,19,12,1,TOB(TX_WEITER),OB_NONE},
  {OB_EXIT,28,19,8,1,OB_NONE,OB_NONE}
}}
#endif
;

EXTERN OBJECT dioptions[3][21]
#ifdef XDIAL_C
=
{{
  {21,0,0,38,21,OB_NONE,OB_NONE},
  {OB_CENTERED|OB_UNDERLINED,1,1,36,1,TOB(TX_XSKAT),OB_NONE},
  {OB_EXIT,2,3,34,1,TOB(TX_COPYRIGHT),OB_NONE},
  {OB_NONE,2,5,35,1,TOB(TX_SORTIEREN),OB_NONE},
  {OB_BUTTON,5,6,13,1,TOB(TX_AUFWAERTS),1},
  {OB_BUTTON,20,6,13,1,TOB(TX_ABWAERTS),-1},
  {OB_BUTTON,5,7,13,1,TOB(TX_ALTERNIEREND),1},
  {OB_BUTTON,20,7,13,1,TOB(TX_SEQUENTIELL),-1},
  {OB_BUTTON,5,8,13,1,TOB(TX_NULL),1},
  {OB_BUTTON,20,8,13,1,TOB(TX_NORMAL),-1},
  {OB_NONE,2,10,35,1,TOB(TX_GEREIZT_BIS_L),OB_NONE},
  {OB_NONE,2,11,35,1,TOB(TX_GESPIELT_WIRD),OB_NONE},
  {OB_NONE,2,12,35,1,TOB(TX_LETZTER_STICH),OB_NONE},
  {OB_NONE,2,12,35,1,TOB(TX_GEDRUECKT),OB_NONE},
  {OB_NONE,5,13,32,1,OB_NONE,OB_NONE},
  {OB_NONE,5,14,32,1,OB_NONE,OB_NONE},
  {OB_NONE,5,15,32,1,OB_NONE,OB_NONE},
  {OB_EXIT,5,17,13,1,TOB(TX_SPIELLISTE),OB_NONE},
  {OB_EXIT,20,17,13,1,TOB(TX_PROTOKOLL),OB_NONE},
  {OB_EXIT,5,19,13,1,TOB(TX_ENDE),OB_NONE},
  {OB_EXIT,20,19,13,1,TOB(TX_WEITER),OB_NONE}
}}
#endif
;

EXTERN OBJECT dicopyr[3][9]
#ifdef XDIAL_C
=
{{
  {9,0,0,38,13,OB_NONE,OB_NONE},
  {OB_CENTERED|OB_UNDERLINED,1,1,36,1,TOB(TX_XSKAT),OB_NONE},
  {OB_CENTERED,1,3,36,1,TOB(TX_COPYRIGHT),OB_NONE},
  {OB_CENTERED,1,4,36,1,TOB(TX_EMAIL),OB_NONE},
  {OB_CENTERED,1,6,36,1,TOB(TX_FR1),OB_NONE},
  {OB_CENTERED,1,7,36,1,TOB(TX_FR2),OB_NONE},
  {OB_CENTERED,1,8,36,1,TOB(TX_FR3),OB_NONE},
  {OB_CENTERED,1,9,36,1,TOB(TX_FR4),OB_NONE},
  {OB_EXIT,12,11,14,1,TOB(TX_WEITER),OB_NONE}
}}
#endif
;
