.TH MAELSTROM 6 29-Dec-1996
.SH NAME
Maelstrom \- an arcade-style game resembling Asteroids
.SH SYNOPSIS
Maelstrom
.RI [ options ]
.PP
Maelstrom [-netscores] -printscores
.SH DESCRIPTION
This is a Linux port of the Macintosh game by the same
name. This version is remarkably faithful to the original.
.PP
You pilot your ship through the dreaded "Maelstrom" asteroid
belt -- suddenly your best friend thrusts towards you and fires, directly
at your cockpit.  You raise your shields just in time, and the battle is
joined.  The deadliest stretch of space known to mankind has just gotten
deadlier.  Everywhere massive asteroids jostle for a chance to crush your
ship, and deadly Shenobi fighter patrols pursue you across the asteroid belt.
But the deadliest of them all is your sister ship, assigned to you on patrol.
The pilot, trained by your own Navy, battle-hardened by months in the
Maelstrom, is equipped with a twin of your own ship and intimate knowledge
of your tactics.  The lovely Stratocaster R&R facility never sounded so good,
but as you fire full thrusters to dodge the latest barrage you begin to think
you'll never get home...
.SH OPTIONS
.TP
.RI "-display " host:0
Runs Maelstrom on the given X11 display.
.TP
-fullscreen
Puts a big black border around the Maelstrom screen, and centers Maelstrom
within it. This help create a "full screen" effect on large displays.
.TP
-privatecmap
Runs Maelstrom with a private (custom) colormap. This prevents Maelstrom from
locking up all of the colors on your display. It is only useful on 256 color
(pseudo-color) displays.
.TP
-gamma [0-8]
Sets the gamma correction level for Maelstrom. The higher the gamma
correction, the brighter Maelstrom will appear on your monitor. If no gamma
level is given, Maelstrom will print the current gamma level saved in your
custom configuration. Once this option is used, the gamma correction level is
saved, and this option doesn't need to be used later unless you want to change
it again.
.TP
-volume [0-8]
Sets the sound volume.
.TP
-nofade
Prevents Maelstrom from doing the screen fading. This is useful if you find
the fading annoying.
.TP
-realfade
Causes the entire display to fade, not just inside the Maelstrom window.
.TP
-netscores
Tells Maelstrom to use the Internet Maelstrom Score Server for the high score
list.
.TP
-printscores
Prints out a list of the current high scores. If used with the -netscores
option, it will will connect to the Internet Maelstrom Score Server and print
out the world-wide Maelstrom high scores.
.TP
-player N[@host][:port]
Tells Maelstrom that it is playing a network game, and that player
.I N
is at host
.I host
and/or port
.IR port .
.TP
-server N@host[:port]
Tells Maelstrom to use a network address server at host
.I host
(and port
.IR port )
for a multiplayer game with
.I N
players.
.TP
-deathmatch [N]
Configures a multiplayer game to continue until someone gets
.I N
frags (default = 8). A frag is 3 shots at a player.
.TP
-version
Prints the version of the Maelstrom binary.
.TP
-speedtest
Runs Maelstrom in a graphics test mode. It prints the number of milliseconds
it takes for your graphics display to display a full 48-frame, 360 degree
rotation of your ship. It is for comparative information only.
.SH NOTES
.B maelstrom
is an alias for
.BR Maelstrom ;
you may use either to start the game.
.PP
.B Maelstrom_sound
is the Maelstrom sound server. You do not need (nor should you try) to
start this yourself; Maelstrom uses it transparently.
.SH AUTHOR
The original Maelstrom was written for the Macintosh by Andrew Welch.
The Linux port was done by Sam Lantinga <slouken@cs.ucdavis.edu>.
.PP
The author has approved the inclusion of Maelstrom in Debian distributions,
including commercially distributed versions, as long as Maelstrom is
.B not
sold independently and remains freely available.
.PP
This manual page was contributed by Robert Leslie <rob@mars.org>.
