/*      -------------------------------------------------------------------
	xldlas -- A Stastics Package

	Copyright (C) 1996 Thor Sigvaldason

	Includes all the routines reached from the File menu.
	
        -------------------------------------------------------------------*/

#include "xldlas.h"

extern void quit_xldlas(FL_OBJECT *ob, long user_data);
extern void about_xldlas(FL_OBJECT *ob, long user_data);
extern void simple_line_output(char which_routine[XLDLASMAX_INPUT], char the_output[XLDLASMAX_INPUT]);
extern void say_status(char the_status[XLDLASMAX_INPUT]);
extern void inhibit_input();
extern void reenable_input();
extern void drop_variable(int to_drop, int shouldi);
extern int check_variable_name(char proposed[XLDLASMAX_INPUT]);
extern void sync_graph_browsers(int type);

void drain_input(FILE *flptr)
{
        char drain;
        while(!feof(flptr))
        {
		fscanf(flptr,"%c",&drain);
	}
}
                                                  

char *remove_blanks (char *inputstring)
{
	char working[XLDLASMAX_INPUT];
	int count;
	strcpy(working,inputstring);
	for(count = 0; count < strlen(working); count ++)
	{
		if(working[count] == ' ') working[count] = '_';
	}
	strcpy(inputstring,working);
	return(inputstring);
}

char *add_blanks (char *inputstring)
{
	char working[XLDLASMAX_INPUT];
	int count;
	strcpy(working,inputstring);
	for(count = 0; count < strlen(working); count++)
	{
		if(working[count] == '_') working[count] = ' ';
	}
	strcpy(inputstring,working);
	return(inputstring);
}


void load_a_variable(FILE *lfptr)
{
	char scratch[XLDLASMAX_INPUT];
	float nowhere;
	int count, place;
	if(numb_variables == MAX_VARS)
	{
		fl_show_alert("Dataset Contains Too Many Variables",
				"It was probably built with a bigger version of xldlas",
				"Please adjust MAX_VARS in xldlas.h and recompile xldlas",1);
		drain_input(lfptr);
		return;
	}
	fvector[numb_variables] = (float *) malloc (MAX_OBS * sizeof(float));
	if (!fvector[numb_variables])
	{
		fl_show_alert("Cannot Load all data in Dataset",
				"Running low on Memory",
				"",1);
		drain_input(lfptr);
		return;
	}
	fscanf(lfptr,"%s\n",scratch);
	strncpy(data_matrix[numb_variables].name, scratch,NAME_LENGTH);
	fscanf(lfptr,"%s\n",scratch);
	strncpy(data_matrix[numb_variables].description, scratch,DESC_LENGTH);
	fscanf(lfptr,"%i\n",&data_matrix[numb_variables].obs);
	if(data_matrix[numb_variables].obs > MAX_OBS)
	{
		strcpy(scratch,data_matrix[numb_variables].name);
		fl_show_alert("The Following Variable Contains Too Many Observations", scratch,"(I'm truncating it)",TRUE); 
	}
	data_matrix[numb_variables].fmem_start=fvector[numb_variables];
	place = 0;
	for(count = 0; count < data_matrix[numb_variables].obs; count ++)
	{
		if(place >= MAX_OBS)
		{
			fscanf(lfptr,"%f\n", &nowhere);
		}
		else
		{
			fscanf(lfptr,"%f\n", &*(fvector[numb_variables] + place));
			place++;
		}
	}
	if(data_matrix[numb_variables].obs > MAX_OBS) data_matrix[numb_variables].obs = MAX_OBS;
	numb_variables++;
}



void load_dataset(FL_OBJECT *ob, long user_data)
{
	FILE *lfptr;
	char string_one[XLDLASMAX_INPUT];
	int i, count, dubious, choice;
	const char *filename;
	inhibit_input();
	say_status("Loading Dataset");
	fl_use_fselector(0);
	fl_set_fselector_title("Load a Dataset");
	filename = fl_show_fselector("Dataset to Load","","*.lda","");
	if(filename == NULL || strlen(filename) == 0)
	{
		say_status("Ready");
		reenable_input();
		return;
	}
	lfptr = fopen(filename,"r");
	if(!lfptr)
	{
		fl_show_alert("Could not open requested file for reading","","",1);
		reenable_input();
		say_status("Ready");
		return;
	}
	for(count = numb_variables - 1; count >= 0; count--)
	{
		drop_variable(count,TRUE);
	}
	fscanf(lfptr,"%s\n",data_matrix_description);
	dubious = TRUE;
	for(i = 0; i < strlen(data_matrix_description); i++)
	{
		if(data_matrix_description[i] == '_') dubious = FALSE;
	}
	if(dubious == TRUE)
	{
		choice = fl_show_choice("Hmmm. The File being loaded Seems Strange",
					"I doubt it's in .lda format","Should I try to Continue?",
               				3,"Yes","No","Cancel");
		if(choice == 2 || choice == 3)
		{
			strcpy(data_matrix_description,"");
			fclose(lfptr);
			say_status("Ready");
			reenable_input();
			return;
		}
	}
	fscanf(lfptr,"%f\n",&missing_value);
	while(!feof(lfptr))
	{
		load_a_variable(lfptr);
	}
	fclose(lfptr);
	strcpy(data_matrix_description,add_blanks(data_matrix_description));
	for(count = 0; count <= numb_variables; count++)
	{
		strcpy(data_matrix[count].description,add_blanks(data_matrix[count].description));
		strcpy(data_matrix[count].name,add_blanks(data_matrix[count].name));
	}
	data_exists = TRUE;
	oktoquit = TRUE;
	sprintf(string_one,"Loaded %d variable(s) into memory from %s", numb_variables, filename);
	simple_line_output("load",string_one);
	reenable_input();
	say_status("Ready");
}




void save_dataset(FL_OBJECT *ob, long user_data)
{
	FILE *fptr;
	char string_one[XLDLASMAX_INPUT];
	int count,countt;
	const char *filename;
	inhibit_input();
	say_status("Saving Dataset");
	fl_use_fselector(1);
	fl_set_fselector_title("Save a Dataset");
	filename = fl_show_fselector("Dataset to Save","","*.lda","");
	if(filename == NULL || strlen(filename) == 0)
	{
		say_status("Ready");
		reenable_input();
		return;
	}
	fptr = fopen(filename,"w");
	if(!fptr)
	{
		fl_show_alert("Could not open requested file for writing","","",1);
		reenable_input();
		say_status("Ready");
		return;
	}
	strcpy(data_matrix_description,remove_blanks(data_matrix_description));
	if(strlen(data_matrix_description) < 1) strcpy(data_matrix_description,"_");
	for(count = 0; count < numb_variables; count++)
	{
		strcpy(data_matrix[count].description,remove_blanks(data_matrix[count].description));
		if(strlen(data_matrix[count].description) < 1) strcpy(data_matrix[count].description,"_");
		strcpy(data_matrix[count].name,remove_blanks(data_matrix[count].name));
	}
	fprintf(fptr,"%-s\n",data_matrix_description);
	fprintf(fptr,"%-f\n",missing_value);
	for(count = 0; count < numb_variables; count++)
	{
		fprintf(fptr,"%s\n",data_matrix[count].name);
		fprintf(fptr,"%s\n",data_matrix[count].description);
		fprintf(fptr,"%i\n",data_matrix[count].obs);
		
		for(countt = 0; countt < data_matrix[count].obs; countt++)
		{
			fprintf(fptr,"%-f\n",*(fvector[count] + countt));
		}
	}
	strcpy(data_matrix_description,add_blanks(data_matrix_description));
	for(count = 0; count < numb_variables; count++)
	{
		strcpy(data_matrix[count].description,add_blanks(data_matrix[count].description));
		strcpy(data_matrix[count].name,add_blanks(data_matrix[count].name));
	}
	oktoquit=TRUE;
	sprintf(string_one,"Saved %d variable(s) in %s",numb_variables,filename);
	simple_line_output("save",string_one);
	reenable_input();
	fclose(fptr);
	say_status("Ready");
}

void append_a_variable(FILE *lfptr)
{
	char scratch[XLDLASMAX_INPUT];
	int count, exists_number;
	int extra;
	if(numb_variables == MAX_VARS)
	{
		fl_show_alert("Dataset Contains Too Many Variables",
				"It was probably built with a bigger version of xldlas",
				"Please adjust MAX_VARS in xldlas.h and recompile xldlas",1);
		drain_input(lfptr);
		return;
	}
	fscanf(lfptr,"%s\n",scratch);
	exists_number = -1;
	for(count = 0; count < numb_variables; count++)
	{
		if(strcmp(data_matrix[count].name, add_blanks(scratch)) == 0) exists_number = count;
	}
	if(exists_number == -1)
	{
		strncpy(data_matrix[numb_variables].name, scratch,NAME_LENGTH);
		fvector[numb_variables] = (float *) malloc (MAX_OBS * sizeof(float));
		if (!fvector[numb_variables])
		{
			fl_show_alert("Cannot Load all data in Dataset",
					"Running low on Memory",
					"",1);
			drain_input(lfptr);
			return;
		}
		fscanf(lfptr,"%s\n",scratch);
		strncpy(data_matrix[numb_variables].description, scratch,DESC_LENGTH);
		fscanf(lfptr,"%i\n",&data_matrix[numb_variables].obs);
		data_matrix[numb_variables].fmem_start=fvector[numb_variables];
		for(count = 0; count < data_matrix[numb_variables].obs; count ++)
		{
			fscanf(lfptr,"%f\n", &*(fvector[numb_variables] + count));
		}
		numb_variables++;
	}
	else
	{
		fscanf(lfptr,"%s\n",scratch);
		fscanf(lfptr,"%i\n",&extra);
		for(count = 0; count < extra; count++)
		{
			fscanf(lfptr,"%f\n",&*(fvector[exists_number] + data_matrix[exists_number].obs  + count));
		}
		data_matrix[exists_number].obs = data_matrix[exists_number].obs + extra;
	}
}


void append_dataset(FL_OBJECT *ob, long user_data)
{
	FILE *lfptr;
	char trash[XLDLASMAX_INPUT];
	float ignore;
	char string_one[XLDLASMAX_INPUT];
	int count, temp, dubious, choice, i;
	const char *filename;
	inhibit_input();
	say_status("Loading Dataset");
	fl_use_fselector(2);
	fl_set_fselector_title("Append a Dataset");
	filename = fl_show_fselector("Dataset to Append","","*.lda","");
	if(filename == NULL || strlen(filename) == 0)
	{
		say_status("Ready");
		reenable_input();
		return;
	}
	lfptr = fopen(filename,"r");
	if(!lfptr)
	{
		fl_show_alert("Could not open requested file for reading","","",1);
		reenable_input();
		say_status("Ready");
		return;
	}
	fscanf(lfptr,"%s\n",trash);
	dubious = TRUE;
	for(i = 0; i < strlen(trash); i++)
	{
		if(trash[i] == '_') dubious = FALSE;
	}
	if(dubious == TRUE)
	{
		choice = fl_show_choice("Hmmm. The File being Appended Seems Strange",
					"I doubt it's in .lda format","Should I try to Continue?",
               				3,"Yes","No","Cancel");
		if(choice == 2 || choice == 3)
		{
			strcpy(data_matrix_description,"");
			fclose(lfptr);
			say_status("Ready");
			reenable_input();
			return;
		}
	}
	fscanf(lfptr,"%f\n",&ignore);
	temp = 0;
	while(!feof(lfptr))
	{
		temp++;
		append_a_variable(lfptr);
	}
	fclose(lfptr);
	for(count = 0; count <= numb_variables; count++)
	{
		strcpy(data_matrix[count].description,add_blanks(data_matrix[count].description));
		strcpy(data_matrix[count].name,add_blanks(data_matrix[count].name));
	}
	data_exists = TRUE;
	oktoquit = FALSE;
	sprintf(string_one,"Read/Appended %d variable(s) into memory from %s", temp, filename);
	simple_line_output("apnd",string_one);
	sync_graph_browsers(2);	
	reenable_input();
	say_status("Ready");
}


int count_columns(FILE *filepointer)
{
	char a_character;
	char a_string[XLDLASMAX_INPUT];
	char *a_whole_line;
	char *another_whole_line;
	int length, escape, place, i, j, numb_columns, start_point, end_point, old_start, old_stop;
	place = 0;
	length = XLDLASMAX_INPUT;
	a_whole_line = (char *) malloc (length * sizeof (char));
	escape = FALSE;
	while(escape == FALSE)
	{
		if(place == length - 2)
		{
			length = length + XLDLASMAX_INPUT;
			another_whole_line = (char *) malloc (length * sizeof (char));
			for(i = 0; i < place; i++)
			{
				*(another_whole_line + i) = *(a_whole_line + i);
			}
			free(a_whole_line);
			a_whole_line = (char *) malloc (length * sizeof (char));
			for(i = 0; i < place; i++)
			{
				*(a_whole_line + i) = *(another_whole_line + i);
			}
			free(another_whole_line);
		}
		fscanf(filepointer,"%c", &a_character);
		if(a_character == '\n' || feof(filepointer))
		{
			escape = TRUE;
		}
		else
		{
			*(a_whole_line + place) = a_character;
			place++;
		}
	}
	length = place;
	sscanf(a_whole_line,"%s",a_string);
	if(strlen(a_string) < 1 || a_string[0] < 43 || a_string[0] > 57)
	{	
		free(a_whole_line);
		return(0);
	}
	numb_columns = 0;
	start_point = 0;
	end_point = 0;
	old_start = -1;
	old_stop = -1;
	for(i = 0; i < MAX_OBS; i++)
	{
		for(j = end_point; j < length; j++)
		{
			if(a_whole_line[j] != ' ' && a_whole_line[j] != '\t')
			{
				start_point = j;
				j = length;
			}
		}
		for(j = start_point; j < length; j++)
		{
			if(a_whole_line[j] == ' ' || a_whole_line[j] == '\t' || j == length - 1)
			{
				end_point = j;
				j = length;
			}
		}
		if(old_stop == end_point || old_start == start_point)
		{
				free(a_whole_line);
				return(numb_columns);
		}
		j = 0;
		for(j = start_point; j <= end_point; j++)
		{
			a_string[j - start_point] = a_whole_line[j];
		}
		a_string[j - start_point] = '\0';
		if(strlen(a_string) != 0)
		{
			numb_columns++;
		}
		old_stop = end_point;
		old_start = start_point;
	}
	free(a_whole_line);
	return(numb_columns);
}		

int import_a_row(FILE *filepointer)
{
	char a_character;
	char a_string[XLDLASMAX_INPUT];
	char *a_whole_line;
	char *another_whole_line;
	char varname[XLDLASMAX_INPUT];
	int length, escape, place, i, j, numb_obs, start_point, end_point, old_start, old_stop;
	place = 0;
	escape = FALSE;
	length = XLDLASMAX_INPUT;
	a_whole_line = (char *) malloc (length * sizeof (char));
	while(escape == FALSE)
	{
		if(place == length - 2)
		{
			length = length + XLDLASMAX_INPUT;
			another_whole_line = (char *) malloc (length * sizeof (char));
			for(i = 0; i < place; i++)
			{
				*(another_whole_line + i) = *(a_whole_line + i);
			}
			free(a_whole_line);
			a_whole_line = (char *) malloc (length * sizeof (char));
			for(i = 0; i < place; i++)
			{
				*(a_whole_line + i) = *(another_whole_line + i);
			}
			free(another_whole_line);
		}
		fscanf(filepointer,"%c", &a_character);
		if(a_character == '\n' || feof(filepointer))
		{
			escape = TRUE;
		}
		else
		{
			*(a_whole_line + place) = a_character;
			place++;
		}
	}
	length = place;
	sscanf(a_whole_line,"%s",a_string);
	if(strlen(a_string) < 1 || a_string[0] < 43 || a_string[0] > 57)
	{	
		free(a_whole_line);
		return(0);
	}
	i = 0;
	sprintf(varname,"row%i", i);
	while(check_variable_name(varname) == FALSE)
	{
		i++;
		sprintf(varname,"row%i", i);
	}
	strcpy(data_matrix[numb_variables].name,varname);	
	fvector[numb_variables] = (float *) malloc (MAX_OBS * sizeof(float));
	numb_obs = 0;
	start_point = 0;
	end_point = 0;
	old_start = -1;
	old_stop = -1;
	for(i = 0; i < MAX_OBS; i++)
	{
		for(j = end_point; j < length; j++)
		{
			if(a_whole_line[j] != ' ' && a_whole_line[j] != '\t')
			{
				start_point = j;
				j = length;
			}
		}
		for(j = start_point; j < length; j++)
		{
			if(a_whole_line[j] == ' ' || a_whole_line[j] == '\t' || j == length - 1)
			{
				end_point = j;
				j = length;
			}
		}
		if(old_stop == end_point || old_start == start_point)
		{
			if(numb_obs == 0)
			{
				free(fvector[numb_variables]);
				free(a_whole_line);
				return(0);
			}
			else
			{
				data_matrix[numb_variables].obs = numb_obs;
				strcpy(data_matrix[numb_variables].description,"Row imported data");
				data_exists = TRUE;
				oktoquit = FALSE;
				free(a_whole_line);
				return(1);
			}
		}
		j = 0;
		for(j = start_point; j <= end_point; j++)
		{
			a_string[j - start_point] = a_whole_line[j];
		}
		a_string[j - start_point] = '\0';
		if(strlen(a_string) != 0)
		{
			*(fvector[numb_variables] + numb_obs) = atof(a_string);
			numb_obs++;
		}
		old_stop = end_point;
		old_start = start_point;
	}
	if(numb_obs > 0)
	{
		fl_show_alert("Data being Row Imported has Too Many Observations","I'm truncating it","Try changing MAX_OBS in xldlas.h", TRUE);
		data_matrix[numb_variables].obs = numb_obs;
		strcpy(data_matrix[numb_variables].description,"Row imported data");
		data_exists = TRUE;
		oktoquit = FALSE;
		free(a_whole_line);
		return(1);
	}
	else
	{
		free(a_whole_line);
		return(0);
	}
}

int parse_string_to_column_data(int numb_imports, int numb_obs, int length, char *the_string)
{
	int i, j, start_point, end_point, old_start, old_stop, all_is_well;
	char a_string[XLDLASMAX_INPUT];
	start_point = 0;
	end_point = 0;
	old_start = -1;
	old_stop = -1;
	for(i = 0; i < numb_imports; i++)
	{
		for(j = end_point; j < length; j++)
		{
			if(the_string[j] != ' ' && the_string[j] != '\t')
			{
				start_point = j;
				j = length;
			}
		}
		for(j = start_point; j < length; j++)
		{
			if(the_string[j] == ' ' || the_string[j] == '\t' || j == length - 1)
			{
				end_point = j;
				j = length;
			}
		}
		if(old_stop == end_point || old_start == start_point)
		{
			for(j = i; j < numb_imports; j++)
			{
				*(fvector[numb_variables + j] + numb_obs) = missing_value;
				return(FALSE);
			}
		}
		j = 0;
		strcpy(a_string,"");
		for(j = start_point; j < end_point; j++)
		{
			a_string[j - start_point] = the_string[j];
		}
		a_string[j - start_point] = '\0';
		if(strlen(a_string) != 0)
		{
			*(fvector[numb_variables + i] + numb_obs) = atof(a_string);
		}
		else
		{
			for(j = i; j < numb_imports; j++)
			{
				*(fvector[numb_variables + j] + numb_obs) = missing_value;
				return(FALSE);
			}
		}
		old_stop = end_point;
		old_start = start_point;
	}
	all_is_well = TRUE;
	for(i = end_point; i < length; i++)
	{
		if(the_string[i] != ' ' && the_string[i] != '\t' && the_string[i] != '\0')
		{
			all_is_well = FALSE;
		}
	} 	
	return(all_is_well);
}

void do_column_import(FILE *the_file, char the_file_name[XLDLASMAX_INPUT])
{
	FILE *lfptr;
	int numb_imports, name_start, i, numb_obs;
	int escape, length, place;
	char *a_whole_line;
	char *another_whole_line;
	char a_character;
	char varname[MAX_VARS][XLDLASMAX_INPUT];
	char string_one[XLDLASMAX_INPUT];
	char a_string[XLDLASMAX_INPUT];
	numb_imports = 0;
	while(numb_imports == 0)
	{
		numb_imports = count_columns(the_file);
		if(feof(the_file)) numb_imports = -1;
	}
	fclose(the_file);
	if(numb_imports <= 0)
	{
		fl_show_alert("I can't find anything in the specified file","","",1);
		reenable_input();
		say_status("Ready");
		return;
	}
	if(numb_imports > MAX_VARS - numb_variables)
	{
		fl_show_alert("No room to add all these variables","Try changing #define MAX_VARS in xldlas.h","I'm not importing anything",1);
		reenable_input();
		say_status("Ready");
		return;
	}
	name_start = 0;
	sprintf(varname[0],"col%i", name_start);
	while(check_variable_name(varname[0]) == FALSE)
	{
		name_start++;
		sprintf(varname[0],"col%i", name_start);
	}
	for(i = 1; i < numb_imports; i++)
	{
		sprintf(varname[i],"col%i", name_start + i);
	}
	for(i = 0; i < numb_imports; i++)
	{
		strncpy(data_matrix[numb_variables + i].name, varname[i],NAME_LENGTH);
		strcpy(data_matrix[numb_variables + i].description, "Column imported Data");
		fvector[numb_variables + i] = (float *) malloc (MAX_OBS * sizeof(float));
		if (!fvector[numb_variables])
		{
			fl_show_alert("Cannot Load Dataset",
					"Running low on Memory",
					"",TRUE);
			return;
		}
	}
	lfptr = fopen(the_file_name,"r");
	numb_obs = 0;
	length = XLDLASMAX_INPUT;
	a_whole_line = (char *) malloc (length * sizeof (char));
	
	for(i = 0; i < MAX_OBS; i++)
	{
		escape = FALSE;
		strcpy(a_whole_line,"");
		place = 0;
		while(escape == FALSE)
		{
			if(place == length - 2)
			{
				length = length + XLDLASMAX_INPUT;
				another_whole_line = (char *) malloc (length * sizeof (char));
				for(i = 0; i < place; i++)
				{
					*(another_whole_line + i) = *(a_whole_line + i);
				}
				free(a_whole_line);
				a_whole_line = (char *) malloc (length * sizeof (char));
				for(i = 0; i < place; i++)
				{
					*(a_whole_line + i) = *(another_whole_line + i);
				}
				free(another_whole_line);
			}
			fscanf(lfptr,"%c", &a_character);
			if(a_character == '\n' || feof(lfptr))
			{
				*(a_whole_line + place) = '\0';
				place++;
				escape = TRUE;
			}
			else
			{
				*(a_whole_line + place) = a_character;
				place++;
			}
		}
		strcpy(a_string,"");
		sscanf(a_whole_line,"%s",a_string);
		if(a_string[0] > 42 && a_string[0] < 58)
		{
			if(parse_string_to_column_data(numb_imports, numb_obs, place, a_whole_line) == TRUE)
			{
				numb_obs++;
			}
			else
			{
				sprintf(string_one, "I've given up after reading %d observation(s)", numb_obs);
				fl_show_alert("Number of Columns in Import File is Varying", string_one, "", TRUE); 
				i = MAX_OBS;
			}
		}
		else
		{
			if(feof(lfptr)) i = MAX_OBS;
			else i--;
		}
	}
	fclose(lfptr);
	free(a_whole_line);
	if(numb_obs >= MAX_OBS - 1)
	{
		fl_show_alert("There are More Observations than Xldlas can Hold!", "Try changing the #define MAX_OBS in xldlas.h","Data has been Truncated",TRUE);
	}
	if(numb_obs > 0)
	{
		for(i = 0; i < numb_imports; i++)
		{
			data_matrix[numb_variables + i].obs = numb_obs;
		}
		numb_variables = numb_variables + numb_imports;
		data_exists = TRUE;
		oktoquit = FALSE;
		sprintf(string_one,"Imported %d variable(s)", numb_imports);
		simple_line_output("imprt",string_one);
	}
	else
	{
		for(i = 0; i < numb_imports; i++)
		{
			free(fvector[numb_variables + i]);
			strcpy(data_matrix[numb_variables + i].name, "");
			strcpy(data_matrix[numb_variables + i].description, "");
			data_matrix[numb_variables].obs = numb_obs;
		}
	}
}

void do_row_import(FILE *the_file)
{
	int original_variables;
	char string_one[XLDLASMAX_INPUT];
	original_variables = numb_variables;
	while(!feof(the_file))
	{
		if(numb_variables > MAX_VARS - 1)
		{
			fclose(the_file);
			fl_show_alert("Too Many Rows of Variables",
					"Try increasing MAX_VARS in xldlas.h",
					"",1);
			data_exists = TRUE;
			oktoquit = FALSE;
			if(numb_variables > original_variables)
			{
				sprintf(string_one,"Imported %d variable(s)", numb_variables - original_variables);
			}
			else
			{
				sprintf(string_one,"No data to import in file");
			}
			simple_line_output("imprt",string_one);
			reenable_input();
			say_status("Ready");
			return;
		}
		else
		{
			numb_variables = numb_variables + import_a_row(the_file);
		}
	}
	fclose(the_file);
	if(numb_variables > original_variables)
	{
		sprintf(string_one,"Imported %d variable(s)", numb_variables - original_variables);
	}
	else
	{
		sprintf(string_one,"No data to import in file");
	}
	simple_line_output("imprt",string_one);
	reenable_input();
}


void import_dataset(FL_OBJECT *ob, long user_data)
{
	FILE *lfptr;
	int choice;
	const char *filename;
	char the_filename[XLDLASMAX_INPUT];
	inhibit_input();
	say_status("Importing Dataset");
	fl_use_fselector(3);
	fl_set_fselector_title("Import a Dataset");
	filename = fl_show_fselector("Import Data","","*","");
	if(filename == NULL || strlen(filename) == 0)
	{
		say_status("Ready");
		reenable_input();
		return;
	}
	lfptr = fopen(filename,"r");
	if(!lfptr)
	{
		fl_show_alert("Could not open requested file for reading","","",1);
		reenable_input();
		say_status("Ready");
		return;
	}

	choice = fl_show_choice("ASCII data is in which format?","","",
               		3,"Columns","Rows","Cancel");
	if(choice == 3)
	{
		reenable_input();
		say_status("Ready");
		fclose(lfptr);
		return;
	}
	if(choice == 2) import_type = TYPE_ROWS;
	if(choice == 1) import_type = TYPE_COLS;

	if(import_type == TYPE_COLS)
	{
		strcpy(the_filename, filename);
		do_column_import(lfptr, the_filename);
	}
	else
	{
		do_row_import(lfptr);
	}
	sync_graph_browsers(2);
	reenable_input();
	say_status("Ready");
}





void file_routines(FL_OBJECT *menu, long user_data)
{
	int choice;
	choice = fl_get_menu(menu);
	if(choice == 1) about_xldlas(menu, user_data);
	if(choice == 2) load_dataset(menu, user_data);
	if(choice == 3) save_dataset(menu, user_data);
	if(choice == 4) append_dataset(menu, user_data);
	if(choice == 5) import_dataset(menu, user_data);
	if(choice == 6) quit_xldlas(menu, user_data);
}




