/* handle the file list feature of skyview */
/* also the eyepiece size dialog. */

#include <stdio.h>
#include <math.h>
#if defined(__STDC__)
#include <stdlib.h>
#endif

#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/RowColumn.h>
#include <Xm/Separator.h>
#include <Xm/Scale.h>
#include <Xm/SelectioB.h>
#include <Xm/Text.h>
#include <Xm/ToggleB.h>
#include <Xm/PushB.h>

#include "P_.h"
#include "astro.h"
#include "circum.h"
#include "preferences.h"
#include "skylist.h"

extern Widget toplevel_w;
extern Colormap xe_cm;

extern FILE *fopenh P_((char *name, char *how));
extern Obj *db_scan P_((DBScan *sp));
extern Now *mm_get_now P_((void));
extern char *getXRes P_((char *name));
extern char *syserrstr P_((void));
extern char *obj_description P_((Obj *op));
extern double atod P_((char *buf));
extern int existsh P_((char *filename));
extern void db_scaninit P_((DBScan *sp, int mask, ObjF *op, int nop));
extern void fs_date P_((char out[], double jd));
extern void fs_prdec P_((char out[], double jd));
extern void fs_pangle P_((char buf[], double a));
extern void fs_ra P_((char buf[], double ra));
extern void fs_time P_((char out[], double t));
extern void get_something P_((Widget w, char *resource, XtArgVal value));
extern void get_xmstring P_((Widget w, char *resource, char **txtp));
extern void prompt_map_cb P_((Widget w, XtPointer client, XtPointer call));
extern void query P_((Widget tw, char *msg, char *label1, char *label2,
    char *label3, void (*func1)(), void (*func2)(), void (*func3)()));
extern void set_something P_((Widget w, char *resource, XtArgVal value));
extern void set_xmstring P_((Widget w, char *resource, char *txtp));
extern void xe_msg P_((char *msg, int app_modal));
extern void watch_cursor P_((int want));
extern void wtip P_((Widget w, char *tip));


static Widget list_w;	/* object list dialog */
static void sv_create_list_w P_((void));
static void sv_listok_cb P_((Widget w, XtPointer client, XtPointer call));
static void listok_append_cb P_((Widget w, XtPointer client, XtPointer call));
static void listok_overwrite_cb P_((Widget w, XtPointer client,XtPointer call));
static void make_list P_((char *name, char *how));
static void write_list P_((FILE *fp));

/* callback from List control button. */
/* ARGSUSED */
void
sv_list_cb (w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
	if (!list_w)
	    sv_create_list_w();

	if (XtIsManaged(list_w))
	    XtUnmanageChild (list_w);
	else
	    XtManageChild (list_w);
}

/* create the list filename prompt */
static void
sv_create_list_w()
{
	Arg args[20];
	int n;

	n = 0;
	XtSetArg (args[n], XmNcolormap, xe_cm); n++;
	XtSetArg(args[n], XmNdefaultPosition, False); n++;
	XtSetArg(args[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL);  n++;
	list_w = XmCreatePromptDialog (toplevel_w, "SkyList", args,n);
	set_something (list_w, XmNcolormap, (XtArgVal)xe_cm);
	set_xmstring (list_w, XmNdialogTitle, "xephem Sky View list");
	set_xmstring (list_w, XmNselectionLabelString, "File name:");
	XtUnmanageChild (XmSelectionBoxGetChild(list_w, XmDIALOG_HELP_BUTTON));
	XtAddCallback (list_w, XmNokCallback, sv_listok_cb, NULL);
	XtAddCallback (list_w, XmNmapCallback, prompt_map_cb, NULL);
}

/* called when the Ok button is hit in the file list prompt */
/* ARGSUSED */
static void
sv_listok_cb (w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
	char buf[1024];
	char *name;

	get_xmstring(w, XmNtextString, &name);

	if (strlen(name) == 0) {
	    xe_msg ("Please enter a Sky View list file name.", 1);
	    XtFree (name);
	    return;
	}

	if (existsh (name) == 0) {
	    (void) sprintf (buf, "%s exists: Append or Overwrite?", name);
	    query (toplevel_w, buf, "Append", "Overwrite", "Cancel",
				listok_append_cb, listok_overwrite_cb, NULL);
	} else
	    make_list (name, "w");

	XtFree (name);
}

/* called when we want to append to a list file */
/* ARGSUSED */
static void
listok_append_cb (w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
	char *name;

	get_xmstring (list_w, XmNtextString, &name);
	make_list (name, "a");
	XtFree (name);
}

/* called when we want to ceate a new list file */
/* ARGSUSED */
static void
listok_overwrite_cb (w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
	char *name;

	get_xmstring (list_w, XmNtextString, &name);
	make_list (name, "w");
	XtFree (name);
}

/* open the named list file "a" or "w" and fill it in. */
static void
make_list (name, how)
char *name;
char *how;
{
	FILE *fp = fopenh (name, how);

	if (fp) {
	    write_list (fp);
	    (void) fclose (fp);
	} else {
	    char buf[1024];

	    (void) sprintf (buf, "Can not open %s: %s", name, syserrstr());
	    xe_msg (buf, 1);
	}
}

/* write out all objects currently on sky view display */
static void
write_list (fp)
FILE *fp;
{
	Now *np = mm_get_now();
	DBScan dbs;
	ObjF *fs;
	int nfs;
	double tmp;
	char buf[64];
	int aamode;
	double fov, alt, az, ra, dec;
	Obj *op;

	watch_cursor(1);

	/* line to summarize the current circumstances */
	sv_getcenter (&aamode, &fov, &alt, &az, &ra, &dec);
	(void) fprintf (fp, "Sky List ");
	fs_time (buf, mjd_hr(mjd));
	(void) fprintf (fp, " %s", buf);
	fs_date (buf, mjd_day(mjd));
	(void) fprintf (fp, " %s UT:", buf);
	(void) fprintf (fp, " FOV: %g", raddeg(fov));

	if (aamode) {
	    /* alt/az mode */
	    fs_pangle (buf, alt);
	    (void) fprintf (fp, " Alt: %s", buf);
	    fs_pangle (buf, az);
	    (void) fprintf (fp, " Az: %s", buf);
	} else {
	    /* ra/dec mode */
	    fs_ra (buf, ra);
	    (void) fprintf (fp, " RA: %s", buf);
	    fs_prdec (buf, dec);
	    (void) fprintf (fp, " Dec: %s", buf);
	}

	if (epoch == EOD)
	    tmp = mjd;
	else
	    tmp = epoch;
	mjd_year (tmp, &tmp);
	(void) fprintf (fp, " Ep: %7.2f", tmp);

	(void) fprintf (fp, "\n");

	/* column headings */

	(void) fprintf (fp, "Name.........");
	(void) fprintf (fp, pref_get(PREF_DPYPREC) == PREF_LOPREC ? " RA....."
							   : " RA........");
	(void) fprintf (fp, pref_get(PREF_DPYPREC) == PREF_LOPREC ? " Dec..."
							   : " Dec......");
	(void) fprintf (fp, pref_get(PREF_DPYPREC) == PREF_LOPREC ? " Alt..."
							   : " Alt......");
	(void) fprintf (fp, pref_get(PREF_DPYPREC) == PREF_LOPREC ? " Az...."
							   : " Az.......");
	(void) fprintf (fp, " Mag...");
	(void) fprintf (fp, " Sp");
	(void) fprintf (fp, " Size.");
	(void) fprintf (fp, " Class");

	(void) fprintf (fp, "\n");

	/* scan db for all objects on Sky screen, including any field stars */
	sv_getfldstars (&fs, &nfs);
	for (db_scaninit(&dbs, ALLM, fs, nfs); (op = db_scan(&dbs)) != NULL; ) {

	    if (!(op->o_flags & OBJF_ONSCREEN))
		continue;

	    (void) fprintf (fp, "%-*.*s", MAXNM-1, MAXNM-1, op->o_name);

	    fs_ra (buf, op->s_ra);
	    (void) fprintf (fp, " %s", buf);

	    fs_prdec (buf, op->s_dec);
	    (void) fprintf (fp, " %s", buf);

	    fs_pangle (buf, op->s_alt);
	    (void) fprintf (fp, " %s", buf);

	    fs_pangle (buf, op->s_az);
	    (void) fprintf (fp, " %s", buf);

	    (void) fprintf (fp, " %6.2f", get_mag(op));

	    if (is_type (op, FIXEDM) && op->f_class != 'G')
		(void) fprintf (fp, " %c%c",
					op->f_spect[0] ? op->f_spect[0] : ' ',
					op->f_spect[1] ? op->f_spect[1] : ' ');
	    else
		(void) fprintf (fp, "   ");

	    (void) fprintf (fp, " %5d", op->s_size);

	    (void) fprintf (fp, " %s", obj_description (op));

	    (void) fprintf (fp, "\n");
	}

	watch_cursor(0);
}

/* stuff for the eyepiece size dialog */

static Widget eyepd_w;		/* overall eyepiece dialog */
static Widget eyepws_w;		/* eyepiece width scale */
static Widget eyephs_w;		/* eyepiece height scale */
static Widget eyer_w;		/* eyepiece Round/Square TB */
static Widget lock_w;		/* lock scales TB */

static void se_create_eyepd_w P_((void));
static void se_wscale_cb P_((Widget w, XtPointer client, XtPointer call));
static void se_hscale_cb P_((Widget w, XtPointer client, XtPointer call));

int
se_ismanaged()
{
	return (eyepd_w && XtIsManaged(eyepd_w));
}

void 
se_unmanage()
{
	if (eyepd_w)
	    XtUnmanageChild (eyepd_w);
}

void 
se_manage()
{
	if (eyepd_w)
	    XtManageChild (eyepd_w);
}

/* callback from Eyepiece Size control button (from skyviewmenu). */
/* ARGSUSED */
void
se_eyepd_cb (w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
	if (!eyepd_w)
	    se_create_eyepd_w();

	if (XtIsManaged(eyepd_w))
	    XtUnmanageChild (eyepd_w);
	else
	    XtManageChild (eyepd_w);
}


/* return the current eyepiece diameter, in rads, whether it is round */
void
se_eyepsz(wp, hp, rp)
double *wp, *hp;
int *rp;
{
	int eyepw, eyeph;
	short wdp = 0, hdp = 0;

	if (!eyepd_w)
	    se_create_eyepd_w();

	XmScaleGetValue (eyepws_w, &eyepw);
	get_something (eyepws_w, XmNdecimalPoints, (XtArgVal)&wdp);
	*wp = degrad(eyepw/pow(10.0,(double)wdp));

	XmScaleGetValue (eyephs_w, &eyeph);
	get_something (eyephs_w, XmNdecimalPoints, (XtArgVal)&hdp);
	*hp = degrad(eyeph/pow(10.0,(double)hdp));

	*rp = XmToggleButtonGetState (eyer_w);
}

/* create the eyepiece size dialog */
static void
se_create_eyepd_w()
{
	Widget w;
	Widget rb_w;
	Arg args[20];
	int n;

	/* create form */

	n = 0;
	XtSetArg(args[n], XmNdefaultPosition, False); n++;
	XtSetArg(args[n], XmNautoUnmanage, True); n++;
	XtSetArg (args[n], XmNcolormap, xe_cm); n++;
	XtSetArg (args[n], XmNverticalSpacing, 5); n++;
	XtSetArg (args[n], XmNmarginHeight, 10); n++;
	XtSetArg (args[n], XmNmarginWidth, 10); n++;
	eyepd_w = XmCreateFormDialog (toplevel_w, "SkyEyep", args, n);
	set_something (eyepd_w, XmNcolormap, (XtArgVal)xe_cm);
	XtAddCallback (eyepd_w, XmNmapCallback, prompt_map_cb, NULL);

	/* set some stuff in the parent DialogShell.
	 * setting XmNdialogTitle in the Form didn't work..
	 */
	n = 0;
	XtSetArg (args[n], XmNtitle, "xephem Eyepiece Size"); n++;
	XtSetValues (XtParent(eyepd_w), args, n);

	/* title label */
	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	w = XmCreateLabel (eyepd_w, "L", args, n);
	set_xmstring (w, XmNlabelString, "Eyepiece width and height, degrees:");
	XtManageChild (w);

	/* lock TB */

	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, w); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftOffset, 10); n++;
	lock_w = XmCreateToggleButton (eyepd_w, "Lock", args, n);
	set_xmstring (lock_w, XmNlabelString, "Lock scales together");
	wtip (lock_w, "When on, width and height scales move as one");
	XtManageChild (lock_w);

	/* w and h scales */

	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, lock_w); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNorientation, XmHORIZONTAL); n++;
	XtSetArg (args[n], XmNshowValue, True); n++;
	XtSetArg (args[n], XmNscaleMultiple, 1); n++;
	eyepws_w = XmCreateScale (eyepd_w, "EyepW", args, n);
	XtAddCallback (eyepws_w, XmNdragCallback, se_wscale_cb, 0);
	wtip (eyepws_w, "Set to desired width of eyepiece, in degrees");
	XtManageChild (eyepws_w);

	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, eyepws_w); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNorientation, XmHORIZONTAL); n++;
	XtSetArg (args[n], XmNshowValue, True); n++;
	XtSetArg (args[n], XmNscaleMultiple, 1); n++;
	eyephs_w = XmCreateScale (eyepd_w, "EyepH", args, n);
	XtAddCallback (eyephs_w, XmNdragCallback, se_hscale_cb, 0);
	wtip (eyephs_w, "Set to desired height of eyepiece, in degrees");
	XtManageChild (eyephs_w);

	/* shape label */

	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, eyephs_w); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	w = XmCreateLabel (eyepd_w, "S", args, n);
	set_xmstring (w, XmNlabelString, "Shape:");
	XtManageChild (w);

	/* round or square Radio box */

	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, w); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftOffset, 10); n++;
	rb_w = XmCreateRadioBox (eyepd_w, "RB", args, n);
	XtManageChild (rb_w);

	    n = 0;
	    eyer_w = XmCreateToggleButton (rb_w, "Elliptical", args, n);
	    wtip (eyer_w, "When on, next eyepiece will be elliptical");
	    XtManageChild (eyer_w);

	    n = 0;
	    w = XmCreateToggleButton (rb_w, "Rectangular", args, n);
	    wtip (w, "When on, next eyepiece will be rectangular");
	    XtManageChild (w);

	/* separator */

	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, rb_w); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	w = XmCreateSeparator (eyepd_w, "Sep", args, n);
	XtManageChild (w);

	/* a close button -- relies on autoUnmanage of dialog */

	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, w); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_POSITION); n++;
	XtSetArg (args[n], XmNleftPosition, 30); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
	XtSetArg (args[n], XmNrightPosition, 70); n++;
	w = XmCreatePushButton (eyepd_w, "Close", args, n);
	wtip (w, "Close this dialog");
	XtManageChild (w);
}

/* drag callback from the height scale */
static void
se_hscale_cb (w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
	int v;

	/* slave the w scale to the h scale */
	if (XmToggleButtonGetState(lock_w)) {
	    XmScaleGetValue (eyephs_w, &v);
	    XmScaleSetValue (eyepws_w, v);
	}
}

/* drag callback from the width scale */
static void
se_wscale_cb (w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
	int v;

	/* slave the w scale to the h scale */
	if (XmToggleButtonGetState(lock_w)) {
	    XmScaleGetValue (eyepws_w, &v);
	    XmScaleSetValue (eyephs_w, v);
	}
}
