
/* cmapsobel.c V1.0 - Copyright (C) 1993/94/95/96 Jim Geuther */

/*
 * Function:	Sobel edge detection plug-in.
 *
 * Author: 	Jim GEUTHER
 * Date:    	16-May-96
 * Environment: Personal Power System 850 + AIX V4.1.3.0
 *
 * This  Gimp plug-in is used to perform sobel edge detection on
 * colormap indexed images.
 *
 * V1.00
 *
 * This filter performs a sobel edge detection.
 *
 * For best results, you should first remap the colormap from 
 * dark to light before using this function.
 *
 * Examples for creating nice effects:
 * 
 * o Load an image (convert to indexed if necessary)
 *
 * o Remap the colors from dark to light.
 *
 * o Perform Sobel edge detect.
 *
 * o Convert from indexed to RGB color.
 *
 * o Use channel operations to blend to Sobel edged image as primary
 *    into the original picture.
 *
 *
 * History:
 * V1.0	Jim GEUTHER, ported from ImageKnife (Amiga) to Gimp (AIX)
 *
 *
 */
 
/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gimp.h"
#include "macros.h"

static void radio_callback (int, void *, void *);
static void ok_callback (int, void *, void *);
static void cancel_callback (int, void *, void *);
static void sobel(
Image	*input,
Image	*output,
int	colors,
int	mode
);

static char *prog_name;
static long amount = 9;
static int dialog_ID;
static int mode=0;	/* 0 = colormode 
			 * 1 = binary mode
			 */

int
main (argc, argv)
     int argc;
     char *argv[];
{
Image	input,output;
long colormode_ID,binarymode_ID,group_ID;
static int one=1;
  /* Save the program name so we can use it later in reporting errors
   */
  prog_name = argv[0];

  /* Call 'gimp_init' to initialize this filter.
   * 'gimp_init' makes sure that the filter was properly called and
   *  it opens pipes for reading and writing.
   */
  if (gimp_init (argc, argv))
    {
	if(input=gimp_get_input_image(0)) {
		switch(gimp_image_type(input)) {
		case INDEXED_IMAGE :
			dialog_ID = gimp_new_dialog("Sobel");
			group_ID=gimp_new_row_group(dialog_ID,DEFAULT,RADIO,"");
			colormode_ID=gimp_new_radio_button(dialog_ID,group_ID,"Color Mode");
			binarymode_ID=gimp_new_radio_button(dialog_ID,group_ID,"Binary Mode");

		      	gimp_change_item(dialog_ID, colormode_ID, sizeof (one), &one);

		      	gimp_add_callback(dialog_ID,colormode_ID,radio_callback,(void *)0);
		      	gimp_add_callback(dialog_ID,binarymode_ID,radio_callback,(void *)1);
		      			      			      			      			      	
		      	gimp_add_callback (dialog_ID, gimp_ok_item_id (dialog_ID), ok_callback, 0);
			gimp_add_callback (dialog_ID, gimp_cancel_item_id (dialog_ID), cancel_callback, 0);
			
		  	if(gimp_show_dialog(dialog_ID)) {    	
				/* A new output image is created, to ensure the
				   image is displayed correctly. */
#ifdef	OBSOLETE				   
				if(output=gimp_new_image(0,gimp_image_width(input),
						gimp_image_height(input),
						INDEXED_IMAGE)) {
						sobel(input,output,256,mode);
#else
				if(output=gimp_get_output_image(0)) {
					sobel(input,output,256,mode);
#endif											
					gimp_display_image(output);
					gimp_update_image(output);
					gimp_free_image(output);
				} else printf("%s: get output image failed\n",prog_name);
			}
			break;
		default :
			gimp_message("cmapsobel: can only operate on indexed color images");
			break;
		}
		gimp_free_image(input);
	}			
       /* Quit
       */
      gimp_quit ();
    }

  return 0;
}


static void
radio_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
#ifdef	OBSOLETE
  *((long*) client_data) = *((long*) call_data);
#endif  
 mode=(int)client_data; 

}

static void
ok_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
  gimp_close_dialog (dialog_ID, 1);
}

static void
cancel_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
  gimp_close_dialog (dialog_ID, 0);
}

#ifdef	OBSOLETE
static void sobel(
Image	*input,
Image	*output,
int	colors,
int	colormode
)
{

 unsigned char *dest;
  unsigned char *prev_row, *cur_row, *next_row;
  long width, height;
  long channels, rowstride;
  int row, col;
  int x1, y1, x2, y2;
  int left, right,top,bottom;
 int cur_progress;
  int max_progress;

register long	i,j;
long c,cc;

/*
 * Should get image_area
 */

printf("%s.%ld: colors=%ld, mode=%ld\n",__FILE__,__LINE__,colors,colormode);

gimp_image_area (input, &x1, &y1, &x2, &y2);

width = gimp_image_width (input);
height = gimp_image_height (input);
channels = gimp_image_channels (input);
rowstride = width * channels; 

  left = (x1 == 0);
  right = (x2 == width);
  top = (y1 == 0);
  bottom = (y2 == height);

  if (x1 == 0)
    x1++;
  if (y1 == 0)
    y1++;
  if (x2 == width)
    x2--;
  if (y2 == height)
    y2--;

prev_row=gimp_image_data(input);
prev_row+=(y1-1)*rowstride;
cur_row=prev_row+rowstride;
next_row=cur_row+rowstride;
dest=gimp_image_data(output);

if(top) {
	for(col=0;col<rowstride;col++) *dest++=0;
} else dest+=y1*rowstride;

for(i=y1;i<y2;i++){
	if(left) for(col=0;col<channels;col++) *dest++=0;
	else dest+=x1;
	printf("%s.%ld: i=%ld\n",__FILE__,__LINE__,i);
	for(j=x1+1;j<x2-1;j++) {
		printf("%s.%ld: j=%ld",__FILE__,__LINE__,j);
#ifdef	OBSOLETE	
		cc= -(long)a_info->data_cm[i-1][j-1] - mul2((long)a_info->data_cm[i-1][j]) - (long)a_info->data_cm[i-1][j+1];
		cc+=(long)a_info->data_cm[i+1][j-1]+mul2((long)a_info->data_cm[i+1][j])+(long)a_info->data_cm[i+1][j+1];
		c=abs(cc);
		cc= -(long)a_info->data_cm[i-1][j-1]-mul2((long)a_info->data_cm[i][j-1])-(long)a_info->data_cm[i+1][j-1];
		cc+=(long)a_info->data_cm[i-1][j+1]+mul2((long)a_info->data_cm[i][j+1])-(long)a_info->data_cm[i+1][j+1];
#else
		cc = -prev_row[j-1] - mul2(prev_row[j]) - prev_row[j+1];
		cc += next_row[j-1] + mul2(next_row[j]) + next_row[j+1];
		c = abs( cc );
		cc = -prev_row[j-1] - mul2(cur_row[j-1]) - next_row[j-1];
		cc += prev_row[j+1] + mul2( cur_row[j+1] ) - next_row[j+1];
#endif		
		c+=abs(cc);
		if(c<=colors) {
			/*
			** You can set the destination b[][] back to the
			** original pen, but the results are not very
pri			** impressive and it doesn't look like edging
			** anymore.
			*/
			if(colormode==0) {
				*dest++=c;
			} else {
				*dest++=0; /* binary */
			}
		} else {
			*dest++=colors-1;	/* highest pennr	*/
		}

     if (right)
        {
          for (col = col; col < rowstride; col++)
            *dest++ = 0;
        }
      else
        {
          dest += rowstride - x2;
        }		
		printf("Done\n");
		prev_row = cur_row;
		cur_row = next_row;
		next_row += rowstride;		
	}
}

 /* And write the last row, zeros again. */
  if (bottom)
    for (col = 0; col < rowstride; col++)
      *dest++ = 0;
 
}
#endif


static void sobel(
Image	*input,
Image	*output,
int	colors,
int	colormode
)
{

  unsigned char *dest;
  unsigned char *prev_row, *cur_row, *next_row;
  long width, height;
  long channels, rowstride;
  int row, col;
  int x1, y1, x2, y2;
  int left, right;
  int top, bottom;
  long sum1, sum2;
  long sum, scale;
  int maxval;
  int cur_progress;
  int max_progress;
	long c,cc;


  gimp_image_area (input, &x1, &y1, &x2, &y2);

  width = gimp_image_width (input);
  height = gimp_image_height (input);
  channels = gimp_image_channels (input);
  rowstride = width * channels;

  left = (x1 == 0);
  right = (x2 == width);
  top = (y1 == 0);
  bottom = (y2 == height);

  if (x1 == 0)
    x1++;
  if (y1 == 0)
    y1++;
  if (x2 == width)
    x2--;
  if (y2 == height)
    y2--;

  x1 *= channels;
  x2 *= channels;

  prev_row = gimp_image_data (input);
  prev_row += (y1 - 1) * rowstride;
  cur_row = prev_row + rowstride;
  next_row = cur_row + rowstride;

  dest = gimp_image_data (output);

  maxval = 255;
  scale = (10 << 16) / amount;

  if (top)
    {
      for (col = 0; col < rowstride; col++)
        *dest++ = 0;
    }
  else
    {
      dest += y1 * rowstride;
    }

  cur_progress = 0;
  max_progress = y2 - y1;

  /* Now the rest of the image - read in the 3rd row of inputbuf,
  ** and convolve with the first row into the output buffer.
  */
  for (row = y1; row < y2; ++row)
    {
      if (left)
        {
          for (col = 0; col < channels; col++)
            *dest++ = 0;
        }
      else
        {
          dest += x1;
        }

      for (col = x1; col < (x2 < (width-2) ? x2 : x2-1 ); col++)
        {
		cc = -prev_row[col-1] - mul2(prev_row[col]) - prev_row[col+1];
		cc += next_row[col-1] + mul2(next_row[col]) + next_row[col+1];
		c = abs( cc );
		cc = -prev_row[col-1] - mul2(cur_row[col-1]) - next_row[col-1];
		cc += prev_row[col+1] + mul2( cur_row[col+1] ) - next_row[col+1];
		c+=abs(cc);
		
		if(c<=colors) {
			/*
			** You can set the destination b[][] back to the
			** original pen, but the results are not very
			** impressive and it doesn't look like edging
			** anymore.
			*/
			if(colormode==0) {
				*dest++=c;
			} else {
				*dest++=0; /* binary */
			}
		} else {
			*dest++=colors-1;	/* highest pennr	*/
		}
	  
        }
     
      if (right)
        {
          for (col = col; col < rowstride; col++)
            *dest++ = 0;
        }
      else
        {
          dest += rowstride - x2;
        }

      prev_row = cur_row;
      cur_row = next_row;
      next_row += rowstride;

	if ((++cur_progress % 10) == 0) gimp_do_progress (cur_progress, max_progress);	

    }

  /* And write the last row, zeros again. */
  if (bottom)
    for (col = 0; col < rowstride; col++)
      *dest++ = 0;
}




